/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.protempa.SourceSystem;
import org.protempa.proposition.DefaultUniqueIdFactory;
import org.protempa.proposition.Event;
import org.protempa.proposition.UniqueIdFactory;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.Granularity;

public final class TemporalEventFactory {
    private static final IntervalFactory intervalFactory = new IntervalFactory();
    private DateFormat dateFormat;
    private Granularity granularity;
    private final UniqueIdFactory factory;

    public TemporalEventFactory(DateFormat dateFormat, Granularity granularity, UniqueIdFactory factory) {
        this.dateFormat = dateFormat == null ? DateFormat.getDateTimeInstance() : dateFormat;
        this.granularity = granularity;
        this.factory = factory != null ? factory : new DefaultUniqueIdFactory();
    }

    public Event getInstance(String id, String timestamp, SourceSystem dataSourceType) throws ParseException {
        return this.getInstance(id, timestamp != null ? this.dateFormat.parse(timestamp) : null, dataSourceType);
    }

    public Event getInstance(String id, Date timestamp, SourceSystem dataSourceType) {
        Long tstampAsPos = AbsoluteTimeGranularityUtil.asPosition(timestamp);
        return this.getInstance(id, tstampAsPos, dataSourceType);
    }

    public Event getInstance(String id, String start, String finish, SourceSystem dataSourceType) throws ParseException {
        return this.getInstance(id, start != null ? this.dateFormat.parse(start) : null, finish != null ? this.dateFormat.parse(finish) : null, dataSourceType);
    }

    public Event getInstance(String id, Date start, Date finish, SourceSystem dataSourceType) {
        Long startAsPos = AbsoluteTimeGranularityUtil.asPosition(start);
        Long finishAsPos = AbsoluteTimeGranularityUtil.asPosition(finish);
        return this.getInstance(id, startAsPos, finishAsPos, dataSourceType);
    }

    private Event getInstance(String id, Long pos, SourceSystem dataSourceType) {
        Event pp = new Event(id, this.factory.getInstance());
        pp.setSourceSystem(dataSourceType);
        pp.setInterval(intervalFactory.getInstance(pos, this.granularity, pos, this.granularity));
        return pp;
    }

    private Event getInstance(String id, Long start, Long finish, SourceSystem dataSourceType) {
        Event e = new Event(id, this.factory.getInstance());
        e.setSourceSystem(dataSourceType);
        e.setInterval(intervalFactory.getInstance(start, this.granularity, finish, this.granularity));
        return e;
    }
}

