/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.mvel.CompileException;
import org.mvel.ForeachContext;
import org.mvel.Node;
import org.mvel.ParseException;
import org.mvel.TemplateInterpreter;
import org.mvel.util.ParseTools;
import org.mvel.util.StringAppender;

public class TemplateCompiler {
    private static final boolean DEFAULT_DEBUG = Boolean.getBoolean("mvflex.expression.debug");
    private char[] expressionArray;
    private int length = 0;
    private int cursor = 0;
    private boolean debug = DEFAULT_DEBUG;
    private int maxDepth = 10;

    public TemplateCompiler(TemplateInterpreter templateInterpreter) {
        this.expressionArray = templateInterpreter.getExpression();
        this.length = this.expressionArray.length;
    }

    public Node[] compileExpression() {
        ArrayList<Node> aList = new ArrayList<Node>(10);
        int depth = 0;
        int literalRange = 0;
        int length = this.expressionArray.length;
        int node = 0;
        while (this.cursor < length) {
            if (this.expressionArray[this.cursor] == '@') {
                if (this.expressionArray[this.cursor + 1] == '@') {
                    ++this.cursor;
                    aList.add(new Node(node++, 6, this.cursor - literalRange, literalRange, node));
                    literalRange = 0;
                } else {
                    if (literalRange != 0) {
                        aList.add(new Node(node++, 6, this.cursor - literalRange, literalRange, node));
                        literalRange = 0;
                    }
                    Node ex = new Node(this.cursor);
                    String token = this.captureTo('{');
                    if (token == null) {
                        ++literalRange;
                    } else {
                        char[] exStr = this.structuredCaptureArray(1);
                        if (token.length() != 0) {
                            if ("if".equals(token)) {
                                ++depth;
                                ex.setToken(0);
                            } else if ("elseif".equals(token)) {
                                aList.add(new Node(node++, 8, -1));
                                ex.setToken(2);
                            } else if ("else".equals(token)) {
                                aList.add(new Node(node++, 8, -1));
                                ex.setToken(3);
                            } else if ("foreach".equals(token)) {
                                ++depth;
                                ex.setToken(1);
                            } else if ("end".equals(token)) {
                                --depth;
                                ex.setToken(4);
                                ex.setRegister(exStr);
                            } else if ("includeByRef".equals(token)) {
                                ex.setToken(10);
                                ex.setRegister(this.buildIncludeRef(exStr));
                            } else {
                                throw new CompileException("unknown token: " + token);
                            }
                        }
                        if (ex.getNodeType() == 1) {
                            ex.setAlias("item");
                            ForeachContext foreachContext = new ForeachContext();
                            LinkedList<String[]> iterators = new LinkedList<String[]>();
                            int start = 0;
                            int i = 0;
                            while (i < exStr.length) {
                                switch (exStr[i]) {
                                    case ',': {
                                        iterators.add(TemplateCompiler.parseAlias(exStr, start, i, iterators.size()));
                                        start = i + 1;
                                    }
                                }
                                ++i;
                            }
                            if (start < exStr.length) {
                                iterators.add(TemplateCompiler.parseAlias(exStr, start, exStr.length, iterators.size()));
                            }
                            String[] names = new String[iterators.size()];
                            String[] aliases = new String[names.length];
                            Iterator iterator = iterators.iterator();
                            int i2 = 0;
                            while (iterator.hasNext()) {
                                String[] temp = (String[])iterator.next();
                                names[i2] = temp[0];
                                aliases[i2] = temp[1];
                                ++i2;
                            }
                            foreachContext.setNames(names);
                            foreachContext.setAliases(aliases);
                            ex.setRegister(foreachContext);
                        } else {
                            ex.setEndPos(this.cursor);
                        }
                        ex.setLength(this.cursor + 1 - ex.getStartPos());
                        if (depth > this.maxDepth) {
                            this.maxDepth = depth;
                        }
                        aList.add(ex.setNode(node++));
                    }
                }
            } else {
                ++literalRange;
            }
            ++this.cursor;
        }
        if (literalRange != 0) {
            aList.add(new Node(node++, 6, this.cursor - literalRange, literalRange, node));
        }
        if (depth != 1 || aList.size() != 1 || ((Node)aList.get(0)).getStartPos() != 0 || ((Node)aList.get(0)).getEndPos() != length) {
            if (depth > 0) {
                throw new CompileException("unbalanced operators: expected $end{}");
            }
            if (depth < 0) {
                throw new CompileException("unexpected $end{} encountered");
            }
        }
        aList.add(new Node(node, 7));
        Node[] expressions = new Node[aList.size()];
        int i = 0;
        while (i < expressions.length) {
            expressions[i] = (Node)aList.get(i);
            ++i;
        }
        ArrayList<Node> stk = new ArrayList<Node>(10);
        int i3 = 0;
        while (i3 < expressions.length) {
            switch (expressions[i3].getToken()) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    break;
                }
                case 4: {
                    Node e = (Node)stk.remove(stk.size() - 1);
                    e.setEndNode(i3);
                    int last = -1;
                    if (e.getToken() == 0) {
                        int x = i3;
                        while (x >= e.getNode()) {
                            switch (expressions[x].getToken()) {
                                case 8: {
                                    expressions[x].setEndNode(i3 + 1);
                                    break;
                                }
                                case 0: 
                                case 2: 
                                case 3: {
                                    if (last == -1) {
                                        expressions[x].setEndNode(i3);
                                    } else {
                                        expressions[x].setEndNode(last);
                                    }
                                    last = x;
                                }
                            }
                            --x;
                        }
                        break;
                    }
                    if (e.getToken() != 1) break;
                    char[] props = (char[])expressions[i3].getRegister();
                    if (props != null && props.length > 0) {
                        int j = 0;
                        while (j < props.length && Character.isWhitespace(props[j])) {
                            ++j;
                        }
                        if (props[j] != '\"' && props[j] != '\'') {
                            throw new CompileException("seperator is not correctly specified \"" + props + "\"");
                        }
                        int k = props.length - 1;
                        while (k < props.length && props[k] != '\"' && props[j] != '\'') {
                            --k;
                        }
                        if (props[k] != '\"' && props[j] != '\'') {
                            throw new CompileException("seperator is not correctly specified \"" + props + "\"");
                        }
                        ((ForeachContext)e.getRegister()).setSeperator(new String(props, j + 1, k - j - 1));
                        break;
                    }
                    ((ForeachContext)e.getRegister()).setSeperator("");
                    break;
                }
                default: {
                    stk.add(expressions[i3]);
                }
            }
            ++i3;
        }
        if (this.debug) {
            System.out.println("Expression:\n");
            System.out.println(String.copyValueOf(this.expressionArray));
            System.out.println("\n------------------------------------------");
            System.out.println("Outputting Expression Tree");
            System.out.println("--------------------------------------------");
            depth = 0;
            Node[] nodeArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Node e = nodeArray[n2];
                switch (e.getToken()) {
                    case 4: {
                        --depth;
                    }
                }
                System.out.println(String.valueOf(TemplateCompiler.indent(depth)) + " + Node (" + e.getNode() + ") [" + TemplateCompiler.getNodeTypeName(e.getNodeType()) + "] " + " {" + e.getStartPos() + "," + e.getEndPos() + "} --> " + e.getEndNode() + " ['" + new String(this.expressionArray, e.getStartPos(), e.getEndPos() - e.getStartPos()) + "']");
                switch (e.getToken()) {
                    case 0: 
                    case 1: {
                        ++depth;
                    }
                }
                ++n2;
            }
            System.out.println("--------------------------------------------");
        }
        return expressions;
    }

    public static String[] parseAlias(char[] seq, int start, int end, int index) {
        int i = start;
        while (i < end) {
            switch (seq[i]) {
                case ' ': {
                    if (i + 3 >= end || seq[i + 1] != 'a' || seq[i + 2] != 's' || seq[i + 3] != ' ') break;
                    return new String[]{new String(seq, start, i - start).trim(), new String(seq, i += 4, end - i).trim()};
                }
            }
            ++i;
        }
        return new String[]{new String(seq, start, end - start).trim(), index != 0 ? "item" + index : "item"};
    }

    public static String getNodeTypeName(int node) {
        switch (node) {
            case 3: {
                return "ELSE";
            }
            case 2: {
                return "ELSE_IF";
            }
            case 4: {
                return "END";
            }
            case 1: {
                return "FOREACH";
            }
            case 8: {
                return "GOTO";
            }
            case 0: {
                return "IF";
            }
            case 10: {
                return "INCLUDE_BY_REF";
            }
            case 6: {
                return "LITERAL";
            }
            case 9: {
                return "OPERATOR";
            }
            case 5: {
                return "EXPRESSION";
            }
            case 7: {
                return "TERMINUS";
            }
        }
        return "UNKNOWN";
    }

    private IncludeRef buildIncludeRef(char[] text) {
        int i = 0;
        while (Character.isWhitespace(text[i])) {
            ++i;
        }
        int start = i;
        while (i < text.length && text[i++] != '(') {
        }
        if (i == text.length) {
            throw new ParseException("expected ')'", this.expressionArray, i);
        }
        int end = i - 1;
        String name = new String(text, start, end - start);
        Map<String, String> parmVars = ParseTools.parseParameters(ParseTools.subset(text, end + 1, ParseTools.balancedCapture(text, end, ')') - end - 1));
        ArrayList<IncludeRefParam> params = new ArrayList<IncludeRefParam>();
        Iterator<String> iterator = parmVars.keySet().iterator();
        while (iterator.hasNext()) {
            String k = iterator.next();
            params.add(new IncludeRefParam(k, parmVars.get(k)));
        }
        return new IncludeRef(name, params.toArray(new IncludeRefParam[params.size()]));
    }

    private static String indent(int depth) {
        StringAppender sb = new StringAppender();
        int i = depth;
        while (i >= 0) {
            sb.append("    ");
            --i;
        }
        return sb.toString();
    }

    private String captureTo(char c) {
        int start = this.cursor + 1;
        if (this.lookahead(c)) {
            return new String(this.expressionArray, start, this.cursor - start);
        }
        return null;
    }

    private boolean lookahead(char c) {
        int start = this.cursor;
        while (this.cursor < this.length) {
            if (this.expressionArray[this.cursor] == c) {
                return true;
            }
            ++this.cursor;
        }
        this.cursor = start;
        return false;
    }

    private char[] structuredCaptureArray(int depth) {
        int start = this.cursor++ + 1;
        while (this.cursor < this.length && depth != 0) {
            switch (this.expressionArray[this.cursor++]) {
                case '}': {
                    --depth;
                    break;
                }
                case '{': {
                    ++depth;
                }
            }
        }
        if (depth > 0) {
            throw new CompileException("unbalanced braces near: " + this.showCodeNearError() + " (" + depth + ")");
        }
        char[] array = new char[--this.cursor - start];
        System.arraycopy(this.expressionArray, start, array, 0, this.cursor - start);
        return array;
    }

    private CharSequence showCodeNearError() {
        int start = this.cursor - 10;
        int end = this.cursor + 20;
        if (start < 0) {
            start = 0;
        }
        if (end > this.length) {
            end = this.length - 1;
        }
        return "'" + String.copyValueOf(this.expressionArray, start, end - start) + "'";
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public static class IncludeRef {
        private String name;
        private IncludeRefParam[] params;

        public IncludeRef(String name, IncludeRefParam[] params) {
            this.name = name;
            this.params = params;
        }

        public String getName() {
            return this.name;
        }

        public IncludeRefParam[] getParams() {
            return this.params;
        }
    }

    public static class IncludeRefParam {
        private String identifier;
        private String value;

        public IncludeRefParam(String identifier, String value) {
            this.identifier = identifier;
            this.value = value;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getValue() {
            return this.value;
        }
    }
}

