/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import com.mockrunner.gen.proc.JavaLineAssembler;
import com.mockrunner.gen.proc.PackageImportSorter;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.ClassUtil;
import com.mockrunner.util.common.StringUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JavaClassGenerator {
    private Package packageInfo;
    private List imports;
    private String className;
    private boolean isAbstract;
    private Class superClass;
    private List interfaces;
    private List memberTypes;
    private List memberNames;
    private String[] classCommentLines;
    private boolean createJavaDocComments;
    private List methods;
    private List constructors;

    public JavaClassGenerator() {
        this.reset();
    }

    public void reset() {
        this.imports = new ArrayList();
        this.interfaces = new ArrayList();
        this.memberTypes = new ArrayList();
        this.memberNames = new ArrayList();
        this.createJavaDocComments = true;
        this.isAbstract = false;
        this.methods = new ArrayList();
        this.constructors = new ArrayList();
    }

    public void setCreateJavaDocComments(boolean createJavaDocComments) {
        this.createJavaDocComments = createJavaDocComments;
    }

    public void setPackage(Package packageInfo) {
        this.packageInfo = packageInfo;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setSuperClass(Class superClass) {
        this.superClass = superClass;
    }

    public void addImport(Class importClass) {
        this.imports.add(importClass.getName());
    }

    public void addInterfaceImplementation(Class interfaceClass) {
        this.interfaces.add(interfaceClass);
    }

    public void setClassComment(String[] commentLines) {
        this.classCommentLines = (String[])ArrayUtil.copyArray(commentLines);
    }

    public void addMemberDeclaration(Class memberType, String name) {
        this.memberTypes.add(memberType);
        this.memberNames.add(name);
    }

    public void addConstructorDeclaration() {
        this.constructors.add(new ConstructorDeclaration());
    }

    public void addConstructorDeclaration(ConstructorDeclaration constructor) {
        this.constructors.add(constructor);
    }

    public void addMethodDeclaration(MethodDeclaration method) {
        this.methods.add(method);
    }

    public String generate() {
        JavaLineAssembler assembler = new JavaLineAssembler();
        assembler.appendPackageInfo(this.getPackageName());
        this.appendImportBlocks(assembler);
        this.appendCommentBlock(assembler, this.classCommentLines);
        if (this.isAbstract) {
            assembler.appendClassDefintion(this.className, Modifier.toString(1024), this.getClassName(this.superClass), this.getClassNames(this.interfaces));
        } else {
            assembler.appendClassDefintion(this.className, "", this.getClassName(this.superClass), this.getClassNames(this.interfaces));
        }
        assembler.appendLeftBrace();
        assembler.appendNewLine();
        assembler.setIndentLevel(1);
        this.appendMembers(assembler);
        this.appendConstructors(assembler);
        this.appendMethods(assembler);
        assembler.setIndentLevel(0);
        assembler.appendRightBrace();
        return assembler.getResult();
    }

    private String getPackageName() {
        if (null != this.packageInfo) {
            return this.packageInfo.getName();
        }
        return null;
    }

    private String getClassName(Class clazz) {
        if (null == clazz) {
            return null;
        }
        return ClassUtil.getClassName(clazz);
    }

    private String[] getClassNames(List classList) {
        if (null == classList || classList.size() <= 0) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (int ii = 0; ii < classList.size(); ++ii) {
            Class clazz = (Class)classList.get(ii);
            if (null == clazz) continue;
            nameList.add(this.getClassName(clazz));
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    private String[] getClassNames(Class[] arguments) {
        if (null == arguments || arguments.length <= 0) {
            return null;
        }
        String[] names = new String[arguments.length];
        for (int ii = 0; ii < arguments.length; ++ii) {
            Class clazz = arguments[ii];
            names[ii] = this.getClassName(clazz);
        }
        return names;
    }

    private String[] getArgumentNames(Class[] arguments, String[] argumentNames) {
        int ii;
        if (null == arguments || arguments.length <= 0) {
            return null;
        }
        if (null != argumentNames && argumentNames.length >= arguments.length) {
            return argumentNames;
        }
        if (null == argumentNames) {
            argumentNames = new String[]{};
        }
        String[] newNames = new String[arguments.length];
        for (ii = 0; ii < argumentNames.length; ++ii) {
            newNames[ii] = argumentNames[ii];
        }
        for (ii = argumentNames.length; ii < arguments.length; ++ii) {
            newNames[ii] = ClassUtil.getArgumentName(arguments[ii]);
        }
        ArrayUtil.ensureUnique(newNames);
        return newNames;
    }

    private void appendImportBlocks(JavaLineAssembler assembler) {
        List importBlocks = this.processImports();
        for (int ii = 0; ii < importBlocks.size(); ++ii) {
            Set currentBlock = (Set)importBlocks.get(ii);
            assembler.appendImports(new ArrayList(currentBlock));
            assembler.appendNewLine();
        }
    }

    private void appendCommentBlock(JavaLineAssembler assembler, String[] commentLines) {
        if (this.createJavaDocComments) {
            assembler.appendJavaDocComment(commentLines);
        } else {
            assembler.appendBlockComment(commentLines);
        }
    }

    private void appendMembers(JavaLineAssembler assembler) {
        String[] memberTypeNames = this.getClassNames(this.memberTypes);
        if (null == memberTypeNames) {
            return;
        }
        for (int ii = 0; ii < memberTypeNames.length; ++ii) {
            assembler.appendMemberDeclaration(memberTypeNames[ii], (String)this.memberNames.get(ii));
        }
    }

    private void appendMethods(JavaLineAssembler assembler) {
        for (int ii = 0; ii < this.methods.size(); ++ii) {
            MethodDeclaration declaration = (MethodDeclaration)this.methods.get(ii);
            this.appendMethodHeader(assembler, declaration);
            String[] modifiers = this.prepareModifiers(declaration.getModifier());
            String returnType = this.getClassName(declaration.getReturnType());
            String[] argumentTypes = this.getClassNames(declaration.getArguments());
            String[] exceptionTypes = this.getClassNames(declaration.getExceptions());
            String[] argumentNames = this.getArgumentNames(declaration.getArguments(), declaration.getArgumentNames());
            assembler.appendMethodDeclaration(modifiers, returnType, declaration.getName(), argumentTypes, argumentNames, exceptionTypes);
            this.appendMethodBody(assembler, declaration);
        }
    }

    private void appendConstructors(JavaLineAssembler assembler) {
        for (int ii = 0; ii < this.constructors.size(); ++ii) {
            ConstructorDeclaration declaration = (ConstructorDeclaration)this.constructors.get(ii);
            this.appendMethodHeader(assembler, declaration);
            String[] argumentTypes = this.getClassNames(declaration.getArguments());
            String[] exceptionTypes = this.getClassNames(declaration.getExceptions());
            String[] argumentNames = this.getArgumentNames(declaration.getArguments(), declaration.getArgumentNames());
            assembler.appendConstructorDeclaration(this.className, argumentTypes, argumentNames, exceptionTypes);
            this.appendMethodBody(assembler, declaration);
        }
    }

    private void appendMethodHeader(JavaLineAssembler assembler, ConstructorDeclaration declaration) {
        assembler.appendNewLine();
        this.appendCommentBlock(assembler, declaration.getCommentLines());
    }

    private void appendMethodBody(JavaLineAssembler assembler, ConstructorDeclaration declaration) {
        assembler.appendIndent();
        assembler.appendLeftBrace();
        assembler.appendNewLine();
        this.appendCodeLines(assembler, declaration.getCodeLines());
        assembler.appendIndent();
        assembler.appendRightBrace();
        assembler.appendNewLine();
    }

    private void appendCodeLines(JavaLineAssembler assembler, String[] codeLines) {
        assembler.setIndentLevel(2);
        assembler.appendCodeLines(codeLines);
        assembler.setIndentLevel(1);
    }

    private String[] prepareModifiers(int modifier) {
        String modifierString = Modifier.toString(modifier);
        if (null == modifierString || modifierString.trim().length() <= 0) {
            return null;
        }
        return StringUtil.split(modifierString, " ", true);
    }

    private List processImports() {
        this.addMissingImports();
        PackageImportSorter sorter = new PackageImportSorter();
        return sorter.sortBlocks(this.imports);
    }

    private void addMissingImports() {
        ConstructorDeclaration declaration;
        int ii;
        this.addImportIfNecessary(this.superClass);
        this.addImportsIfNecessary(this.interfaces);
        this.addImportsIfNecessary(this.memberTypes);
        for (ii = 0; ii < this.constructors.size(); ++ii) {
            declaration = (ConstructorDeclaration)this.constructors.get(ii);
            this.addImportsForArguments(declaration);
            this.addImportsForExceptions(declaration);
        }
        for (ii = 0; ii < this.methods.size(); ++ii) {
            declaration = (MethodDeclaration)this.methods.get(ii);
            this.addImportForReturnType((MethodDeclaration)declaration);
            this.addImportsForArguments(declaration);
            this.addImportsForExceptions(declaration);
        }
    }

    private void addImportsForExceptions(ConstructorDeclaration declaration) {
        Class[] exceptions = declaration.getExceptions();
        if (null == exceptions || exceptions.length <= 0) {
            return;
        }
        for (int ii = 0; ii < exceptions.length; ++ii) {
            this.addImportIfNecessary(exceptions[ii]);
        }
    }

    private void addImportsForArguments(ConstructorDeclaration declaration) {
        Class[] arguments = declaration.getArguments();
        if (null == arguments || arguments.length <= 0) {
            return;
        }
        for (int ii = 0; ii < arguments.length; ++ii) {
            this.addImportIfNecessary(arguments[ii]);
        }
    }

    private void addImportForReturnType(MethodDeclaration declaration) {
        Class returnType = declaration.getReturnType();
        if (null == returnType) {
            return;
        }
        this.addImportIfNecessary(returnType);
    }

    private void addImportsIfNecessary(List classes) {
        if (null == classes) {
            return;
        }
        for (int ii = 0; ii < classes.size(); ++ii) {
            this.addImportIfNecessary((Class)classes.get(ii));
        }
    }

    private void addImportIfNecessary(Class clazz) {
        if (null == clazz) {
            return;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (this.imports.contains(clazz.getName())) {
            return;
        }
        if (clazz.getName().startsWith("java.lang")) {
            return;
        }
        if (this.belongsToSamePackage(clazz)) {
            return;
        }
        if (clazz.isPrimitive()) {
            return;
        }
        this.addImport(clazz);
    }

    private boolean belongsToSamePackage(Class clazz) {
        String thisPackageName = this.getPackageName();
        Package classPackage = clazz.getPackage();
        String classPackageName = "";
        if (null != classPackage) {
            classPackageName = classPackage.getName();
        }
        if (null == thisPackageName) {
            thisPackageName = "";
        }
        if (null == classPackageName) {
            classPackageName = "";
        }
        return thisPackageName.equals(classPackageName);
    }

    public static class MethodDeclaration
    extends ConstructorDeclaration {
        private int modifier;
        private Class returnType;
        private String name;

        public MethodDeclaration() {
            this("method");
        }

        public MethodDeclaration(String name) {
            this(1, name);
        }

        public MethodDeclaration(int modifier, String name) {
            this(modifier, name, Void.TYPE);
        }

        public MethodDeclaration(int modifier, String name, Class returnType) {
            this.setModifier(modifier);
            this.setReturnType(returnType);
            this.setName(name);
        }

        public int getModifier() {
            return this.modifier;
        }

        public void setModifier(int modifier) {
            this.modifier = modifier;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class getReturnType() {
            return this.returnType;
        }

        public void setReturnType(Class returnType) {
            this.returnType = returnType;
        }
    }

    public static class ConstructorDeclaration {
        private Class[] arguments;
        private String[] argumentNames;
        private String[] codeLines;
        private String[] commentLines;
        private Class[] exceptions;

        public String[] getCodeLines() {
            if (null == this.codeLines) {
                return null;
            }
            return (String[])ArrayUtil.copyArray(this.codeLines);
        }

        public void setCodeLines(String[] codeLines) {
            this.codeLines = (String[])ArrayUtil.copyArray(codeLines);
        }

        public String[] getCommentLines() {
            if (null == this.commentLines) {
                return null;
            }
            return (String[])ArrayUtil.copyArray(this.commentLines);
        }

        public void setCommentLines(String[] commentLines) {
            this.commentLines = (String[])ArrayUtil.copyArray(commentLines);
        }

        public String[] getArgumentNames() {
            if (null == this.argumentNames) {
                return null;
            }
            return (String[])ArrayUtil.copyArray(this.argumentNames);
        }

        public void setArgumentNames(String[] argumentNames) {
            this.argumentNames = (String[])ArrayUtil.copyArray(argumentNames);
        }

        public Class[] getArguments() {
            if (null == this.arguments) {
                return null;
            }
            return (Class[])ArrayUtil.copyArray(this.arguments);
        }

        public void setArguments(Class[] arguments) {
            this.arguments = (Class[])ArrayUtil.copyArray(arguments);
        }

        public Class[] getExceptions() {
            if (null == this.exceptions) {
                return null;
            }
            return (Class[])ArrayUtil.copyArray(this.exceptions);
        }

        public void setExceptions(Class[] exceptions) {
            this.exceptions = (Class[])ArrayUtil.copyArray(exceptions);
        }
    }
}

