/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.protempa.backend.dsb.relationaldb.JDBCPositionFormat;
import org.protempa.proposition.value.AbsoluteTimeGranularity;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;

public final class JDBCDateTimeTimestampPositionParser
implements JDBCPositionFormat {
    private final Long defaultDate;

    public JDBCDateTimeTimestampPositionParser() {
        this(null);
    }

    public JDBCDateTimeTimestampPositionParser(Date defaultDate) {
        this.defaultDate = defaultDate != null ? Long.valueOf(defaultDate.getTime()) : null;
    }

    @Override
    public Long toPosition(ResultSet resultSet, int columnIndex, int colType) throws SQLException {
        Date result;
        switch (colType) {
            case 91: {
                result = resultSet.getDate(columnIndex);
                break;
            }
            case 92: {
                result = resultSet.getTime(columnIndex);
                break;
            }
            default: {
                result = resultSet.getTimestamp(columnIndex);
            }
        }
        if (result != null) {
            return AbsoluteTimeGranularityUtil.asPosition((Date)result);
        }
        return this.defaultDate;
    }

    @Override
    public String format(Long position) {
        return "{ts '" + AbsoluteTimeGranularity.toSQLString((Long)position) + "'}";
    }
}

