/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.protempa.DataSourceBackendSourceSystem;
import org.protempa.DataStreamingEventIterator;
import org.protempa.SourceSystem;
import org.protempa.UniqueIdPair;
import org.protempa.backend.dsb.relationaldb.AbstractResultProcessor;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EmptyDataStreamingEventIterator;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.InboundReferenceResultSetIterator;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.PropositionResultSetIterator;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.StreamingMainResultProcessor;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueType;

class PrimitiveParameterStreamingResultProcessor
extends StreamingMainResultProcessor<PrimitiveParameter> {
    private static final DataStreamingEventIterator<UniqueIdPair> EMPTY_UNIQUE_ID_PAIR_ITR = new EmptyDataStreamingEventIterator<UniqueIdPair>();
    private static final DataStreamingEventIterator<PrimitiveParameter> EMPTY_PRIMPARAM_ITR = new EmptyDataStreamingEventIterator<PrimitiveParameter>();
    private PrimParamIterator itr;
    private final Set<String> queryPropIds;

    PrimitiveParameterStreamingResultProcessor(EntitySpec entitySpec, LinkedHashMap<String, ReferenceSpec> inboundRefSpecs, Map<String, ReferenceSpec> bidirectionalRefSpecs, String dataSourceBackendId, Set<String> propIds) {
        super(entitySpec, inboundRefSpecs, bidirectionalRefSpecs, dataSourceBackendId);
        assert (propIds != null) : "propIds cannot be null";
        this.queryPropIds = propIds;
    }

    public void process(ResultSet resultSet) throws SQLException {
        EntitySpec entitySpec = this.getEntitySpec();
        this.itr = new PrimParamIterator(this.getStatement(), resultSet, entitySpec, this.getInboundRefSpecs(), this.getBidirectionalRefSpecs(), new InboundReferenceResultSetIterator(entitySpec.getName()));
    }

    @Override
    final DataStreamingEventIterator<PrimitiveParameter> getResults() {
        if (this.itr != null) {
            return this.itr;
        }
        return EMPTY_PRIMPARAM_ITR;
    }

    @Override
    DataStreamingEventIterator<UniqueIdPair> getInboundReferenceResults() {
        if (this.itr != null) {
            return this.itr.getReferenceIterator();
        }
        return EMPTY_UNIQUE_ID_PAIR_ITR;
    }

    class PrimParamIterator
    extends PropositionResultSetIterator<PrimitiveParameter> {
        private final Logger logger;
        private final DataSourceBackendSourceSystem dsType;
        private final Date now;

        PrimParamIterator(Statement statement, ResultSet resultSet, EntitySpec entitySpec, Map<String, ReferenceSpec> inboundRefSpecs, Map<String, ReferenceSpec> bidirectionalRefSpecs, InboundReferenceResultSetIterator referenceIterator) throws SQLException {
            super(statement, resultSet, entitySpec, inboundRefSpecs, bidirectionalRefSpecs, PrimitiveParameterStreamingResultProcessor.this.getDataSourceBackendId(), referenceIterator);
            this.logger = SQLGenUtil.logger();
            this.dsType = DataSourceBackendSourceSystem.getInstance((String)PrimitiveParameterStreamingResultProcessor.this.getDataSourceBackendId());
            this.now = new Date();
        }

        @Override
        void doProcess(ResultSet resultSet, String[] uniqueIds, ColumnSpec codeSpec, EntitySpec entitySpec, Map<String, ReferenceSpec> bidirectionalRefSpecs, int[] columnTypes, String[] propIds, PropertySpec[] propertySpecs, Value[] propertyValues, UniqueIdPair[] refUniqueIds) throws SQLException {
            String kId;
            int i = 1;
            if ((kId = resultSet.getString(i++)) == null) {
                this.logger.warning("A keyId is null. Skipping record.");
                return;
            }
            this.handleKeyId(kId);
            i = AbstractResultProcessor.readUniqueIds(uniqueIds, resultSet, i);
            if (Arrays.contains((Object[])uniqueIds, null)) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Unique ids contain null ({0}). Skipping record.", StringUtils.join((Object[])uniqueIds, (String)", "));
                }
                this.getReferenceIterator().addUniqueIds(kId, null);
                return;
            }
            UniqueId uniqueId = PrimitiveParameterStreamingResultProcessor.this.generateUniqueId(entitySpec.getName(), uniqueIds);
            String propId = null;
            if (!PrimitiveParameterStreamingResultProcessor.this.isCasePresent()) {
                String code;
                if (codeSpec == null) {
                    assert (propIds.length == 1) : "Don't know which proposition id to assign to";
                    propId = propIds[0];
                } else if ((propId = StreamingMainResultProcessor.sqlCodeToPropositionId(codeSpec, code = resultSet.getString(i++))) == null) {
                    this.getReferenceIterator().addUniqueIds(kId, null);
                    return;
                }
            } else {
                ++i;
            }
            Long timestamp = null;
            try {
                timestamp = entitySpec.getPositionParser().toPosition(resultSet, i, columnTypes[i - 1]);
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Could not parse timestamp. Leaving timestamp unset.", e);
            }
            ValueType valueType = entitySpec.getValueType();
            int n = ++i;
            ++i;
            String cpValStr = resultSet.getString(n);
            Value cpVal = valueType.parse(cpValStr);
            i = PrimitiveParameterStreamingResultProcessor.this.extractPropertyValues(resultSet, i, propertyValues, columnTypes);
            i = PrimitiveParameterStreamingResultProcessor.this.extractReferenceUniqueIdPairs(resultSet, uniqueId, refUniqueIds, i);
            this.getReferenceIterator().addUniqueIds(kId, refUniqueIds);
            if (PrimitiveParameterStreamingResultProcessor.this.isCasePresent()) {
                propId = resultSet.getString(i++);
            }
            if (!PrimitiveParameterStreamingResultProcessor.this.queryPropIds.contains(propId)) {
                return;
            }
            PrimitiveParameter p = new PrimitiveParameter(propId, uniqueId);
            p.setPosition(timestamp);
            p.setGranularity(entitySpec.getGranularity());
            p.setValue(cpVal);
            for (int j = 0; j < propertySpecs.length; ++j) {
                PropertySpec propertySpec = propertySpecs[j];
                p.setProperty(propertySpec.getName(), propertyValues[j]);
            }
            p.setSourceSystem((SourceSystem)this.dsType);
            p.setDownloadDate(this.now);
            this.handleProposition(p);
            this.logger.log(Level.FINEST, "Created primitive parameter {0}", p);
        }

        @Override
        void fireResultSetCompleted() {
            this.getReferenceIterator().resultSetComplete();
        }
    }
}

