/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import org.protempa.backend.dsb.relationaldb.ColumnSpec;

public final class StagedColumnSpec {
    private final ColumnSpec spec;
    private final String asName;
    private final String[] forEntitySpecs;

    public StagedColumnSpec(String schema, String table, String column, String asName, String[] forEntitySpecs) {
        if (asName != null && (forEntitySpecs == null || forEntitySpecs.length < 1)) {
            throw new IllegalArgumentException("The substitute name for a column must apply to at least one entity spec. 'forEntitySpecs' is null or has fewer than 1 element.");
        }
        this.spec = new ColumnSpec(schema, table, column);
        this.asName = asName;
        this.forEntitySpecs = forEntitySpecs;
    }

    public StagedColumnSpec(String schema, String table, String column) {
        this(schema, table, column, null, null);
    }

    public String getSchema() {
        return this.spec.getSchema();
    }

    public String getTable() {
        return this.spec.getTable();
    }

    public String getColumn() {
        return this.spec.getColumn();
    }

    public String getAsName() {
        return this.asName;
    }

    public String[] getForEntitySpecs() {
        if (null == this.forEntitySpecs) {
            return null;
        }
        return (String[])this.forEntitySpecs.clone();
    }

    public ColumnSpec toColumnSpec() {
        return this.spec;
    }
}

