/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.StagedColumnSpec;
import org.protempa.backend.dsb.relationaldb.TableSpec;

public final class StagingSpec {
    private final TableSpec stagingArea;
    private final String indexTablespace;
    private final String uniqueColumn;
    private final TableSpec replacedTable;
    private final StagedColumnSpec[] stagedColumns;
    private final EntitySpec[] entitySpecs;

    public StagingSpec(TableSpec stagingArea, String indexTablespace, String uniqueColumn, TableSpec replacedTable, StagedColumnSpec[] stagedColumns, EntitySpec[] entitySpecs) {
        if (!this.validateStagedColumns(stagedColumns, entitySpecs)) {
            throw new IllegalArgumentException("All staging columns that specify substitute column names must apply only to entity specs that are specified in the staging spec.");
        }
        this.stagingArea = stagingArea;
        this.indexTablespace = indexTablespace;
        this.uniqueColumn = uniqueColumn;
        this.replacedTable = replacedTable;
        this.stagedColumns = stagedColumns;
        this.entitySpecs = entitySpecs;
    }

    public static StagingSpec newTableName(StagingSpec stagingSpec, String newTableName) {
        return new StagingSpec(TableSpec.withSchemaAndTable(stagingSpec.getStagingArea().getSchema(), newTableName), stagingSpec.getIndexTablespace(), stagingSpec.getUniqueColumn(), stagingSpec.getReplacedTable(), stagingSpec.getStagedColumns(), stagingSpec.getEntitySpecs());
    }

    private boolean validateStagedColumns(StagedColumnSpec[] stagedColumns, EntitySpec[] entitySpecs) {
        for (StagedColumnSpec cs : stagedColumns) {
            if (cs.getForEntitySpecs() == null) continue;
            for (String esName : cs.getForEntitySpecs()) {
                boolean match = false;
                for (EntitySpec es : entitySpecs) {
                    if (!esName.equals(es.getName())) continue;
                    match = true;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public TableSpec getStagingArea() {
        return this.stagingArea;
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public String getUniqueColumn() {
        return this.uniqueColumn;
    }

    public TableSpec getReplacedTable() {
        return this.replacedTable;
    }

    public StagedColumnSpec[] getStagedColumns() {
        return (StagedColumnSpec[])this.stagedColumns.clone();
    }

    public EntitySpec[] getEntitySpecs() {
        return this.entitySpecs;
    }
}

