/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb.mappings;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.arp.javautil.arrays.Arrays;
import org.protempa.backend.dsb.relationaldb.mappings.Mappings;

public class DefaultMappings
implements Mappings {
    private static final Logger LOGGER = Logger.getLogger(DefaultMappings.class.toString());
    private static final String DEFAULT_DESCRIPTION_MISSING_TARGET = "DescriptionMissing";
    private final Map<Object, String> cache;
    private final Set<Object> descriptionsMissing;

    public DefaultMappings(Map<Object, String> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException("mappings cannot be null");
        }
        this.cache = new HashMap<Object, String>(mappings);
        this.descriptionsMissing = new HashSet<Object>();
    }

    @Override
    public Object[] readSources() {
        Set<Object> keySet = this.cache.keySet();
        return keySet.toArray(new Object[keySet.size()]);
    }

    @Override
    public String[] readTargets() throws IOException {
        Collection<String> targetColl = this.cache.values();
        HashSet<String> targets = new HashSet<String>();
        for (String target : targetColl) {
            targets.add(target);
        }
        return targets.toArray(new String[targets.size()]);
    }

    @Override
    public String getTarget(Object source) {
        String result = this.cache.get(source);
        if (result == null && (result = this.cache.get("*")) == null) {
            result = DEFAULT_DESCRIPTION_MISSING_TARGET;
            if (this.descriptionsMissing.add(source) && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "No mapping for source {0}; this value will be loaded as {1}", new Object[]{source, result});
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Mappings subMappingsBySources(Object[] sources) {
        HashMap<Object, String> newMappings = new HashMap<Object, String>();
        for (Object source : sources) {
            newMappings.put(source, this.cache.get(source));
        }
        return new DefaultMappings(newMappings);
    }

    @Override
    public Mappings subMappingsByTargets(String[] targets) {
        HashMap<Object, String> newMappings = new HashMap<Object, String>();
        Set targetsSet = Arrays.asSet((Object[])targets);
        for (Map.Entry<Object, String> me : this.cache.entrySet()) {
            if (!targetsSet.contains(me.getValue())) continue;
            newMappings.put(me.getKey(), me.getValue());
        }
        return new DefaultMappings(newMappings);
    }

    @Override
    public void close() {
        this.cache.clear();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

