/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb.mappings;

import java.io.IOException;
import org.protempa.backend.dsb.relationaldb.mappings.AbstractMappingsFactory;
import org.protempa.backend.dsb.relationaldb.mappings.ResourceMappings;

public class ResourceMappingsFactory
extends AbstractMappingsFactory {
    private final String resourcePrefix;
    private final Class<?> cls;

    public ResourceMappingsFactory(String resourcePrefix, Class<?> cls) {
        if (resourcePrefix == null) {
            throw new IllegalArgumentException("resourcePrefix cannot be null");
        }
        if (cls == null) {
            throw new IllegalArgumentException("cls cannot be null");
        }
        this.resourcePrefix = resourcePrefix.endsWith("/") ? resourcePrefix : resourcePrefix + "/";
        this.cls = cls;
    }

    @Override
    public ResourceMappings getInstance(String resource) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        ResourceMappings m = new ResourceMappings(this.resourcePrefix + resource, this.cls);
        this.addMappings(m);
        return m;
    }
}

