/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ConnectionSpecQueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.TableAccessReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.arp.javautil.sql.DatabaseAPI;
import org.arp.javautil.sql.DatabaseProduct;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;
import org.protempa.KnowledgeSourceReadException;

class QuerySupport {
    private static final String DEFAULT_EUREKA_ID_COLUMN = "EK_UNIQUE_ID";
    private DatabaseAPI databaseApi = DatabaseAPI.DRIVERMANAGER;
    private String databaseId;
    private String username;
    private String password;
    private String excludeTableName;
    private TableAccessReader ontTableReader = new TableAccessReader(null);
    private String eurekaIdColumn = "EK_UNIQUE_ID";
    private DatabaseProduct databaseProduct;

    QuerySupport() {
    }

    String getEurekaIdColumn() {
        return this.eurekaIdColumn;
    }

    void setEurekaIdColumn(String eurekaIdColumn) {
        this.eurekaIdColumn = eurekaIdColumn;
    }

    DatabaseAPI getDatabaseApi() {
        return this.databaseApi;
    }

    void setDatabaseApi(DatabaseAPI databaseApi) {
        this.databaseApi = databaseApi;
    }

    String getDatabaseId() {
        return this.databaseId;
    }

    void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
        this.databaseProduct = null;
    }

    String getUsername() {
        return this.username;
    }

    void setUsername(String username) {
        this.username = username;
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = password;
    }

    String getExcludeTableName() {
        return this.excludeTableName;
    }

    void setExcludeTableName(String excludeTableName) {
        this.excludeTableName = excludeTableName;
        this.ontTableReader = new TableAccessReader(excludeTableName);
    }

    TableAccessReader getTableAccessReader() {
        return this.ontTableReader;
    }

    Connection getConnection() throws InvalidConnectionSpecArguments, SQLException {
        return this.databaseApi.newConnectionSpecInstance(this.databaseId, this.username, this.password, false).getOrCreate();
    }

    DatabaseProduct getDatabaseProduct() throws KnowledgeSourceReadException {
        if (this.databaseProduct == null) {
            try (Connection cn = this.getConnection();){
                this.databaseProduct = DatabaseProduct.fromMetaData((DatabaseMetaData)cn.getMetaData());
            }
            catch (SQLException | InvalidConnectionSpecArguments ex) {
                throw new KnowledgeSourceReadException(ex);
            }
        }
        return this.databaseProduct;
    }

    ConnectionSpecQueryExecutor getQueryExecutorInstance(QueryConstructor queryConstructor, String ... tables) throws KnowledgeSourceReadException {
        try {
            return new ConnectionSpecQueryExecutor(this.databaseApi, this.databaseId, this.username, this.password, queryConstructor, tables);
        }
        catch (SQLException | InvalidConnectionSpecArguments ex) {
            throw new KnowledgeSourceReadException(ex);
        }
    }

    ConnectionSpecQueryExecutor getQueryExecutorInstance(QueryConstructor queryConstructor) throws KnowledgeSourceReadException {
        try {
            return new ConnectionSpecQueryExecutor(this.databaseApi, this.databaseId, this.username, this.password, queryConstructor, this.ontTableReader);
        }
        catch (SQLException | InvalidConnectionSpecArguments ex) {
            throw new KnowledgeSourceReadException(ex);
        }
    }

    QueryExecutor getQueryExecutorInstance(Connection connection, QueryConstructor queryConstructor, String ... tables) throws KnowledgeSourceReadException {
        if (connection != null) {
            return new QueryExecutor(connection, queryConstructor, tables);
        }
        return this.getQueryExecutorInstance(queryConstructor, tables);
    }

    QueryExecutor getQueryExecutorInstance(Connection connection, QueryConstructor queryConstructor) throws KnowledgeSourceReadException {
        if (connection != null) {
            return new QueryExecutor(connection, queryConstructor, this.ontTableReader);
        }
        return this.getQueryExecutorInstance(queryConstructor);
    }
}

