/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.datastore;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.logging.Level;
import org.arp.javautil.datastore.BdbStoreFactory;
import org.arp.javautil.datastore.DataStoreUtil;

public class BdbCacheFactory<E, V>
extends BdbStoreFactory<E, V> {
    private static final String CLASS_CATALOG = "java_class_catalog";

    public BdbCacheFactory(String pathname, boolean deleteOnExit) {
        super(pathname, deleteOnExit);
    }

    @Override
    protected DatabaseConfig createDatabaseConfig() {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTemporary(true);
        return dbConfig;
    }

    @Override
    protected EnvironmentConfig createEnvConfig() {
        EnvironmentConfig envConf = new EnvironmentConfig();
        envConf.setAllowCreate(true);
        envConf.setTransactional(false);
        envConf.setConfigParam("je.evictor.lruOnly", "false");
        envConf.setConfigParam("je.evictor.nodesPerScan", "100");
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        long max = memoryUsage.getMax();
        long used = memoryUsage.getUsed();
        long available = max - used;
        long cacheSize = Math.round((double)available / 4.0);
        envConf.setCacheSize(cacheSize);
        DataStoreUtil.logger().log(Level.FINE, "BerkeleyDB cache size: {0} bytes", cacheSize);
        return envConf;
    }

    @Override
    protected StoredClassCatalog createClassCatalog(Environment env) throws IllegalArgumentException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTemporary(true);
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(false);
        Database catalogDb = env.openDatabase(null, CLASS_CATALOG, dbConfig);
        return new StoredClassCatalog(catalogDb);
    }
}

