/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.graph;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.graph.Edge;
import org.arp.javautil.graph.Weight;

public final class DirectedGraph {
    private static int DEFAULT_INITIAL_CAPACITY = 10;
    private int capacity;
    private Edge[][] edges;
    private transient Edge[] edgesArr;
    private transient int edgeModCount;
    private int edgeCount;
    private final Map<Object, VertexMetadata> vertices;
    private transient int vertexModCount;
    private final FreeList freeList;

    public DirectedGraph(int initialCapacity) {
        this.capacity = initialCapacity > 0 ? initialCapacity : DEFAULT_INITIAL_CAPACITY;
        this.edges = new Edge[initialCapacity][initialCapacity];
        this.vertices = new HashMap<Object, VertexMetadata>(initialCapacity);
        this.freeList = new FreeList();
        for (int row = this.capacity - 1; row >= 0; --row) {
            this.freeList.add(row);
        }
    }

    public DirectedGraph() {
        this(DEFAULT_INITIAL_CAPACITY);
    }

    public void clear() {
        this.vertices.clear();
        ++this.vertexModCount;
        Arrays.matrixFill(this.edges, null);
        this.edgeCount = 0;
        this.edgesArr = null;
        ++this.edgeModCount;
        this.freeList.clear();
        for (int row = this.capacity - 1; row >= 0; --row) {
            this.freeList.add(row);
        }
    }

    public void add(Object vertex) {
        if (vertex == null || this.vertices.containsKey(vertex)) {
            return;
        }
        this.checkGraphSize();
        this.vertices.put(vertex, new VertexMetadata(this.freeList.removeFirst()));
        ++this.vertexModCount;
    }

    public Object remove(Object vertex) {
        VertexMetadata vm = this.vertices.get(vertex);
        if (vm == null) {
            return null;
        }
        this.vertices.remove(vertex);
        ++this.vertexModCount;
        int index = vm.index;
        for (int row = 0; row < this.capacity; ++row) {
            this.edges[row][index] = null;
            this.edges[index][row] = null;
            ++this.edgeModCount;
        }
        this.edgesArr = null;
        this.freeList.add(index);
        return vertex;
    }

    public boolean contains(Object vertex) {
        return this.vertices.containsKey(vertex);
    }

    public int size() {
        return this.vertices.size();
    }

    public boolean isEmpty() {
        return this.vertices.isEmpty();
    }

    public Edge getEdge(Object vertex1, Object vertex2) {
        VertexMetadata vm1 = this.vertices.get(vertex1);
        VertexMetadata vm2 = this.vertices.get(vertex2);
        if (vm1 == null || vm2 == null) {
            return null;
        }
        return this.edges[vm1.index][vm2.index];
    }

    public void setEdge(Object vertex1, Object vertex2, Weight weight) {
        VertexMetadata vm1 = this.vertices.get(vertex1);
        VertexMetadata vm2 = this.vertices.get(vertex2);
        if (vm1 == null || vm2 == null) {
            return;
        }
        int index1 = vm1.index;
        int index2 = vm2.index;
        Edge e = new Edge(vertex1, vertex2, weight);
        Edge prev = this.edges[index1][index2];
        this.edges[index1][index2] = e;
        this.edgesArr = null;
        ++this.edgeModCount;
        if (prev == null) {
            ++this.edgeCount;
        }
    }

    public boolean containsEdge(Object label1, Object label2) {
        return this.getEdge(label1, label2) != null;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public Iterator<?> iterator() {
        return this.vertices.keySet().iterator();
    }

    public Iterator<?> neighbors(Object label) {
        return new NeighborIterator(label);
    }

    public Edge[] edgesAsArray() {
        if (this.edgesArr == null) {
            this.edgesArr = new Edge[this.edgeCount];
            Iterator<Edge> itr = this.edges();
            for (int i = 0; i < this.edgeCount; ++i) {
                this.edgesArr[i] = itr.next();
            }
        }
        return this.edgesArr;
    }

    public Iterator<Edge> edges() {
        return new EdgeIterator();
    }

    private void checkGraphSize() {
        if (this.freeList.isEmpty()) {
            int oldSize = this.capacity;
            this.capacity += 10;
            Object[][] newdata = new Edge[this.capacity][this.capacity];
            Arrays.matrixCopy(this.edges, newdata);
            this.edges = newdata;
            for (int row = this.capacity - 1; row >= oldSize; --row) {
                this.freeList.add(row);
            }
        }
    }

    private class EdgeIterator
    implements Iterator<Edge> {
        int row;
        int column = -1;
        int expectedModCount = DirectedGraph.access$700(DirectedGraph.this);

        private EdgeIterator() {
            try {
                this.advance();
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.row < DirectedGraph.this.edges.length && this.column < DirectedGraph.this.edges[this.row].length;
        }

        @Override
        public Edge next() {
            this.checkForComodification();
            try {
                Edge result = DirectedGraph.this.edges[this.row][this.column];
                this.advance();
                return result;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (true) {
                if (++this.column < DirectedGraph.this.edges[this.row].length) {
                    if (DirectedGraph.this.edges[this.row][this.column] == null) continue;
                    return;
                }
                ++this.row;
                this.column = -1;
                if (this.row >= DirectedGraph.this.edges.length) break;
            }
        }

        final void checkForComodification() {
            if (DirectedGraph.this.edgeModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class NeighborIterator
    implements Iterator {
        final Object vertex;
        final int index;
        int row;
        Object neighbor;
        int expectedModCount;

        private NeighborIterator(Object vertex) {
            this.row = DirectedGraph.this.capacity;
            this.expectedModCount = DirectedGraph.this.vertexModCount;
            this.vertex = vertex;
            this.index = ((VertexMetadata)((DirectedGraph)DirectedGraph.this).vertices.get((Object)vertex)).index;
            try {
                this.advance();
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.neighbor != null;
        }

        public Object next() {
            this.checkForComodification();
            try {
                Object result = this.neighbor;
                this.advance();
                return result;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            this.neighbor = null;
            if (this.vertex != null) {
                while (--this.row >= 0) {
                    Edge e = DirectedGraph.this.edges[this.index][this.row];
                    if (e == null) continue;
                    if (e.getStart().equals(this.vertex)) {
                        this.neighbor = e.getFinish();
                        break;
                    }
                    this.neighbor = e.getStart();
                    break;
                }
            }
        }

        final void checkForComodification() {
            if (DirectedGraph.this.vertexModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class VertexMetadata {
        int index;

        VertexMetadata(int index) {
            this.index = index;
        }
    }

    private static class FreeList {
        private Entry header;

        private FreeList() {
        }

        void add(int element) {
            this.header = new Entry(element, this.header);
        }

        void clear() {
            this.header = null;
        }

        int removeFirst() {
            int first = this.header.element;
            Entry oldHeader = this.header;
            this.header = this.header.next;
            oldHeader.next = null;
            return first;
        }

        boolean isEmpty() {
            return this.header == null;
        }

        private static class Entry {
            int element;
            Entry next;

            Entry(int element, Entry next) {
                this.element = element;
                this.next = next;
            }
        }
    }
}

