/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.framework.bcelbundle;

import com.kirkk.analyzer.framework.Jar;
import com.kirkk.analyzer.framework.JarCollection;
import com.kirkk.analyzer.framework.bcelbundle.JarBuilderImpl;
import com.kirkk.analyzer.framework.jar.JarFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JarCollectionImpl
implements JarCollection {
    private List jars;
    private Iterator jarIterator;

    public JarCollectionImpl(File file) throws Exception {
        this(file, new ArrayList());
    }

    public JarCollectionImpl(File file, List list) throws Exception {
        this(file, list, new ArrayList());
    }

    public JarCollectionImpl(File file, List list, List list2) throws Exception {
        this.jars = this.getJars(file, list, list2);
        this.jarIterator = this.jars.iterator();
    }

    public int getJarCount() {
        return this.jars.size();
    }

    public boolean hasNext() {
        return this.jarIterator.hasNext();
    }

    public Jar nextJar() {
        return (Jar)this.jarIterator.next();
    }

    public void first() {
        this.jarIterator = this.jars.iterator();
    }

    public Jar getJar(String string) {
        Iterator iterator = this.jars.iterator();
        while (iterator.hasNext()) {
            Jar jar = (Jar)iterator.next();
            if (!jar.getJarFileName().equals(string)) continue;
            return jar;
        }
        return null;
    }

    public Jar getJarContainingPackage(String string) {
        Iterator iterator = this.jars.iterator();
        while (iterator.hasNext()) {
            Jar jar = (Jar)iterator.next();
            if (!jar.containsPackage(string)) continue;
            return jar;
        }
        return null;
    }

    public Jar[] toArray() {
        Jar[] jarArray = new Jar[this.jars.size()];
        Iterator iterator = this.jars.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            jarArray[n] = (Jar)iterator.next();
            ++n;
        }
        return jarArray;
    }

    private List getJars(File file, List list, List list2) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray = this.getJarFiles(file);
            ArrayList<Jar> arrayList = new ArrayList<Jar>();
            for (int i = 0; i < fileArray.length; ++i) {
                JarBuilderImpl jarBuilderImpl = new JarBuilderImpl();
                JarFile jarFile = new JarFile(fileArray[i]);
                Jar jar = jarBuilderImpl.buildJar(jarFile, list);
                if (jar.getClassCount() <= 0 || list2.contains(jar.getJarFileName())) continue;
                arrayList.add(jar);
            }
            return arrayList;
        }
        throw new IOException("File must be a directory");
    }

    private File[] getJarFiles(File file) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        };
        return file.listFiles(filenameFilter);
    }
}

