/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEventIterator;
import org.protempa.UniqueIdPair;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.filter.PositionFilter;
import org.protempa.backend.dsb.relationaldb.ConstantResultProcessorFactory;
import org.protempa.backend.dsb.relationaldb.DataStager;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.EventResultProcessorFactory;
import org.protempa.backend.dsb.relationaldb.PrimitiveParameterResultProcessorFactory;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.RelationalDatabaseSpec;
import org.protempa.backend.dsb.relationaldb.RelationalDbDataReadIterator;
import org.protempa.backend.dsb.relationaldb.RelationalDbDataSourceBackend;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessorFactory;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.SQLGenerator;
import org.protempa.backend.dsb.relationaldb.SQLOrderBy;
import org.protempa.backend.dsb.relationaldb.SelectStatement;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.backend.dsb.relationaldb.StreamingMainResultProcessor;
import org.protempa.backend.dsb.relationaldb.StreamingResultProcessor;
import org.protempa.backend.dsb.relationaldb.StreamingSQLExecutor;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.GranularityFactory;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.UnitFactory;

public abstract class AbstractSQLGenerator
implements SQLGenerator {
    static final int FETCH_SIZE = 10000;
    private static final int DEFAULT_QUERY_THREAD_COUNT = 4;
    private static final String readPropositionsSQL = "select {0} from {1} {2}";
    private ConnectionSpec connectionSpec;
    private final Map<String, List<EntitySpec>> primitiveParameterSpecs = new HashMap<String, List<EntitySpec>>();
    private EntitySpec[] primitiveParameterEntitySpecs;
    private final Map<String, List<EntitySpec>> eventSpecs = new HashMap<String, List<EntitySpec>>();
    private EntitySpec[] eventEntitySpecs;
    private final Map<String, List<EntitySpec>> constantSpecs = new HashMap<String, List<EntitySpec>>();
    private EntitySpec[] constantEntitySpecs;
    private StagingSpec[] stagedTableSpecs;
    private GranularityFactory granularities;
    private UnitFactory units;
    private RelationalDbDataSourceBackend backend;
    private int queryThreadCount = 4;

    protected AbstractSQLGenerator() {
    }

    @Override
    public void initialize(ConnectionSpec connectionSpec, RelationalDatabaseSpec relationalDatabaseSpec, RelationalDbDataSourceBackend backend) {
        if (relationalDatabaseSpec != null) {
            this.primitiveParameterEntitySpecs = relationalDatabaseSpec.getPrimitiveParameterSpecs();
            AbstractSQLGenerator.populatePropositionMap(this.primitiveParameterSpecs, this.primitiveParameterEntitySpecs);
            this.eventEntitySpecs = relationalDatabaseSpec.getEventSpecs();
            AbstractSQLGenerator.populatePropositionMap(this.eventSpecs, this.eventEntitySpecs);
            this.constantEntitySpecs = relationalDatabaseSpec.getConstantSpecs();
            AbstractSQLGenerator.populatePropositionMap(this.constantSpecs, this.constantEntitySpecs);
            this.stagedTableSpecs = relationalDatabaseSpec.getStagedSpecs();
            this.granularities = relationalDatabaseSpec.getGranularities();
            this.units = relationalDatabaseSpec.getUnits();
            this.connectionSpec = connectionSpec;
            Integer queryThreadCountSetting = backend.getQueryThreadCount();
            if (queryThreadCountSetting != null) {
                this.queryThreadCount = queryThreadCountSetting;
            }
        } else {
            throw new IllegalArgumentException("relationalDatabaseSpec cannot be null");
        }
        this.backend = backend;
    }

    public boolean getStreamingMode() {
        return true;
    }

    @Override
    public GranularityFactory getGranularities() {
        return this.granularities;
    }

    @Override
    public UnitFactory getUnits() {
        return this.units;
    }

    @Override
    public final boolean loadDriverIfNeeded() {
        String className = this.getDriverClassNameToLoad();
        if (className == null) {
            return true;
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            Logger logger = SQLGenUtil.logger();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0} when trying to load {1}.", new Object[]{ex.getClass().getName(), className});
            }
            return false;
        }
    }

    @Override
    public DataStreamingEventIterator<Proposition> readPropositionsStreaming(Set<String> keyIds, Set<String> propIds, Filter filters) throws DataSourceReadException {
        Map<EntitySpec, List<String>> entitySpecToPropIds = this.entitySpecToPropIds(propIds);
        Map<EntitySpec, SQLGenResultProcessorFactory> allEntitySpecToResultProcessor = this.allEntitySpecToResultProcessor();
        Set<EntitySpec> allEntitySpecs = allEntitySpecToResultProcessor.keySet();
        DataStager stager = null;
        if (this.stagingApplies()) {
            stager = this.doStage(allEntitySpecs, filters, propIds, keyIds, null);
        }
        ArrayList itrs = new ArrayList();
        ExecutorService executor = Executors.newFixedThreadPool(this.queryThreadCount);
        ArrayList<Future<List<StreamingIteratorPair>>> list = new ArrayList<Future<List<StreamingIteratorPair>>>();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (EntitySpec entitySpec : entitySpecToPropIds.keySet()) {
            list.add(executor.submit(new SQLExecutorCallable(entitySpec, allEntitySpecToResultProcessor, allEntitySpecs, filters, propIds, keyIds)));
        }
        for (Future future : list) {
            try {
                itrs.addAll((Collection)future.get());
            }
            catch (InterruptedException ex) {
                SQLGenUtil.logger().log(Level.FINER, "SQL generation thread interrupted", ex);
            }
            catch (ExecutionException ex) {
                throw new DataSourceReadException((Throwable)ex);
            }
        }
        executor.shutdown();
        ArrayList<DataStreamingEventIterator<Proposition>> events = new ArrayList<DataStreamingEventIterator<Proposition>>(itrs.size());
        ArrayList<? extends DataStreamingEventIterator<UniqueIdPair>> arrayList = new ArrayList<DataStreamingEventIterator<UniqueIdPair>>();
        for (StreamingIteratorPair pair : itrs) {
            events.add(pair.getProps());
            arrayList.addAll(pair.getRefs());
        }
        RelationalDbDataReadIterator streamingResults = new RelationalDbDataReadIterator(arrayList, events, connections, this.stagingApplies() ? stager : null);
        return streamingResults;
    }

    private List<StreamingIteratorPair> processEntitySpecStreaming(EntitySpec entitySpec, Map<EntitySpec, SQLGenResultProcessorFactory> allEntitySpecToResultProcessor, Collection<EntitySpec> allEntitySpecs, Filter filters, Set<String> propIds, Set<String> keyIds, StreamingSQLExecutor executor) throws DataSourceReadException {
        ArrayList<StreamingIteratorPair> result = new ArrayList<StreamingIteratorPair>();
        Logger logger = SQLGenUtil.logger();
        this.logProcessingEntitySpec(logger, entitySpec);
        SQLGenResultProcessorFactory<Proposition> factory = AbstractSQLGenerator.getResultProcessorFactory(allEntitySpecToResultProcessor, entitySpec);
        List<EntitySpec> applicableEntitySpecs = AbstractSQLGenerator.computeApplicableEntitySpecs(allEntitySpecs, entitySpec);
        Set<Filter> applicableFilters = this.computeApplicableFilters(filters, allEntitySpecs, entitySpec);
        List<Set<Filter>> partitions = this.constructPartitions(entitySpec, applicableFilters);
        LinkedHashMap<String, ReferenceSpec> inboundRefSpecs = AbstractSQLGenerator.collectInboundRefSpecs(applicableEntitySpecs, entitySpec, propIds);
        Map<String, ReferenceSpec> bidirRefSpecs = AbstractSQLGenerator.collectBidirectionalReferences(applicableEntitySpecs, entitySpec, propIds);
        String dataSourceBackendId = this.backend.getDataSourceBackendId();
        StreamingMainResultProcessor<Proposition> resultProcessor = factory.getStreamingInstance(dataSourceBackendId, entitySpec, inboundRefSpecs, bidirRefSpecs, propIds);
        for (Set<Filter> filterSet : partitions) {
            this.generateAndExecuteSelectStreaming(entitySpec, null, propIds, filterSet, applicableEntitySpecs, inboundRefSpecs, keyIds, SQLOrderBy.ASCENDING, resultProcessor, executor, true);
            DataStreamingEventIterator<Proposition> results = resultProcessor.getResults();
            List<DataStreamingEventIterator<UniqueIdPair>> refResults = Collections.singletonList(resultProcessor.getInboundReferenceResults());
            result.add(new StreamingIteratorPair(results, refResults, executor.getConnection()));
        }
        this.logDoneProcessing(logger, entitySpec);
        return result;
    }

    private static List<EntitySpec> computeApplicableEntitySpecs(Collection<EntitySpec> allEntitySpecs, EntitySpec entitySpec) {
        LinkedList<EntitySpec> result = new LinkedList<EntitySpec>(allEntitySpecs);
        AbstractSQLGenerator.removeNonApplicableEntitySpecs(entitySpec, result);
        AbstractSQLGenerator.logApplicableEntitySpecs(result);
        assert (!result.isEmpty()) : "allEntitySpecsCopy should have at least one element";
        return result;
    }

    private Set<Filter> computeApplicableFilters(Filter filters, Collection<EntitySpec> allEntitySpecs, EntitySpec entitySpec) {
        Set<Filter> filtersCopy = AbstractSQLGenerator.copyFilters(filters);
        AbstractSQLGenerator.removeNonApplicableFilters(allEntitySpecs, filtersCopy, entitySpec);
        this.removeStagedFilters(entitySpec, filtersCopy);
        return filtersCopy;
    }

    private List<Set<Filter>> constructPartitions(EntitySpec entitySpec, Set<Filter> filtersCopy) {
        PositionFilter positionFilter = null;
        for (Filter filter : filtersCopy) {
            if (!(filter instanceof PositionFilter)) continue;
            positionFilter = (PositionFilter)filter;
            break;
        }
        Unit partitionBy = entitySpec.getPartitionBy();
        ArrayList<Set<Filter>> filterList = new ArrayList<Set<Filter>>();
        if (partitionBy == null || positionFilter == null || positionFilter.getStart() == null || positionFilter.getFinish() == null || !positionFilter.getStartSide().equals((Object)positionFilter.getFinishSide())) {
            filterList.add(filtersCopy);
        } else {
            Long start = positionFilter.getStart();
            Long actualFinish = positionFilter.getFinish();
            Granularity startGran = positionFilter.getStartGranularity();
            Granularity finishGran = positionFilter.getFinishGranularity();
            Unit finishUnit = finishGran != null ? finishGran.getCorrespondingUnit() : null;
            boolean doLoop = true;
            while (doLoop) {
                HashSet<Filter> newFiltersCopy = new HashSet<Filter>(filtersCopy);
                newFiltersCopy.remove(positionFilter);
                Long nextStart = partitionBy.addToPosition(start.longValue(), 1);
                Long finish = finishUnit != null ? finishUnit.addToPosition(nextStart.longValue(), -1) : -1L;
                if (finish.compareTo(actualFinish) >= 0) {
                    finish = actualFinish;
                    doLoop = false;
                }
                PositionFilter newPositionFilter = new PositionFilter(positionFilter.getPropositionIds(), start, startGran, finish, finishGran, positionFilter.getStartSide(), positionFilter.getFinishSide());
                newFiltersCopy.add((Filter)newPositionFilter);
                filterList.add(newFiltersCopy);
                start = nextStart;
            }
        }
        return filterList;
    }

    private DataStager doStage(Collection<EntitySpec> allEntitySpecs, Filter filters, Set<String> propIds, Set<String> keyIds, SQLOrderBy order) throws DataSourceReadException {
        DataStager stager = null;
        try {
            stager = this.getDataStager(this.stagedTableSpecs, null, new LinkedList<EntitySpec>(allEntitySpecs), AbstractSQLGenerator.copyFilters(filters), propIds, keyIds, order, this.connectionSpec);
            stager.stageTables();
        }
        catch (SQLException ex) {
            Logger logger = SQLGenUtil.logger();
            logger.log(Level.SEVERE, "Failed to create staging area", ex);
            throw new DataSourceReadException((Throwable)ex);
        }
        return stager;
    }

    private static SQLGenResultProcessorFactory<Proposition> getResultProcessorFactory(Map<EntitySpec, SQLGenResultProcessorFactory> allEntitySpecToResultProcessor, EntitySpec entitySpec) {
        SQLGenResultProcessorFactory factory = allEntitySpecToResultProcessor.get(entitySpec);
        assert (factory != null) : "factory should never be null";
        return factory;
    }

    private void removeStagedFilters(EntitySpec entitySpec, Set<Filter> filtersCopy) {
        boolean first = true;
        Unit partitionBy = entitySpec.getPartitionBy();
        Iterator<Filter> itr = filtersCopy.iterator();
        block0: while (itr.hasNext()) {
            String[] propIds;
            boolean isPositionFilter = false;
            Filter f = itr.next();
            if (f instanceof PositionFilter) {
                isPositionFilter = true;
            }
            for (String propId : propIds = f.getPropositionIds()) {
                ArrayList entitySpecs = new ArrayList();
                if (this.constantSpecs.containsKey(propId)) {
                    entitySpecs.addAll(this.constantSpecs.get(propId));
                }
                if (this.eventSpecs.containsKey(propId)) {
                    entitySpecs.addAll(this.eventSpecs.get(propId));
                }
                if (this.primitiveParameterSpecs.containsKey(propId)) {
                    entitySpecs.addAll(this.primitiveParameterSpecs.get(propId));
                }
                for (StagingSpec staged : this.stagedTableSpecs) {
                    for (EntitySpec es : entitySpecs) {
                        for (EntitySpec ses : staged.getEntitySpecs()) {
                            PositionFilter pf;
                            Long start;
                            if (!SQLGenUtil.somePropIdsMatch(es, ses)) continue;
                            if (first && isPositionFilter && partitionBy != null && (start = (pf = (PositionFilter)f).getStart()) != null) {
                                long addToPosition = partitionBy.addToPosition(start.longValue(), 1);
                                Long finish = pf.getFinish();
                                if (finish != null && addToPosition < finish) continue block0;
                            }
                            itr.remove();
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    private boolean stagingApplies() {
        return this.stagedTableSpecs != null && this.stagedTableSpecs.length > 0;
    }

    private void logDoneProcessing(Logger logger, EntitySpec entitySpec) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Results of query for {0} in data source backend {1} have been processed", new Object[]{entitySpec.getName(), this.backendNameForMessages()});
        }
    }

    private void logProcessingEntitySpec(Logger logger, EntitySpec entitySpec) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Data source backend {0} is processing entity spec {1}", new Object[]{this.backendNameForMessages(), entitySpec.getName()});
        }
    }

    private static void logApplicableEntitySpecs(List<EntitySpec> allEntitySpecsCopy) {
        Logger logger = SQLGenUtil.logger();
        if (logger.isLoggable(Level.FINER)) {
            Object[] allEntitySpecsCopyNames = new String[allEntitySpecsCopy.size()];
            int i = 0;
            for (EntitySpec aesc : allEntitySpecsCopy) {
                allEntitySpecsCopyNames[i++] = aesc.getName();
            }
            logger.log(Level.FINER, "Applicable entity specs are {0}", StringUtils.join((Object[])allEntitySpecsCopyNames, (String)", "));
        }
    }

    private static LinkedHashMap<String, ReferenceSpec> collectInboundRefSpecs(Collection<EntitySpec> entitySpecs, EntitySpec rhsEntitySpec, Set<String> propIds) {
        LinkedHashMap<String, ReferenceSpec> result = new LinkedHashMap<String, ReferenceSpec>();
        for (EntitySpec lhsReferenceSpec : entitySpecs) {
            if (!lhsReferenceSpec.hasReferenceTo(rhsEntitySpec) || !org.arp.javautil.collections.Collections.containsAny(propIds, (Object[])lhsReferenceSpec.getPropositionIds())) continue;
            boolean isMany = false;
            if (rhsEntitySpec.hasReferenceTo(lhsReferenceSpec)) {
                for (ReferenceSpec rhsToLhsReferenceSpec : rhsEntitySpec.getReferenceSpecs()) {
                    if (!rhsToLhsReferenceSpec.getEntityName().equals(lhsReferenceSpec.getName()) || rhsToLhsReferenceSpec.getType() != ReferenceSpec.Type.MANY) continue;
                    isMany = true;
                    break;
                }
            }
            if (isMany) continue;
            for (ReferenceSpec lhsToRhsReferenceSpec : lhsReferenceSpec.getReferenceSpecs()) {
                if (!lhsToRhsReferenceSpec.getEntityName().equals(rhsEntitySpec.getName())) continue;
                result.put(lhsReferenceSpec.getName(), lhsToRhsReferenceSpec);
            }
        }
        return result;
    }

    private static Map<String, ReferenceSpec> collectBidirectionalReferences(Collection<EntitySpec> entitySpecs, EntitySpec lhsEntitySpec, Set<String> propIds) {
        HashMap<String, ReferenceSpec> result = new HashMap<String, ReferenceSpec>();
        for (ReferenceSpec lhsToRhsReferenceSpec : lhsEntitySpec.getReferenceSpecs()) {
            for (EntitySpec rhsEntitySpec : entitySpecs) {
                if (!rhsEntitySpec.getName().equals(lhsToRhsReferenceSpec.getEntityName()) || !org.arp.javautil.collections.Collections.containsAny(propIds, (Object[])rhsEntitySpec.getPropositionIds()) || !rhsEntitySpec.hasReferenceTo(lhsEntitySpec)) continue;
                for (ReferenceSpec rhsToLhsReferenceSpec : rhsEntitySpec.getReferenceSpecs()) {
                    if (!rhsToLhsReferenceSpec.getEntityName().equals(lhsEntitySpec.getName()) || rhsToLhsReferenceSpec.getType() != ReferenceSpec.Type.MANY) continue;
                    result.put(rhsEntitySpec.getName(), lhsToRhsReferenceSpec);
                }
            }
        }
        return result;
    }

    private Map<EntitySpec, SQLGenResultProcessorFactory> allEntitySpecToResultProcessor() {
        LinkedHashMap<EntitySpec, SQLGenResultProcessorFactory> result = new LinkedHashMap<EntitySpec, SQLGenResultProcessorFactory>();
        PrimitiveParameterResultProcessorFactory ppFactory = new PrimitiveParameterResultProcessorFactory();
        for (EntitySpec es : this.primitiveParameterEntitySpecs) {
            result.put(es, ppFactory);
        }
        EventResultProcessorFactory eFactory = new EventResultProcessorFactory();
        for (EntitySpec es : this.eventEntitySpecs) {
            result.put(es, eFactory);
        }
        ConstantResultProcessorFactory cFactory = new ConstantResultProcessorFactory();
        for (EntitySpec es : this.constantEntitySpecs) {
            result.put(es, cFactory);
        }
        for (StagingSpec ss : this.stagedTableSpecs) {
            for (EntitySpec es : ss.getEntitySpecs()) {
                result.put(es, null);
            }
        }
        return result;
    }

    private static Set<Filter> copyFilters(Filter filters) {
        HashSet<Filter> filtersCopy = new HashSet<Filter>();
        if (filters != null) {
            Iterator itr = filters.andIterator();
            while (itr.hasNext()) {
                filtersCopy.add((Filter)itr.next());
            }
        }
        return filtersCopy;
    }

    private <P extends Proposition> void generateAndExecuteSelectStreaming(EntitySpec entitySpec, ReferenceSpec referenceSpec, Set<String> propIds, Set<Filter> filtersCopy, List<EntitySpec> entitySpecsCopy, LinkedHashMap<String, ReferenceSpec> inboundRefSpecs, Set<String> keyIds, SQLOrderBy order, StreamingResultProcessor<P> resultProcessor, StreamingSQLExecutor executor, boolean wrapKeyId) throws DataSourceReadException {
        Logger logger = SQLGenUtil.logger();
        String backendNameForMessages = this.backendNameForMessages();
        String entitySpecName = entitySpec.getName();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Data source backend {0} is generating query for {1}", new Object[]{backendNameForMessages, entitySpecName});
        }
        String query = this.getSelectStatement(entitySpec, referenceSpec, entitySpecsCopy, inboundRefSpecs, filtersCopy, propIds, keyIds, order, resultProcessor, this.stagedTableSpecs, wrapKeyId).generateStatement();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Data source backend {0} generated the following query for {1}: {2}", new Object[]{backendNameForMessages, entitySpecName, query});
        }
        executor.executeSelect(entitySpecName, query, resultProcessor);
    }

    private static void removeNonApplicableEntitySpecs(EntitySpec entitySpec, Collection<EntitySpec> entitySpecs) {
        Iterator<EntitySpec> itr = entitySpecs.iterator();
        while (itr.hasNext()) {
            EntitySpec es = itr.next();
            if (es == entitySpec || es.hasReferenceTo(entitySpec)) continue;
            itr.remove();
        }
    }

    private static void removeNonApplicableFilters(Collection<EntitySpec> entitySpecs, Set<Filter> filtersCopy, EntitySpec entitySpec) {
        HashSet<EntitySpec> entitySpecsSet = new HashSet<EntitySpec>();
        HashSet filterPropIds = new HashSet();
        Object[] entitySpecPropIds = entitySpec.getPropositionIds();
        Iterator<Filter> itr = filtersCopy.iterator();
        while (itr.hasNext()) {
            Filter f = itr.next();
            Arrays.addAll(filterPropIds, (Object[][])new String[][]{f.getPropositionIds()});
            for (EntitySpec es : entitySpecs) {
                if (!org.arp.javautil.collections.Collections.containsAny(filterPropIds, (Object[])es.getPropositionIds())) continue;
                entitySpecsSet.add(es);
            }
            if (org.arp.javautil.collections.Collections.containsAny(filterPropIds, (Object[])entitySpecPropIds)) {
                return;
            }
            if (!AbstractSQLGenerator.atLeastOneInInboundReferences(entitySpecsSet, entitySpec)) {
                itr.remove();
            }
            entitySpecsSet.clear();
            filterPropIds.clear();
        }
    }

    private static boolean atLeastOneInInboundReferences(Set<EntitySpec> entitySpecsSet, EntitySpec entitySpec) {
        for (EntitySpec es : entitySpecsSet) {
            if (!es.hasReferenceTo(entitySpec)) continue;
            return true;
        }
        return false;
    }

    protected abstract SelectStatement getSelectStatement(EntitySpec var1, ReferenceSpec var2, List<EntitySpec> var3, Map<String, ReferenceSpec> var4, Set<Filter> var5, Set<String> var6, Set<String> var7, SQLOrderBy var8, SQLGenResultProcessor var9, StagingSpec[] var10, boolean var11);

    protected DataStager getDataStager(StagingSpec[] stagingSpecs, ReferenceSpec referenceSpec, List<EntitySpec> entitySpecs, Set<Filter> filters, Set<String> propIds, Set<String> keyIds, SQLOrderBy order, ConnectionSpec connectionSpec) {
        throw new UnsupportedOperationException("SQL generator " + this.getClass().getName() + " does not support data staging");
    }

    protected String assembleReadPropositionsQuery(StringBuilder selectClause, StringBuilder fromClause, StringBuilder whereClause) {
        return MessageFormat.format(readPropositionsSQL, selectClause, fromClause, whereClause);
    }

    static boolean needsPropIdInClause(Set<String> queryPropIds, String[] entitySpecPropIds) {
        Set entitySpecPropIdsSet = Arrays.asSet((Object[])entitySpecPropIds);
        ArrayList<String> filteredPropIds = new ArrayList<String>(entitySpecPropIds.length);
        for (String propId : queryPropIds) {
            if (!entitySpecPropIdsSet.contains(propId)) continue;
            filteredPropIds.add(propId);
        }
        return (float)filteredPropIds.size() < (float)entitySpecPropIds.length * 0.85f && filteredPropIds.size() <= 2000;
    }

    protected String getDriverClassNameToLoad() {
        return null;
    }

    private String backendNameForMessages() {
        String backendDisplayName = this.backend.getDisplayName();
        if (backendDisplayName != null) {
            return backendDisplayName + "(" + ((Object)((Object)this.backend)).getClass().getName() + ")";
        }
        return ((Object)((Object)this.backend)).getClass().getName();
    }

    private Map<EntitySpec, List<String>> entitySpecToPropIds(Set<String> propIds) throws AssertionError {
        HashMap<EntitySpec, List<String>> result = new HashMap<EntitySpec, List<String>>();
        for (String propId : propIds) {
            boolean inDataSource = this.populateEntitySpecToPropIdMap(new String[]{propId}, result);
            Logger logger = SQLGenUtil.logger();
            if (inDataSource || !logger.isLoggable(Level.FINER)) continue;
            logger.log(Level.FINER, "Data source backend {0} does not know about proposition {1}", new Object[]{this.backendNameForMessages(), propId});
        }
        return result;
    }

    private List<EntitySpec> entitySpecs(String propId) {
        if (this.primitiveParameterSpecs.containsKey(propId)) {
            return this.primitiveParameterSpecs.get(propId);
        }
        if (this.eventSpecs.containsKey(propId)) {
            return this.eventSpecs.get(propId);
        }
        if (this.constantSpecs.containsKey(propId)) {
            return this.constantSpecs.get(propId);
        }
        return null;
    }

    private boolean populateEntitySpecToPropIdMap(String[] propIds, Map<EntitySpec, List<String>> entitySpecToPropIdMap) throws AssertionError {
        boolean result = false;
        for (String propId : propIds) {
            List<EntitySpec> entitySpecs = this.entitySpecs(propId);
            if (entitySpecs == null) continue;
            for (EntitySpec entitySpec : entitySpecs) {
                org.arp.javautil.collections.Collections.putList(entitySpecToPropIdMap, (Object)entitySpec, (Object)propId);
                result = true;
            }
        }
        return result;
    }

    private static void populatePropositionMap(Map<String, List<EntitySpec>> map, EntitySpec[] entitySpecs) {
        if (entitySpecs != null) {
            for (EntitySpec entitySpec : entitySpecs) {
                for (String code : entitySpec.getPropositionIds()) {
                    org.arp.javautil.collections.Collections.putList(map, (Object)code, (Object)entitySpec);
                }
            }
        }
    }

    private class StreamingIteratorPair {
        private final DataStreamingEventIterator<Proposition> props;
        private final List<? extends DataStreamingEventIterator<UniqueIdPair>> refs;
        private final Connection connection;

        StreamingIteratorPair(DataStreamingEventIterator<Proposition> props, List<? extends DataStreamingEventIterator<UniqueIdPair>> refs, Connection connection) {
            this.props = props;
            this.refs = refs;
            this.connection = connection;
        }

        public DataStreamingEventIterator<Proposition> getProps() {
            return this.props;
        }

        public List<? extends DataStreamingEventIterator<UniqueIdPair>> getRefs() {
            return this.refs;
        }

        public Connection getConnection() {
            return this.connection;
        }
    }

    private class SQLExecutorCallable
    implements Callable<List<StreamingIteratorPair>> {
        private final Map<EntitySpec, SQLGenResultProcessorFactory> allEntitySpecToResultProcessor;
        private final Collection<EntitySpec> allEntitySpecs;
        private final Filter filters;
        private final Set<String> propIds;
        private final Set<String> keyIds;
        private final EntitySpec entitySpec;

        public SQLExecutorCallable(EntitySpec entitySpec, Map<EntitySpec, SQLGenResultProcessorFactory> allEntitySpecToResultProcessor, Collection<EntitySpec> allEntitySpecs, Filter filters, Set<String> propIds, Set<String> keyIds) {
            this.entitySpec = entitySpec;
            this.allEntitySpecToResultProcessor = allEntitySpecToResultProcessor;
            this.allEntitySpecs = allEntitySpecs;
            this.filters = filters;
            this.propIds = propIds;
            this.keyIds = keyIds;
        }

        @Override
        public List<StreamingIteratorPair> call() throws Exception {
            Connection conn;
            try {
                conn = AbstractSQLGenerator.this.connectionSpec.getOrCreate();
            }
            catch (SQLException ex) {
                throw new DataSourceReadException((Throwable)ex);
            }
            return AbstractSQLGenerator.this.processEntitySpecStreaming(this.entitySpec, this.allEntitySpecToResultProcessor, this.allEntitySpecs, this.filters, this.propIds, this.keyIds, new StreamingSQLExecutor(conn, AbstractSQLGenerator.this.backendNameForMessages(), AbstractSQLGenerator.this.backend.getQueryTimeout()));
        }
    }
}

