/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResultSetMetaData
implements ResultSetMetaData,
Cloneable {
    private int columnCount = 0;
    private Map<Integer, Integer> columnDisplaySizeMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> columnTypeMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> precisionMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> scaleMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> isNullableMap = new HashMap<Integer, Integer>();
    private Map<Integer, Boolean> isAutoIncrementMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> isCaseSensitiveMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> isCurrencyMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> isDefinitelyWritableMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> isReadOnlyMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> isSearchableMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> isSignedMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> isWritableMap = new HashMap<Integer, Boolean>();
    private Map<Integer, String> catalogNameMap = new HashMap<Integer, String>();
    private Map<Integer, String> columnClassNameMap = new HashMap<Integer, String>();
    private Map<Integer, String> columnLabelMap = new HashMap<Integer, String>();
    private Map<Integer, String> columnNameMap = new HashMap<Integer, String>();
    private Map<Integer, String> columnTypeNameMap = new HashMap<Integer, String>();
    private Map<Integer, String> schemaNameMap = new HashMap<Integer, String>();
    private Map<Integer, String> tableNameMap = new HashMap<Integer, String>();

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public void setColumnDisplaySize(int column, int displaySize) {
        this.columnDisplaySizeMap.put(column, displaySize);
    }

    public void setColumnType(int column, int columnType) {
        this.columnTypeMap.put(column, columnType);
    }

    public void setPrecision(int column, int precision) {
        this.precisionMap.put(column, precision);
    }

    public void setScale(int column, int scale) {
        this.scaleMap.put(column, scale);
    }

    public void setNullable(int column, int nullable) {
        this.isNullableMap.put(column, nullable);
    }

    public void setAutoIncrement(int column, boolean autoIncrement) {
        this.isAutoIncrementMap.put(column, autoIncrement);
    }

    public void setCaseSensitive(int column, boolean caseSensitive) {
        this.isCaseSensitiveMap.put(column, caseSensitive);
    }

    public void setCurrency(int column, boolean currency) {
        this.isCurrencyMap.put(column, currency);
    }

    public void setDefinitelyWritable(int column, boolean definitelyWritable) {
        this.isDefinitelyWritableMap.put(column, definitelyWritable);
    }

    public void setReadOnly(int column, boolean readOnly) {
        this.isReadOnlyMap.put(column, readOnly);
    }

    public void setSearchable(int column, boolean searchable) {
        this.isSearchableMap.put(column, searchable);
    }

    public void setSigned(int column, boolean signed) {
        this.isSignedMap.put(column, signed);
    }

    public void setWritable(int column, boolean writable) {
        this.isWritableMap.put(column, writable);
    }

    public void setCatalogName(int column, String catalogName) {
        this.catalogNameMap.put(column, catalogName);
    }

    public void setColumnClassName(int column, String columnClassName) {
        this.columnClassNameMap.put(column, columnClassName);
    }

    public void setColumnLabel(int column, String columnLabel) {
        this.columnLabelMap.put(column, columnLabel);
    }

    public void setColumnName(int column, String columnName) {
        this.columnNameMap.put(column, columnName);
    }

    public void setColumnTypeName(int column, String columnTypeName) {
        this.columnTypeNameMap.put(column, columnTypeName);
    }

    public void setSchemaName(int column, String schemaName) {
        this.schemaNameMap.put(column, schemaName);
    }

    public void setTableName(int column, String tableName) {
        this.tableNameMap.put(column, tableName);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Integer columnDisplaySize = this.columnDisplaySizeMap.get(column);
        if (null == columnDisplaySize) {
            return this.getColumnCount();
        }
        return columnDisplaySize;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Integer columnType = this.columnTypeMap.get(column);
        if (null == columnType) {
            return 1111;
        }
        return columnType;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Integer precision = this.precisionMap.get(column);
        if (null == precision) {
            return 0;
        }
        return precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        Integer scale = this.scaleMap.get(column);
        if (null == scale) {
            return 0;
        }
        return scale;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        Integer isNullable = this.isNullableMap.get(column);
        if (null == isNullable) {
            return 1;
        }
        return isNullable;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        Boolean isAutoIncrement = this.isAutoIncrementMap.get(column);
        if (null == isAutoIncrement) {
            return false;
        }
        return isAutoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        Boolean isCaseSensitive = this.isCaseSensitiveMap.get(column);
        if (null == isCaseSensitive) {
            return true;
        }
        return isCaseSensitive;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        Boolean isCurrency = this.isCurrencyMap.get(column);
        if (null == isCurrency) {
            return false;
        }
        return isCurrency;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        Boolean isDefinitelyWritable = this.isDefinitelyWritableMap.get(column);
        if (null == isDefinitelyWritable) {
            return true;
        }
        return isDefinitelyWritable;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        Boolean isReadOnly = this.isReadOnlyMap.get(column);
        if (null == isReadOnly) {
            return false;
        }
        return isReadOnly;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        Boolean isSearchable = this.isSearchableMap.get(column);
        if (null == isSearchable) {
            return true;
        }
        return isSearchable;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        Boolean isSigned = this.isSignedMap.get(column);
        if (null == isSigned) {
            return false;
        }
        return isSigned;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        Boolean isWritable = this.isWritableMap.get(column);
        if (null == isWritable) {
            return true;
        }
        return isWritable;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        String catalogName = this.catalogNameMap.get(column);
        if (null == catalogName) {
            return "";
        }
        return catalogName;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String columnClassName = this.columnClassNameMap.get(column);
        if (null == columnClassName) {
            return Object.class.getName();
        }
        return columnClassName;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        String columnLabel = this.columnLabelMap.get(column);
        if (null == columnLabel) {
            return this.getColumnName(column);
        }
        return columnLabel;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String columnName = this.columnNameMap.get(column);
        if (null == columnName) {
            return "";
        }
        return columnName;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        String columnTypeName = this.columnTypeNameMap.get(column);
        if (null == columnTypeName) {
            return "";
        }
        return columnTypeName;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        String schemaName = this.schemaNameMap.get(column);
        if (null == schemaName) {
            return "";
        }
        return schemaName;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        String tableName = this.tableNameMap.get(column);
        if (null == tableName) {
            return "";
        }
        return tableName;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            MockResultSetMetaData copy = (MockResultSetMetaData)super.clone();
            copy.columnDisplaySizeMap = new HashMap<Integer, Integer>(this.columnDisplaySizeMap);
            copy.columnTypeMap = new HashMap<Integer, Integer>(this.columnTypeMap);
            copy.precisionMap = new HashMap<Integer, Integer>(this.precisionMap);
            copy.scaleMap = new HashMap<Integer, Integer>(this.scaleMap);
            copy.isNullableMap = new HashMap<Integer, Integer>(this.isNullableMap);
            copy.isAutoIncrementMap = new HashMap<Integer, Boolean>(this.isAutoIncrementMap);
            copy.isCurrencyMap = new HashMap<Integer, Boolean>(this.isCurrencyMap);
            copy.isDefinitelyWritableMap = new HashMap<Integer, Boolean>(this.isDefinitelyWritableMap);
            copy.isReadOnlyMap = new HashMap<Integer, Boolean>(this.isReadOnlyMap);
            copy.isSearchableMap = new HashMap<Integer, Boolean>(this.isSearchableMap);
            copy.isSignedMap = new HashMap<Integer, Boolean>(this.isSignedMap);
            copy.isWritableMap = new HashMap<Integer, Boolean>(this.isWritableMap);
            copy.catalogNameMap = new HashMap<Integer, String>(this.catalogNameMap);
            copy.columnClassNameMap = new HashMap<Integer, String>(this.columnClassNameMap);
            copy.columnLabelMap = new HashMap<Integer, String>(this.columnLabelMap);
            copy.columnNameMap = new HashMap<Integer, String>(this.columnNameMap);
            copy.columnTypeNameMap = new HashMap<Integer, String>(this.columnTypeNameMap);
            copy.schemaNameMap = new HashMap<Integer, String>(this.schemaNameMap);
            copy.tableNameMap = new HashMap<Integer, String>(this.tableNameMap);
            return copy;
        }
        catch (CloneNotSupportedException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("No object found for " + iface);
    }
}

