/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.Accessor;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.ParserContext;
import org.mvel.PropertyAccessor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ArrayTools;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class NewObjectNode
extends ASTNode {
    private transient Accessor newObjectOptimizer;
    private String className;
    private ArraySize[] arraySize;
    private ExecutableStatement[] compiledArraySize;
    private static final Class[] EMPTYCLS = new Class[0];

    public NewObjectNode(char[] expr, int fields) {
        super(expr, fields);
        this.updateClassName(fields);
        if ((fields & 0x10) != 0) {
            ParserContext pCtx = AbstractParser.getCurrentThreadParserContext();
            if (pCtx != null && pCtx.hasImport(this.className)) {
                this.egressType = pCtx.getImport(this.className);
            } else {
                try {
                    this.egressType = Thread.currentThread().getContextClassLoader().loadClass(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (this.egressType != null) {
                this.rewriteClassReferenceToFQCN(fields);
                if (this.arraySize != null) {
                    try {
                        this.egressType = ParseTools.findClass(null, String.valueOf(ParseTools.repeatChar('[', this.arraySize.length)) + "L" + this.egressType.getName() + ";");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void rewriteClassReferenceToFQCN(int fields) {
        String FQCN = this.egressType.getName();
        if (this.className.indexOf(46) == -1) {
            int idx = ArrayTools.findFirst('(', this.name);
            char[] fqcn = FQCN.toCharArray();
            if (idx == -1) {
                idx = fqcn.length;
                this.name = new char[idx];
                int i = 0;
                while (i < idx) {
                    this.name[i] = fqcn[i];
                    ++i;
                }
            } else {
                char[] newName = new char[fqcn.length + (this.name.length - idx)];
                int i = 0;
                while (i < fqcn.length) {
                    newName[i] = fqcn[i];
                    ++i;
                }
                int i0 = this.name.length - idx;
                int i1 = fqcn.length;
                int i2 = 0;
                while (i2 < i0) {
                    newName[i2 + i1] = this.name[i2 + idx];
                    ++i2;
                }
                this.name = newName;
            }
            this.updateClassName(fields);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateClassName(int fields) {
        block9: {
            block7: {
                block8: {
                    endRange = ArrayTools.findFirst('(', this.name);
                    if (endRange != -1) break block7;
                    endRange = ArrayTools.findFirst('[', this.name);
                    if (endRange == -1) break block8;
                    this.className = new String(this.name, 0, endRange);
                    sizes = new LinkedList<char[]>();
                    ** GOTO lbl20
                    {
                        ++endRange;
                        do {
                            if (endRange < this.name.length && Character.isWhitespace(this.name[endRange])) continue block0;
                            if (endRange == this.name.length) break block0;
                            if (this.name[endRange] != '[') {
                                throw new CompileException("unexpected token in contstructor", this.name, endRange);
                            }
                            to = ParseTools.balancedCapture(this.name, endRange, '[');
                            if (to == -1) {
                                throw new CompileException("unbalanced brace '['", this.name, endRange);
                            }
                            sizes.add(ParseTools.subset(this.name, ++endRange, to - endRange));
                            endRange = to + 1;
lbl20:
                            // 2 sources

                        } while (endRange < this.name.length);
                    }
                    iter = sizes.iterator();
                    this.arraySize = new ArraySize[sizes.size()];
                    i = 0;
                    while (i < this.arraySize.length) {
                        this.arraySize[i] = new ArraySize((char[])iter.next());
                        ++i;
                    }
                    if ((fields & 16) != 0) {
                        this.compiledArraySize = new ExecutableStatement[this.arraySize.length];
                        i = 0;
                        while (i < this.compiledArraySize.length) {
                            this.compiledArraySize[i] = (ExecutableStatement)ParseTools.subCompileExpression(this.arraySize[i].value);
                            ++i;
                        }
                    }
                    return;
                }
                this.className = new String(this.name);
                break block9;
            }
            this.className = new String(this.name, 0, endRange);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.newObjectOptimizer == null) {
            Class<?> clazz;
            if (this.egressType == null && factory != null && factory.isResolveable(this.className)) {
                try {
                    this.egressType = (Class)factory.getVariableResolver(this.className).getValue();
                    this.rewriteClassReferenceToFQCN(16);
                    if (this.arraySize != null) {
                        try {
                            this.egressType = ParseTools.findClass(factory, String.valueOf(ParseTools.repeatChar('[', this.arraySize.length)) + "L" + this.egressType.getName() + ";");
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (ClassCastException e) {
                    throw new CompileException("cannot construct object: " + this.className + " is not a class reference", e);
                }
            }
            try {
                clazz = Class.forName("[Ljava.lang.Class;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Class<?> cls = clazz;
            if (this.arraySize != null) {
                this.newObjectOptimizer = new NewObjectArray(PropertyTools.getBaseComponentType(this.egressType.getComponentType()), this.compiledArraySize);
                return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
            }
            AccessorOptimizer optimizer = OptimizerFactory.getThreadAccessorOptimizer();
            this.newObjectOptimizer = optimizer.optimizeObjectCreation(this.name, ctx, thisValue, factory);
            if (optimizer.getResultOptPass() != null) {
                this.egressType = optimizer.getEgressType();
                return optimizer.getResultOptPass();
            }
        }
        return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (this.arraySize != null) {
                Class cls = ParseTools.findClass(factory, this.className);
                int[] s = new int[this.arraySize.length];
                int i = 0;
                while (i < s.length) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    s[i] = (Integer)DataConversion.convert(MVEL.eval(this.arraySize[i].value, ctx, factory), clazz);
                    ++i;
                }
                return Array.newInstance(cls, s);
            }
            String[] cnsRes = ParseTools.captureContructorAndResidual(this.name);
            String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
            if (constructorParms != null) {
                Class cls = ParseTools.findClass(factory, new String(ParseTools.subset(this.name, 0, ArrayTools.findFirst('(', this.name))));
                Object[] parms = new Object[constructorParms.length];
                int i = 0;
                while (i < constructorParms.length) {
                    parms[i] = MVEL.eval(constructorParms[i], ctx, factory);
                    ++i;
                }
                Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
                if (cns == null) {
                    throw new CompileException("unable to find constructor for: " + cls.getName());
                }
                int i2 = 0;
                while (i2 < parms.length) {
                    parms[i2] = DataConversion.convert(parms[i2], cns.getParameterTypes()[i2]);
                    ++i2;
                }
                if (cnsRes.length > 1) {
                    return PropertyAccessor.get(cnsRes[1], cns.newInstance(parms), factory, thisValue);
                }
                return cns.newInstance(parms);
            }
            Constructor<?> cns = Thread.currentThread().getContextClassLoader().loadClass(new String(this.name)).getConstructor(EMPTYCLS);
            if (cnsRes.length > 1) {
                return PropertyAccessor.get(cnsRes[1], cns.newInstance(new Object[0]), factory, thisValue);
            }
            return cns.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("unable to resolve class: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new CompileException("cannot resolve constructor: " + e.getMessage());
        }
        catch (Exception e) {
            throw new CompileException("could not instantiate class: " + e.getMessage());
        }
    }

    public Accessor getNewObjectOptimizer() {
        return this.newObjectOptimizer;
    }

    public static class ArraySize
    implements Serializable {
        public char[] value;

        public ArraySize(char[] value) {
            this.value = value;
        }
    }

    public static class NewObjectArray
    implements Accessor,
    Serializable {
        private ExecutableStatement[] sizes;
        private Class arrayType;

        public NewObjectArray(Class arrayType, ExecutableStatement[] sizes) {
            this.arrayType = arrayType;
            this.sizes = sizes;
        }

        public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
            int[] s = new int[this.sizes.length];
            int i = 0;
            while (i < s.length) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                s[i] = (Integer)DataConversion.convert(this.sizes[i].getValue(ctx, elCtx, variableFactory), clazz);
                ++i;
            }
            return Array.newInstance(this.arrayType, s);
        }

        public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
            return null;
        }
    }
}

