--------------------------------------------------------
--  File created - Wednesday-February-25-2015   
--------------------------------------------------------

-- TO_DATE
create alias TO_DATE as $$
java.util.Date toDate(String s, String ignorePattern) throws Exception {
    return new java.text.SimpleDateFormat("dd-MMM-dd HH:mm:ss").parse(s);
}
$$;

--------------------------------------------------------
--  DDL for Table EK_VITALS
--------------------------------------------------------

  CREATE TABLE EK_VITALS 
   (	C_HLEVEL NUMBER(22,0), 
	C_FULLNAME VARCHAR2(700), 
	C_NAME VARCHAR2(2000), 
	C_SYNONYM_CD CHAR(1), 
	C_VISUALATTRIBUTES CHAR(3), 
	C_TOTALNUM NUMBER(22,0), 
	C_BASECODE VARCHAR2(50), 
	C_METADATAXML CLOB, 
	C_FACTTABLECOLUMN VARCHAR2(50), 
	C_TABLENAME VARCHAR2(50), 
	C_COLUMNNAME VARCHAR2(50), 
	C_COLUMNDATATYPE VARCHAR2(50), 
	C_OPERATOR VARCHAR2(10), 
	C_DIMCODE VARCHAR2(700), 
	C_COMMENT CLOB, 
	C_TOOLTIP VARCHAR2(900), 
	M_APPLIED_PATH VARCHAR2(700), 
	UPDATE_DATE DATE, 
	DOWNLOAD_DATE DATE, 
	IMPORT_DATE DATE, 
	SOURCESYSTEM_CD VARCHAR2(50), 
	VALUETYPE_CD VARCHAR2(50), 
	M_EXCLUSION_CD VARCHAR2(25), 
	C_PATH VARCHAR2(700), 
	C_SYMBOL VARCHAR2(50),
	EK_UNIQUE_ID VARCHAR2(50)
   );
--------------------------------------------------------
--  DDL for Table EK_LABS
--------------------------------------------------------

  CREATE TABLE EK_LABS 
   (	C_HLEVEL NUMBER(22,0), 
	C_FULLNAME VARCHAR2(700), 
	C_NAME VARCHAR2(2000), 
	C_SYNONYM_CD CHAR(1), 
	C_VISUALATTRIBUTES CHAR(3), 
	C_TOTALNUM NUMBER(22,0), 
	C_BASECODE VARCHAR2(50), 
	C_METADATAXML CLOB, 
	C_FACTTABLECOLUMN VARCHAR2(50), 
	C_TABLENAME VARCHAR2(50), 
	C_COLUMNNAME VARCHAR2(50), 
	C_COLUMNDATATYPE VARCHAR2(50), 
	C_OPERATOR VARCHAR2(10), 
	C_DIMCODE VARCHAR2(700), 
	C_COMMENT CLOB, 
	C_TOOLTIP VARCHAR2(900), 
	M_APPLIED_PATH VARCHAR2(700), 
	UPDATE_DATE DATE, 
	DOWNLOAD_DATE DATE, 
	IMPORT_DATE DATE, 
	SOURCESYSTEM_CD VARCHAR2(50), 
	VALUETYPE_CD VARCHAR2(50), 
	M_EXCLUSION_CD VARCHAR2(25), 
	C_PATH VARCHAR2(700), 
	C_SYMBOL VARCHAR2(50),
	EK_UNIQUE_ID VARCHAR2(50)
   );
--------------------------------------------------------
--  DDL for Table EK_MED_ORDERS
--------------------------------------------------------

  CREATE TABLE EK_MED_ORDERS 
   (	C_HLEVEL NUMBER(22,0), 
	C_FULLNAME VARCHAR2(700), 
	C_NAME VARCHAR2(2000), 
	C_SYNONYM_CD CHAR(1), 
	C_VISUALATTRIBUTES CHAR(3), 
	C_TOTALNUM NUMBER(22,0), 
	C_BASECODE VARCHAR2(50), 
	C_METADATAXML CLOB, 
	C_FACTTABLECOLUMN VARCHAR2(50), 
	C_TABLENAME VARCHAR2(50), 
	C_COLUMNNAME VARCHAR2(50), 
	C_COLUMNDATATYPE VARCHAR2(50), 
	C_OPERATOR VARCHAR2(10), 
	C_DIMCODE VARCHAR2(700), 
	C_COMMENT CLOB, 
	C_TOOLTIP VARCHAR2(900), 
	M_APPLIED_PATH VARCHAR2(700), 
	UPDATE_DATE DATE, 
	DOWNLOAD_DATE DATE, 
	IMPORT_DATE DATE, 
	SOURCESYSTEM_CD VARCHAR2(50), 
	VALUETYPE_CD VARCHAR2(50), 
	M_EXCLUSION_CD VARCHAR2(25), 
	C_PATH VARCHAR2(700), 
	C_SYMBOL VARCHAR2(50),
	EK_UNIQUE_ID VARCHAR2(50)
   );
--------------------------------------------------------
--  DDL for Table EK_ICD9D
--------------------------------------------------------

  CREATE TABLE EK_ICD9D 
   (	C_HLEVEL NUMBER(22,0), 
	C_FULLNAME VARCHAR2(700), 
	C_NAME VARCHAR2(2000), 
	C_SYNONYM_CD CHAR(1), 
	C_VISUALATTRIBUTES CHAR(3), 
	C_TOTALNUM NUMBER(22,0), 
	C_BASECODE VARCHAR2(50), 
	C_METADATAXML CLOB, 
	C_FACTTABLECOLUMN VARCHAR2(50), 
	C_TABLENAME VARCHAR2(50), 
	C_COLUMNNAME VARCHAR2(50), 
	C_COLUMNDATATYPE VARCHAR2(50), 
	C_OPERATOR VARCHAR2(10), 
	C_DIMCODE VARCHAR2(700), 
	C_COMMENT CLOB, 
	C_TOOLTIP VARCHAR2(900), 
	M_APPLIED_PATH VARCHAR2(700), 
	UPDATE_DATE DATE, 
	DOWNLOAD_DATE DATE, 
	IMPORT_DATE DATE, 
	SOURCESYSTEM_CD VARCHAR2(50), 
	VALUETYPE_CD VARCHAR2(50), 
	M_EXCLUSION_CD VARCHAR2(25), 
	C_PATH VARCHAR2(700), 
	C_SYMBOL VARCHAR2(50),
	EK_UNIQUE_ID VARCHAR2(50)
   );
--------------------------------------------------------
--  DDL for Table EK_ICD9P
--------------------------------------------------------

  CREATE TABLE EK_ICD9P 
   (	C_HLEVEL NUMBER(22,0), 
	C_FULLNAME VARCHAR2(700), 
	C_NAME VARCHAR2(2000), 
	C_SYNONYM_CD CHAR(1), 
	C_VISUALATTRIBUTES CHAR(3), 
	C_TOTALNUM NUMBER(22,0), 
	C_BASECODE VARCHAR2(50), 
	C_METADATAXML CLOB, 
	C_FACTTABLECOLUMN VARCHAR2(50), 
	C_TABLENAME VARCHAR2(50), 
	C_COLUMNNAME VARCHAR2(50), 
	C_COLUMNDATATYPE VARCHAR2(50), 
	C_OPERATOR VARCHAR2(10), 
	C_DIMCODE VARCHAR2(700), 
	C_COMMENT CLOB, 
	C_TOOLTIP VARCHAR2(900), 
	M_APPLIED_PATH VARCHAR2(700), 
	UPDATE_DATE DATE, 
	DOWNLOAD_DATE DATE, 
	IMPORT_DATE DATE, 
	SOURCESYSTEM_CD VARCHAR2(50), 
	VALUETYPE_CD VARCHAR2(50), 
	M_EXCLUSION_CD VARCHAR2(25), 
	C_PATH VARCHAR2(700), 
	C_SYMBOL VARCHAR2(50),
	EK_UNIQUE_ID VARCHAR2(50)
   );
--------------------------------------------------------
--  DDL for Table EK_DEMOG
--------------------------------------------------------

  CREATE TABLE EK_DEMOG 
   (	C_HLEVEL NUMBER(22,0), 
	C_FULLNAME VARCHAR2(700), 
	C_NAME VARCHAR2(2000), 
	C_SYNONYM_CD CHAR(1), 
	C_VISUALATTRIBUTES CHAR(3), 
	C_TOTALNUM NUMBER(22,0), 
	C_BASECODE VARCHAR2(50), 
	C_METADATAXML CLOB, 
	C_FACTTABLECOLUMN VARCHAR2(50), 
	C_TABLENAME VARCHAR2(50), 
	C_COLUMNNAME VARCHAR2(50), 
	C_COLUMNDATATYPE VARCHAR2(50), 
	C_OPERATOR VARCHAR2(10), 
	C_DIMCODE VARCHAR2(700), 
	C_COMMENT CLOB, 
	C_TOOLTIP VARCHAR2(900), 
	M_APPLIED_PATH VARCHAR2(700), 
	UPDATE_DATE DATE, 
	DOWNLOAD_DATE DATE, 
	IMPORT_DATE DATE, 
	SOURCESYSTEM_CD VARCHAR2(50), 
	VALUETYPE_CD VARCHAR2(50), 
	M_EXCLUSION_CD VARCHAR2(25), 
	C_PATH VARCHAR2(700), 
	C_SYMBOL VARCHAR2(50),
	EK_UNIQUE_ID VARCHAR2(50)
   );

--------------------------------------------------------
--  DDL for Table EK_MODIFIER_INTERP
--------------------------------------------------------

--  CREATE TABLE EK_MODIFIER_INTERP
--   (	DECLARING_CONCEPT VARCHAR2(50), 
--	C_BASECODE VARCHAR2(50), 
--	PROPERTYNAME VARCHAR2(255),
--	DISPLAYNAME VARCHAR2(255)
--   );


Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (1,'\EK\VitalSign\','Vital Sign','N','FAE',null,'VitalSign','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\',' \ Eureka \ Vital Signs','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\','VitalSign');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\BodyMassIndex\','Body mass index','N','LAE',null,'BodyMassIndex','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\BodyMassIndex\',' \ Eureka \ Vital Signs \ Body mass index','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','BodyMassIndex');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\DiastolicBloodPressure\','Diastolic Blood Pressure','N','LAE',null,'DiastolicBloodPressure','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\DiastolicBloodPressure\',' \ Eureka \ Vital Signs \ Diastolic Blood Pressure','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','DiastolicBloodPressure');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\HeartRate\','Heart Rate','N','LAE',null,'HeartRate','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\HeartRate\',' \ Eureka \ Vital Signs \ Heart Rate','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','HeartRate');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\Height\','Height','N','LAE',null,'Height','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Height\',' \ Eureka \ Vital Signs \ Height','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','Height');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\O2Saturation\','Oxygen Saturation','N','LAE',null,'O2Saturation','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\O2Saturation\',' \ Eureka \ Vital Signs \ Oxygen Saturation','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','O2Saturation');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\RespiratoryRate\','Respiratory Rate','N','LAE',null,'RespiratoryRate','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\RespiratoryRate\',' \ Eureka \ Vital Signs \ Respiratory Rate','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','RespiratoryRate');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\SystolicBloodPressure\','Systolic Blood Pressure','N','LAE',null,'SystolicBloodPressure','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\SystolicBloodPressure\',' \ Eureka \ Vital Signs \ Systolic Blood Pressure','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','SystolicBloodPressure');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\Temperature\','Temperature','N','FAE',null,'Temperature','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Temperature\',' \ Eureka \ Vital Signs \ Temperature','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','Temperature');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\VitalSign\Temperature\TemperatureAxillary\','Temperature (C) Axillary','N','LAE',null,'TemperatureAxillary','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Temperature\TemperatureAxillary\',' \ Eureka \ Vital Signs \ Temperature \ Temperature (C) Axillary','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\Temperature\','TemperatureAxillary');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\VitalSign\Temperature\TemperatureCore\','Temperature (C) Core','N','LAE',null,'TemperatureCore','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Temperature\TemperatureCore\',' \ Eureka \ Vital Signs \ Temperature \ Temperature (C) Core','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\Temperature\','TemperatureCore');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\VitalSign\Temperature\TemperatureNOS\','Temperature','N','LAE',null,'TemperatureNOS','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Temperature\TemperatureNOS\',' \ Eureka \ Vital Signs \ Temperature \ Temperature','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\Temperature\','TemperatureNOS');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\VitalSign\Temperature\TemperatureOral\','Temperature (C) Oral','N','LAE',null,'TemperatureOral','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Temperature\TemperatureOral\',' \ Eureka \ Vital Signs \ Temperature \ Temperature (C) Oral','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\Temperature\','TemperatureOral');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\VitalSign\Temperature\TemperatureRectal\','Temperature (C) Rectal','N','LAE',null,'TemperatureRectal','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Temperature\TemperatureRectal\',' \ Eureka \ Vital Signs \ Temperature \ Temperature (C) Rectal','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\Temperature\','TemperatureRectal');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\VitalSign\Temperature\TemperatureTympanic\','Temperature (C) Tympanic','N','LAE',null,'TemperatureTympanic','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Temperature\TemperatureTympanic\',' \ Eureka \ Vital Signs \ Temperature \ Temperature (C) Tympanic','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\Temperature\','TemperatureTympanic');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\VS:DescriptionMissing\','Description Missing','N','LHE',null,'VS:DescriptionMissing','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\VS:DescriptionMissing\',' \ Eureka \ Vital Signs \ Description Missing','@',to_date('14-FEB-15 05:58:55','DD-MON-RR HH24:MI:SS'),null,to_date('14-FEB-15 05:59:00','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','VS:DescriptionMissing');
Insert into EK_VITALS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\VitalSign\Weight\','Weight','N','LAE',null,'Weight','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\VitalSign\Weight\',' \ Eureka \ Vital Signs \ Weight','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:23:19','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\VitalSign\','Weight');
commit;


Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002056\','POC ABG O2 SAT','N','LAE',null,'LAB:1002056','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002056\',' \ Eureka \ Lab Test \ Blood Gases \ POC ABG O2 SAT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002056');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002057\','POC BLOOD GAS BASE EXCESS','N','LAE',null,'LAB:1002057','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002057\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS BASE EXCESS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002057');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002058\','POC BLOOD GAS METHEMOGLOBIN','N','LAE',null,'LAB:1002058','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002058\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS METHEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002058');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002059\','POC BLOOD GAS POTASSIUM','N','LAE',null,'LAB:1002059','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002059\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS POTASSIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002059');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002060\','POC BLOOD GAS SODIUM','N','LAE',null,'LAB:1002060','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002060\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS SODIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002060');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002061\','POC BLOOD GAS IONIZED CALCIUM','N','LAE',null,'LAB:1002061','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002061\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS IONIZED CALCIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002061');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002062\','POC BLOOD GAS HEMOGLOBIN','N','LAE',null,'LAB:1002062','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002062\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS HEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002062');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002063\','POC BLOOD GAS HEMATOCRIT','N','LAE',null,'LAB:1002063','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002063\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS HEMATOCRIT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002063');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002064\','POC BLOOD GAS LACTATE','N','LAE',null,'LAB:1002064','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002064\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS LACTATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002064');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002065\','POC BLOOD GAS GLUCOSE','N','LAE',null,'LAB:1002065','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002065\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS GLUCOSE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002065');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002067\','POC BLOOD GAS CHLORIDE','N','LAE',null,'LAB:1002067','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002067\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS CHLORIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002067');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1500503\','GLUCOSE,OR LAB             CLH','N','LAE',null,'LAB:1500503','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1500503\',' \ Eureka \ Lab Test \ Blood Gases \ GLUCOSE,OR LAB             CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1500503');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503799\','TEMP','N','LAE',null,'LAB:1503799','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503799\',' \ Eureka \ Lab Test \ Blood Gases \ TEMP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503799');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503802\','FIO2                      CLH','N','LAE',null,'LAB:1503802','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503802\',' \ Eureka \ Lab Test \ Blood Gases \ FIO2                      CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503802');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503803\','PH,ARTERIAL BLOOD          CLH','N','LAE',null,'LAB:1503803','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503803\',' \ Eureka \ Lab Test \ Blood Gases \ PH,ARTERIAL BLOOD          CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503803');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503804\','PO2,ARTERIAL BLOOD         CLH','N','LAE',null,'LAB:1503804','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503804\',' \ Eureka \ Lab Test \ Blood Gases \ PO2,ARTERIAL BLOOD         CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503804');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503805\','PCO2,ARTERIAL BLOOD        CLH','N','LAE',null,'LAB:1503805','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503805\',' \ Eureka \ Lab Test \ Blood Gases \ PCO2,ARTERIAL BLOOD        CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503805');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503806\','HCO3,ARTERIAL BLOOD        CLH','N','LAE',null,'LAB:1503806','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503806\',' \ Eureka \ Lab Test \ Blood Gases \ HCO3,ARTERIAL BLOOD        CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503806');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503807\','BASE EXCESS                CLH','N','LAE',null,'LAB:1503807','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503807\',' \ Eureka \ Lab Test \ Blood Gases \ BASE EXCESS                CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503807');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503808\','O2 SATURATION,ARTERIAL BLD.CLH','N','LAE',null,'LAB:1503808','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503808\',' \ Eureka \ Lab Test \ Blood Gases \ O2 SATURATION,ARTERIAL BLD.CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503808');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503809\','CARBOXYHEMOGLOBIN          CLH','N','LAE',null,'LAB:1503809','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503809\',' \ Eureka \ Lab Test \ Blood Gases \ CARBOXYHEMOGLOBIN          CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503809');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503810\','METHEMOGLOBIN              CLH','N','LAE',null,'LAB:1503810','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503810\',' \ Eureka \ Lab Test \ Blood Gases \ METHEMOGLOBIN              CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503810');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503811\','PH,(CORRECTED),ARTERIAL    CLH','N','LAE',null,'LAB:1503811','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503811\',' \ Eureka \ Lab Test \ Blood Gases \ PH,(CORRECTED),ARTERIAL    CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503811');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503812\','PCO2(CORRECTED)ARTERIAL    CLH','N','LAE',null,'LAB:1503812','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503812\',' \ Eureka \ Lab Test \ Blood Gases \ PCO2(CORRECTED)ARTERIAL    CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503812');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (1,'\EK\LAB:LabTest\','Lab Test','N','FAE',null,'LAB:LabTest','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\',' \ Eureka \ Lab Test','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\','LAB:LabTest');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Blood Gases\','Blood Gases','N','FAE',null,'LAB:Blood Gases','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\',' \ Eureka \ Lab Test \ Blood Gases','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Blood Gases');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002051\','POC ABG PH','N','LAE',null,'LAB:1002051','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002051\',' \ Eureka \ Lab Test \ Blood Gases \ POC ABG PH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002051');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002052\','POC ABG PO2','N','LAE',null,'LAB:1002052','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002052\',' \ Eureka \ Lab Test \ Blood Gases \ POC ABG PO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002052');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002053\','POC ABG PCO2','N','LAE',null,'LAB:1002053','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002053\',' \ Eureka \ Lab Test \ Blood Gases \ POC ABG PCO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002053');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002054\','POC ABG HCO3','N','LAE',null,'LAB:1002054','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002054\',' \ Eureka \ Lab Test \ Blood Gases \ POC ABG HCO3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002054');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002055\','POC BLOOD GAS CARBOXYHGB','N','LAE',null,'LAB:1002055','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1002055\',' \ Eureka \ Lab Test \ Blood Gases \ POC BLOOD GAS CARBOXYHGB','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1002055');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503823\','PH,(CORRECTED),VENOUS      CLH','N','LAE',null,'LAB:1503823','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503823\',' \ Eureka \ Lab Test \ Blood Gases \ PH,(CORRECTED),VENOUS      CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503823');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503824\','PCO2(CORRECTED)VENOUS      CLH','N','LAE',null,'LAB:1503824','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503824\',' \ Eureka \ Lab Test \ Blood Gases \ PCO2(CORRECTED)VENOUS      CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503824');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503825\','PO2 (CORRECTED)VENOUS      CLH','N','LAE',null,'LAB:1503825','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503825\',' \ Eureka \ Lab Test \ Blood Gases \ PO2 (CORRECTED)VENOUS      CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503825');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503828\','POTASSIUM,OR LAB           CLH','N','LAE',null,'LAB:1503828','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503828\',' \ Eureka \ Lab Test \ Blood Gases \ POTASSIUM,OR LAB           CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503828');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503829\','SODIUM,OR LAB              CLH','N','LAE',null,'LAB:1503829','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503829\',' \ Eureka \ Lab Test \ Blood Gases \ SODIUM,OR LAB              CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503829');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503830\','IONIZED CALCIUM-OR LAB     CLH','N','LAE',null,'LAB:1503830','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503830\',' \ Eureka \ Lab Test \ Blood Gases \ IONIZED CALCIUM-OR LAB     CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503830');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910010\','METHEMOGLOBIN','N','LAE',null,'LAB:9910010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910010\',' \ Eureka \ Lab Test \ Blood Gases \ METHEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910011\','PH,(CORRECTED),ARTERIAL','N','LAE',null,'LAB:9910011','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910011\',' \ Eureka \ Lab Test \ Blood Gases \ PH,(CORRECTED),ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910011');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910012\','PCO2,(CORRECTED),ARTERIAL','N','LAE',null,'LAB:9910012','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910012\',' \ Eureka \ Lab Test \ Blood Gases \ PCO2,(CORRECTED),ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910012');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910013\','PO2,(CORRECTED),ARTERIAL','N','LAE',null,'LAB:9910013','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910013\',' \ Eureka \ Lab Test \ Blood Gases \ PO2,(CORRECTED),ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910013');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910014\','TEMPERATURE','N','LAE',null,'LAB:9910014','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910014\',' \ Eureka \ Lab Test \ Blood Gases \ TEMPERATURE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910014');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910015\','LACTIC ACID','N','LAE',null,'LAB:9910015','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910015\',' \ Eureka \ Lab Test \ Blood Gases \ LACTIC ACID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910015');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910016\','GLUCOSE','N','LAE',null,'LAB:9910016','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910016\',' \ Eureka \ Lab Test \ Blood Gases \ GLUCOSE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910016');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910017\','SODIUM','N','LAE',null,'LAB:9910017','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910017\',' \ Eureka \ Lab Test \ Blood Gases \ SODIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910017');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910019\','HEMOGLOBIN','N','LAE',null,'LAB:9910019','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910019\',' \ Eureka \ Lab Test \ Blood Gases \ HEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910019');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910020\','HEMATOCRIT','N','LAE',null,'LAB:9910020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910020\',' \ Eureka \ Lab Test \ Blood Gases \ HEMATOCRIT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915005\','HCO3','N','LAE',null,'LAB:9915005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915005\',' \ Eureka \ Lab Test \ Blood Gases \ HCO3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915006\','BASE EXCESS','N','LAE',null,'LAB:9915006','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915006\',' \ Eureka \ Lab Test \ Blood Gases \ BASE EXCESS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915006');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915007\','HEMOGLOBIN','N','LAE',null,'LAB:9915007','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915007\',' \ Eureka \ Lab Test \ Blood Gases \ HEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915007');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915013\','O2 SAT, ARTERIAL MEASURED','N','LAE',null,'LAB:9915013','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915013\',' \ Eureka \ Lab Test \ Blood Gases \ O2 SAT, ARTERIAL MEASURED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915013');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915014\','TEMPERATURE','N','LAE',null,'LAB:9915014','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915014\',' \ Eureka \ Lab Test \ Blood Gases \ TEMPERATURE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915014');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915015\','O2 CONTENT, ARTERIAL','N','LAE',null,'LAB:9915015','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915015\',' \ Eureka \ Lab Test \ Blood Gases \ O2 CONTENT, ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915015');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915016\','PO2,ARTERIAL CORRECTED','N','LAE',null,'LAB:9915016','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915016\',' \ Eureka \ Lab Test \ Blood Gases \ PO2,ARTERIAL CORRECTED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915016');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915017\','PH, ARTERIAL CORRECTED','N','LAE',null,'LAB:9915017','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915017\',' \ Eureka \ Lab Test \ Blood Gases \ PH, ARTERIAL CORRECTED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915017');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915018\','PCO2, ARTERIAL CORRECTED','N','LAE',null,'LAB:9915018','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915018\',' \ Eureka \ Lab Test \ Blood Gases \ PCO2, ARTERIAL CORRECTED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915018');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915031\','O2 CONTENT, VENOUS','N','LAE',null,'LAB:9915031','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915031\',' \ Eureka \ Lab Test \ Blood Gases \ O2 CONTENT, VENOUS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915031');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915032\','PH, VENOUS CORRECTED','N','LAE',null,'LAB:9915032','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915032\',' \ Eureka \ Lab Test \ Blood Gases \ PH, VENOUS CORRECTED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915032');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915033\','PO2, VENOUS CORRECTED','N','LAE',null,'LAB:9915033','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915033\',' \ Eureka \ Lab Test \ Blood Gases \ PO2, VENOUS CORRECTED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915033');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915034\','PCO2, VENOUS CORRECTED','N','LAE',null,'LAB:9915034','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915034\',' \ Eureka \ Lab Test \ Blood Gases \ PCO2, VENOUS CORRECTED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915034');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915035\','O2 SAT, VENOUS MEASURED','N','LAE',null,'LAB:9915035','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915035\',' \ Eureka \ Lab Test \ Blood Gases \ O2 SAT, VENOUS MEASURED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915035');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503831\','HEMOGLOBIN-OR LAB          CLH','N','LAE',null,'LAB:1503831','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503831\',' \ Eureka \ Lab Test \ Blood Gases \ HEMOGLOBIN-OR LAB          CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503831');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503832\','HEMATOCRIT-OR LAB          CLH','N','LAE',null,'LAB:1503832','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503832\',' \ Eureka \ Lab Test \ Blood Gases \ HEMATOCRIT-OR LAB          CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503832');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:5745005\','BLOOD GAS FIO2','N','LAE',null,'LAB:5745005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:5745005\',' \ Eureka \ Lab Test \ Blood Gases \ BLOOD GAS FIO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:5745005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910000\','PH,ARTERIAL','N','LAE',null,'LAB:9910000','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910000\',' \ Eureka \ Lab Test \ Blood Gases \ PH,ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910000');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910001\','IONIZED CALCIUM','N','LAE',null,'LAB:9910001','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910001\',' \ Eureka \ Lab Test \ Blood Gases \ IONIZED CALCIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910001');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910003\','PO2, ARTERIAL','N','LAE',null,'LAB:9910003','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910003\',' \ Eureka \ Lab Test \ Blood Gases \ PO2, ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910003');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910004\','PCO2, ARTERIAL','N','LAE',null,'LAB:9910004','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910004\',' \ Eureka \ Lab Test \ Blood Gases \ PCO2, ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910004');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910005\','HCO3, ARTERIAL','N','LAE',null,'LAB:9910005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910005\',' \ Eureka \ Lab Test \ Blood Gases \ HCO3, ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910006\','BASE EXCESS','N','LAE',null,'LAB:9910006','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910006\',' \ Eureka \ Lab Test \ Blood Gases \ BASE EXCESS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910006');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910007\','O2SAT,ARTERIAL','N','LAE',null,'LAB:9910007','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910007\',' \ Eureka \ Lab Test \ Blood Gases \ O2SAT,ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910007');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910008\','FIO2','N','LAE',null,'LAB:9910008','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910008\',' \ Eureka \ Lab Test \ Blood Gases \ FIO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910008');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910009\','CARBOXYHEMOGLOBIN','N','LAE',null,'LAB:9910009','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9910009\',' \ Eureka \ Lab Test \ Blood Gases \ CARBOXYHEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9910009');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503813\','PO2 (CORRECTED)ARTERIAL    CLH','N','LAE',null,'LAB:1503813','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503813\',' \ Eureka \ Lab Test \ Blood Gases \ PO2 (CORRECTED)ARTERIAL    CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503813');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503814\','PH,VENOUS BLOOD            CLH','N','LAE',null,'LAB:1503814','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503814\',' \ Eureka \ Lab Test \ Blood Gases \ PH,VENOUS BLOOD            CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503814');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503816\','PO2,VENOUS BLOOD           CLH','N','LAE',null,'LAB:1503816','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503816\',' \ Eureka \ Lab Test \ Blood Gases \ PO2,VENOUS BLOOD           CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503816');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503817\','PCO2,VENOUS BLOOD          CLH','N','LAE',null,'LAB:1503817','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503817\',' \ Eureka \ Lab Test \ Blood Gases \ PCO2,VENOUS BLOOD          CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503817');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503818\','HCO3,VENOUS BLOOD          CLH','N','LAE',null,'LAB:1503818','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503818\',' \ Eureka \ Lab Test \ Blood Gases \ HCO3,VENOUS BLOOD          CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503818');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503820\','O2 SATURATION,VENOUS BLOOD CLH','N','LAE',null,'LAB:1503820','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:1503820\',' \ Eureka \ Lab Test \ Blood Gases \ O2 SATURATION,VENOUS BLOOD CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:1503820');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Cardiology\LAB:1002225\','MB','N','LAE',null,'LAB:1002225','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Cardiology\LAB:1002225\',' \ Eureka \ Lab Test \ Cardiology \ MB','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Cardiology\','LAB:1002225');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Cardiology\LAB:1002501\','MYOGLOBIN','N','LAE',null,'LAB:1002501','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Cardiology\LAB:1002501\',' \ Eureka \ Lab Test \ Cardiology \ MYOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Cardiology\','LAB:1002501');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Cardiology\LAB:1002504\','TROPONIN I','N','LAE',null,'LAB:1002504','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Cardiology\LAB:1002504\',' \ Eureka \ Lab Test \ Cardiology \ TROPONIN I','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Cardiology\','LAB:1002504');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Cardiology\LAB:1002510\','B-TYPE NATRIURETIC PEPTIDE','N','LAE',null,'LAB:1002510','concept_cd','concept_dimension','concept_path','N','LIKE','\EK\LAB:LabTest\LAB:Cardiology\LAB:1002510\',' \ Eureka \ Lab Test \ Cardiology \ B-TYPE NATRIURETIC PEPTIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Cardiology\','LAB:1002510');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Chemistry\','Chemistry','N','FAE',null,'LAB:Chemistry','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\',' \ Eureka \ Lab Test \ Chemistry','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Chemistry');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1000024\','FOLATE SERUM','N','LAE',null,'LAB:1000024','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1000024\',' \ Eureka \ Lab Test \ Chemistry \ FOLATE SERUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1000024');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1000132\','MAGNESIUM','N','LAE',null,'LAB:1000132','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1000132\',' \ Eureka \ Lab Test \ Chemistry \ MAGNESIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1000132');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1000134\','IONIZED MAGNESIUM LEVEL PLASMA','N','LAE',null,'LAB:1000134','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1000134\',' \ Eureka \ Lab Test \ Chemistry \ IONIZED MAGNESIUM LEVEL PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1000134');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1000200\','AMYLASE','N','LAE',null,'LAB:1000200','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1000200\',' \ Eureka \ Lab Test \ Chemistry \ AMYLASE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1000200');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1000241\','CALCULATED OSMOLALITY','N','LAE',null,'LAB:1000241','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1000241\',' \ Eureka \ Lab Test \ Chemistry \ CALCULATED OSMOLALITY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1000241');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1000360\','CALCIUM','N','LAE',null,'LAB:1000360','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1000360\',' \ Eureka \ Lab Test \ Chemistry \ CALCIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1000360');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1000820\','FERRITIN SERUM','N','LAE',null,'LAB:1000820','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1000820\',' \ Eureka \ Lab Test \ Chemistry \ FERRITIN SERUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1000820');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001120\','IRON SERUM','N','LAE',null,'LAB:1001120','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001120\',' \ Eureka \ Lab Test \ Chemistry \ IRON SERUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001120');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001122\','PERSENT IRON SATURATION','N','LAE',null,'LAB:1001122','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001122\',' \ Eureka \ Lab Test \ Chemistry \ PERSENT IRON SATURATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001122');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001140\','TOTAL IRON BINDING CAPACITY','N','LAE',null,'LAB:1001140','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001140\',' \ Eureka \ Lab Test \ Chemistry \ TOTAL IRON BINDING CAPACITY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001140');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001200\','LACTIC ACID BLOOD','N','LAE',null,'LAB:1001200','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001200\',' \ Eureka \ Lab Test \ Chemistry \ LACTIC ACID BLOOD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001200');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001220\','LD (LACTIC ACID DEHYDROGENASE)','N','LAE',null,'LAB:1001220','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001220\',' \ Eureka \ Lab Test \ Chemistry \ LD (LACTIC ACID DEHYDROGENASE)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001220');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001380\','OSMOLALITY SERUM','N','LAE',null,'LAB:1001380','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001380\',' \ Eureka \ Lab Test \ Chemistry \ OSMOLALITY SERUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001380');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001480\','PHOSPHORUS','N','LAE',null,'LAB:1001480','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001480\',' \ Eureka \ Lab Test \ Chemistry \ PHOSPHORUS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001480');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001803\','LIPASE','N','LAE',null,'LAB:1001803','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001803\',' \ Eureka \ Lab Test \ Chemistry \ LIPASE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001803');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001840\','URIC ACID','N','LAE',null,'LAB:1001840','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001840\',' \ Eureka \ Lab Test \ Chemistry \ URIC ACID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001840');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:1001929\','VITAMIN B12','N','LAE',null,'LAB:1001929','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:1001929\',' \ Eureka \ Lab Test \ Chemistry \ VITAMIN B12','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:1001929');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:5040065\','CERULOPLASMIN','N','LAE',null,'LAB:5040065','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:5040065\',' \ Eureka \ Lab Test \ Chemistry \ CERULOPLASMIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:5040065');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:5040190\','HAPTOGLOBIN','N','LAE',null,'LAB:5040190','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:5040190\',' \ Eureka \ Lab Test \ Chemistry \ HAPTOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:5040190');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:5040660\','PREALBUMIN','N','LAE',null,'LAB:5040660','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:5040660\',' \ Eureka \ Lab Test \ Chemistry \ PREALBUMIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:5040660');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915041\','a/AO2','N','LAE',null,'LAB:9915041','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915041\',' \ Eureka \ Lab Test \ Blood Gases \ a/AO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915041');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915054\','A-a O2, ARTERIAL','N','LAE',null,'LAB:9915054','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915054\',' \ Eureka \ Lab Test \ Blood Gases \ A-a O2, ARTERIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915054');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915055\','A-a O2','N','LAE',null,'LAB:9915055','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915055\',' \ Eureka \ Lab Test \ Blood Gases \ A-a O2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915055');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915058\','FIO2 L/MIN','N','LAE',null,'LAB:9915058','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:9915058\',' \ Eureka \ Lab Test \ Blood Gases \ FIO2 L/MIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:9915058');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Blood Gases\LAB:LOINC:14743-9\','Glucose [Moles/volume] in Capillary blood by Glocometer','N','LAE',null,'LAB:LOINC:14743-9','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Blood Gases\LAB:LOINC:14743-9\',' \ Eureka \ Lab Test \ Blood Gases \ Glucose [Moles/volume] in Capillary blood by Glocometer','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Blood Gases\','LAB:LOINC:14743-9');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:CBC\','CBC','N','FAE',null,'LAB:CBC','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\',' \ Eureka \ Lab Test \ CBC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:CBC');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000100\','MEAN CORPUSCULAR VOLUME','N','LAE',null,'LAB:2000100','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000100\',' \ Eureka \ Lab Test \ CBC \ MEAN CORPUSCULAR VOLUME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000100');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000120\','MEAN CORPUSCULAR HGB','N','LAE',null,'LAB:2000120','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000120\',' \ Eureka \ Lab Test \ CBC \ MEAN CORPUSCULAR HGB','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000120');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000140\','MEAN CORPUSCULAR HGB CONCENTRN','N','LAE',null,'LAB:2000140','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000140\',' \ Eureka \ Lab Test \ CBC \ MEAN CORPUSCULAR HGB CONCENTRN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000140');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000150\','RED CELL DISTRIBUTION WIDTH','N','LAE',null,'LAB:2000150','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000150\',' \ Eureka \ Lab Test \ CBC \ RED CELL DISTRIBUTION WIDTH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000150');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000210\','HEMOGLOBIN','N','LAE',null,'LAB:2000210','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000210\',' \ Eureka \ Lab Test \ CBC \ HEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000210');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000220\','HEMATOCRIT','N','LAE',null,'LAB:2000220','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000220\',' \ Eureka \ Lab Test \ CBC \ HEMATOCRIT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000220');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000230\','WHITE BLOOD CELL COUNT','N','LAE',null,'LAB:2000230','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000230\',' \ Eureka \ Lab Test \ CBC \ WHITE BLOOD CELL COUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000230');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000240\','RED BLOOD CELL COUNT','N','LAE',null,'LAB:2000240','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000240\',' \ Eureka \ Lab Test \ CBC \ RED BLOOD CELL COUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000240');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000255\','OVALOCYTES','N','LAE',null,'LAB:2000255','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000255\',' \ Eureka \ Lab Test \ CBC \ OVALOCYTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000255');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000260\','AUTO NUCLEATED RED CELL COUNT','N','LAE',null,'LAB:2000260','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000260\',' \ Eureka \ Lab Test \ CBC \ AUTO NUCLEATED RED CELL COUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000260');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000643\','MEAN PLATELET VOLUME','N','LAE',null,'LAB:2000643','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000643\',' \ Eureka \ Lab Test \ CBC \ MEAN PLATELET VOLUME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000643');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:CBC\LAB:2000820\','PLATELET CT','N','LAE',null,'LAB:2000820','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:CBC\LAB:2000820\',' \ Eureka \ Lab Test \ CBC \ PLATELET CT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:CBC\','LAB:2000820');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Cardiology\','Cardiology','N','FAE',null,'LAB:Cardiology','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Cardiology\',' \ Eureka \ Lab Test \ Cardiology','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Cardiology');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Cardiology\LAB:1000720\','CK (CREATINE KINASE)','N','LAE',null,'LAB:1000720','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Cardiology\LAB:1000720\',' \ Eureka \ Lab Test \ Cardiology \ CK (CREATINE KINASE)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Cardiology\','LAB:1000720');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000390\','FIBRINOGEN','N','LAE',null,'LAB:3000390','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000390\',' \ Eureka \ Lab Test \ Coags \ FIBRINOGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000390');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000431\','PTT (PARTIAL PROTIME)','N','LAE',null,'LAB:3000431','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000431\',' \ Eureka \ Lab Test \ Coags \ PTT (PARTIAL PROTIME)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000431');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000510\','PT RESULT','N','LAE',null,'LAB:3000510','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000510\',' \ Eureka \ Lab Test \ Coags \ PT RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000510');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000511\','PROTIME INR','N','LAE',null,'LAB:3000511','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000511\',' \ Eureka \ Lab Test \ Coags \ PROTIME INR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000511');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000650\','HEPARIN ASSAY','N','LAE',null,'LAB:3000650','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000650\',' \ Eureka \ Lab Test \ Coags \ HEPARIN ASSAY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000650');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3500001\','D-DIMER','N','LAE',null,'LAB:3500001','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3500001\',' \ Eureka \ Lab Test \ Coags \ D-DIMER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3500001');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000390\','EOSINOPHILS','N','LAE',null,'LAB:2000390','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000390\',' \ Eureka \ Lab Test \ Diff \ EOSINOPHILS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000390');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000410\','BASOPHIL','N','LAE',null,'LAB:2000410','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000410\',' \ Eureka \ Lab Test \ Diff \ BASOPHIL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000410');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000440\','NUCLEATED RBC','N','LAE',null,'LAB:2000440','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000440\',' \ Eureka \ Lab Test \ Diff \ NUCLEATED RBC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000440');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000460\','POIKILOCYTOSIS','N','LAE',null,'LAB:2000460','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000460\',' \ Eureka \ Lab Test \ Diff \ POIKILOCYTOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000460');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000480\','ANISOCYTOSIS','N','LAE',null,'LAB:2000480','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000480\',' \ Eureka \ Lab Test \ Diff \ ANISOCYTOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000480');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000490\','POLYCHROMASIA','N','LAE',null,'LAB:2000490','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000490\',' \ Eureka \ Lab Test \ Diff \ POLYCHROMASIA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000490');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000491\','PELG HUET FORMS','N','LAE',null,'LAB:2000491','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000491\',' \ Eureka \ Lab Test \ Diff \ PELG HUET FORMS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000491');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000492\','HYPOGRANULAR NEUTROPHILS','N','LAE',null,'LAB:2000492','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000492\',' \ Eureka \ Lab Test \ Diff \ HYPOGRANULAR NEUTROPHILS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000492');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000493\','TOTAL CELLS COUNTED IN DIFF','N','LAE',null,'LAB:2000493','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000493\',' \ Eureka \ Lab Test \ Diff \ TOTAL CELLS COUNTED IN DIFF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000493');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000495\','GIANT PLATELET FORMS','N','LAE',null,'LAB:2000495','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000495\',' \ Eureka \ Lab Test \ Diff \ GIANT PLATELET FORMS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000495');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000496\','OTHER CELLS IDENTIFIED ON DIFF','N','LAE',null,'LAB:2000496','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000496\',' \ Eureka \ Lab Test \ Diff \ OTHER CELLS IDENTIFIED ON DIFF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000496');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000510\','HYPOCHROMASIA','N','LAE',null,'LAB:2000510','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000510\',' \ Eureka \ Lab Test \ Diff \ HYPOCHROMASIA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000510');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000520\','MACROCYTES','N','LAE',null,'LAB:2000520','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000520\',' \ Eureka \ Lab Test \ Diff \ MACROCYTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000520');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000530\','MICROCYTES','N','LAE',null,'LAB:2000530','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000530\',' \ Eureka \ Lab Test \ Diff \ MICROCYTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000530');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000540\','SPHEROCYTES','N','LAE',null,'LAB:2000540','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000540\',' \ Eureka \ Lab Test \ Diff \ SPHEROCYTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000540');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000550\','TARGET CELLS','N','LAE',null,'LAB:2000550','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000550\',' \ Eureka \ Lab Test \ Diff \ TARGET CELLS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000550');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000560\','BASOPHILIC STIPPLING','N','LAE',null,'LAB:2000560','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000560\',' \ Eureka \ Lab Test \ Diff \ BASOPHILIC STIPPLING','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000560');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000570\','SCHISTOCYTE','N','LAE',null,'LAB:2000570','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000570\',' \ Eureka \ Lab Test \ Diff \ SCHISTOCYTE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000570');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000580\','PAPPENHEIMER BODIES','N','LAE',null,'LAB:2000580','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000580\',' \ Eureka \ Lab Test \ Diff \ PAPPENHEIMER BODIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000580');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000590\','HOWELL JOLLY BODIES','N','LAE',null,'LAB:2000590','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000590\',' \ Eureka \ Lab Test \ Diff \ HOWELL JOLLY BODIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000590');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000600\','DOHLE BODIES','N','LAE',null,'LAB:2000600','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000600\',' \ Eureka \ Lab Test \ Diff \ DOHLE BODIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000600');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000644\','PLATELET ESTIMATE','N','LAE',null,'LAB:2000644','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000644\',' \ Eureka \ Lab Test \ Diff \ PLATELET ESTIMATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000644');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000670\','EOSINOPHIL COUNT','N','LAE',null,'LAB:2000670','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000670\',' \ Eureka \ Lab Test \ Diff \ EOSINOPHIL COUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000670');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000680\','SCAN MICRO SMEAR FOR EOS','N','LAE',null,'LAB:2000680','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000680\',' \ Eureka \ Lab Test \ Diff \ SCAN MICRO SMEAR FOR EOS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000680');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3500002\','HEPARIN INDUCED THROMBOCYPENIA','N','LAE',null,'LAB:3500002','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3500002\',' \ Eureka \ Lab Test \ Coags \ HEPARIN INDUCED THROMBOCYPENIA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3500002');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3500004\','REPTILASE TIME','N','LAE',null,'LAB:3500004','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3500004\',' \ Eureka \ Lab Test \ Coags \ REPTILASE TIME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3500004');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3500005\','THROMBIN TIME','N','LAE',null,'LAB:3500005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3500005\',' \ Eureka \ Lab Test \ Coags \ THROMBIN TIME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3500005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3500007\','BLEEDING TIME','N','LAE',null,'LAB:3500007','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3500007\',' \ Eureka \ Lab Test \ Coags \ BLEEDING TIME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3500007');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3500008\','PROTHROMBIN SECONDS        CLH','N','LAE',null,'LAB:3500008','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3500008\',' \ Eureka \ Lab Test \ Coags \ PROTHROMBIN SECONDS        CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3500008');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3500016\','PTT (PARTIAL THROMBOPLAST TIME','N','LAE',null,'LAB:3500016','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3500016\',' \ Eureka \ Lab Test \ Coags \ PTT (PARTIAL THROMBOPLAST TIME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3500016');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Diff\','Diff','N','FAE',null,'LAB:Diff','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\',' \ Eureka \ Lab Test \ Diff','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Diff');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000270\','MYELOCYTE','N','LAE',null,'LAB:2000270','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000270\',' \ Eureka \ Lab Test \ Diff \ MYELOCYTE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000270');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000290\','METAMYELOCYTE','N','LAE',null,'LAB:2000290','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000290\',' \ Eureka \ Lab Test \ Diff \ METAMYELOCYTE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000290');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000310\','BAND','N','LAE',null,'LAB:2000310','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000310\',' \ Eureka \ Lab Test \ Diff \ BAND','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000310');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000330\','SEGMENTED NEUTROPHIL','N','LAE',null,'LAB:2000330','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000330\',' \ Eureka \ Lab Test \ Diff \ SEGMENTED NEUTROPHIL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000330');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000350\','LYMPHOCYTE','N','LAE',null,'LAB:2000350','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000350\',' \ Eureka \ Lab Test \ Diff \ LYMPHOCYTE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000350');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000370\','MONOCYTES','N','LAE',null,'LAB:2000370','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000370\',' \ Eureka \ Lab Test \ Diff \ MONOCYTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000370');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:9915001\','IONIZED CALCIUM','N','LAE',null,'LAB:9915001','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:9915001\',' \ Eureka \ Lab Test \ Chemistry \ IONIZED CALCIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:9915001');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Chemistry\LAB:9915063\','LACTIC ACID','N','LAE',null,'LAB:9915063','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Chemistry\LAB:9915063\',' \ Eureka \ Lab Test \ Chemistry \ LACTIC ACID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Chemistry\','LAB:9915063');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Coags\','Coags','N','FAE',null,'LAB:Coags','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\',' \ Eureka \ Lab Test \ Coags','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Coags');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000010\','PROTEIN C ASSAY','N','LAE',null,'LAB:3000010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000010\',' \ Eureka \ Lab Test \ Coags \ PROTEIN C ASSAY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000080\','ANTITHROMBIN ASSAY','N','LAE',null,'LAB:3000080','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000080\',' \ Eureka \ Lab Test \ Coags \ ANTITHROMBIN ASSAY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000080');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000123\','PROTEIN S ASSAY','N','LAE',null,'LAB:3000123','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000123\',' \ Eureka \ Lab Test \ Coags \ PROTEIN S ASSAY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000123');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Coags\LAB:3000250\','FACTOR VII','N','LAE',null,'LAB:3000250','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Coags\LAB:3000250\',' \ Eureka \ Lab Test \ Coags \ FACTOR VII','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Coags\','LAB:3000250');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000405\','DOPAMINE PLASMA','N','LAE',null,'LAB:1000405','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000405\',' \ Eureka \ Lab Test \ Drug Levels \ DOPAMINE PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Drug Levels\','LAB:1000405');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000406\','EPINEPHRINE PLASMA','N','LAE',null,'LAB:1000406','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000406\',' \ Eureka \ Lab Test \ Drug Levels \ EPINEPHRINE PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Drug Levels\','LAB:1000406');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000407\','NOREPINEPHRINE PLASMA','N','LAE',null,'LAB:1000407','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000407\',' \ Eureka \ Lab Test \ Drug Levels \ NOREPINEPHRINE PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Drug Levels\','LAB:1000407');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000409\','PROGRAF (TACROLIMUS)','N','LAE',null,'LAB:1000409','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000409\',' \ Eureka \ Lab Test \ Drug Levels \ PROGRAF (TACROLIMUS)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Drug Levels\','LAB:1000409');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000410\','FK506','N','LAE',null,'LAB:1000410','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\LAB:1000410\',' \ Eureka \ Lab Test \ Drug Levels \ FK506','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Drug Levels\','LAB:1000410');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Drug Levels\LAB:1503230\','GENTAMICIN (RANDOM)','N','LAE',null,'LAB:1503230','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\LAB:1503230\',' \ Eureka \ Lab Test \ Drug Levels \ GENTAMICIN (RANDOM)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Drug Levels\','LAB:1503230');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Drug Levels\LAB:1503296\','DIGOXIN','N','LAE',null,'LAB:1503296','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\LAB:1503296\',' \ Eureka \ Lab Test \ Drug Levels \ DIGOXIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Drug Levels\','LAB:1503296');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Drug Levels\LAB:1503555\','VANCOMYCIN (PEAK)','N','LAE',null,'LAB:1503555','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\LAB:1503555\',' \ Eureka \ Lab Test \ Drug Levels \ VANCOMYCIN (PEAK)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Drug Levels\','LAB:1503555');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Endocrine\','Endocrine','N','FAE',null,'LAB:Endocrine','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\',' \ Eureka \ Lab Test \ Endocrine','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Endocrine');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:1000400\','HBA1C (HEMOGLOBIN A1C)','N','LAE',null,'LAB:1000400','concept_cd','concept_dimension','concept_path','N','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:1000400\',' \ Eureka \ Lab Test \ Endocrine \ HBA1C (HEMOGLOBIN A1C)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:1000400');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:1000660\','CORTISOL SERUM','N','LAE',null,'LAB:1000660','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:1000660\',' \ Eureka \ Lab Test \ Endocrine \ CORTISOL SERUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:1000660');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:1001610\','T3','N','LAE',null,'LAB:1001610','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:1001610\',' \ Eureka \ Lab Test \ Endocrine \ T3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:1001610');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:1001611\','T4, FREE','N','LAE',null,'LAB:1001611','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:1001611\',' \ Eureka \ Lab Test \ Endocrine \ T4, FREE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:1001611');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:1001739\','TSH - REFLEX ORDER FT4 IF ABN','N','LAE',null,'LAB:1001739','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:1001739\',' \ Eureka \ Lab Test \ Endocrine \ TSH - REFLEX ORDER FT4 IF ABN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:1001739');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:1001740\','THYROID STIMULATING HORM (TSH)','N','LAE',null,'LAB:1001740','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:1001740\',' \ Eureka \ Lab Test \ Endocrine \ THYROID STIMULATING HORM (TSH)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:1001740');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:1001780\','T4','N','LAE',null,'LAB:1001780','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:1001780\',' \ Eureka \ Lab Test \ Endocrine \ T4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:1001780');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:1001931\','PARATHORMONE','N','LAE',null,'LAB:1001931','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:1001931\',' \ Eureka \ Lab Test \ Endocrine \ PARATHORMONE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:1001931');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:9000300\','ANGIOTENSIN CONVERTING ENZYME','N','LAE',null,'LAB:9000300','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:9000300\',' \ Eureka \ Lab Test \ Endocrine \ ANGIOTENSIN CONVERTING ENZYME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:9000300');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:9001541\','FREE T3','N','LAE',null,'LAB:9001541','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:9001541\',' \ Eureka \ Lab Test \ Endocrine \ FREE T3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:9001541');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:9002323\','PTH RELATED PROTEIN','N','LAE',null,'LAB:9002323','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:9002323\',' \ Eureka \ Lab Test \ Endocrine \ PTH RELATED PROTEIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:9002323');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:9003490\','VITAMIN D (25 HYDROXYVITAMIN)','N','LAE',null,'LAB:9003490','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:9003490\',' \ Eureka \ Lab Test \ Endocrine \ VITAMIN D (25 HYDROXYVITAMIN)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:9003490');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:9003500\','VITAMIN D (1, 25 HYDROXYVITA)','N','LAE',null,'LAB:9003500','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:9003500\',' \ Eureka \ Lab Test \ Endocrine \ VITAMIN D (1, 25 HYDROXYVITA)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:9003500');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:LOINC:17856-6\','Hemoglobin A1c/Hemoglobin.total in Blood by HPLC','N','LAE',null,'LAB:LOINC:17856-6','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:LOINC:17856-6\',' \ Eureka \ Lab Test \ Endocrine \ Hemoglobin A1c/Hemoglobin.total in Blood by HPLC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:LOINC:17856-6');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:LOINC:4548-4\','Hemoglobin A1c/Hemoglobin.total in Blood','N','LAE',null,'LAB:LOINC:4548-4','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:LOINC:4548-4\',' \ Eureka \ Lab Test \ Endocrine \ Hemoglobin A1c/Hemoglobin.total in Blood','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:LOINC:4548-4');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000690\','TEAR DROP CELLS','N','LAE',null,'LAB:2000690','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000690\',' \ Eureka \ Lab Test \ Diff \ TEAR DROP CELLS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000690');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000730\','HYPERSEGMENTED NEUTROPHILS','N','LAE',null,'LAB:2000730','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000730\',' \ Eureka \ Lab Test \ Diff \ HYPERSEGMENTED NEUTROPHILS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000730');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000780\','LEUKOCYTE ALKALINE PHOSPHATASE','N','LAE',null,'LAB:2000780','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000780\',' \ Eureka \ Lab Test \ Diff \ LEUKOCYTE ALKALINE PHOSPHATASE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000780');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000840\','RETICULOCYTE PERCENT','N','LAE',null,'LAB:2000840','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000840\',' \ Eureka \ Lab Test \ Diff \ RETICULOCYTE PERCENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000840');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000841\','ABSOLUTE RETICULOCYTE COUNT','N','LAE',null,'LAB:2000841','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000841\',' \ Eureka \ Lab Test \ Diff \ ABSOLUTE RETICULOCYTE COUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000841');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000970\','GRANULOCYTE','N','LAE',null,'LAB:2000970','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000970\',' \ Eureka \ Lab Test \ Diff \ GRANULOCYTE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000970');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000971\','PRELIMINARY NEUTROPHIL %','N','LAE',null,'LAB:2000971','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000971\',' \ Eureka \ Lab Test \ Diff \ PRELIMINARY NEUTROPHIL %','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000971');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000972\','IMMATURE GRAN, AUTO','N','LAE',null,'LAB:2000972','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000972\',' \ Eureka \ Lab Test \ Diff \ IMMATURE GRAN, AUTO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000972');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000975\','AUTO LYMPHOCYTE','N','LAE',null,'LAB:2000975','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000975\',' \ Eureka \ Lab Test \ Diff \ AUTO LYMPHOCYTE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000975');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2000980\','AUTO MONOCYTE','N','LAE',null,'LAB:2000980','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2000980\',' \ Eureka \ Lab Test \ Diff \ AUTO MONOCYTE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2000980');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2002000\','TOXIC GRANULATION','N','LAE',null,'LAB:2002000','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2002000\',' \ Eureka \ Lab Test \ Diff \ TOXIC GRANULATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2002000');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2002040\','AUER RODS','N','LAE',null,'LAB:2002040','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2002040\',' \ Eureka \ Lab Test \ Diff \ AUER RODS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2002040');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2002060\','ROULEAUX','N','LAE',null,'LAB:2002060','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2002060\',' \ Eureka \ Lab Test \ Diff \ ROULEAUX','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2002060');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2002080\','CRENATED RBCS','N','LAE',null,'LAB:2002080','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2002080\',' \ Eureka \ Lab Test \ Diff \ CRENATED RBCS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2002080');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2500010\','AUTO EOSINOPHIL','N','LAE',null,'LAB:2500010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2500010\',' \ Eureka \ Lab Test \ Diff \ AUTO EOSINOPHIL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2500010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2500015\','AUTO BASOPHIL','N','LAE',null,'LAB:2500015','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2500015\',' \ Eureka \ Lab Test \ Diff \ AUTO BASOPHIL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2500015');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2500035\','ABSOLUTE EOSINOPHIL        CLH','N','LAE',null,'LAB:2500035','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2500035\',' \ Eureka \ Lab Test \ Diff \ ABSOLUTE EOSINOPHIL        CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2500035');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Diff\LAB:2500045\','REACTIVE LYMPHOCYTE        CLH','N','LAE',null,'LAB:2500045','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Diff\LAB:2500045\',' \ Eureka \ Lab Test \ Diff \ REACTIVE LYMPHOCYTE        CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Diff\','LAB:2500045');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Drug Levels\','Drug Levels','N','FAE',null,'LAB:Drug Levels','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Drug Levels\',' \ Eureka \ Lab Test \ Drug Levels','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Drug Levels');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Fluids\LAB:5040030\','ALBUMIN BODY FLUID','N','LAE',null,'LAB:5040030','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Fluids\LAB:5040030\',' \ Eureka \ Lab Test \ Fluids \ ALBUMIN BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Fluids\','LAB:5040030');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Hematology\','Hematology','N','FAE',null,'LAB:Hematology','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Hematology\',' \ Eureka \ Lab Test \ Hematology','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Hematology');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Hematology\LAB:1001991\','RBC FOLATE','N','LAE',null,'LAB:1001991','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Hematology\LAB:1001991\',' \ Eureka \ Lab Test \ Hematology \ RBC FOLATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Hematology\','LAB:1001991');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Hematology\LAB:2000860\','WESTERGREN SED RATE','N','LAE',null,'LAB:2000860','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Hematology\LAB:2000860\',' \ Eureka \ Lab Test \ Hematology \ WESTERGREN SED RATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Hematology\','LAB:2000860');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Hematology\LAB:9915011\','METHEMOGLOBIN','N','LAE',null,'LAB:9915011','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Hematology\LAB:9915011\',' \ Eureka \ Lab Test \ Hematology \ METHEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Hematology\','LAB:9915011');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Hematology\LAB:9915012\','CARBOXYHEMOGLOBIN','N','LAE',null,'LAB:9915012','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Hematology\LAB:9915012\',' \ Eureka \ Lab Test \ Hematology \ CARBOXYHEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Hematology\','LAB:9915012');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Hepatitis\','Hepatitis','N','FAE',null,'LAB:Hepatitis','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Hepatitis\',' \ Eureka \ Lab Test \ Hepatitis','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Hepatitis');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080001\','HIV ANTIGEN ANTIBODY COMBO','N','LAE',null,'LAB:5080001','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080001\',' \ Eureka \ Lab Test \ Immunology \ HIV ANTIGEN ANTIBODY COMBO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080001');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080010\','HEPATITIS B SURFACE ANTIBODY','N','LAE',null,'LAB:5080010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080010\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS B SURFACE ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080013\','ANTIHBS QUANTITATIVE','N','LAE',null,'LAB:5080013','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080013\',' \ Eureka \ Lab Test \ Immunology \ ANTIHBS QUANTITATIVE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080013');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080016\','ANTI HTLV1-2','N','LAE',null,'LAB:5080016','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080016\',' \ Eureka \ Lab Test \ Immunology \ ANTI HTLV1-2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080016');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080018\','HIV ANTIBODY','N','LAE',null,'LAB:5080018','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080018\',' \ Eureka \ Lab Test \ Immunology \ HIV ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080018');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080020\','HEPATITIS B CORE ANTIBODY','N','LAE',null,'LAB:5080020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080020\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS B CORE ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080030\','HEPATITIS BE ANTIGEN','N','LAE',null,'LAB:5080030','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080030\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS BE ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080030');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080040\','HEPATITIS BE ANTIBODY','N','LAE',null,'LAB:5080040','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080040\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS BE ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080040');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080050\','HEPATITIS B IGM CORE AB','N','LAE',null,'LAB:5080050','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080050\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS B IGM CORE AB','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080050');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080060\','HEPATITIS A ANTIBODY','N','LAE',null,'LAB:5080060','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080060\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS A ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080060');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080070\','HEPATITIS A IGM ANTIBODY','N','LAE',null,'LAB:5080070','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080070\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS A IGM ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080070');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080075\','HEPATITIS C ANTIBODY','N','LAE',null,'LAB:5080075','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080075\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS C ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080075');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080200\','RPR RESULT','N','LAE',null,'LAB:5080200','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080200\',' \ Eureka \ Lab Test \ Immunology \ RPR RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080200');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:9000470\','MITOCHONDRIAL M2 AB, IGG','N','LAE',null,'LAB:9000470','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:9000470\',' \ Eureka \ Lab Test \ Immunology \ MITOCHONDRIAL M2 AB, IGG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:9000470');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:9000915\','CYTOMEGALOVIRUS IgG','N','LAE',null,'LAB:9000915','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:9000915\',' \ Eureka \ Lab Test \ Immunology \ CYTOMEGALOVIRUS IgG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:9000915');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:9001242\','DONOR HIV 1-2 ANTIBODY SCREEN','N','LAE',null,'LAB:9001242','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:9001242\',' \ Eureka \ Lab Test \ Immunology \ DONOR HIV 1-2 ANTIBODY SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:9001242');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:9007602\','THYROGLOBULIN ANTIBODY','N','LAE',null,'LAB:9007602','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:9007602\',' \ Eureka \ Lab Test \ Immunology \ THYROGLOBULIN ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:9007602');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Lipids\','Lipids','N','FAE',null,'LAB:Lipids','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lipids\',' \ Eureka \ Lab Test \ Lipids','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Lipids');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lipids\LAB:1000620\','CHOLESTEROL','N','LAE',null,'LAB:1000620','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lipids\LAB:1000620\',' \ Eureka \ Lab Test \ Lipids \ CHOLESTEROL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lipids\','LAB:1000620');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lipids\LAB:1000822\','VERY LOW DENSITY LIPOPROTEIN','N','LAE',null,'LAB:1000822','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lipids\LAB:1000822\',' \ Eureka \ Lab Test \ Lipids \ VERY LOW DENSITY LIPOPROTEIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lipids\','LAB:1000822');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lipids\LAB:1000823\','LOW DENSITY LIPOPROTEINS','N','LAE',null,'LAB:1000823','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lipids\LAB:1000823\',' \ Eureka \ Lab Test \ Lipids \ LOW DENSITY LIPOPROTEINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lipids\','LAB:1000823');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lipids\LAB:1001080\','HDL (HIGH DENS LIPO CHOLESTER)','N','LAE',null,'LAB:1001080','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lipids\LAB:1001080\',' \ Eureka \ Lab Test \ Lipids \ HDL (HIGH DENS LIPO CHOLESTER)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lipids\','LAB:1001080');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lipids\LAB:1001085\','NON HDL CHOLESTEROL','N','LAE',null,'LAB:1001085','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lipids\LAB:1001085\',' \ Eureka \ Lab Test \ Lipids \ NON HDL CHOLESTEROL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lipids\','LAB:1001085');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lipids\LAB:1001800\','TRIGLYCERIDES','N','LAE',null,'LAB:1001800','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lipids\LAB:1001800\',' \ Eureka \ Lab Test \ Lipids \ TRIGLYCERIDES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lipids\','LAB:1001800');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Liver Function\','Liver Function','N','FAE',null,'LAB:Liver Function','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\',' \ Eureka \ Lab Test \ Liver Function','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Liver Function');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1000060\','ALBUMIN','N','LAE',null,'LAB:1000060','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1000060\',' \ Eureka \ Lab Test \ Liver Function \ ALBUMIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1000060');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Hepatitis\LAB:9009862\','HEPATITIS C VIRUS/QUANTITATION','N','LAE',null,'LAB:9009862','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Hepatitis\LAB:9009862\',' \ Eureka \ Lab Test \ Hepatitis \ HEPATITIS C VIRUS/QUANTITATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Hepatitis\','LAB:9009862');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Immunology\','Immunology','N','FAE',null,'LAB:Immunology','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\',' \ Eureka \ Lab Test \ Immunology','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Immunology');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:1000650\','PROSTATIC SPECIFIC ANTIGEN SCR','N','LAE',null,'LAB:1000650','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:1000650\',' \ Eureka \ Lab Test \ Immunology \ PROSTATIC SPECIFIC ANTIGEN SCR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:1000650');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:1000655\','PROSTATIC SPECIFIC ANTIGEN','N','LAE',null,'LAB:1000655','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:1000655\',' \ Eureka \ Lab Test \ Immunology \ PROSTATIC SPECIFIC ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:1000655');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:1000656\','FREE PSA','N','LAE',null,'LAB:1000656','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:1000656\',' \ Eureka \ Lab Test \ Immunology \ FREE PSA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:1000656');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:1000657\','RATIO','N','LAE',null,'LAB:1000657','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:1000657\',' \ Eureka \ Lab Test \ Immunology \ RATIO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:1000657');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:3001005\','CRP-HIGH SENSITIVITY','N','LAE',null,'LAB:3001005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:3001005\',' \ Eureka \ Lab Test \ Immunology \ CRP-HIGH SENSITIVITY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:3001005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5010051\','HERPES 1 IGG ANTIBODY','N','LAE',null,'LAB:5010051','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5010051\',' \ Eureka \ Lab Test \ Immunology \ HERPES 1 IGG ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5010051');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5010110\','ANTIBODY TO EBV NUCLEAR AG','N','LAE',null,'LAB:5010110','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5010110\',' \ Eureka \ Lab Test \ Immunology \ ANTIBODY TO EBV NUCLEAR AG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5010110');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5020105\','ANTINUCLEAR ANTIBODY TITER','N','LAE',null,'LAB:5020105','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5020105\',' \ Eureka \ Lab Test \ Immunology \ ANTINUCLEAR ANTIBODY TITER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5020105');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5040010\','ALPHA 1 ANTITRYPSIN','N','LAE',null,'LAB:5040010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5040010\',' \ Eureka \ Lab Test \ Immunology \ ALPHA 1 ANTITRYPSIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5040010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5040245\','C-REACTIVE PROTEIN','N','LAE',null,'LAB:5040245','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5040245\',' \ Eureka \ Lab Test \ Immunology \ C-REACTIVE PROTEIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5040245');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Immunology\LAB:5080000\','HEPATITIS B SURFACE ANTIGEN','N','LAE',null,'LAB:5080000','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Immunology\LAB:5080000\',' \ Eureka \ Lab Test \ Immunology \ HEPATITIS B SURFACE ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Immunology\','LAB:5080000');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Endocrine\LAB:LOINC:4549-2\','Hemoglobin A1c/Hemoglobin.total in Blood by Electrophoresis','N','LAE',null,'LAB:LOINC:4549-2','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Endocrine\LAB:LOINC:4549-2\',' \ Eureka \ Lab Test \ Endocrine \ Hemoglobin A1c/Hemoglobin.total in Blood by Electrophoresis','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Endocrine\','LAB:LOINC:4549-2');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Fluids\','Fluids','N','FAE',null,'LAB:Fluids','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Fluids\',' \ Eureka \ Lab Test \ Fluids','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Fluids');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Fluids\LAB:1000320\','GLUCOSE BODY FLUID','N','LAE',null,'LAB:1000320','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Fluids\LAB:1000320\',' \ Eureka \ Lab Test \ Fluids \ GLUCOSE BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Fluids\','LAB:1000320');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Fluids\LAB:2000169\','FLUID MANUAL NUCLEATED CELL CT','N','LAE',null,'LAB:2000169','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Fluids\LAB:2000169\',' \ Eureka \ Lab Test \ Fluids \ FLUID MANUAL NUCLEATED CELL CT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Fluids\','LAB:2000169');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Fluids\LAB:2000170\','FLUID MANUAL RBC COUNT','N','LAE',null,'LAB:2000170','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Fluids\LAB:2000170\',' \ Eureka \ Lab Test \ Fluids \ FLUID MANUAL RBC COUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Fluids\','LAB:2000170');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Fluids\LAB:2001085\','BODY FLUID SEGMENTED NEUTROPHI','N','LAE',null,'LAB:2001085','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Fluids\LAB:2001085\',' \ Eureka \ Lab Test \ Fluids \ BODY FLUID SEGMENTED NEUTROPHI','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Fluids\','LAB:2001085');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000940\','GLUCOSE','N','LAE',null,'LAB:1000940','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000940\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ GLUCOSE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1000940');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1001520\','POTASSIUM PLASMA','N','LAE',null,'LAB:1001520','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1001520\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ POTASSIUM PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1001520');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1001700\','SODIUM PLASMA','N','LAE',null,'LAB:1001700','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1001700\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ SODIUM PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1001700');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1001765\','GFR CALCULATED','N','LAE',null,'LAB:1001765','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1001765\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ GFR CALCULATED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1001765');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1001820\','BUN (BLOOD UREA NITROGEN)','N','LAE',null,'LAB:1001820','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1001820\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ BUN (BLOOD UREA NITROGEN)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1001820');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503007\','GLUCOSE CONF FASTING','N','LAE',null,'LAB:1503007','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503007\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ GLUCOSE CONF FASTING','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1503007');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503009\','GLUCOSE 1 HOUR CONFIRMATORY','N','LAE',null,'LAB:1503009','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503009\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ GLUCOSE 1 HOUR CONFIRMATORY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1503009');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503054\','UREA:CREATININE RATIO','N','LAE',null,'LAB:1503054','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503054\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ UREA:CREATININE RATIO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1503054');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503115\','GLUCOSE 2 HOUR CONFIRMATORY','N','LAE',null,'LAB:1503115','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503115\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ GLUCOSE 2 HOUR CONFIRMATORY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1503115');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503281\','GLUCOSE,FASTING,TOLERANCE','N','LAE',null,'LAB:1503281','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1503281\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ GLUCOSE,FASTING,TOLERANCE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1503281');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:9915008\','SODIUM','N','LAE',null,'LAB:9915008','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:9915008\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ SODIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:9915008');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:9915009\','POTASSIUM','N','LAE',null,'LAB:9915009','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:9915009\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ POTASSIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:9915009');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:9915010\','GLUCOSE','N','LAE',null,'LAB:9915010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:9915010\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ GLUCOSE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:9915010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:9915059\','CHLORIDE','N','LAE',null,'LAB:9915059','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:9915059\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ CHLORIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:9915059');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:17865-7\','Glucose [Mass/volume] in Serum or Plasma -- 8 hours fasting','N','LAE',null,'LAB:LOINC:17865-7','concept_cd','concept_dimension','concept_path','N','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:17865-7\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ Glucose [Mass/volume] in Serum or Plasma -- 8 hours fasting','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:LOINC:17865-7');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:2160-0\','Createnine [Mass/volume] in Serum or Plasma','N','LAE',null,'LAB:LOINC:2160-0','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:2160-0\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ Createnine [Mass/volume] in Serum or Plasma','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:LOINC:2160-0');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:2341-6\','Glucose [Mass/volume] in Blood by Test strip','N','LAE',null,'LAB:LOINC:2341-6','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:2341-6\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ Glucose [Mass/volume] in Blood by Test strip','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:LOINC:2341-6');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:2345-7\','Glucose [Mass/volume] in Serum or Plasma','N','LAE',null,'LAB:LOINC:2345-7','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:2345-7\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ Glucose [Mass/volume] in Serum or Plasma','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:LOINC:2345-7');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:48642-3\','Estimated glomerular filtration rate (MDRD) non black','N','LAE',null,'LAB:LOINC:48642-3','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:48642-3\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ Estimated glomerular filtration rate (MDRD) non black','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:LOINC:48642-3');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:48643-1\','Estimated glomerular filtration rate (MDRD) black','N','LAE',null,'LAB:LOINC:48643-1','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:48643-1\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ Estimated glomerular filtration rate (MDRD) black','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:LOINC:48643-1');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:50044-7\','Estimated glomerular filtration rate (MDRD) female','N','LAE',null,'LAB:LOINC:50044-7','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:LOINC:50044-7\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ Estimated glomerular filtration rate (MDRD) female','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:LOINC:50044-7');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\','eGFR','N','FAE',null,'LAB:eGFR','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ eGFR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:eGFR');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (4,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\LAB:LOINC:33914-3\','Estimated glomerular filtration rate (MDRD)','N','LAE',null,'LAB:LOINC:33914-3','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\LAB:LOINC:33914-3\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ eGFR \ Estimated glomerular filtration rate (MDRD)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\','LAB:LOINC:33914-3');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1000100\','ALKALINE PHOSPHATASE','N','LAE',null,'LAB:1000100','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1000100\',' \ Eureka \ Lab Test \ Liver Function \ ALKALINE PHOSPHATASE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1000100');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1000260\','BILIRUBIN, DIRECT','N','LAE',null,'LAB:1000260','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1000260\',' \ Eureka \ Lab Test \ Liver Function \ BILIRUBIN, DIRECT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1000260');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1000270\','BILIRUBIN TOTAL','N','LAE',null,'LAB:1000270','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1000270\',' \ Eureka \ Lab Test \ Liver Function \ BILIRUBIN TOTAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1000270');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1000280\','INDIRECT BILIRUBIN','N','LAE',null,'LAB:1000280','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1000280\',' \ Eureka \ Lab Test \ Liver Function \ INDIRECT BILIRUBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1000280');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1001400\','AMMONIA','N','LAE',null,'LAB:1001400','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1001400\',' \ Eureka \ Lab Test \ Liver Function \ AMMONIA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1001400');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1001420\','GAMMA GT','N','LAE',null,'LAB:1001420','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1001420\',' \ Eureka \ Lab Test \ Liver Function \ GAMMA GT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1001420');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1001620\','PROTEIN TOTAL PLASMA','N','LAE',null,'LAB:1001620','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1001620\',' \ Eureka \ Lab Test \ Liver Function \ PROTEIN TOTAL PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1001620');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1001660\','AST/SGOT','N','LAE',null,'LAB:1001660','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1001660\',' \ Eureka \ Lab Test \ Liver Function \ AST/SGOT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1001660');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:1001680\','ALT/SGPT','N','LAE',null,'LAB:1001680','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:1001680\',' \ Eureka \ Lab Test \ Liver Function \ ALT/SGPT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:1001680');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:LOINC:1975-2\','Bilirubin.total [Mass/volume] in Serum or Plasma','N','LAE',null,'LAB:LOINC:1975-2','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:LOINC:1975-2\',' \ Eureka \ Lab Test \ Liver Function \ Bilirubin.total [Mass/volume] in Serum or Plasma','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:LOINC:1975-2');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Liver Function\LAB:LOINC:6768-6\','Alkaline phosphatase [Enzymatic activity/volume] in Serum or Plasma','N','LAE',null,'LAB:LOINC:6768-6','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Liver Function\LAB:LOINC:6768-6\',' \ Eureka \ Lab Test \ Liver Function \ Alkaline phosphatase [Enzymatic activity/volume] in Serum or Plasma','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Liver Function\','LAB:LOINC:6768-6');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','Lytes/Renal/Glucose','N','FAE',null,'LAB:Lytes/Renal/Glucose','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Lytes/Renal/Glucose');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000090\','WHOLE BLOOD GLUCOSE','N','LAE',null,'LAB:1000090','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000090\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ WHOLE BLOOD GLUCOSE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1000090');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000099\','GLUCOSE 2 HOURS','N','LAE',null,'LAB:1000099','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000099\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ GLUCOSE 2 HOURS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1000099');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000240\','ANION GAP, BLOOD','N','LAE',null,'LAB:1000240','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000240\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ ANION GAP, BLOOD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1000240');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000580\','CHLORIDE','N','LAE',null,'LAB:1000580','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000580\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ CHLORIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1000580');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000640\','CO2','N','LAE',null,'LAB:1000640','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000640\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ CO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1000640');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000764\','CREATININE','N','LAE',null,'LAB:1000764','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:1000764\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ CREATININE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\','LAB:1000764');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:0907064\','CODEINE, FREE','N','LAE',null,'LAB:0907064','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:0907064\',' \ Eureka \ Lab Test \ Other \ CODEINE, FREE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:0907064');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000020\','ACID PHOSPHATASE','N','LAE',null,'LAB:1000020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000020\',' \ Eureka \ Lab Test \ Other \ ACID PHOSPHATASE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000022\','ESTRADIOL','N','LAE',null,'LAB:1000022','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000022\',' \ Eureka \ Lab Test \ Other \ ESTRADIOL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000022');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000023\','CONC','N','LAE',null,'LAB:1000023','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000023\',' \ Eureka \ Lab Test \ Other \ CONC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000023');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000025\','PREGNANCY SCREEN SERUM','N','LAE',null,'LAB:1000025','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000025\',' \ Eureka \ Lab Test \ Other \ PREGNANCY SCREEN SERUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000025');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000027\','PREGNANCY TEST INTERP','N','LAE',null,'LAB:1000027','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000027\',' \ Eureka \ Lab Test \ Other \ PREGNANCY TEST INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000027');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000380\','URINE CALCIUM TIMED','N','LAE',null,'LAB:1000380','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000380\',' \ Eureka \ Lab Test \ Other \ URINE CALCIUM TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000380');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000383\','DOPAMINE,RANDOM URINE','N','LAE',null,'LAB:1000383','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000383\',' \ Eureka \ Lab Test \ Other \ DOPAMINE,RANDOM URINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000383');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000384\','URINE DOPAMINE,TIMED','N','LAE',null,'LAB:1000384','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000384\',' \ Eureka \ Lab Test \ Other \ URINE DOPAMINE,TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000384');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000385\','EPINEPHRINE,RANDOM URINE','N','LAE',null,'LAB:1000385','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000385\',' \ Eureka \ Lab Test \ Other \ EPINEPHRINE,RANDOM URINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000385');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000386\','URINE EPINEPHRINE TIMED','N','LAE',null,'LAB:1000386','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000386\',' \ Eureka \ Lab Test \ Other \ URINE EPINEPHRINE TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000386');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000387\','NOREPINEPHRINE,RANDOM URINE','N','LAE',null,'LAB:1000387','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000387\',' \ Eureka \ Lab Test \ Other \ NOREPINEPHRINE,RANDOM URINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000387');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000388\','URINE NOREPINEPHRINE TIMED','N','LAE',null,'LAB:1000388','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000388\',' \ Eureka \ Lab Test \ Other \ URINE NOREPINEPHRINE TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000388');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000411\','TIME DRAWN','N','LAE',null,'LAB:1000411','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000411\',' \ Eureka \ Lab Test \ Other \ TIME DRAWN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000411');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000412\','BUSULFAN','N','LAE',null,'LAB:1000412','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000412\',' \ Eureka \ Lab Test \ Other \ BUSULFAN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000412');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000413\','POST DOSE','N','LAE',null,'LAB:1000413','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000413\',' \ Eureka \ Lab Test \ Other \ POST DOSE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000413');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000415\','TIME OF COLLECTION','N','LAE',null,'LAB:1000415','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000415\',' \ Eureka \ Lab Test \ Other \ TIME OF COLLECTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000415');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000416\','TOTAL VOLUME','N','LAE',null,'LAB:1000416','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000416\',' \ Eureka \ Lab Test \ Other \ TOTAL VOLUME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000416');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000418\','URINE CREATININE, TIMED','N','LAE',null,'LAB:1000418','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000418\',' \ Eureka \ Lab Test \ Other \ URINE CREATININE, TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000418');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000420\','CREATININE BODY FLUID','N','LAE',null,'LAB:1000420','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000420\',' \ Eureka \ Lab Test \ Other \ CREATININE BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000420');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000440\','CHLORIDE BODY FLUID','N','LAE',null,'LAB:1000440','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000440\',' \ Eureka \ Lab Test \ Other \ CHLORIDE BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000440');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000480\','GLUCOSE CSF','N','LAE',null,'LAB:1000480','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000480\',' \ Eureka \ Lab Test \ Other \ GLUCOSE CSF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000480');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000500\','LACTIC ACID CSF','N','LAE',null,'LAB:1000500','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000500\',' \ Eureka \ Lab Test \ Other \ LACTIC ACID CSF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000500');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000520\','LD CSF','N','LAE',null,'LAB:1000520','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000520\',' \ Eureka \ Lab Test \ Other \ LD CSF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000520');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000540\','PROTEIN CSF','N','LAE',null,'LAB:1000540','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000540\',' \ Eureka \ Lab Test \ Other \ PROTEIN CSF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000540');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000590\','MYOGLOBIN SCREEN URINE','N','LAE',null,'LAB:1000590','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000590\',' \ Eureka \ Lab Test \ Other \ MYOGLOBIN SCREEN URINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000590');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000600\','URINE CHLORIDE, TIMED','N','LAE',null,'LAB:1000600','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000600\',' \ Eureka \ Lab Test \ Other \ URINE CHLORIDE, TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000600');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000775\','CREATININE CLEARANCE','N','LAE',null,'LAB:1000775','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000775\',' \ Eureka \ Lab Test \ Other \ CREATININE CLEARANCE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000775');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000824\','APOLIPOPROTEIN A1','N','LAE',null,'LAB:1000824','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000824\',' \ Eureka \ Lab Test \ Other \ APOLIPOPROTEIN A1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000824');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000825\','APOLIPOPROTEIN B','N','LAE',null,'LAB:1000825','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000825\',' \ Eureka \ Lab Test \ Other \ APOLIPOPROTEIN B','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000825');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000031\','NTX (nMol BCE/uMol CREATININE)','N','LAE',null,'LAB:1000031','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000031\',' \ Eureka \ Lab Test \ Other \ NTX (nMol BCE/uMol CREATININE)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000031');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000095\','RAPID STREP','N','LAE',null,'LAB:1000095','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000095\',' \ Eureka \ Lab Test \ Other \ RAPID STREP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000095');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000097\','RAPID STREP A','N','LAE',null,'LAB:1000097','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000097\',' \ Eureka \ Lab Test \ Other \ RAPID STREP A','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000097');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000098\','MALARIA SCREEN','N','LAE',null,'LAB:1000098','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000098\',' \ Eureka \ Lab Test \ Other \ MALARIA SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000098');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000133\','MAGNESIUM','N','LAE',null,'LAB:1000133','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000133\',' \ Eureka \ Lab Test \ Other \ MAGNESIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000133');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000136\','MPA PHENOL GLUCURONIDE','N','LAE',null,'LAB:1000136','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000136\',' \ Eureka \ Lab Test \ Other \ MPA PHENOL GLUCURONIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000136');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000230\','AMYLASE URINE RANDOM','N','LAE',null,'LAB:1000230','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000230\',' \ Eureka \ Lab Test \ Other \ AMYLASE URINE RANDOM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000230');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000242\','FREE THYROXINE INDEX','N','LAE',null,'LAB:1000242','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000242\',' \ Eureka \ Lab Test \ Other \ FREE THYROXINE INDEX','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000242');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000271\','BILIRUBIN TOTAL, CORD','N','LAE',null,'LAB:1000271','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000271\',' \ Eureka \ Lab Test \ Other \ BILIRUBIN TOTAL, CORD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000271');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000300\','AMYLASE BODY FLUID','N','LAE',null,'LAB:1000300','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000300\',' \ Eureka \ Lab Test \ Other \ AMYLASE BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000300');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000340\','PH BODY FLUID','N','LAE',null,'LAB:1000340','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000340\',' \ Eureka \ Lab Test \ Other \ PH BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000340');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000361\','IONIZED CALCIUM LEVEL, PLASMA','N','LAE',null,'LAB:1000361','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000361\',' \ Eureka \ Lab Test \ Other \ IONIZED CALCIUM LEVEL, PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000361');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (4,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\LAB:LOINC:48642-3\','Estimated glomerular filtration rate (MDRD) non black','Y','LAE',null,'LAB:LOINC:48642-3','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\LAB:LOINC:48642-3\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ eGFR \ Estimated glomerular filtration rate (MDRD) non black','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\','LAB:LOINC:48642-3');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (4,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\LAB:LOINC:48643-1\','Estimated glomerular filtration rate (MDRD) black','Y','LAE',null,'LAB:LOINC:48643-1','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\LAB:LOINC:48643-1\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ eGFR \ Estimated glomerular filtration rate (MDRD) black','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\','LAB:LOINC:48643-1');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (4,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\LAB:LOINC:50044-7\','Estimated glomerular filtration rate (MDRD) female','Y','LAE',null,'LAB:LOINC:50044-7','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\LAB:LOINC:50044-7\',' \ Eureka \ Lab Test \ Lytes/Renal/Glucose \ eGFR \ Estimated glomerular filtration rate (MDRD) female','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Lytes/Renal/Glucose\LAB:eGFR\','LAB:LOINC:50044-7');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (2,'\EK\LAB:LabTest\LAB:Other\','Other','N','FAE',null,'LAB:Other','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\',' \ Eureka \ Lab Test \ Other','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\','LAB:Other');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:0808542\','MOL DIAG;ISOL OR EXTRACTION','N','LAE',null,'LAB:0808542','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:0808542\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;ISOL OR EXTRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:0808542');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:0833115\','CPTII MM QUALITY Q3260F8P','N','LAE',null,'LAB:0833115','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:0833115\',' \ Eureka \ Lab Test \ Other \ CPTII MM QUALITY Q3260F8P','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:0833115');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001180\','BODY FLUID CRYSTAL','N','LAE',null,'LAB:1001180','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001180\',' \ Eureka \ Lab Test \ Other \ BODY FLUID CRYSTAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001180');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001260\','LITHIUM','N','LAE',null,'LAB:1001260','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001260\',' \ Eureka \ Lab Test \ Other \ LITHIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001260');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001340\','URINE MAGNESIUM, TIMED','N','LAE',null,'LAB:1001340','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001340\',' \ Eureka \ Lab Test \ Other \ URINE MAGNESIUM, TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001340');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001350\','RANDOM URINE MAGNESIUM','N','LAE',null,'LAB:1001350','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001350\',' \ Eureka \ Lab Test \ Other \ RANDOM URINE MAGNESIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001350');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001412\','HOMOCYSTEINE','N','LAE',null,'LAB:1001412','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001412\',' \ Eureka \ Lab Test \ Other \ HOMOCYSTEINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001412');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001540\','URINE POTASSIUM, TIMED','N','LAE',null,'LAB:1001540','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001540\',' \ Eureka \ Lab Test \ Other \ URINE POTASSIUM, TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001540');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001548\','SODIUM FLUID','N','LAE',null,'LAB:1001548','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001548\',' \ Eureka \ Lab Test \ Other \ SODIUM FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001548');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001551\','POTASSIUM FLUID','N','LAE',null,'LAB:1001551','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001551\',' \ Eureka \ Lab Test \ Other \ POTASSIUM FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001551');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001560\','PROLACTIN','N','LAE',null,'LAB:1001560','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001560\',' \ Eureka \ Lab Test \ Other \ PROLACTIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001560');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001563\','PROLACTIN1:10','N','LAE',null,'LAB:1001563','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001563\',' \ Eureka \ Lab Test \ Other \ PROLACTIN1:10','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001563');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001564\','PROLACTIN 1:100','N','LAE',null,'LAB:1001564','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001564\',' \ Eureka \ Lab Test \ Other \ PROLACTIN 1:100','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001564');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001590\','ACETAMINOPHEN (TYLENOL)','N','LAE',null,'LAB:1001590','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001590\',' \ Eureka \ Lab Test \ Other \ ACETAMINOPHEN (TYLENOL)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001590');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001605\','PENTOBARBITAL','N','LAE',null,'LAB:1001605','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001605\',' \ Eureka \ Lab Test \ Other \ PENTOBARBITAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001605');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001608\','T3 RESIN UPTAKE','N','LAE',null,'LAB:1001608','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001608\',' \ Eureka \ Lab Test \ Other \ T3 RESIN UPTAKE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001608');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001612\','CYCLOSPORINE, MONOCLONAL','N','LAE',null,'LAB:1001612','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001612\',' \ Eureka \ Lab Test \ Other \ CYCLOSPORINE, MONOCLONAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001612');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001619\','METHOTREXATE','N','LAE',null,'LAB:1001619','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001619\',' \ Eureka \ Lab Test \ Other \ METHOTREXATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001619');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001721\','URINE SODIUM TIMED','N','LAE',null,'LAB:1001721','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001721\',' \ Eureka \ Lab Test \ Other \ URINE SODIUM TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001721');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001750\','LATEX ANTIBODY','N','LAE',null,'LAB:1001750','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001750\',' \ Eureka \ Lab Test \ Other \ LATEX ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001750');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001760\','TESTOSTERONE','N','LAE',null,'LAB:1001760','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001760\',' \ Eureka \ Lab Test \ Other \ TESTOSTERONE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001760');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001817\','URINE URIC ACID,TIMED','N','LAE',null,'LAB:1001817','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001817\',' \ Eureka \ Lab Test \ Other \ URINE URIC ACID,TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001817');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001818\','URIC ACID URINE RANDOM','N','LAE',null,'LAB:1001818','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001818\',' \ Eureka \ Lab Test \ Other \ URIC ACID URINE RANDOM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001818');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001831\','OPIATES SCREEN','N','LAE',null,'LAB:1001831','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001831\',' \ Eureka \ Lab Test \ Other \ OPIATES SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001831');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001832\','COCAINE METABOLITE SCREEN','N','LAE',null,'LAB:1001832','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001832\',' \ Eureka \ Lab Test \ Other \ COCAINE METABOLITE SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001832');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001833\','MARIJUANA METABOLITE SCREEN','N','LAE',null,'LAB:1001833','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001833\',' \ Eureka \ Lab Test \ Other \ MARIJUANA METABOLITE SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001833');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000826\','LIPOPROTEIN LITTLE A','N','LAE',null,'LAB:1000826','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000826\',' \ Eureka \ Lab Test \ Other \ LIPOPROTEIN LITTLE A','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000826');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000829\','DIRECT LDL','N','LAE',null,'LAB:1000829','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000829\',' \ Eureka \ Lab Test \ Other \ DIRECT LDL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000829');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000841\','BODY FLUID PROTEIN','N','LAE',null,'LAB:1000841','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000841\',' \ Eureka \ Lab Test \ Other \ BODY FLUID PROTEIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000841');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000918\','URINE PROTEIN, TIMED','N','LAE',null,'LAB:1000918','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000918\',' \ Eureka \ Lab Test \ Other \ URINE PROTEIN, TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000918');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000960\','GLUCOSE 1/2 HOUR','N','LAE',null,'LAB:1000960','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000960\',' \ Eureka \ Lab Test \ Other \ GLUCOSE 1/2 HOUR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000960');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1000980\','GLUCOSE 1 HOUR','N','LAE',null,'LAB:1000980','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1000980\',' \ Eureka \ Lab Test \ Other \ GLUCOSE 1 HOUR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1000980');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001000\','GLUCOSE 3 HOURS','N','LAE',null,'LAB:1001000','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001000\',' \ Eureka \ Lab Test \ Other \ GLUCOSE 3 HOURS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001000');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001001\','GLUCOSE 4 HOURS','N','LAE',null,'LAB:1001001','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001001\',' \ Eureka \ Lab Test \ Other \ GLUCOSE 4 HOURS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001001');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001002\','GLUCOSE 5 HOURS','N','LAE',null,'LAB:1001002','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001002\',' \ Eureka \ Lab Test \ Other \ GLUCOSE 5 HOURS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001002');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001036\','RAPAMYCIN (SIROLIMUS)','N','LAE',null,'LAB:1001036','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001036\',' \ Eureka \ Lab Test \ Other \ RAPAMYCIN (SIROLIMUS)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001036');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001040\','KETONES SERUM','N','LAE',null,'LAB:1001040','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001040\',' \ Eureka \ Lab Test \ Other \ KETONES SERUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001040');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001060\','SYNOVIAL FL CRYSTAL','N','LAE',null,'LAB:1001060','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001060\',' \ Eureka \ Lab Test \ Other \ SYNOVIAL FL CRYSTAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001060');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001092\','TV/24 HR','N','LAE',null,'LAB:1001092','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001092\',' \ Eureka \ Lab Test \ Other \ TV/24 HR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001092');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001093\','U CREAT/24HR','N','LAE',null,'LAB:1001093','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001093\',' \ Eureka \ Lab Test \ Other \ U CREAT/24HR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001093');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001094\','TV/24 HR','N','LAE',null,'LAB:1001094','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001094\',' \ Eureka \ Lab Test \ Other \ TV/24 HR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001094');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001100\','BETA-HCG','N','LAE',null,'LAB:1001100','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001100\',' \ Eureka \ Lab Test \ Other \ BETA-HCG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001100');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001145\','TRANIBC','N','LAE',null,'LAB:1001145','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001145\',' \ Eureka \ Lab Test \ Other \ TRANIBC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001145');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001160\','DUODENAL FL CRYSTAL','N','LAE',null,'LAB:1001160','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001160\',' \ Eureka \ Lab Test \ Other \ DUODENAL FL CRYSTAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001160');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001904\','PREGNANCY TEST URINE','N','LAE',null,'LAB:1001904','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001904\',' \ Eureka \ Lab Test \ Other \ PREGNANCY TEST URINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001904');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001924\','URINE UREA, TIMED','N','LAE',null,'LAB:1001924','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001924\',' \ Eureka \ Lab Test \ Other \ URINE UREA, TIMED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001924');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001926\','PROTEIN CREATININE RATIO','N','LAE',null,'LAB:1001926','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001926\',' \ Eureka \ Lab Test \ Other \ PROTEIN CREATININE RATIO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001926');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001927\','ACTH','N','LAE',null,'LAB:1001927','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001927\',' \ Eureka \ Lab Test \ Other \ ACTH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001927');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001930\','DHEA SULFATE','N','LAE',null,'LAB:1001930','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001930\',' \ Eureka \ Lab Test \ Other \ DHEA SULFATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001930');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001932\','C-PEPTIDE','N','LAE',null,'LAB:1001932','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001932\',' \ Eureka \ Lab Test \ Other \ C-PEPTIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001932');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002021\','CALCIUM OXALATE CRYSTALS','N','LAE',null,'LAB:1002021','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002021\',' \ Eureka \ Lab Test \ Other \ CALCIUM OXALATE CRYSTALS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002021');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002022\','TRIPLE PHOSPHATE','N','LAE',null,'LAB:1002022','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002022\',' \ Eureka \ Lab Test \ Other \ TRIPLE PHOSPHATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002022');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002027\','RENAL EPI','N','LAE',null,'LAB:1002027','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002027\',' \ Eureka \ Lab Test \ Other \ RENAL EPI','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002027');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002029\','TRICHAMONADS','N','LAE',null,'LAB:1002029','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002029\',' \ Eureka \ Lab Test \ Other \ TRICHAMONADS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002029');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002031\','OVAL FAT BODIES','N','LAE',null,'LAB:1002031','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002031\',' \ Eureka \ Lab Test \ Other \ OVAL FAT BODIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002031');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002035\','SPECIFIC GRAVITY BODY FLUID','N','LAE',null,'LAB:1002035','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002035\',' \ Eureka \ Lab Test \ Other \ SPECIFIC GRAVITY BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002035');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002036\','URIC ACID BODY FLUID','N','LAE',null,'LAB:1002036','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002036\',' \ Eureka \ Lab Test \ Other \ URIC ACID BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002036');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002070\','POC VENOUS BLOOD GAS PH','N','LAE',null,'LAB:1002070','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002070\',' \ Eureka \ Lab Test \ Other \ POC VENOUS BLOOD GAS PH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002070');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002071\','POC VENOUS BLOOD GAS PO2','N','LAE',null,'LAB:1002071','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002071\',' \ Eureka \ Lab Test \ Other \ POC VENOUS BLOOD GAS PO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002071');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002072\','POC VENOUS PCO2','N','LAE',null,'LAB:1002072','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002072\',' \ Eureka \ Lab Test \ Other \ POC VENOUS PCO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002072');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002091\','POC VENOUS BICARBONATE','N','LAE',null,'LAB:1002091','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002091\',' \ Eureka \ Lab Test \ Other \ POC VENOUS BICARBONATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002091');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002092\','POC VENOUS O2 SATURATION','N','LAE',null,'LAB:1002092','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002092\',' \ Eureka \ Lab Test \ Other \ POC VENOUS O2 SATURATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002092');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002125\','POC LR ACTIVATED CLOTTING TIME','N','LAE',null,'LAB:1002125','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002125\',' \ Eureka \ Lab Test \ Other \ POC LR ACTIVATED CLOTTING TIME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002125');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002127\','POC HR ACTIVATED CLOTTING TIME','N','LAE',null,'LAB:1002127','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002127\',' \ Eureka \ Lab Test \ Other \ POC HR ACTIVATED CLOTTING TIME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002127');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002224\','INDEX','N','LAE',null,'LAB:1002224','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002224\',' \ Eureka \ Lab Test \ Other \ INDEX','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002224');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002400\','COTININE URINE RANDOM','N','LAE',null,'LAB:1002400','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002400\',' \ Eureka \ Lab Test \ Other \ COTININE URINE RANDOM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002400');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002402\','TOTAL NICOTINE + COTININE','N','LAE',null,'LAB:1002402','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002402\',' \ Eureka \ Lab Test \ Other \ TOTAL NICOTINE + COTININE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002402');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1003656\','PHENCYCLIDINE SCREEN','N','LAE',null,'LAB:1003656','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1003656\',' \ Eureka \ Lab Test \ Other \ PHENCYCLIDINE SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1003656');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1003807\','FRACTION OF INSPIRED OXYGEN %','N','LAE',null,'LAB:1003807','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1003807\',' \ Eureka \ Lab Test \ Other \ FRACTION OF INSPIRED OXYGEN %','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1003807');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1003808\','BLOOD GAS SAMPLE TYPE','N','LAE',null,'LAB:1003808','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1003808\',' \ Eureka \ Lab Test \ Other \ BLOOD GAS SAMPLE TYPE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1003808');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1005000\','INTRA-OPERATIVE PTH','N','LAE',null,'LAB:1005000','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1005000\',' \ Eureka \ Lab Test \ Other \ INTRA-OPERATIVE PTH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1005000');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1009998\','FETAL TESTING, MISCELLANEOUS','N','LAE',null,'LAB:1009998','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1009998\',' \ Eureka \ Lab Test \ Other \ FETAL TESTING, MISCELLANEOUS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1009998');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1012345\','BILIRUBIN TOTAL BODY FLUID','N','LAE',null,'LAB:1012345','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1012345\',' \ Eureka \ Lab Test \ Other \ BILIRUBIN TOTAL BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1012345');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1050000\','CALCIUM:CREATININE RATIO','N','LAE',null,'LAB:1050000','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1050000\',' \ Eureka \ Lab Test \ Other \ CALCIUM:CREATININE RATIO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1050000');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001933\','FSH-FOLLICLE STIMULATING HORM','N','LAE',null,'LAB:1001933','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001933\',' \ Eureka \ Lab Test \ Other \ FSH-FOLLICLE STIMULATING HORM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001933');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001934\','INSULIN','N','LAE',null,'LAB:1001934','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001934\',' \ Eureka \ Lab Test \ Other \ INSULIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001934');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001935\','LUTENIZING HORMONE (LH)','N','LAE',null,'LAB:1001935','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001935\',' \ Eureka \ Lab Test \ Other \ LUTENIZING HORMONE (LH)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001935');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001936\','TRIGLYCERIDES BODY FLUID','N','LAE',null,'LAB:1001936','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001936\',' \ Eureka \ Lab Test \ Other \ TRIGLYCERIDES BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001936');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001937\','OSMOLALITY URINE','N','LAE',null,'LAB:1001937','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001937\',' \ Eureka \ Lab Test \ Other \ OSMOLALITY URINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001937');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001938\','OSMOLALITY BODY FLUID','N','LAE',null,'LAB:1001938','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001938\',' \ Eureka \ Lab Test \ Other \ OSMOLALITY BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001938');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001939\','SODIUM BODY FLUID','N','LAE',null,'LAB:1001939','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001939\',' \ Eureka \ Lab Test \ Other \ SODIUM BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001939');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001941\','POTASSIUM BODY FLUID','N','LAE',null,'LAB:1001941','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001941\',' \ Eureka \ Lab Test \ Other \ POTASSIUM BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001941');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001943\','UREA BODY FLUID','N','LAE',null,'LAB:1001943','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001943\',' \ Eureka \ Lab Test \ Other \ UREA BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001943');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001947\','LD FLUID','N','LAE',null,'LAB:1001947','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001947\',' \ Eureka \ Lab Test \ Other \ LD FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001947');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001995\','THYROGLOBULIN2','N','LAE',null,'LAB:1001995','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001995\',' \ Eureka \ Lab Test \ Other \ THYROGLOBULIN2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001995');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1002020\','URIC ACID CRYSTALS','N','LAE',null,'LAB:1002020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1002020\',' \ Eureka \ Lab Test \ Other \ URIC ACID CRYSTALS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1002020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001834\','BENZODIAZEPINE SCREEN','N','LAE',null,'LAB:1001834','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001834\',' \ Eureka \ Lab Test \ Other \ BENZODIAZEPINE SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001834');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001835\','AMPHETAMINE SCREEN','N','LAE',null,'LAB:1001835','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001835\',' \ Eureka \ Lab Test \ Other \ AMPHETAMINE SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001835');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001836\','BARBITURATE SCREEN','N','LAE',null,'LAB:1001836','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001836\',' \ Eureka \ Lab Test \ Other \ BARBITURATE SCREEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001836');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001900\','PLASMA HEMOGLOBIN','N','LAE',null,'LAB:1001900','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001900\',' \ Eureka \ Lab Test \ Other \ PLASMA HEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001900');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001902\','HEMOSIDERIN','N','LAE',null,'LAB:1001902','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001902\',' \ Eureka \ Lab Test \ Other \ HEMOSIDERIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001902');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1001903\','ALCOHOL','N','LAE',null,'LAB:1001903','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1001903\',' \ Eureka \ Lab Test \ Other \ ALCOHOL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1001903');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501780\','FETAL T4','N','LAE',null,'LAB:1501780','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501780\',' \ Eureka \ Lab Test \ Other \ FETAL T4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501780');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501820\','FETAL BUN(BLOOD UREA NITROGEN)','N','LAE',null,'LAB:1501820','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501820\',' \ Eureka \ Lab Test \ Other \ FETAL BUN(BLOOD UREA NITROGEN)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501820');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501917\','FETAL PROTEIN URINE RANDOM','N','LAE',null,'LAB:1501917','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501917\',' \ Eureka \ Lab Test \ Other \ FETAL PROTEIN URINE RANDOM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501917');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501937\','FETAL OSMOLALITY URINE','N','LAE',null,'LAB:1501937','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501937\',' \ Eureka \ Lab Test \ Other \ FETAL OSMOLALITY URINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501937');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503090\','IONIZED CALCIUM            CLH','N','LAE',null,'LAB:1503090','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503090\',' \ Eureka \ Lab Test \ Other \ IONIZED CALCIUM            CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503090');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503106\','GLUCOSE 2HR PP             CLH','N','LAE',null,'LAB:1503106','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503106\',' \ Eureka \ Lab Test \ Other \ GLUCOSE 2HR PP             CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503106');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503116\','GLUCOSE 3 HOUR CONFIRMATORY','N','LAE',null,'LAB:1503116','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503116\',' \ Eureka \ Lab Test \ Other \ GLUCOSE 3 HOUR CONFIRMATORY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503116');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503120\','CSF CHLORIDE               CLH','N','LAE',null,'LAB:1503120','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503120\',' \ Eureka \ Lab Test \ Other \ CSF CHLORIDE               CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503120');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503154\','FETAL UREA:CREATININE RATIO','N','LAE',null,'LAB:1503154','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503154\',' \ Eureka \ Lab Test \ Other \ FETAL UREA:CREATININE RATIO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503154');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503231\','GENTAMICIN (PEAK)','N','LAE',null,'LAB:1503231','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503231\',' \ Eureka \ Lab Test \ Other \ GENTAMICIN (PEAK)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503231');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503232\','GENTAMICIN (TROUGH)','N','LAE',null,'LAB:1503232','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503232\',' \ Eureka \ Lab Test \ Other \ GENTAMICIN (TROUGH)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503232');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503279\','GLUCOSE,FASTING,PREGNANCY','N','LAE',null,'LAB:1503279','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503279\',' \ Eureka \ Lab Test \ Other \ GLUCOSE,FASTING,PREGNANCY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503279');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503280\','RAPID GESTATIONAL SCRN (50GM)','N','LAE',null,'LAB:1503280','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503280\',' \ Eureka \ Lab Test \ Other \ RAPID GESTATIONAL SCRN (50GM)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503280');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503282\','GLUCOSE 2HR','N','LAE',null,'LAB:1503282','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503282\',' \ Eureka \ Lab Test \ Other \ GLUCOSE 2HR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503282');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503313\','CARBAMAZEPINE (TEGRETOL)','N','LAE',null,'LAB:1503313','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503313\',' \ Eureka \ Lab Test \ Other \ CARBAMAZEPINE (TEGRETOL)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503313');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503315\','VALPROIC ACID (DEPACOTE)','N','LAE',null,'LAB:1503315','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503315\',' \ Eureka \ Lab Test \ Other \ VALPROIC ACID (DEPACOTE)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503315');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503317\','PRIMIDONE','N','LAE',null,'LAB:1503317','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503317\',' \ Eureka \ Lab Test \ Other \ PRIMIDONE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503317');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503390\','LIDOCAINE','N','LAE',null,'LAB:1503390','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503390\',' \ Eureka \ Lab Test \ Other \ LIDOCAINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503390');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503460\','PHENOBARBITAL','N','LAE',null,'LAB:1503460','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503460\',' \ Eureka \ Lab Test \ Other \ PHENOBARBITAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503460');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503470\','PHENYTOIN (DILANTIN)','N','LAE',null,'LAB:1503470','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503470\',' \ Eureka \ Lab Test \ Other \ PHENYTOIN (DILANTIN)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503470');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503499\','PROCAINAMIDE','N','LAE',null,'LAB:1503499','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503499\',' \ Eureka \ Lab Test \ Other \ PROCAINAMIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503499');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503501\','N-ACETYLPROCAINAMIDE','N','LAE',null,'LAB:1503501','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503501\',' \ Eureka \ Lab Test \ Other \ N-ACETYLPROCAINAMIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503501');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503510\','QUINIDINE','N','LAE',null,'LAB:1503510','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503510\',' \ Eureka \ Lab Test \ Other \ QUINIDINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503510');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503520\','SALICYLATE','N','LAE',null,'LAB:1503520','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503520\',' \ Eureka \ Lab Test \ Other \ SALICYLATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503520');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500240\','FETAL ANION GAP, BLOOD','N','LAE',null,'LAB:1500240','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500240\',' \ Eureka \ Lab Test \ Other \ FETAL ANION GAP, BLOOD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500240');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500241\','FETAL CALCULATED OSMOLALITY','N','LAE',null,'LAB:1500241','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500241\',' \ Eureka \ Lab Test \ Other \ FETAL CALCULATED OSMOLALITY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500241');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500270\','FETAL BILIRUBIN TOTAL','N','LAE',null,'LAB:1500270','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500270\',' \ Eureka \ Lab Test \ Other \ FETAL BILIRUBIN TOTAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500270');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500360\','FETAL CALCIUM','N','LAE',null,'LAB:1500360','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500360\',' \ Eureka \ Lab Test \ Other \ FETAL CALCIUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500360');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500390\','FETAL CALCIUM URINE RANDOM','N','LAE',null,'LAB:1500390','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500390\',' \ Eureka \ Lab Test \ Other \ FETAL CALCIUM URINE RANDOM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500390');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500580\','FETAL CHLORIDE','N','LAE',null,'LAB:1500580','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500580\',' \ Eureka \ Lab Test \ Other \ FETAL CHLORIDE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500580');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500610\','FETAL CHLORIDE URINE RANDOM','N','LAE',null,'LAB:1500610','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500610\',' \ Eureka \ Lab Test \ Other \ FETAL CHLORIDE URINE RANDOM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500610');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500640\','FETAL CO2','N','LAE',null,'LAB:1500640','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500640\',' \ Eureka \ Lab Test \ Other \ FETAL CO2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500640');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500764\','FETAL CREATININE','N','LAE',null,'LAB:1500764','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500764\',' \ Eureka \ Lab Test \ Other \ FETAL CREATININE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500764');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1500940\','FETAL GLUCOSE','N','LAE',null,'LAB:1500940','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1500940\',' \ Eureka \ Lab Test \ Other \ FETAL GLUCOSE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:00','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1500940');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501004\','HEMOGLOBIN,OTHERS','N','LAE',null,'LAB:1501004','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501004\',' \ Eureka \ Lab Test \ Other \ HEMOGLOBIN,OTHERS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501004');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501520\','FETAL POTASSIUM PLASMA','N','LAE',null,'LAB:1501520','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501520\',' \ Eureka \ Lab Test \ Other \ FETAL POTASSIUM PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501520');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501550\','FETAL POTASSIUM URINE RANDOM','N','LAE',null,'LAB:1501550','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501550\',' \ Eureka \ Lab Test \ Other \ FETAL POTASSIUM URINE RANDOM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501550');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501608\','FETAL T3 RESIN UPTAKE','N','LAE',null,'LAB:1501608','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501608\',' \ Eureka \ Lab Test \ Other \ FETAL T3 RESIN UPTAKE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501608');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501610\','FETAL T3','N','LAE',null,'LAB:1501610','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501610\',' \ Eureka \ Lab Test \ Other \ FETAL T3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501610');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501700\','FETAL SODIUM PLASMA','N','LAE',null,'LAB:1501700','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501700\',' \ Eureka \ Lab Test \ Other \ FETAL SODIUM PLASMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501700');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501720\','FETAL SODIUM URINE RANDOM','N','LAE',null,'LAB:1501720','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501720\',' \ Eureka \ Lab Test \ Other \ FETAL SODIUM URINE RANDOM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501720');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1501740\','FETAL THYROID STIMU HORM (TSH)','N','LAE',null,'LAB:1501740','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1501740\',' \ Eureka \ Lab Test \ Other \ FETAL THYROID STIMU HORM (TSH)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1501740');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503571\','AMIKACIN (RANDOM)','N','LAE',null,'LAB:1503571','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503571\',' \ Eureka \ Lab Test \ Other \ AMIKACIN (RANDOM)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503571');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503573\','AMIKACIN (PEAK)','N','LAE',null,'LAB:1503573','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503573\',' \ Eureka \ Lab Test \ Other \ AMIKACIN (PEAK)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503573');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503574\','AMIKACIN (TROUGH)','N','LAE',null,'LAB:1503574','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503574\',' \ Eureka \ Lab Test \ Other \ AMIKACIN (TROUGH)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503574');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503959\','CHD RISK FACTOR','N','LAE',null,'LAB:1503959','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503959\',' \ Eureka \ Lab Test \ Other \ CHD RISK FACTOR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503959');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504004\','AMYLASE URINE /HOUR','N','LAE',null,'LAB:1504004','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504004\',' \ Eureka \ Lab Test \ Other \ AMYLASE URINE /HOUR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504004');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504205\','HEMOGLOBIN E               CLH','N','LAE',null,'LAB:1504205','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504205\',' \ Eureka \ Lab Test \ Other \ HEMOGLOBIN E               CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504205');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504543\','CLINITEST FOR REDUCING SUB.CLH','N','LAE',null,'LAB:1504543','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504543\',' \ Eureka \ Lab Test \ Other \ CLINITEST FOR REDUCING SUB.CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504543');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504566\','CORTISOL SERUM BASELINE','N','LAE',null,'LAB:1504566','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504566\',' \ Eureka \ Lab Test \ Other \ CORTISOL SERUM BASELINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504566');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504567\','CORTISOL SERUM 30 MINUTES','N','LAE',null,'LAB:1504567','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504567\',' \ Eureka \ Lab Test \ Other \ CORTISOL SERUM 30 MINUTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504567');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504568\','CORTISOL SERUM 60 MINUTES','N','LAE',null,'LAB:1504568','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504568\',' \ Eureka \ Lab Test \ Other \ CORTISOL SERUM 60 MINUTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504568');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504569\','TIME DRUG GIVEN','N','LAE',null,'LAB:1504569','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504569\',' \ Eureka \ Lab Test \ Other \ TIME DRUG GIVEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504569');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504585\','SQUAMOUS W/O BACTERIA','N','LAE',null,'LAB:1504585','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504585\',' \ Eureka \ Lab Test \ Other \ SQUAMOUS W/O BACTERIA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504585');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504586\','SQUAMOUS WITH BACTERIA','N','LAE',null,'LAB:1504586','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504586\',' \ Eureka \ Lab Test \ Other \ SQUAMOUS WITH BACTERIA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504586');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504588\','TRICHOMONADS-MICRO MISC.   CLH','N','LAE',null,'LAB:1504588','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504588\',' \ Eureka \ Lab Test \ Other \ TRICHOMONADS-MICRO MISC.   CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504588');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504589\','MICROSCOPIC MISCELLANEOUS WBC','N','LAE',null,'LAB:1504589','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504589\',' \ Eureka \ Lab Test \ Other \ MICROSCOPIC MISCELLANEOUS WBC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504589');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504599\','MICROSCOPIC MISCELLANEOUS RBC','N','LAE',null,'LAB:1504599','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504599\',' \ Eureka \ Lab Test \ Other \ MICROSCOPIC MISCELLANEOUS RBC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504599');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504620\','RHEUMATOID FACTOR','N','LAE',null,'LAB:1504620','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504620\',' \ Eureka \ Lab Test \ Other \ RHEUMATOID FACTOR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504620');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504809\','CARBOXYHEMOGLOBIN, FETAL   CLH','N','LAE',null,'LAB:1504809','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504809\',' \ Eureka \ Lab Test \ Other \ CARBOXYHEMOGLOBIN, FETAL   CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504809');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504810\','METHEMOGLOBI, FETAL        CLH','N','LAE',null,'LAB:1504810','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504810\',' \ Eureka \ Lab Test \ Other \ METHEMOGLOBI, FETAL        CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504810');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504995\','IMMUNOGLOBULIN KAPPA','N','LAE',null,'LAB:1504995','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504995\',' \ Eureka \ Lab Test \ Other \ IMMUNOGLOBULIN KAPPA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504995');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504996\','IMMUNOGLOBULIN LAMBDA','N','LAE',null,'LAB:1504996','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504996\',' \ Eureka \ Lab Test \ Other \ IMMUNOGLOBULIN LAMBDA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504996');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1507230\','CAFFEINE','N','LAE',null,'LAB:1507230','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1507230\',' \ Eureka \ Lab Test \ Other \ CAFFEINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1507230');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000020\','BODY FLUID APPEARANCE','N','LAE',null,'LAB:2000020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000020\',' \ Eureka \ Lab Test \ Other \ BODY FLUID APPEARANCE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000160\','CSF APPEARANCE','N','LAE',null,'LAB:2000160','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000160\',' \ Eureka \ Lab Test \ Other \ CSF APPEARANCE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000160');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000250\','BLAST','N','LAE',null,'LAB:2000250','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000250\',' \ Eureka \ Lab Test \ Other \ BLAST','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000250');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000251\','OTHER','N','LAE',null,'LAB:2000251','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000251\',' \ Eureka \ Lab Test \ Other \ OTHER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000251');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000252\','PROMYELOCYTE','N','LAE',null,'LAB:2000252','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000252\',' \ Eureka \ Lab Test \ Other \ PROMYELOCYTE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000252');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000253\','BURR CELL','N','LAE',null,'LAB:2000253','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000253\',' \ Eureka \ Lab Test \ Other \ BURR CELL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000253');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000254\','SICKLE CELLS','N','LAE',null,'LAB:2000254','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000254\',' \ Eureka \ Lab Test \ Other \ SICKLE CELLS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000254');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000258\','BIZARRE RBCS','N','LAE',null,'LAB:2000258','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000258\',' \ Eureka \ Lab Test \ Other \ BIZARRE RBCS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000258');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504281\','LDH ISOENZYME FRACTION I   CLH','N','LAE',null,'LAB:1504281','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504281\',' \ Eureka \ Lab Test \ Other \ LDH ISOENZYME FRACTION I   CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504281');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504282\','LDH ISOENZYME FRACTION II  CLH','N','LAE',null,'LAB:1504282','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504282\',' \ Eureka \ Lab Test \ Other \ LDH ISOENZYME FRACTION II  CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504282');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504283\','LDH ISOENZYME FRACTION III CLH','N','LAE',null,'LAB:1504283','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504283\',' \ Eureka \ Lab Test \ Other \ LDH ISOENZYME FRACTION III CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504283');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504284\','LDH ISOENZYME FRACTION IV  CLH','N','LAE',null,'LAB:1504284','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504284\',' \ Eureka \ Lab Test \ Other \ LDH ISOENZYME FRACTION IV  CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504284');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504285\','LDH ISOENZYME FRACTION V   CLH','N','LAE',null,'LAB:1504285','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504285\',' \ Eureka \ Lab Test \ Other \ LDH ISOENZYME FRACTION V   CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504285');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504330\','OCCULT BLOOD,GASTRIC       CLH','N','LAE',null,'LAB:1504330','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504330\',' \ Eureka \ Lab Test \ Other \ OCCULT BLOOD,GASTRIC       CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504330');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504340\','OCCULT BLOOD,STOOL         CLH','N','LAE',null,'LAB:1504340','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504340\',' \ Eureka \ Lab Test \ Other \ OCCULT BLOOD,STOOL         CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504340');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504400\','NEONATAL HEMOGLOBIN SCREEN CLH','N','LAE',null,'LAB:1504400','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504400\',' \ Eureka \ Lab Test \ Other \ NEONATAL HEMOGLOBIN SCREEN CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504400');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504497\','URIC ACID CRYSTALS,FLUID   CLH','N','LAE',null,'LAB:1504497','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504497\',' \ Eureka \ Lab Test \ Other \ URIC ACID CRYSTALS,FLUID   CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504497');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504522\','FETAL LUNG MATURITY','N','LAE',null,'LAB:1504522','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504522\',' \ Eureka \ Lab Test \ Other \ FETAL LUNG MATURITY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504522');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504523\','AMNIO FL COLOR','N','LAE',null,'LAB:1504523','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504523\',' \ Eureka \ Lab Test \ Other \ AMNIO FL COLOR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504523');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1504524\','AMNIO FL CLARITY','N','LAE',null,'LAB:1504524','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1504524\',' \ Eureka \ Lab Test \ Other \ AMNIO FL CLARITY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1504524');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503540\','THEOPHYLLINE','N','LAE',null,'LAB:1503540','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503540\',' \ Eureka \ Lab Test \ Other \ THEOPHYLLINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503540');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503550\','TOBRAMYCIN (RANDOM)','N','LAE',null,'LAB:1503550','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503550\',' \ Eureka \ Lab Test \ Other \ TOBRAMYCIN (RANDOM)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503550');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503552\','TOBRAMYCIN (PEAK)','N','LAE',null,'LAB:1503552','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503552\',' \ Eureka \ Lab Test \ Other \ TOBRAMYCIN (PEAK)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503552');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503553\','TOBRAMYCIN (TROUGH)','N','LAE',null,'LAB:1503553','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503553\',' \ Eureka \ Lab Test \ Other \ TOBRAMYCIN (TROUGH)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503553');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503557\','VANCOMYCIN (TROUGH)','N','LAE',null,'LAB:1503557','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503557\',' \ Eureka \ Lab Test \ Other \ VANCOMYCIN (TROUGH)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503557');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:1503558\','VANCOMYCIN (RANDOM)','N','LAE',null,'LAB:1503558','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:1503558\',' \ Eureka \ Lab Test \ Other \ VANCOMYCIN (RANDOM)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:1503558');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001010\','SEGMENTED NEUTROPHIL CSF 1','N','LAE',null,'LAB:2001010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001010\',' \ Eureka \ Lab Test \ Other \ SEGMENTED NEUTROPHIL CSF 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001011\','BAND CSF TUBE 1','N','LAE',null,'LAB:2001011','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001011\',' \ Eureka \ Lab Test \ Other \ BAND CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001011');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001012\','EOSINOPHIL CSF TUBE 1','N','LAE',null,'LAB:2001012','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001012\',' \ Eureka \ Lab Test \ Other \ EOSINOPHIL CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001012');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001013\','BASOPHIL CSF TUBE 1','N','LAE',null,'LAB:2001013','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001013\',' \ Eureka \ Lab Test \ Other \ BASOPHIL CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001013');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001014\','LYMPHOCYTE CSF TUBE 1','N','LAE',null,'LAB:2001014','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001014\',' \ Eureka \ Lab Test \ Other \ LYMPHOCYTE CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001014');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001015\','MACROPHAGE CSF TUBE 1','N','LAE',null,'LAB:2001015','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001015\',' \ Eureka \ Lab Test \ Other \ MACROPHAGE CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001015');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001016\','OTHER CELLS CSF TUBE 1','N','LAE',null,'LAB:2001016','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001016\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001016');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001017\','OTHER CELLS IDENTIFIED CSF 1','N','LAE',null,'LAB:2001017','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001017\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS IDENTIFIED CSF 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001017');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001018\','# CELLS COUNTED ON DIFF','N','LAE',null,'LAB:2001018','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001018\',' \ Eureka \ Lab Test \ Other \ # CELLS COUNTED ON DIFF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001018');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001020\','BODY FLUID LYMPHOCYTES','N','LAE',null,'LAB:2001020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001020\',' \ Eureka \ Lab Test \ Other \ BODY FLUID LYMPHOCYTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001021\','APPEARANCE CSF TUBE 4','N','LAE',null,'LAB:2001021','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001021\',' \ Eureka \ Lab Test \ Other \ APPEARANCE CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001021');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001022\','XANTHOCHOMIA CSF TUBE 4','N','LAE',null,'LAB:2001022','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001022\',' \ Eureka \ Lab Test \ Other \ XANTHOCHOMIA CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001022');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001026\','NUCLEATED COUNT CSF TUBE 4','N','LAE',null,'LAB:2001026','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001026\',' \ Eureka \ Lab Test \ Other \ NUCLEATED COUNT CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001026');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001030\','RBC COUNT CSF TUBE 4','N','LAE',null,'LAB:2001030','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001030\',' \ Eureka \ Lab Test \ Other \ RBC COUNT CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001030');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001031\','SEGMENTED NEUTROPHIL CSF 4','N','LAE',null,'LAB:2001031','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001031\',' \ Eureka \ Lab Test \ Other \ SEGMENTED NEUTROPHIL CSF 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001031');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001032\','BAND CSF TUBE 4','N','LAE',null,'LAB:2001032','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001032\',' \ Eureka \ Lab Test \ Other \ BAND CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001032');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001033\','EOSINOPHIL CSF TUBE 4','N','LAE',null,'LAB:2001033','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001033\',' \ Eureka \ Lab Test \ Other \ EOSINOPHIL CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001033');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001034\','BASOPHIL CSF TUBE 4','N','LAE',null,'LAB:2001034','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001034\',' \ Eureka \ Lab Test \ Other \ BASOPHIL CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001034');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001035\','LYMPHOCYTE CSF TUBE 4','N','LAE',null,'LAB:2001035','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001035\',' \ Eureka \ Lab Test \ Other \ LYMPHOCYTE CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001035');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001036\','MACAROPHAGE CSF TUBE 4','N','LAE',null,'LAB:2001036','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001036\',' \ Eureka \ Lab Test \ Other \ MACAROPHAGE CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001036');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001037\','OTHER CELLS CSF TUBE 4','N','LAE',null,'LAB:2001037','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001037\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS CSF TUBE 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001037');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001038\','OTHER CELLS IDENTIFIED CSF 4','N','LAE',null,'LAB:2001038','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001038\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS IDENTIFIED CSF 4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001038');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001039\','# CELLS COUNTED ON DIFF','N','LAE',null,'LAB:2001039','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001039\',' \ Eureka \ Lab Test \ Other \ # CELLS COUNTED ON DIFF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001039');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001084\','BODY FLUID PRELIMINARY SEG','N','LAE',null,'LAB:2001084','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001084\',' \ Eureka \ Lab Test \ Other \ BODY FLUID PRELIMINARY SEG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001084');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000842\','RETICULOCYTE PRODUCTION INDEX','N','LAE',null,'LAB:2000842','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000842\',' \ Eureka \ Lab Test \ Other \ RETICULOCYTE PRODUCTION INDEX','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000842');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000940\','CSF TUBE','N','LAE',null,'LAB:2000940','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000940\',' \ Eureka \ Lab Test \ Other \ CSF TUBE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000940');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000952\','CSF XANTHACHROMIA','N','LAE',null,'LAB:2000952','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000952\',' \ Eureka \ Lab Test \ Other \ CSF XANTHACHROMIA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000952');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000954\','TOTAL CELLS COUNTED IN CSF','N','LAE',null,'LAB:2000954','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000954\',' \ Eureka \ Lab Test \ Other \ TOTAL CELLS COUNTED IN CSF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000954');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000955\','CSF SEGMENTED NEUTROPHILS','N','LAE',null,'LAB:2000955','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000955\',' \ Eureka \ Lab Test \ Other \ CSF SEGMENTED NEUTROPHILS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000955');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000956\','CSF LYMPHOCYTES','N','LAE',null,'LAB:2000956','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000956\',' \ Eureka \ Lab Test \ Other \ CSF LYMPHOCYTES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000956');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000957\','CSF MACROPHAGE','N','LAE',null,'LAB:2000957','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000957\',' \ Eureka \ Lab Test \ Other \ CSF MACROPHAGE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000957');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000958\','CSF OTHER','N','LAE',null,'LAB:2000958','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000958\',' \ Eureka \ Lab Test \ Other \ CSF OTHER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000958');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000959\','CSF OTHER CELLS IDENTIFIED','N','LAE',null,'LAB:2000959','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000959\',' \ Eureka \ Lab Test \ Other \ CSF OTHER CELLS IDENTIFIED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000959');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000960\','CSF BAND','N','LAE',null,'LAB:2000960','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000960\',' \ Eureka \ Lab Test \ Other \ CSF BAND','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000960');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000961\','CSF EOSINOPHILS','N','LAE',null,'LAB:2000961','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000961\',' \ Eureka \ Lab Test \ Other \ CSF EOSINOPHILS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000961');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000962\','CSF BASOPHILS','N','LAE',null,'LAB:2000962','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000962\',' \ Eureka \ Lab Test \ Other \ CSF BASOPHILS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000962');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000963\','HEMATOCRIT CSF','N','LAE',null,'LAB:2000963','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000963\',' \ Eureka \ Lab Test \ Other \ HEMATOCRIT CSF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000963');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2000965\','HEMATOCRIT BODY FLUID','N','LAE',null,'LAB:2000965','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2000965\',' \ Eureka \ Lab Test \ Other \ HEMATOCRIT BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2000965');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001000\','APPEARANCE CSF TUBE 1','N','LAE',null,'LAB:2001000','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001000\',' \ Eureka \ Lab Test \ Other \ APPEARANCE CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001000');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001001\','XANTHOCHROMIA CSF TUBE 1','N','LAE',null,'LAB:2001001','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001001\',' \ Eureka \ Lab Test \ Other \ XANTHOCHROMIA CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001001');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001005\','NUCLEATED COUNT CSF TUBE 1','N','LAE',null,'LAB:2001005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001005\',' \ Eureka \ Lab Test \ Other \ NUCLEATED COUNT CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001009\','RBC COUNT CSF TUBE 1','N','LAE',null,'LAB:2001009','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001009\',' \ Eureka \ Lab Test \ Other \ RBC COUNT CSF TUBE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001009');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001098\','BF OTHER CELLS IDENTIFIED','N','LAE',null,'LAB:2001098','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001098\',' \ Eureka \ Lab Test \ Other \ BF OTHER CELLS IDENTIFIED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001098');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001099\','BODY FLUID MACROPHAGE','N','LAE',null,'LAB:2001099','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001099\',' \ Eureka \ Lab Test \ Other \ BODY FLUID MACROPHAGE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001099');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001100\','APPEARANCE CSF TUBE 2','N','LAE',null,'LAB:2001100','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001100\',' \ Eureka \ Lab Test \ Other \ APPEARANCE CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001100');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001101\','XANTHOCHROMIA CSF TUBE 2','N','LAE',null,'LAB:2001101','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001101\',' \ Eureka \ Lab Test \ Other \ XANTHOCHROMIA CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001101');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001105\','NUCLEATED COUNT CSF TUBE 2','N','LAE',null,'LAB:2001105','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001105\',' \ Eureka \ Lab Test \ Other \ NUCLEATED COUNT CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001105');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001109\','RBC COUNT CSF TUBE 2','N','LAE',null,'LAB:2001109','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001109\',' \ Eureka \ Lab Test \ Other \ RBC COUNT CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001109');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001130\','RBC COUNT CSF TUBE 3','N','LAE',null,'LAB:2001130','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001130\',' \ Eureka \ Lab Test \ Other \ RBC COUNT CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001130');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001131\','SEGMENTED NEUTROPHIL CSF 3','N','LAE',null,'LAB:2001131','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001131\',' \ Eureka \ Lab Test \ Other \ SEGMENTED NEUTROPHIL CSF 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001131');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001132\','BAND CSF TUBE 3','N','LAE',null,'LAB:2001132','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001132\',' \ Eureka \ Lab Test \ Other \ BAND CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001132');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001133\','EOSINOPHIL CSF TUBE 3','N','LAE',null,'LAB:2001133','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001133\',' \ Eureka \ Lab Test \ Other \ EOSINOPHIL CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001133');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001134\','BASOPHIL CSF TUBE 3','N','LAE',null,'LAB:2001134','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001134\',' \ Eureka \ Lab Test \ Other \ BASOPHIL CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001134');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001135\','LYMPHOCYT CSF TUBE 3','N','LAE',null,'LAB:2001135','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001135\',' \ Eureka \ Lab Test \ Other \ LYMPHOCYT CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001135');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001136\','MACROPHAGE CSF TUBE 3','N','LAE',null,'LAB:2001136','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001136\',' \ Eureka \ Lab Test \ Other \ MACROPHAGE CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001136');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001137\','OTHER CELLS CSF TUBE 3','N','LAE',null,'LAB:2001137','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001137\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001137');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001138\','OTHER CELLS IDENTIFIED CSF 3','N','LAE',null,'LAB:2001138','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001138\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS IDENTIFIED CSF 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001138');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001139\','# CELLS COUNTED ON DIFF','N','LAE',null,'LAB:2001139','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001139\',' \ Eureka \ Lab Test \ Other \ # CELLS COUNTED ON DIFF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001139');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001150\','APPEARANCE CSF SHUNT','N','LAE',null,'LAB:2001150','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001150\',' \ Eureka \ Lab Test \ Other \ APPEARANCE CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001150');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001151\','XANTHOCHROMIA CSF SHUNT','N','LAE',null,'LAB:2001151','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001151\',' \ Eureka \ Lab Test \ Other \ XANTHOCHROMIA CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001151');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001155\','NUCLEATED COUNT CSF SHUNT','N','LAE',null,'LAB:2001155','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001155\',' \ Eureka \ Lab Test \ Other \ NUCLEATED COUNT CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001155');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001156\','SEGMENTED NEUTROPHIL CSF SHUNT','N','LAE',null,'LAB:2001156','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001156\',' \ Eureka \ Lab Test \ Other \ SEGMENTED NEUTROPHIL CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001156');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001157\','BAND CSF SHUNT','N','LAE',null,'LAB:2001157','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001157\',' \ Eureka \ Lab Test \ Other \ BAND CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001157');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001158\','EOSINOPHIL CSF SHUNT','N','LAE',null,'LAB:2001158','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001158\',' \ Eureka \ Lab Test \ Other \ EOSINOPHIL CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001158');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001159\','BASOPHIL CSF SHUNT','N','LAE',null,'LAB:2001159','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001159\',' \ Eureka \ Lab Test \ Other \ BASOPHIL CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001159');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001160\','LYMPHOCYTE CSF SHUNT','N','LAE',null,'LAB:2001160','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001160\',' \ Eureka \ Lab Test \ Other \ LYMPHOCYTE CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001160');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001161\','MACROPHAGE CSF SHUNT','N','LAE',null,'LAB:2001161','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001161\',' \ Eureka \ Lab Test \ Other \ MACROPHAGE CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001161');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001162\','OTHER CELLS CSF SHUNT','N','LAE',null,'LAB:2001162','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001162\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS CSF SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001162');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001163\','OTHER CELLS IDENTIFIED SHUNT','N','LAE',null,'LAB:2001163','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001163\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS IDENTIFIED SHUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001163');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001164\','# CELLS COUNTED ON DIFF','N','LAE',null,'LAB:2001164','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001164\',' \ Eureka \ Lab Test \ Other \ # CELLS COUNTED ON DIFF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001164');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2121016\','ATYPICAL ANCA RESULT','N','LAE',null,'LAB:2121016','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2121016\',' \ Eureka \ Lab Test \ Other \ ATYPICAL ANCA RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2121016');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500131\','FETAL FIBRONECTIN','N','LAE',null,'LAB:2500131','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500131\',' \ Eureka \ Lab Test \ Other \ FETAL FIBRONECTIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500131');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001110\','SEGMENTED NEUTROPHILS CSF 2','N','LAE',null,'LAB:2001110','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001110\',' \ Eureka \ Lab Test \ Other \ SEGMENTED NEUTROPHILS CSF 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001110');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001111\','BAND CSF TUBE 2','N','LAE',null,'LAB:2001111','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001111\',' \ Eureka \ Lab Test \ Other \ BAND CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001111');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001112\','EOSINOPHIL CSF TUBE 2','N','LAE',null,'LAB:2001112','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001112\',' \ Eureka \ Lab Test \ Other \ EOSINOPHIL CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001112');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001113\','BASOPHIL CSF TUBE 2','N','LAE',null,'LAB:2001113','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001113\',' \ Eureka \ Lab Test \ Other \ BASOPHIL CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001113');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001114\','LYMPHOCYTE CSF TUBE 2','N','LAE',null,'LAB:2001114','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001114\',' \ Eureka \ Lab Test \ Other \ LYMPHOCYTE CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001114');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001115\','MACROPHAGE CSF TUBE 2','N','LAE',null,'LAB:2001115','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001115\',' \ Eureka \ Lab Test \ Other \ MACROPHAGE CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001115');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001116\','OTHER CELLS CSF TUBE 2','N','LAE',null,'LAB:2001116','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001116\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS CSF TUBE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001116');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001117\','OTHER CELLS IDENTIFIED CSF 2','N','LAE',null,'LAB:2001117','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001117\',' \ Eureka \ Lab Test \ Other \ OTHER CELLS IDENTIFIED CSF 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001117');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001118\','# CELLS COUNTED ON DIFF','N','LAE',null,'LAB:2001118','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001118\',' \ Eureka \ Lab Test \ Other \ # CELLS COUNTED ON DIFF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001118');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001121\','APPEARANCE CSF TUBE 3','N','LAE',null,'LAB:2001121','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001121\',' \ Eureka \ Lab Test \ Other \ APPEARANCE CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001121');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001122\','XANTHOCHROMIA CSF TUBE 3','N','LAE',null,'LAB:2001122','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001122\',' \ Eureka \ Lab Test \ Other \ XANTHOCHROMIA CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001122');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001126\','NUCLEATED COUNT CSF TUBE 3','N','LAE',null,'LAB:2001126','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001126\',' \ Eureka \ Lab Test \ Other \ NUCLEATED COUNT CSF TUBE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001126');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001086\','BODY FLUID BAND','N','LAE',null,'LAB:2001086','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001086\',' \ Eureka \ Lab Test \ Other \ BODY FLUID BAND','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001086');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001087\','BODY FLUID EOSINOPHILS','N','LAE',null,'LAB:2001087','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001087\',' \ Eureka \ Lab Test \ Other \ BODY FLUID EOSINOPHILS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001087');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001088\','BODY FLUID BASOPHILS','N','LAE',null,'LAB:2001088','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001088\',' \ Eureka \ Lab Test \ Other \ BODY FLUID BASOPHILS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001088');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001095\','TOTAL CELLS COUNTED IN BF','N','LAE',null,'LAB:2001095','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001095\',' \ Eureka \ Lab Test \ Other \ TOTAL CELLS COUNTED IN BF','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001095');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001096\','BODY FLUID MESOTHELIAL','N','LAE',null,'LAB:2001096','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001096\',' \ Eureka \ Lab Test \ Other \ BODY FLUID MESOTHELIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001096');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2001097\','BODY FLUID OTHER','N','LAE',null,'LAB:2001097','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2001097\',' \ Eureka \ Lab Test \ Other \ BODY FLUID OTHER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2001097');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000141\','NORMAL+PATIENT MIX IMMEDIATE','N','LAE',null,'LAB:3000141','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000141\',' \ Eureka \ Lab Test \ Other \ NORMAL+PATIENT MIX IMMEDIATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000141');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000150\','NORMAL INCUBATED','N','LAE',null,'LAB:3000150','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000150\',' \ Eureka \ Lab Test \ Other \ NORMAL INCUBATED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000150');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000151\','NORMAL INCUBATED','N','LAE',null,'LAB:3000151','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000151\',' \ Eureka \ Lab Test \ Other \ NORMAL INCUBATED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000151');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000160\','PATIENT INCUBATED','N','LAE',null,'LAB:3000160','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000160\',' \ Eureka \ Lab Test \ Other \ PATIENT INCUBATED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000160');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000161\','PATIENT INCUBATED','N','LAE',null,'LAB:3000161','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000161\',' \ Eureka \ Lab Test \ Other \ PATIENT INCUBATED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000161');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000170\','CONTROL+PATIENT INCUBATED','N','LAE',null,'LAB:3000170','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000170\',' \ Eureka \ Lab Test \ Other \ CONTROL+PATIENT INCUBATED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000170');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000171\','NORMAL+PATIENT MIX INCUBATED','N','LAE',null,'LAB:3000171','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000171\',' \ Eureka \ Lab Test \ Other \ NORMAL+PATIENT MIX INCUBATED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000171');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000200\','FACTOR II','N','LAE',null,'LAB:3000200','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000200\',' \ Eureka \ Lab Test \ Other \ FACTOR II','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000200');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000210\','FACTOR VIII','N','LAE',null,'LAB:3000210','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000210\',' \ Eureka \ Lab Test \ Other \ FACTOR VIII','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000210');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000211\','CHROMOGENIC FACTOR VIII','N','LAE',null,'LAB:3000211','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000211\',' \ Eureka \ Lab Test \ Other \ CHROMOGENIC FACTOR VIII','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000211');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000220\','FACTOR IX','N','LAE',null,'LAB:3000220','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000220\',' \ Eureka \ Lab Test \ Other \ FACTOR IX','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000220');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000230\','FACTOR V','N','LAE',null,'LAB:3000230','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000230\',' \ Eureka \ Lab Test \ Other \ FACTOR V','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000230');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000240\','FACTOR X','N','LAE',null,'LAB:3000240','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000240\',' \ Eureka \ Lab Test \ Other \ FACTOR X','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000240');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000241\','CHROMOGENIC FACTOR X','N','LAE',null,'LAB:3000241','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000241\',' \ Eureka \ Lab Test \ Other \ CHROMOGENIC FACTOR X','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000241');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000260\','FACTOR XI','N','LAE',null,'LAB:3000260','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000260\',' \ Eureka \ Lab Test \ Other \ FACTOR XI','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000260');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000270\','FACTOR XII','N','LAE',null,'LAB:3000270','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000270\',' \ Eureka \ Lab Test \ Other \ FACTOR XII','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000270');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000280\','FACTOR XIII','N','LAE',null,'LAB:3000280','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000280\',' \ Eureka \ Lab Test \ Other \ FACTOR XIII','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000280');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000290\','FIBRIN SPLIT PRODUCT (FSP)','N','LAE',null,'LAB:3000290','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000290\',' \ Eureka \ Lab Test \ Other \ FIBRIN SPLIT PRODUCT (FSP)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000290');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000350\','FIBRIN MONOMER','N','LAE',null,'LAB:3000350','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000350\',' \ Eureka \ Lab Test \ Other \ FIBRIN MONOMER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000350');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000380\','DIMER','N','LAE',null,'LAB:3000380','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000380\',' \ Eureka \ Lab Test \ Other \ DIMER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000380');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000412\','PTT LUPUS ANTICOAGULANT','N','LAE',null,'LAB:3000412','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000412\',' \ Eureka \ Lab Test \ Other \ PTT LUPUS ANTICOAGULANT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000412');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000470\','PLASMINOGEN ASSAY','N','LAE',null,'LAB:3000470','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000470\',' \ Eureka \ Lab Test \ Other \ PLASMINOGEN ASSAY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000470');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000540\','EUGLOBULIN LYSIS TIME','N','LAE',null,'LAB:3000540','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000540\',' \ Eureka \ Lab Test \ Other \ EUGLOBULIN LYSIS TIME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000540');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000570\','THROMBIN CTRL','N','LAE',null,'LAB:3000570','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000570\',' \ Eureka \ Lab Test \ Other \ THROMBIN CTRL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000570');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500132\','HIV RAPID','N','LAE',null,'LAB:2500132','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500132\',' \ Eureka \ Lab Test \ Other \ HIV RAPID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500132');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500250\','FETAL RED CELL DISTRIB WIDTH','N','LAE',null,'LAB:2500250','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500250\',' \ Eureka \ Lab Test \ Other \ FETAL RED CELL DISTRIB WIDTH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500250');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500310\','FETAL HEMOGLOBIN','N','LAE',null,'LAB:2500310','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500310\',' \ Eureka \ Lab Test \ Other \ FETAL HEMOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500310');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500320\','FETAL HEMATOCRIT','N','LAE',null,'LAB:2500320','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500320\',' \ Eureka \ Lab Test \ Other \ FETAL HEMATOCRIT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500320');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500330\','FETAL WHITE BLOOD COUNT','N','LAE',null,'LAB:2500330','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500330\',' \ Eureka \ Lab Test \ Other \ FETAL WHITE BLOOD COUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500330');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500340\','FETAL RED BLOOD CELL COUNT','N','LAE',null,'LAB:2500340','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500340\',' \ Eureka \ Lab Test \ Other \ FETAL RED BLOOD CELL COUNT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500340');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500420\','FETAL MEAN CORPUSULAR HGB','N','LAE',null,'LAB:2500420','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500420\',' \ Eureka \ Lab Test \ Other \ FETAL MEAN CORPUSULAR HGB','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500420');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500440\','FETAL MEAN CORPUSCULAR HGB CON','N','LAE',null,'LAB:2500440','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500440\',' \ Eureka \ Lab Test \ Other \ FETAL MEAN CORPUSCULAR HGB CON','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500440');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500600\','FETAL MEAN CORPUSULAR VOLUME','N','LAE',null,'LAB:2500600','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500600\',' \ Eureka \ Lab Test \ Other \ FETAL MEAN CORPUSULAR VOLUME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500600');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500643\','FETAL MEAN PLATELETE VOLUME','N','LAE',null,'LAB:2500643','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500643\',' \ Eureka \ Lab Test \ Other \ FETAL MEAN PLATELETE VOLUME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500643');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2500920\','FETAL PLATLET CT','N','LAE',null,'LAB:2500920','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2500920\',' \ Eureka \ Lab Test \ Other \ FETAL PLATLET CT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2500920');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:2501005\','FETAL CELL COUNT           CLH','N','LAE',null,'LAB:2501005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:2501005\',' \ Eureka \ Lab Test \ Other \ FETAL CELL COUNT           CLH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:2501005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000094\','PROTIME INR','N','LAE',null,'LAB:3000094','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000094\',' \ Eureka \ Lab Test \ Other \ PROTIME INR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000094');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000120\','NORMAL','N','LAE',null,'LAB:3000120','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000120\',' \ Eureka \ Lab Test \ Other \ NORMAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000120');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000121\','NORMAL IMMEDIATE','N','LAE',null,'LAB:3000121','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000121\',' \ Eureka \ Lab Test \ Other \ NORMAL IMMEDIATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000121');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000130\','PATIENT IMMEDIATE','N','LAE',null,'LAB:3000130','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000130\',' \ Eureka \ Lab Test \ Other \ PATIENT IMMEDIATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000130');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000131\','PATIENT IMMEDIATE','N','LAE',null,'LAB:3000131','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000131\',' \ Eureka \ Lab Test \ Other \ PATIENT IMMEDIATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000131');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000140\','CONTROL+PATIENT IMMEDIATE','N','LAE',null,'LAB:3000140','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000140\',' \ Eureka \ Lab Test \ Other \ CONTROL+PATIENT IMMEDIATE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000140');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000678\','IIb/IIIa PLATELET AB SCRN RES','N','LAE',null,'LAB:3000678','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000678\',' \ Eureka \ Lab Test \ Other \ IIb/IIIa PLATELET AB SCRN RES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000678');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000685\','Ib/IX PLATELET AB SCRN RESULT','N','LAE',null,'LAB:3000685','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000685\',' \ Eureka \ Lab Test \ Other \ Ib/IX PLATELET AB SCRN RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000685');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000686\','Ia/IIa PLATELET AB SCRN RESULT','N','LAE',null,'LAB:3000686','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000686\',' \ Eureka \ Lab Test \ Other \ Ia/IIa PLATELET AB SCRN RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000686');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000687\','IV PLATELET AB SCREEN RESULT','N','LAE',null,'LAB:3000687','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000687\',' \ Eureka \ Lab Test \ Other \ IV PLATELET AB SCREEN RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000687');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000688\','PLATELET ANTIBODY SCRN INTER','N','LAE',null,'LAB:3000688','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000688\',' \ Eureka \ Lab Test \ Other \ PLATELET ANTIBODY SCRN INTER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000688');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000711\','PLATELET NEUTRALIZATION','N','LAE',null,'LAB:3000711','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000711\',' \ Eureka \ Lab Test \ Other \ PLATELET NEUTRALIZATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000711');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3500013\','ARACHIDONIC ACID','N','LAE',null,'LAB:3500013','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3500013\',' \ Eureka \ Lab Test \ Other \ ARACHIDONIC ACID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3500013');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3500102\','PATHOLOGY REVIEW/DIC','N','LAE',null,'LAB:3500102','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3500102\',' \ Eureka \ Lab Test \ Other \ PATHOLOGY REVIEW/DIC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3500102');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700005\','THROMBOSIS INTERP','N','LAE',null,'LAB:3700005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700005\',' \ Eureka \ Lab Test \ Other \ THROMBOSIS INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700010\','PROTEIN C ANTIGEN','N','LAE',null,'LAB:3700010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700010\',' \ Eureka \ Lab Test \ Other \ PROTEIN C ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700011\','STRONG RISTOCETIN','N','LAE',null,'LAB:3700011','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700011\',' \ Eureka \ Lab Test \ Other \ STRONG RISTOCETIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700011');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700012\','STRONG ADP','N','LAE',null,'LAB:3700012','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700012\',' \ Eureka \ Lab Test \ Other \ STRONG ADP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700012');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700013\','MODERATE ADP','N','LAE',null,'LAB:3700013','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700013\',' \ Eureka \ Lab Test \ Other \ MODERATE ADP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700013');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700015\','WEAK ADP','N','LAE',null,'LAB:3700015','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700015\',' \ Eureka \ Lab Test \ Other \ WEAK ADP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700015');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700016\','MODERATE RISTOCETIN','N','LAE',null,'LAB:3700016','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700016\',' \ Eureka \ Lab Test \ Other \ MODERATE RISTOCETIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700016');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700017\','WEAK RISTOCETIN','N','LAE',null,'LAB:3700017','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700017\',' \ Eureka \ Lab Test \ Other \ WEAK RISTOCETIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700017');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700018\','EPINEPHRINE','N','LAE',null,'LAB:3700018','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700018\',' \ Eureka \ Lab Test \ Other \ EPINEPHRINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700018');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700019\','PLATELET AGGREGATION INTERP','N','LAE',null,'LAB:3700019','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700019\',' \ Eureka \ Lab Test \ Other \ PLATELET AGGREGATION INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700019');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700020\','HIT INTERPRETATION','N','LAE',null,'LAB:3700020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700020\',' \ Eureka \ Lab Test \ Other \ HIT INTERPRETATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700021\','APC RESISTANCE INTERPRETATION','N','LAE',null,'LAB:3700021','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700021\',' \ Eureka \ Lab Test \ Other \ APC RESISTANCE INTERPRETATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700021');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700023\','FONDAPARINUX (ARIXTRA) ASSAY','N','LAE',null,'LAB:3700023','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700023\',' \ Eureka \ Lab Test \ Other \ FONDAPARINUX (ARIXTRA) ASSAY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700023');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700024\','FACTOR XIII QUANTITATIVE','N','LAE',null,'LAB:3700024','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700024\',' \ Eureka \ Lab Test \ Other \ FACTOR XIII QUANTITATIVE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700024');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700026\','HIT OD RESULT','N','LAE',null,'LAB:3700026','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700026\',' \ Eureka \ Lab Test \ Other \ HIT OD RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700026');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700031\','ANTI ANNEXIN V IGG','N','LAE',null,'LAB:3700031','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700031\',' \ Eureka \ Lab Test \ Other \ ANTI ANNEXIN V IGG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700031');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700032\','ANTI ANNEXIN V IGM','N','LAE',null,'LAB:3700032','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700032\',' \ Eureka \ Lab Test \ Other \ ANTI ANNEXIN V IGM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700032');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700034\','ANTIPHOSPHATIDYLSERINE IGG','N','LAE',null,'LAB:3700034','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700034\',' \ Eureka \ Lab Test \ Other \ ANTIPHOSPHATIDYLSERINE IGG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700034');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700035\','ANTIPHOSPHATIDYLSERINE IGM','N','LAE',null,'LAB:3700035','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700035\',' \ Eureka \ Lab Test \ Other \ ANTIPHOSPHATIDYLSERINE IGM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700035');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700038\','APS EXTENDED PROFILE INTERP','N','LAE',null,'LAB:3700038','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700038\',' \ Eureka \ Lab Test \ Other \ APS EXTENDED PROFILE INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700038');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700080\','ANTITHROMBIN ANTIGEN','N','LAE',null,'LAB:3700080','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700080\',' \ Eureka \ Lab Test \ Other \ ANTITHROMBIN ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700080');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3700114\','PLATELET RICH PLASMA PLAT CT','N','LAE',null,'LAB:3700114','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3700114\',' \ Eureka \ Lab Test \ Other \ PLATELET RICH PLASMA PLAT CT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3700114');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000718\','DRVVT CONFIRM PATIENT','N','LAE',null,'LAB:3000718','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000718\',' \ Eureka \ Lab Test \ Other \ DRVVT CONFIRM PATIENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000718');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000719\','DRVVT RATIO','N','LAE',null,'LAB:3000719','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000719\',' \ Eureka \ Lab Test \ Other \ DRVVT RATIO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000719');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000720\','DILUTE RUSS VIP VENOM TIME','N','LAE',null,'LAB:3000720','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000720\',' \ Eureka \ Lab Test \ Other \ DILUTE RUSS VIP VENOM TIME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000720');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000722\','DRVVT CONTROL','N','LAE',null,'LAB:3000722','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000722\',' \ Eureka \ Lab Test \ Other \ DRVVT CONTROL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000722');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000725\','DRVVT PATIENT','N','LAE',null,'LAB:3000725','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000725\',' \ Eureka \ Lab Test \ Other \ DRVVT PATIENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000725');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000735\','ANTICARDIOLIPIN IGG','N','LAE',null,'LAB:3000735','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000735\',' \ Eureka \ Lab Test \ Other \ ANTICARDIOLIPIN IGG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000735');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000736\','ANTICARDIOLIPIN IGM','N','LAE',null,'LAB:3000736','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000736\',' \ Eureka \ Lab Test \ Other \ ANTICARDIOLIPIN IGM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000736');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000740\','LUPUS INTERPRETATION','N','LAE',null,'LAB:3000740','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000740\',' \ Eureka \ Lab Test \ Other \ LUPUS INTERPRETATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000740');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000927\','PLATELET FUNCTION ASSAY-ADP','N','LAE',null,'LAB:3000927','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000927\',' \ Eureka \ Lab Test \ Other \ PLATELET FUNCTION ASSAY-ADP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000927');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3001001\','ANTI BETA2 GLYCOPROTEIN1-IGG','N','LAE',null,'LAB:3001001','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3001001\',' \ Eureka \ Lab Test \ Other \ ANTI BETA2 GLYCOPROTEIN1-IGG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3001001');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3001002\','ANTI BETA2 GLYCOPROTEIN1-IGM','N','LAE',null,'LAB:3001002','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3001002\',' \ Eureka \ Lab Test \ Other \ ANTI BETA2 GLYCOPROTEIN1-IGM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3001002');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3500010\','COLLAGEN','N','LAE',null,'LAB:3500010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3500010\',' \ Eureka \ Lab Test \ Other \ COLLAGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3500010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000580\','REPTILASE CTRL','N','LAE',null,'LAB:3000580','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000580\',' \ Eureka \ Lab Test \ Other \ REPTILASE CTRL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000580');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000610\','RISTOCETIN COFACTOR','N','LAE',null,'LAB:3000610','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000610\',' \ Eureka \ Lab Test \ Other \ RISTOCETIN COFACTOR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000610');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000620\','VON WILLEBRAND FACTOR AG','N','LAE',null,'LAB:3000620','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000620\',' \ Eureka \ Lab Test \ Other \ VON WILLEBRAND FACTOR AG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000620');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000630\','VON WILLEBRAND INTERP','N','LAE',null,'LAB:3000630','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000630\',' \ Eureka \ Lab Test \ Other \ VON WILLEBRAND INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000630');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000675\','PROTHROMBIN FRAGMENT 1.2','N','LAE',null,'LAB:3000675','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000675\',' \ Eureka \ Lab Test \ Other \ PROTHROMBIN FRAGMENT 1.2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000675');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:3000677\','HLA PLATELET AB SCRN RESULTS','N','LAE',null,'LAB:3000677','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:3000677\',' \ Eureka \ Lab Test \ Other \ HLA PLATELET AB SCRN RESULTS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:3000677');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005035\','IP GASTRIN','N','LAE',null,'LAB:8005035','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005035\',' \ Eureka \ Lab Test \ Other \ IP GASTRIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005035');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005037\','IP GLUCAGON','N','LAE',null,'LAB:8005037','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005037\',' \ Eureka \ Lab Test \ Other \ IP GLUCAGON','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005037');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005040\','IP GLIAL FIBRILLARY ACIDC PROT','N','LAE',null,'LAB:8005040','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005040\',' \ Eureka \ Lab Test \ Other \ IP GLIAL FIBRILLARY ACIDC PROT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005040');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005042\','IP GROSS CYSTIC DIS FLD PROT','N','LAE',null,'LAB:8005042','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005042\',' \ Eureka \ Lab Test \ Other \ IP GROSS CYSTIC DIS FLD PROT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005042');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005045\','IP HEPATITIS B CORE ANTIGEN','N','LAE',null,'LAB:8005045','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005045\',' \ Eureka \ Lab Test \ Other \ IP HEPATITIS B CORE ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005045');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005050\','IP HEPATITIS B SURFACE ANTIGEN','N','LAE',null,'LAB:8005050','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005050\',' \ Eureka \ Lab Test \ Other \ IP HEPATITIS B SURFACE ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005050');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007040\','SP GROSS DESCRIPTION','N','LAE',null,'LAB:8007040','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007040\',' \ Eureka \ Lab Test \ Other \ SP GROSS DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007040');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007045\','SP CASSETTE SUMMARY','N','LAE',null,'LAB:8007045','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007045\',' \ Eureka \ Lab Test \ Other \ SP CASSETTE SUMMARY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007045');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007050\','SP MICROSCOPIC DESCRIPTION','N','LAE',null,'LAB:8007050','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007050\',' \ Eureka \ Lab Test \ Other \ SP MICROSCOPIC DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007050');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007060\','SP DIAGNOSIS','N','LAE',null,'LAB:8007060','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007060\',' \ Eureka \ Lab Test \ Other \ SP DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007060');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007070\','SP PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007070','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007070\',' \ Eureka \ Lab Test \ Other \ SP PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007070');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007075\','SP ADDITIONAL STUDIES','N','LAE',null,'LAB:8007075','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007075\',' \ Eureka \ Lab Test \ Other \ SP ADDITIONAL STUDIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007075');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007211\','AU PAD RESIDENT','N','LAE',null,'LAB:8007211','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007211\',' \ Eureka \ Lab Test \ Other \ AU PAD RESIDENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007211');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007212\','AU PAD PATHOLOGY ASSISTANT','N','LAE',null,'LAB:8007212','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007212\',' \ Eureka \ Lab Test \ Other \ AU PAD PATHOLOGY ASSISTANT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007212');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007220\','AU PRELIM ANATOMICAL DIAGNOSES','N','LAE',null,'LAB:8007220','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007220\',' \ Eureka \ Lab Test \ Other \ AU PRELIM ANATOMICAL DIAGNOSES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007220');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007230\','AU PRELIMINARY COMMENT','N','LAE',null,'LAB:8007230','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007230\',' \ Eureka \ Lab Test \ Other \ AU PRELIMINARY COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007230');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007240\','AU CLINICAL HISTORY','N','LAE',null,'LAB:8007240','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007240\',' \ Eureka \ Lab Test \ Other \ AU CLINICAL HISTORY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007240');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007250\','AU GROSS DESCRIPTION','N','LAE',null,'LAB:8007250','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007250\',' \ Eureka \ Lab Test \ Other \ AU GROSS DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007250');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007450\','DP GROSS DESCRIPTION','N','LAE',null,'LAB:8007450','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007450\',' \ Eureka \ Lab Test \ Other \ DP GROSS DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007450');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007455\','DP CASSETTE SUMMARY','N','LAE',null,'LAB:8007455','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007455\',' \ Eureka \ Lab Test \ Other \ DP CASSETTE SUMMARY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007455');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007460\','DP INTRAOPERATIVE CONSULTATION','N','LAE',null,'LAB:8007460','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007460\',' \ Eureka \ Lab Test \ Other \ DP INTRAOPERATIVE CONSULTATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007460');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007465\','DP MICROSCOPIC DESCRIPTION','N','LAE',null,'LAB:8007465','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007465\',' \ Eureka \ Lab Test \ Other \ DP MICROSCOPIC DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007465');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007470\','DP DIAGNOSIS','N','LAE',null,'LAB:8007470','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007470\',' \ Eureka \ Lab Test \ Other \ DP DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007470');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007475\','DP PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007475','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007475\',' \ Eureka \ Lab Test \ Other \ DP PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007475');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007480\','DP ICD-9 CODES','N','LAE',null,'LAB:8007480','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007480\',' \ Eureka \ Lab Test \ Other \ DP ICD-9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007480');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007485\','DP ADDITIONAL STUDIES','N','LAE',null,'LAB:8007485','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007485\',' \ Eureka \ Lab Test \ Other \ DP ADDITIONAL STUDIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007485');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007495\','DP QM CODES AND STAINS','N','LAE',null,'LAB:8007495','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007495\',' \ Eureka \ Lab Test \ Other \ DP QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007495');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007600\','AP 3RD AMENDED DISCUSSION','N','LAE',null,'LAB:8007600','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007600\',' \ Eureka \ Lab Test \ Other \ AP 3RD AMENDED DISCUSSION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007600');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007610\','AP 2ND AMENDED DISCUSSION','N','LAE',null,'LAB:8007610','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007610\',' \ Eureka \ Lab Test \ Other \ AP 2ND AMENDED DISCUSSION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007610');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007620\','AP 1ST AMENDED DISCUSSION','N','LAE',null,'LAB:8007620','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007620\',' \ Eureka \ Lab Test \ Other \ AP 1ST AMENDED DISCUSSION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007620');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007630\','SC TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007630','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007630\',' \ Eureka \ Lab Test \ Other \ SC TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007630');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007635\','SC CLINICAL INFORMATION','N','LAE',null,'LAB:8007635','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007635\',' \ Eureka \ Lab Test \ Other \ SC CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007635');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007650\','SC ITEMS RECEIVED','N','LAE',null,'LAB:8007650','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007650\',' \ Eureka \ Lab Test \ Other \ SC ITEMS RECEIVED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007650');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007655\','SC MICROSCOPIC DESCRIPTION','N','LAE',null,'LAB:8007655','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007655\',' \ Eureka \ Lab Test \ Other \ SC MICROSCOPIC DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007655');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007660\','SC DIAGNOSIS','N','LAE',null,'LAB:8007660','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007660\',' \ Eureka \ Lab Test \ Other \ SC DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007660');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007665\','SC PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007665','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007665\',' \ Eureka \ Lab Test \ Other \ SC PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007665');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007675\','SC ADDITIONAL STUDIES','N','LAE',null,'LAB:8007675','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007675\',' \ Eureka \ Lab Test \ Other \ SC ADDITIONAL STUDIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007675');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007680\','SC INTRADEPARTMENTAL CONSULT','N','LAE',null,'LAB:8007680','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007680\',' \ Eureka \ Lab Test \ Other \ SC INTRADEPARTMENTAL CONSULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007680');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007691\','SC TISSUE COMMITTE CODE','N','LAE',null,'LAB:8007691','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007691\',' \ Eureka \ Lab Test \ Other \ SC TISSUE COMMITTE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007691');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007692\','SC RESIDENT/FELLOW ID','N','LAE',null,'LAB:8007692','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007692\',' \ Eureka \ Lab Test \ Other \ SC RESIDENT/FELLOW ID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007692');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007693\','SC ICD 9 CODES','N','LAE',null,'LAB:8007693','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007693\',' \ Eureka \ Lab Test \ Other \ SC ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007693');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007694\','SC QM CODES AND STAINS','N','LAE',null,'LAB:8007694','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007694\',' \ Eureka \ Lab Test \ Other \ SC QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007694');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007695\','DC TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007695','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007695\',' \ Eureka \ Lab Test \ Other \ DC TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007695');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007698\','DC CLINICAL INFORMATION','N','LAE',null,'LAB:8007698','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007698\',' \ Eureka \ Lab Test \ Other \ DC CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007698');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007715\','DC ITEMS RECEIVED','N','LAE',null,'LAB:8007715','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007715\',' \ Eureka \ Lab Test \ Other \ DC ITEMS RECEIVED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007715');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007720\','DC MICROSCOPIC DESCRIPTION','N','LAE',null,'LAB:8007720','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007720\',' \ Eureka \ Lab Test \ Other \ DC MICROSCOPIC DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007720');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007725\','DC DIAGNOSIS','N','LAE',null,'LAB:8007725','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007725\',' \ Eureka \ Lab Test \ Other \ DC DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007725');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007730\','DC PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007730','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007730\',' \ Eureka \ Lab Test \ Other \ DC PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007730');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007740\','DC ADDITIONAL STUDIES','N','LAE',null,'LAB:8007740','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007740\',' \ Eureka \ Lab Test \ Other \ DC ADDITIONAL STUDIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007740');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007745\','DC INTRADEPARTMENTAL CONSULT','N','LAE',null,'LAB:8007745','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007745\',' \ Eureka \ Lab Test \ Other \ DC INTRADEPARTMENTAL CONSULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007745');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007746\','DCR TISSUE COMMITTEE CODE','N','LAE',null,'LAB:8007746','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007746\',' \ Eureka \ Lab Test \ Other \ DCR TISSUE COMMITTEE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007746');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007747\','DC RESIDENT/FELLOW ID','N','LAE',null,'LAB:8007747','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007747\',' \ Eureka \ Lab Test \ Other \ DC RESIDENT/FELLOW ID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007747');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007748\','DC ICD 9 CODES','N','LAE',null,'LAB:8007748','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007748\',' \ Eureka \ Lab Test \ Other \ DC ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007748');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007750\','DC QM CODES AND STAINS','N','LAE',null,'LAB:8007750','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007750\',' \ Eureka \ Lab Test \ Other \ DC QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007750');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007850\','NP TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007850','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007850\',' \ Eureka \ Lab Test \ Other \ NP TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007850');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007851\','NP CLINICAL INFORMATION','N','LAE',null,'LAB:8007851','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007851\',' \ Eureka \ Lab Test \ Other \ NP CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007851');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007852\','NP GROSS DESCRIPTION','N','LAE',null,'LAB:8007852','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007852\',' \ Eureka \ Lab Test \ Other \ NP GROSS DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007852');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007853\','NP LIGHT MICROSCOPY','N','LAE',null,'LAB:8007853','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007853\',' \ Eureka \ Lab Test \ Other \ NP LIGHT MICROSCOPY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007853');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007854\','NP IMMUNOFLUORESCENCE','N','LAE',null,'LAB:8007854','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007854\',' \ Eureka \ Lab Test \ Other \ NP IMMUNOFLUORESCENCE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007854');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007855\','NP ELECTRON MICROSCOPY','N','LAE',null,'LAB:8007855','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007855\',' \ Eureka \ Lab Test \ Other \ NP ELECTRON MICROSCOPY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007855');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007856\','NP DIAGNOSIS','N','LAE',null,'LAB:8007856','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007856\',' \ Eureka \ Lab Test \ Other \ NP DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007856');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007857\','NP PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007857','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007857\',' \ Eureka \ Lab Test \ Other \ NP PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007857');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007858\','NP CONSULT','N','LAE',null,'LAB:8007858','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007858\',' \ Eureka \ Lab Test \ Other \ NP CONSULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007858');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007860\','NC TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007860','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007860\',' \ Eureka \ Lab Test \ Other \ NC TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007860');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007861\','NC CLINICAL INFORMATION','N','LAE',null,'LAB:8007861','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007861\',' \ Eureka \ Lab Test \ Other \ NC CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007861');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007862\','NC ITEMS RECEIVED','N','LAE',null,'LAB:8007862','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007862\',' \ Eureka \ Lab Test \ Other \ NC ITEMS RECEIVED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007862');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007863\','NC LIGHT MICROSCOPY','N','LAE',null,'LAB:8007863','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007863\',' \ Eureka \ Lab Test \ Other \ NC LIGHT MICROSCOPY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007863');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007864\','NC IMMUNOFLUORESCENCE','N','LAE',null,'LAB:8007864','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007864\',' \ Eureka \ Lab Test \ Other \ NC IMMUNOFLUORESCENCE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007864');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007865\','NC ELECTRON MICROSCOPY','N','LAE',null,'LAB:8007865','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007865\',' \ Eureka \ Lab Test \ Other \ NC ELECTRON MICROSCOPY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007865');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007866\','NC DIAGNOSIS','N','LAE',null,'LAB:8007866','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007866\',' \ Eureka \ Lab Test \ Other \ NC DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007866');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007867\','NC PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007867','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007867\',' \ Eureka \ Lab Test \ Other \ NC PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007867');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007868\','NC CONSULT','N','LAE',null,'LAB:8007868','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007868\',' \ Eureka \ Lab Test \ Other \ NC CONSULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007868');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007872\','BC ASPIRATE CLOT EXAM','N','LAE',null,'LAB:8007872','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007872\',' \ Eureka \ Lab Test \ Other \ BC ASPIRATE CLOT EXAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007872');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007873\','BC TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007873','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007873\',' \ Eureka \ Lab Test \ Other \ BC TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007873');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007874\','BC CLINICAL INFORMATION','N','LAE',null,'LAB:8007874','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007874\',' \ Eureka \ Lab Test \ Other \ BC CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007874');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007875\','BC ITEMS RECEIVED','N','LAE',null,'LAB:8007875','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007875\',' \ Eureka \ Lab Test \ Other \ BC ITEMS RECEIVED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007875');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007876\','BC PERIPHERAL BLOOD EXAM','N','LAE',null,'LAB:8007876','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007876\',' \ Eureka \ Lab Test \ Other \ BC PERIPHERAL BLOOD EXAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007876');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007877\','BC ASPIRATE SMEAR EXAM','N','LAE',null,'LAB:8007877','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007877\',' \ Eureka \ Lab Test \ Other \ BC ASPIRATE SMEAR EXAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007877');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007878\','BC TOUCH PREP IMPRINT','N','LAE',null,'LAB:8007878','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007878\',' \ Eureka \ Lab Test \ Other \ BC TOUCH PREP IMPRINT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007878');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007880\','BC BIOPSY EXAM','N','LAE',null,'LAB:8007880','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007880\',' \ Eureka \ Lab Test \ Other \ BC BIOPSY EXAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007880');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007881\','BC MICROSCOPIC DESCRIPTION','N','LAE',null,'LAB:8007881','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007881\',' \ Eureka \ Lab Test \ Other \ BC MICROSCOPIC DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007881');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007882\','BC DIAGNOSIS','N','LAE',null,'LAB:8007882','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007882\',' \ Eureka \ Lab Test \ Other \ BC DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007882');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007883\','BC PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007883','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007883\',' \ Eureka \ Lab Test \ Other \ BC PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007883');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007886\','BC CONSULT','N','LAE',null,'LAB:8007886','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007886\',' \ Eureka \ Lab Test \ Other \ BC CONSULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007886');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008400\','MOL DIAG;ISOL OR EXTRACTION','N','LAE',null,'LAB:8008400','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008400\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;ISOL OR EXTRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008400');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008401\','MOL Diag:Capillary Electrophor','N','LAE',null,'LAB:8008401','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008401\',' \ Eureka \ Lab Test \ Other \ MOL Diag:Capillary Electrophor','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008401');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008402\','MOL DIAG;SEPARAT BY GEL ELECTR','N','LAE',null,'LAB:8008402','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008402\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;SEPARAT BY GEL ELECTR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008402');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008403\','MOL DIAG;MULTIPLEX 1ST TWO SEQ','N','LAE',null,'LAB:8008403','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008403\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;MULTIPLEX 1ST TWO SEQ','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008403');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008404\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008404','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008404\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008404');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008406\','MOL DIAG;INTERP AND REPORT','N','LAE',null,'LAB:8008406','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008406\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;INTERP AND REPORT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008406');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007890\','NP TISSUE COMMITTE CODE','N','LAE',null,'LAB:8007890','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007890\',' \ Eureka \ Lab Test \ Other \ NP TISSUE COMMITTE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007890');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007891\','NP RESIDENT/FELLOW ID','N','LAE',null,'LAB:8007891','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007891\',' \ Eureka \ Lab Test \ Other \ NP RESIDENT/FELLOW ID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007891');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007892\','NP ICD 9 CODES','N','LAE',null,'LAB:8007892','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007892\',' \ Eureka \ Lab Test \ Other \ NP ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007892');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007893\','NP QM CODES AND STAINS','N','LAE',null,'LAB:8007893','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007893\',' \ Eureka \ Lab Test \ Other \ NP QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007893');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007894\','BC TISSUE COMMITTE CODE','N','LAE',null,'LAB:8007894','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007894\',' \ Eureka \ Lab Test \ Other \ BC TISSUE COMMITTE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007894');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007895\','BC RESIDENT/FELLOW ID','N','LAE',null,'LAB:8007895','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007895\',' \ Eureka \ Lab Test \ Other \ BC RESIDENT/FELLOW ID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007895');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008044\','SW ITEMS RECEIVED','N','LAE',null,'LAB:8008044','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008044\',' \ Eureka \ Lab Test \ Other \ SW ITEMS RECEIVED','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008044');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008045\','CONSULTS AP','N','LAE',null,'LAB:8008045','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008045\',' \ Eureka \ Lab Test \ Other \ CONSULTS AP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008045');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008046\','AP CONSULT RETURN','N','LAE',null,'LAB:8008046','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008046\',' \ Eureka \ Lab Test \ Other \ AP CONSULT RETURN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008046');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008047\','SW DIAGNOSIS','N','LAE',null,'LAB:8008047','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008047\',' \ Eureka \ Lab Test \ Other \ SW DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008047');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008048\','SW PATHOLOGIST COMMENT','N','LAE',null,'LAB:8008048','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008048\',' \ Eureka \ Lab Test \ Other \ SW PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008048');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008049\','SW RESIDENT/FELLOW ID','N','LAE',null,'LAB:8008049','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008049\',' \ Eureka \ Lab Test \ Other \ SW RESIDENT/FELLOW ID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008049');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008408\','MOL DIAG;ISOL OR EXTRACTION','N','LAE',null,'LAB:8008408','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008408\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;ISOL OR EXTRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008408');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008410\','MOL DIAG;SEPARAT BY GEL ELECTR','N','LAE',null,'LAB:8008410','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008410\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;SEPARAT BY GEL ELECTR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008410');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008412\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008412','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008412\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008412');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008414\','MOL DIAG;INTERP AND REPORT','N','LAE',null,'LAB:8008414','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008414\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;INTERP AND REPORT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008414');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008415\','MOL DIAG;CELL LYSIS BEFORE EXT','N','LAE',null,'LAB:8008415','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008415\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;CELL LYSIS BEFORE EXT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008415');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008416\','MOL DIAG;ISOL OR EXTRACTION','N','LAE',null,'LAB:8008416','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008416\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;ISOL OR EXTRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008416');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007896\','BC ICD 9 CODES','N','LAE',null,'LAB:8007896','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007896\',' \ Eureka \ Lab Test \ Other \ BC ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007896');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007897\','BC QM CODES AND STAINS','N','LAE',null,'LAB:8007897','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007897\',' \ Eureka \ Lab Test \ Other \ BC QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007897');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007898\','NC TISSUE COMMITTE CODE','N','LAE',null,'LAB:8007898','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007898\',' \ Eureka \ Lab Test \ Other \ NC TISSUE COMMITTE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007898');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007899\','NC RESIDENT/FELLOW ID','N','LAE',null,'LAB:8007899','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007899\',' \ Eureka \ Lab Test \ Other \ NC RESIDENT/FELLOW ID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007899');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007900\','NC ICD 9 CODES','N','LAE',null,'LAB:8007900','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007900\',' \ Eureka \ Lab Test \ Other \ NC ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007900');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007901\','NC QM CODES AND STAINS','N','LAE',null,'LAB:8007901','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007901\',' \ Eureka \ Lab Test \ Other \ NC QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007901');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008077\','AP OUTREACH PEDIATRIC SPECIMEN','N','LAE',null,'LAB:8008077','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008077\',' \ Eureka \ Lab Test \ Other \ AP OUTREACH PEDIATRIC SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008077');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008108\','ERPR DIAGNOSIS 1','N','LAE',null,'LAB:8008108','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008108\',' \ Eureka \ Lab Test \ Other \ ERPR DIAGNOSIS 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008108');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008110\','ERPR BLOCK 1','N','LAE',null,'LAB:8008110','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008110\',' \ Eureka \ Lab Test \ Other \ ERPR BLOCK 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008110');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008112\','ERPR SPECIMEN TYPE 1','N','LAE',null,'LAB:8008112','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008112\',' \ Eureka \ Lab Test \ Other \ ERPR SPECIMEN TYPE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008112');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008114\','ERPR MICROSCOPIC 1','N','LAE',null,'LAB:8008114','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008114\',' \ Eureka \ Lab Test \ Other \ ERPR MICROSCOPIC 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008114');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008116\','ERPR COMMENT 1','N','LAE',null,'LAB:8008116','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008116\',' \ Eureka \ Lab Test \ Other \ ERPR COMMENT 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008116');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008417\','MOL Diag:Capillary Electrophor','N','LAE',null,'LAB:8008417','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008417\',' \ Eureka \ Lab Test \ Other \ MOL Diag:Capillary Electrophor','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008417');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008418\','MOL DIAG;SEPARAT BY GEL ELECTR','N','LAE',null,'LAB:8008418','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008418\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;SEPARAT BY GEL ELECTR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008418');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008419\','TCR: MULTIPLEX EA ADDL NA','N','LAE',null,'LAB:8008419','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008419\',' \ Eureka \ Lab Test \ Other \ TCR: MULTIPLEX EA ADDL NA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008419');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008420\','MOL DIAG;NUCLEIC ACID PROBE,EA','N','LAE',null,'LAB:8008420','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008420\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;NUCLEIC ACID PROBE,EA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008420');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008421\','MOL DIAG;NUCLEIC ACID PROBE,EA','N','LAE',null,'LAB:8008421','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008421\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;NUCLEIC ACID PROBE,EA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008421');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008422\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008422','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008422\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008422');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007902\','FLOW CYT CLINICAL INFO','N','LAE',null,'LAB:8007902','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007902\',' \ Eureka \ Lab Test \ Other \ FLOW CYT CLINICAL INFO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007902');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007903\','FLOW CYT GROSS DESCRIPTION','N','LAE',null,'LAB:8007903','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007903\',' \ Eureka \ Lab Test \ Other \ FLOW CYT GROSS DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007903');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007904\','FLOW CYT ANTIGENS','N','LAE',null,'LAB:8007904','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007904\',' \ Eureka \ Lab Test \ Other \ FLOW CYT ANTIGENS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007904');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007905\','FLOW CYTOMETRY INTERPRETATION','N','LAE',null,'LAB:8007905','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007905\',' \ Eureka \ Lab Test \ Other \ FLOW CYTOMETRY INTERPRETATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007905');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007906\','FLOW CYT RESIDENT INFORMATION','N','LAE',null,'LAB:8007906','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007906\',' \ Eureka \ Lab Test \ Other \ FLOW CYT RESIDENT INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007906');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007908\','FLOW CYT SPECIMEN DESCRIPTION','N','LAE',null,'LAB:8007908','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007908\',' \ Eureka \ Lab Test \ Other \ FLOW CYT SPECIMEN DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007908');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008118\','ERPR BLOCK 2','N','LAE',null,'LAB:8008118','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008118\',' \ Eureka \ Lab Test \ Other \ ERPR BLOCK 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008118');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008120\','ERPR SPECIMEN TYPE 2','N','LAE',null,'LAB:8008120','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008120\',' \ Eureka \ Lab Test \ Other \ ERPR SPECIMEN TYPE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008120');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008122\','ERPR MICROSCOPIC 2','N','LAE',null,'LAB:8008122','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008122\',' \ Eureka \ Lab Test \ Other \ ERPR MICROSCOPIC 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008122');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008124\','ERPR COMMENT 2','N','LAE',null,'LAB:8008124','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008124\',' \ Eureka \ Lab Test \ Other \ ERPR COMMENT 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008124');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008126\','ERPR BLOCK 3','N','LAE',null,'LAB:8008126','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008126\',' \ Eureka \ Lab Test \ Other \ ERPR BLOCK 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008126');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008128\','ERPR SPECIMEN TYPE 3','N','LAE',null,'LAB:8008128','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008128\',' \ Eureka \ Lab Test \ Other \ ERPR SPECIMEN TYPE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008128');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008423\','MOL DIAG;MULTIPLEX 1ST TWO SEQ','N','LAE',null,'LAB:8008423','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008423\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;MULTIPLEX 1ST TWO SEQ','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008423');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008424\','MOL DIAG;INTERP AND REPORT','N','LAE',null,'LAB:8008424','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008424\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;INTERP AND REPORT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008424');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008425\','BCL2: AMPLIF OF NUCLEIC ACID','N','LAE',null,'LAB:8008425','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008425\',' \ Eureka \ Lab Test \ Other \ BCL2: AMPLIF OF NUCLEIC ACID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008425');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008426\','BCL2: AMPLIF OF NUCLEIC ACID 2','N','LAE',null,'LAB:8008426','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008426\',' \ Eureka \ Lab Test \ Other \ BCL2: AMPLIF OF NUCLEIC ACID 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008426');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008427\','BCL2: AMPLIF OF NUCLEIC ACID 3','N','LAE',null,'LAB:8008427','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008427\',' \ Eureka \ Lab Test \ Other \ BCL2: AMPLIF OF NUCLEIC ACID 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008427');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008428\','MOL DIAG;SEPARAT BY GEL ELECTR','N','LAE',null,'LAB:8008428','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008428\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;SEPARAT BY GEL ELECTR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008428');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008000\','SURGICAL PATHOLOGY SPECIMEN','N','LAE',null,'LAB:8008000','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008000\',' \ Eureka \ Lab Test \ Other \ SURGICAL PATHOLOGY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008000');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008001\','AP SURGICAL PATH CONSULT SPEC','N','LAE',null,'LAB:8008001','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008001\',' \ Eureka \ Lab Test \ Other \ AP SURGICAL PATH CONSULT SPEC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008001');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008005\','FLOW CYTOMETRY SPECIMEN','N','LAE',null,'LAB:8008005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008005\',' \ Eureka \ Lab Test \ Other \ FLOW CYTOMETRY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008006\','MOLECULAR DIAGNOSTICS SPECIMEN','N','LAE',null,'LAB:8008006','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008006\',' \ Eureka \ Lab Test \ Other \ MOLECULAR DIAGNOSTICS SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008006');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008008\','COUMADIN RESISTANCE SPECIMEN','N','LAE',null,'LAB:8008008','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008008\',' \ Eureka \ Lab Test \ Other \ COUMADIN RESISTANCE SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008008');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008010\','AUTOPSY SPECIMEN','N','LAE',null,'LAB:8008010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008010\',' \ Eureka \ Lab Test \ Other \ AUTOPSY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008130\','ERPR MICROSCOPIC 3','N','LAE',null,'LAB:8008130','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008130\',' \ Eureka \ Lab Test \ Other \ ERPR MICROSCOPIC 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008130');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008132\','ERPR COMMENT 3','N','LAE',null,'LAB:8008132','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008132\',' \ Eureka \ Lab Test \ Other \ ERPR COMMENT 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008132');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008140\','DNAP BLOCK 1','N','LAE',null,'LAB:8008140','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008140\',' \ Eureka \ Lab Test \ Other \ DNAP BLOCK 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008140');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008142\','DNAP SPECIMEN TYPE 1','N','LAE',null,'LAB:8008142','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008142\',' \ Eureka \ Lab Test \ Other \ DNAP SPECIMEN TYPE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008142');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008144\','DNAP MICROSCOPIC 1','N','LAE',null,'LAB:8008144','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008144\',' \ Eureka \ Lab Test \ Other \ DNAP MICROSCOPIC 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008144');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008146\','DNAP COMMENT 1','N','LAE',null,'LAB:8008146','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008146\',' \ Eureka \ Lab Test \ Other \ DNAP COMMENT 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008146');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008480\','MOL DIAG;INTERP AND REPORT','N','LAE',null,'LAB:8008480','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008480\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;INTERP AND REPORT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008480');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008500\','MOL DIAG;ISOL OR EXTRACTION','N','LAE',null,'LAB:8008500','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008500\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;ISOL OR EXTRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008500');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008502\','MOL DIAG;ISOL/EXTR NUCLEIC ACD','N','LAE',null,'LAB:8008502','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008502\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;ISOL/EXTR NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008502');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008503\','MOL DIAG;CELL LYSIS BEFORE EXT','N','LAE',null,'LAB:8008503','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008503\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;CELL LYSIS BEFORE EXT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008503');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008504\','MOL DIAG;SEPARAT BY GEL ELECTR','N','LAE',null,'LAB:8008504','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008504\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;SEPARAT BY GEL ELECTR','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008504');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008505\','MOL Diag:Capillary Electrophor','N','LAE',null,'LAB:8008505','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008505\',' \ Eureka \ Lab Test \ Other \ MOL Diag:Capillary Electrophor','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008505');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008016\','SHOBA SHARMA SPECIMEN','N','LAE',null,'LAB:8008016','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008016\',' \ Eureka \ Lab Test \ Other \ SHOBA SHARMA SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008016');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008017\','AP SURGICAL BIOPSY SPECIMEN','N','LAE',null,'LAB:8008017','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008017\',' \ Eureka \ Lab Test \ Other \ AP SURGICAL BIOPSY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008017');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008018\','AP NEUROPATHOLOGY SPECIMEN','N','LAE',null,'LAB:8008018','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008018\',' \ Eureka \ Lab Test \ Other \ AP NEUROPATHOLOGY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008018');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008019\','IMMUNOFLUORESCENCE, INDIRECT','N','LAE',null,'LAB:8008019','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008019\',' \ Eureka \ Lab Test \ Other \ IMMUNOFLUORESCENCE, INDIRECT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008019');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008020\','AP DERMATOPATHOLOGY SPECIMEN','N','LAE',null,'LAB:8008020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008020\',' \ Eureka \ Lab Test \ Other \ AP DERMATOPATHOLOGY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008021\','AP DERMPATH CONSULT SPEC','N','LAE',null,'LAB:8008021','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008021\',' \ Eureka \ Lab Test \ Other \ AP DERMPATH CONSULT SPEC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008021');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008148\','DNAP BLOCK 2','N','LAE',null,'LAB:8008148','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008148\',' \ Eureka \ Lab Test \ Other \ DNAP BLOCK 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008148');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008150\','DNAP SPECIMEN TYPE 2','N','LAE',null,'LAB:8008150','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008150\',' \ Eureka \ Lab Test \ Other \ DNAP SPECIMEN TYPE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008150');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008152\','DNAP MICROSCOPIC 2','N','LAE',null,'LAB:8008152','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008152\',' \ Eureka \ Lab Test \ Other \ DNAP MICROSCOPIC 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008152');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008162\','DNAP COMMENT 3','N','LAE',null,'LAB:8008162','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008162\',' \ Eureka \ Lab Test \ Other \ DNAP COMMENT 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008162');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008168\','CERB DIAGNOSIS 1','N','LAE',null,'LAB:8008168','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008168\',' \ Eureka \ Lab Test \ Other \ CERB DIAGNOSIS 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008168');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008170\','CERB BLOCK 1','N','LAE',null,'LAB:8008170','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008170\',' \ Eureka \ Lab Test \ Other \ CERB BLOCK 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008170');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008430\','MOL DIAG;NUCLEIC ACID PROBE,EA','N','LAE',null,'LAB:8008430','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008430\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;NUCLEIC ACID PROBE,EA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008430');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008432\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008432','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008432\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008432');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008433\','MOL DIAG;MULTIPLEX 1ST TWO SEQ','N','LAE',null,'LAB:8008433','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008433\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;MULTIPLEX 1ST TWO SEQ','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008433');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008436\','MOL DIAG;INTERP AND REPORT','N','LAE',null,'LAB:8008436','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008436\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;INTERP AND REPORT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008436');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008437\','MOL DIAG;ISOL OR EXTRACTION','N','LAE',null,'LAB:8008437','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008437\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;ISOL OR EXTRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008437');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008440\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008440','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008440\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008440');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008022\','AP ORAL PATHOLOGY SPECIMEN','N','LAE',null,'LAB:8008022','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008022\',' \ Eureka \ Lab Test \ Other \ AP ORAL PATHOLOGY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008022');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008023\','ORAL PATH CONSULT SPEC','N','LAE',null,'LAB:8008023','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008023\',' \ Eureka \ Lab Test \ Other \ ORAL PATH CONSULT SPEC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008023');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008024\','AP HEMATOPATHOLOGY SPECIMEN','N','LAE',null,'LAB:8008024','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008024\',' \ Eureka \ Lab Test \ Other \ AP HEMATOPATHOLOGY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008024');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008025\','AP HEMPATH CONSULT SPEC','N','LAE',null,'LAB:8008025','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008025\',' \ Eureka \ Lab Test \ Other \ AP HEMPATH CONSULT SPEC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008025');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008026\','AP UROGENITAL SPECIMEN','N','LAE',null,'LAB:8008026','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008026\',' \ Eureka \ Lab Test \ Other \ AP UROGENITAL SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008026');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008027\','AP NEPHROPATHOLOGY SPECIMEN','N','LAE',null,'LAB:8008027','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008027\',' \ Eureka \ Lab Test \ Other \ AP NEPHROPATHOLOGY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008027');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008172\','CERB SPECIMEN TYPE 1','N','LAE',null,'LAB:8008172','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008172\',' \ Eureka \ Lab Test \ Other \ CERB SPECIMEN TYPE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008172');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008174\','CERB MICROSCOPIC 1','N','LAE',null,'LAB:8008174','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008174\',' \ Eureka \ Lab Test \ Other \ CERB MICROSCOPIC 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008174');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008176\','CERB COMMENT 1','N','LAE',null,'LAB:8008176','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008176\',' \ Eureka \ Lab Test \ Other \ CERB COMMENT 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008176');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008178\','CERB BLOCK 2','N','LAE',null,'LAB:8008178','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008178\',' \ Eureka \ Lab Test \ Other \ CERB BLOCK 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008178');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008180\','CERB SPECIMEN TYPE 2','N','LAE',null,'LAB:8008180','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008180\',' \ Eureka \ Lab Test \ Other \ CERB SPECIMEN TYPE 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008180');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008182\','CERB MICROSCOPIC 2','N','LAE',null,'LAB:8008182','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008182\',' \ Eureka \ Lab Test \ Other \ CERB MICROSCOPIC 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008182');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008446\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008446','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008446\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008446');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008448\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008448','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008448\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008448');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008450\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008450','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008450\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008450');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008456\','MOL DIAG;NUCLEIC ACID PROBE,EA','N','LAE',null,'LAB:8008456','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008456\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;NUCLEIC ACID PROBE,EA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008456');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008458\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008458','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008458\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008458');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008462\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008462','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008462\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008462');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008028\','AP NEPHROPATH CONSULT SPEC','N','LAE',null,'LAB:8008028','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008028\',' \ Eureka \ Lab Test \ Other \ AP NEPHROPATH CONSULT SPEC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008028');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008030\','ELECTRON MICROSCOPY SPECIMEN','N','LAE',null,'LAB:8008030','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008030\',' \ Eureka \ Lab Test \ Other \ ELECTRON MICROSCOPY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008030');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008031\','AP GASTROINTESTINAL SPECIMEN','N','LAE',null,'LAB:8008031','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008031\',' \ Eureka \ Lab Test \ Other \ AP GASTROINTESTINAL SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008031');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008032\','SHARON WEISS SPECIMEN','N','LAE',null,'LAB:8008032','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008032\',' \ Eureka \ Lab Test \ Other \ SHARON WEISS SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008032');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008033\','AP UROGENTIAL CONSULT SPECIMEN','N','LAE',null,'LAB:8008033','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008033\',' \ Eureka \ Lab Test \ Other \ AP UROGENTIAL CONSULT SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008033');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008034\','AP GASTROINTESTINAL SPECIMEN','N','LAE',null,'LAB:8008034','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008034\',' \ Eureka \ Lab Test \ Other \ AP GASTROINTESTINAL SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008034');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008184\','CERB COMMENT 2','N','LAE',null,'LAB:8008184','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008184\',' \ Eureka \ Lab Test \ Other \ CERB COMMENT 2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008184');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008186\','CERB BLOCK 3','N','LAE',null,'LAB:8008186','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008186\',' \ Eureka \ Lab Test \ Other \ CERB BLOCK 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008186');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008188\','CERB SPECIMEN TYPE 3','N','LAE',null,'LAB:8008188','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008188\',' \ Eureka \ Lab Test \ Other \ CERB SPECIMEN TYPE 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008188');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008190\','CERB MICROSCOPIC 3','N','LAE',null,'LAB:8008190','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008190\',' \ Eureka \ Lab Test \ Other \ CERB MICROSCOPIC 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008190');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008192\','CERB COMMENT 3','N','LAE',null,'LAB:8008192','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008192\',' \ Eureka \ Lab Test \ Other \ CERB COMMENT 3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008192');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008200\','MIB BLOCK 1','N','LAE',null,'LAB:8008200','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008200\',' \ Eureka \ Lab Test \ Other \ MIB BLOCK 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008200');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008463\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008463','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008463\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008463');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008465\','IGHPCR;AMPLIF OF NUCLEIC ACID4','N','LAE',null,'LAB:8008465','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008465\',' \ Eureka \ Lab Test \ Other \ IGHPCR;AMPLIF OF NUCLEIC ACID4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008465');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008467\','IGHPCR;AMPLIF OF NUCLEIC ACID5','N','LAE',null,'LAB:8008467','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008467\',' \ Eureka \ Lab Test \ Other \ IGHPCR;AMPLIF OF NUCLEIC ACID5','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008467');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008468\','MOL DIAG;ISOL/EXTR NUCLEIC ACD','N','LAE',null,'LAB:8008468','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008468\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;ISOL/EXTR NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008468');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008469\','PML MOL DIAG;RNA STABILIZATION','N','LAE',null,'LAB:8008469','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008469\',' \ Eureka \ Lab Test \ Other \ PML MOL DIAG;RNA STABILIZATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008469');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008470\','MOL DIAG;REVERSE TRANSCRIPTION','N','LAE',null,'LAB:8008470','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008470\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;REVERSE TRANSCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008470');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008035\','INITIAL HANDLING/CLERICAL SURG','N','LAE',null,'LAB:8008035','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008035\',' \ Eureka \ Lab Test \ Other \ INITIAL HANDLING/CLERICAL SURG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008035');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008037\','FLUORESCENT MICROSCOPY SPEC','N','LAE',null,'LAB:8008037','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008037\',' \ Eureka \ Lab Test \ Other \ FLUORESCENT MICROSCOPY SPEC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008037');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008038\','MAHUL AMIN SPECIMEN','N','LAE',null,'LAB:8008038','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008038\',' \ Eureka \ Lab Test \ Other \ MAHUL AMIN SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008038');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008039\','IMMUNOFLUOR, DIRECT SPECIMEN','N','LAE',null,'LAB:8008039','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008039\',' \ Eureka \ Lab Test \ Other \ IMMUNOFLUOR, DIRECT SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008039');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008042\','SW TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8008042','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008042\',' \ Eureka \ Lab Test \ Other \ SW TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008042');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008043\','SW CLINICAL INFORMATION','N','LAE',null,'LAB:8008043','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008043\',' \ Eureka \ Lab Test \ Other \ SW CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008043');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008202\','MIB SPECIMEN TYPE 1','N','LAE',null,'LAB:8008202','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008202\',' \ Eureka \ Lab Test \ Other \ MIB SPECIMEN TYPE 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008202');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008204\','MIB MICROSCOPIC 1','N','LAE',null,'LAB:8008204','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008204\',' \ Eureka \ Lab Test \ Other \ MIB MICROSCOPIC 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008204');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008206\','MIB COMMENT 1','N','LAE',null,'LAB:8008206','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008206\',' \ Eureka \ Lab Test \ Other \ MIB COMMENT 1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008206');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008266\','VOLKAN ADSAY SPECIMEN','N','LAE',null,'LAB:8008266','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008266\',' \ Eureka \ Lab Test \ Other \ VOLKAN ADSAY SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008266');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008267\','ADEBOYE OSUNKOYA SPECIMEN','N','LAE',null,'LAB:8008267','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008267\',' \ Eureka \ Lab Test \ Other \ ADEBOYE OSUNKOYA SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008267');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008270\','ANDREA DEYRUP SPECIMEN','N','LAE',null,'LAB:8008270','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008270\',' \ Eureka \ Lab Test \ Other \ ANDREA DEYRUP SPECIMEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008270');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008471\','MOL DIAG;CELL LYSIS BEFORE EXT','N','LAE',null,'LAB:8008471','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008471\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;CELL LYSIS BEFORE EXT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008471');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008472\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008472','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008472\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008472');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008474\','MOL DIAG;AMPLIF OF NUCLEIC ACD','N','LAE',null,'LAB:8008474','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008474\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;AMPLIF OF NUCLEIC ACD','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008474');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008475\','MOL DIAG;MULTIPLEX 1ST TWO SEQ','N','LAE',null,'LAB:8008475','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008475\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;MULTIPLEX 1ST TWO SEQ','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008475');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008476\','MOL DIAG;NUCLEIC ACID PROBE,EA','N','LAE',null,'LAB:8008476','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008476\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;NUCLEIC ACID PROBE,EA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008476');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8008478\','MOL DIAG;NUCLEIC ACID PROBE,EA','N','LAE',null,'LAB:8008478','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8008478\',' \ Eureka \ Lab Test \ Other \ MOL DIAG;NUCLEIC ACID PROBE,EA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8008478');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003469\','IP BCL-6','N','LAE',null,'LAB:8003469','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003469\',' \ Eureka \ Lab Test \ Other \ IP BCL-6','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003469');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003471\','IP CALDESMON','N','LAE',null,'LAB:8003471','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003471\',' \ Eureka \ Lab Test \ Other \ IP CALDESMON','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003471');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003473\','IP CD138','N','LAE',null,'LAB:8003473','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003473\',' \ Eureka \ Lab Test \ Other \ IP CD138','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003473');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003477\','IP E-CADHERIN','N','LAE',null,'LAB:8003477','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003477\',' \ Eureka \ Lab Test \ Other \ IP E-CADHERIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003477');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003479\','IP EPITHELIAL SPECIFIC ANTIGEN','N','LAE',null,'LAB:8003479','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003479\',' \ Eureka \ Lab Test \ Other \ IP EPITHELIAL SPECIFIC ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003479');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003481\','IP HELICOBACTER PYLORI','N','LAE',null,'LAB:8003481','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003481\',' \ Eureka \ Lab Test \ Other \ IP HELICOBACTER PYLORI','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003481');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005055\','IP HERPES SIMPLEX VIRUS I','N','LAE',null,'LAB:8005055','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005055\',' \ Eureka \ Lab Test \ Other \ IP HERPES SIMPLEX VIRUS I','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005055');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005060\','AP CALCIUM/VONKOSSA','N','LAE',null,'LAB:8005060','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005060\',' \ Eureka \ Lab Test \ Other \ AP CALCIUM/VONKOSSA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005060');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005075\','IP B-HCG','N','LAE',null,'LAB:8005075','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005075\',' \ Eureka \ Lab Test \ Other \ IP B-HCG','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005075');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005080\','IP KI-1/BERH2/CD30','N','LAE',null,'LAB:8005080','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005080\',' \ Eureka \ Lab Test \ Other \ IP KI-1/BERH2/CD30','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005080');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005085\','IP LEU-M1/CD15','N','LAE',null,'LAB:8005085','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005085\',' \ Eureka \ Lab Test \ Other \ IP LEU-M1/CD15','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005085');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005090\','IP B-CELL/CD20','N','LAE',null,'LAB:8005090','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005090\',' \ Eureka \ Lab Test \ Other \ IP B-CELL/CD20','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005090');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007076\','SP INTRADEPARTMENTAL CONSULT','N','LAE',null,'LAB:8007076','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007076\',' \ Eureka \ Lab Test \ Other \ SP INTRADEPARTMENTAL CONSULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007076');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007077\','SP TISSUE COMMITTE CODE','N','LAE',null,'LAB:8007077','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007077\',' \ Eureka \ Lab Test \ Other \ SP TISSUE COMMITTE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007077');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007078\','SP RESIDENT/FELLOW ID','N','LAE',null,'LAB:8007078','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007078\',' \ Eureka \ Lab Test \ Other \ SP RESIDENT/FELLOW ID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007078');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007079\','SP ICD 9 CODES','N','LAE',null,'LAB:8007079','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007079\',' \ Eureka \ Lab Test \ Other \ SP ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007079');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007081\','SP QM CODES AND STAINS','N','LAE',null,'LAB:8007081','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007081\',' \ Eureka \ Lab Test \ Other \ SP QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007081');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007100\','AP 1ST SUPPLEMENTAL DISCUSSION','N','LAE',null,'LAB:8007100','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007100\',' \ Eureka \ Lab Test \ Other \ AP 1ST SUPPLEMENTAL DISCUSSION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007100');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007260\','AU MICROSCOPIC DESCRIPTION','N','LAE',null,'LAB:8007260','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007260\',' \ Eureka \ Lab Test \ Other \ AU MICROSCOPIC DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007260');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007270\','AU FINAL ANATOMICAL DIAGNOSIS','N','LAE',null,'LAB:8007270','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007270\',' \ Eureka \ Lab Test \ Other \ AU FINAL ANATOMICAL DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007270');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007280\','AU FINAL SUMMARY','N','LAE',null,'LAB:8007280','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007280\',' \ Eureka \ Lab Test \ Other \ AU FINAL SUMMARY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007280');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007300\','AU ADDITIONAL INFORMATION','N','LAE',null,'LAB:8007300','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007300\',' \ Eureka \ Lab Test \ Other \ AU ADDITIONAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007300');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007310\','AU REASON','N','LAE',null,'LAB:8007310','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007310\',' \ Eureka \ Lab Test \ Other \ AU REASON','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007310');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007320\','AU CULTURES','N','LAE',null,'LAB:8007320','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007320\',' \ Eureka \ Lab Test \ Other \ AU CULTURES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007320');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003483\','IP NEUN','N','LAE',null,'LAB:8003483','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003483\',' \ Eureka \ Lab Test \ Other \ IP NEUN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003483');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003487\','IP P504S','N','LAE',null,'LAB:8003487','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003487\',' \ Eureka \ Lab Test \ Other \ IP P504S','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003487');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003489\','IP P16','N','LAE',null,'LAB:8003489','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003489\',' \ Eureka \ Lab Test \ Other \ IP P16','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003489');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003491\','IP P63','N','LAE',null,'LAB:8003491','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003491\',' \ Eureka \ Lab Test \ Other \ IP P63','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003491');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003493\','IP RENAL CELL CARCINOMA','N','LAE',null,'LAB:8003493','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003493\',' \ Eureka \ Lab Test \ Other \ IP RENAL CELL CARCINOMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003493');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003495\','IP THROMBOMODULIN','N','LAE',null,'LAB:8003495','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003495\',' \ Eureka \ Lab Test \ Other \ IP THROMBOMODULIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003495');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005095\','IP MACROPHAGE/CD68','N','LAE',null,'LAB:8005095','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005095\',' \ Eureka \ Lab Test \ Other \ IP MACROPHAGE/CD68','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005095');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005097\','IP MYELIN BASIC PROTEIN','N','LAE',null,'LAB:8005097','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005097\',' \ Eureka \ Lab Test \ Other \ IP MYELIN BASIC PROTEIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005097');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005100\','IP MYOGLOBIN','N','LAE',null,'LAB:8005100','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005100\',' \ Eureka \ Lab Test \ Other \ IP MYOGLOBIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005100');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005102\','IP MYOD1','N','LAE',null,'LAB:8005102','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005102\',' \ Eureka \ Lab Test \ Other \ IP MYOD1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005102');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005105\','IP PLACENTAL ALK PHOSPHATASE','N','LAE',null,'LAB:8005105','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005105\',' \ Eureka \ Lab Test \ Other \ IP PLACENTAL ALK PHOSPHATASE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005105');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005110\','IP PROSTATIC ACID PHOSPHATASE','N','LAE',null,'LAB:8005110','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005110\',' \ Eureka \ Lab Test \ Other \ IP PROSTATIC ACID PHOSPHATASE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005110');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007105\','AP 1ST SUPPLEMENTAL DIAGNOSIS','N','LAE',null,'LAB:8007105','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007105\',' \ Eureka \ Lab Test \ Other \ AP 1ST SUPPLEMENTAL DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007105');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007106\','AP 1ST AMENDED DIAGNOSIS','N','LAE',null,'LAB:8007106','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007106\',' \ Eureka \ Lab Test \ Other \ AP 1ST AMENDED DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007106');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007115\','AP 2ND SUPPLEMENTAL DISCUSSION','N','LAE',null,'LAB:8007115','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007115\',' \ Eureka \ Lab Test \ Other \ AP 2ND SUPPLEMENTAL DISCUSSION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007115');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007120\','AP 2ND SUPPLEMENTAL DIAGNOSIS','N','LAE',null,'LAB:8007120','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007120\',' \ Eureka \ Lab Test \ Other \ AP 2ND SUPPLEMENTAL DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007120');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007121\','AP 2ND AMENDED DIAGNOSIS','N','LAE',null,'LAB:8007121','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007121\',' \ Eureka \ Lab Test \ Other \ AP 2ND AMENDED DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007121');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007130\','BM DIAGNOSIS','N','LAE',null,'LAB:8007130','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007130\',' \ Eureka \ Lab Test \ Other \ BM DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007130');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007330\','AU X-RAYS','N','LAE',null,'LAB:8007330','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007330\',' \ Eureka \ Lab Test \ Other \ AU X-RAYS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007330');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007340\','AU BLOCK CODE','N','LAE',null,'LAB:8007340','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007340\',' \ Eureka \ Lab Test \ Other \ AU BLOCK CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007340');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007351\','AU FAD RESIDENT','N','LAE',null,'LAB:8007351','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007351\',' \ Eureka \ Lab Test \ Other \ AU FAD RESIDENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007351');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007352\','AU FAD PATHOLOGY ASSISTANT','N','LAE',null,'LAB:8007352','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007352\',' \ Eureka \ Lab Test \ Other \ AU FAD PATHOLOGY ASSISTANT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007352');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007360\','AU QM CODES AND STAINS','N','LAE',null,'LAB:8007360','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007360\',' \ Eureka \ Lab Test \ Other \ AU QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007360');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007362\','NEUROPATH AUTOPSY GROSS','N','LAE',null,'LAB:8007362','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007362\',' \ Eureka \ Lab Test \ Other \ NEUROPATH AUTOPSY GROSS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007362');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003497\','IP TIA-1','N','LAE',null,'LAB:8003497','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003497\',' \ Eureka \ Lab Test \ Other \ IP TIA-1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003497');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003501\','IP WT-CARBOXY','N','LAE',null,'LAB:8003501','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003501\',' \ Eureka \ Lab Test \ Other \ IP WT-CARBOXY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003501');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8003503\','IP UROPLAKIN','N','LAE',null,'LAB:8003503','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8003503\',' \ Eureka \ Lab Test \ Other \ IP UROPLAKIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8003503');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004005\','AP METHYL GREEN PYRONINE','N','LAE',null,'LAB:8004005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004005\',' \ Eureka \ Lab Test \ Other \ AP METHYL GREEN PYRONINE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004015\','IP ALPHA-1 ANTITRYPSIN','N','LAE',null,'LAB:8004015','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004015\',' \ Eureka \ Lab Test \ Other \ IP ALPHA-1 ANTITRYPSIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004015');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004017\','IP BER-EP4','N','LAE',null,'LAB:8004017','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004017\',' \ Eureka \ Lab Test \ Other \ IP BER-EP4','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004017');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005115\','IP T-CELL/CD45RO','N','LAE',null,'LAB:8005115','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005115\',' \ Eureka \ Lab Test \ Other \ IP T-CELL/CD45RO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005115');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005120\','AP PHOSPHOTUNG ACID HEMATOX','N','LAE',null,'LAB:8005120','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005120\',' \ Eureka \ Lab Test \ Other \ AP PHOSPHOTUNG ACID HEMATOX','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005120');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005125\','AP LUXOL FAST BLUE','N','LAE',null,'LAB:8005125','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005125\',' \ Eureka \ Lab Test \ Other \ AP LUXOL FAST BLUE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005125');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005137\','IP FOLLICLE STIMULATING HORMON','N','LAE',null,'LAB:8005137','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005137\',' \ Eureka \ Lab Test \ Other \ IP FOLLICLE STIMULATING HORMON','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005137');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005139\','IP GROWTH HORMONE','N','LAE',null,'LAB:8005139','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005139\',' \ Eureka \ Lab Test \ Other \ IP GROWTH HORMONE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005139');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005141\','IP B CELL','N','LAE',null,'LAB:8005141','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005141\',' \ Eureka \ Lab Test \ Other \ IP B CELL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005141');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007135\','BM PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007135','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007135\',' \ Eureka \ Lab Test \ Other \ BM PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007135');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007140\','BM TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007140','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007140\',' \ Eureka \ Lab Test \ Other \ BM TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007140');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007145\','BM CLINICAL INFORMATION','N','LAE',null,'LAB:8007145','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007145\',' \ Eureka \ Lab Test \ Other \ BM CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007145');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007150\','BM GROSS DESCRIPTION','N','LAE',null,'LAB:8007150','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007150\',' \ Eureka \ Lab Test \ Other \ BM GROSS DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007150');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007155\','BM CASSETTE SUMMARY','N','LAE',null,'LAB:8007155','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007155\',' \ Eureka \ Lab Test \ Other \ BM CASSETTE SUMMARY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007155');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007157\','BM INTRAOPERATIVE CONSULTATION','N','LAE',null,'LAB:8007157','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007157\',' \ Eureka \ Lab Test \ Other \ BM INTRAOPERATIVE CONSULTATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007157');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007363\','NEUROPATH AUTOPSY MICROSCOPIC','N','LAE',null,'LAB:8007363','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007363\',' \ Eureka \ Lab Test \ Other \ NEUROPATH AUTOPSY MICROSCOPIC','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007363');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007364\','NEUROPATH AUTOPSY DIAGNOSIS','N','LAE',null,'LAB:8007364','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007364\',' \ Eureka \ Lab Test \ Other \ NEUROPATH AUTOPSY DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007364');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007365\','NEUROPATH AUTOPSY COMMENT','N','LAE',null,'LAB:8007365','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007365\',' \ Eureka \ Lab Test \ Other \ NEUROPATH AUTOPSY COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007365');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007367\','IF TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007367','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007367\',' \ Eureka \ Lab Test \ Other \ IF TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007367');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007369\','IF TEST DESCRIPTION','N','LAE',null,'LAB:8007369','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007369\',' \ Eureka \ Lab Test \ Other \ IF TEST DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007369');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007371\','IF DIAGNOSIS','N','LAE',null,'LAB:8007371','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007371\',' \ Eureka \ Lab Test \ Other \ IF DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007371');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004020\','IP CALCITONIN','N','LAE',null,'LAB:8004020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004020\',' \ Eureka \ Lab Test \ Other \ IP CALCITONIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004025\','IP CYTOKERATIN AE1/AE3','N','LAE',null,'LAB:8004025','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004025\',' \ Eureka \ Lab Test \ Other \ IP CYTOKERATIN AE1/AE3','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004025');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004027\','IP T CELL','N','LAE',null,'LAB:8004027','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004027\',' \ Eureka \ Lab Test \ Other \ IP T CELL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004027');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004029\','IP LEU-M1','N','LAE',null,'LAB:8004029','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004029\',' \ Eureka \ Lab Test \ Other \ IP LEU-M1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004029');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004031\','IP B CELL','N','LAE',null,'LAB:8004031','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004031\',' \ Eureka \ Lab Test \ Other \ IP B CELL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004031');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004033\','IP KI-1','N','LAE',null,'LAB:8004033','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004033\',' \ Eureka \ Lab Test \ Other \ IP KI-1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004033');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005143\','IP B CELL','N','LAE',null,'LAB:8005143','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005143\',' \ Eureka \ Lab Test \ Other \ IP B CELL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005143');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005145\','IP MYOSIN','N','LAE',null,'LAB:8005145','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005145\',' \ Eureka \ Lab Test \ Other \ IP MYOSIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005145');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005147\','IP MYELOPEROXIDASE','N','LAE',null,'LAB:8005147','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005147\',' \ Eureka \ Lab Test \ Other \ IP MYELOPEROXIDASE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005147');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005151\','AP CRYSTAL VIOLET','N','LAE',null,'LAB:8005151','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005151\',' \ Eureka \ Lab Test \ Other \ AP CRYSTAL VIOLET','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005151');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005153\','AP THIOFLAVIN T','N','LAE',null,'LAB:8005153','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005153\',' \ Eureka \ Lab Test \ Other \ AP THIOFLAVIN T','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005153');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005155\','AP PAMS','N','LAE',null,'LAB:8005155','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005155\',' \ Eureka \ Lab Test \ Other \ AP PAMS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005155');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007160\','BM PERIPHERAL BLOOD EXAM','N','LAE',null,'LAB:8007160','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007160\',' \ Eureka \ Lab Test \ Other \ BM PERIPHERAL BLOOD EXAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007160');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007165\','BM ASPIRATE SMEAR EXAM','N','LAE',null,'LAB:8007165','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007165\',' \ Eureka \ Lab Test \ Other \ BM ASPIRATE SMEAR EXAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007165');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007170\','BM TOUCH PREP IMPRINT','N','LAE',null,'LAB:8007170','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007170\',' \ Eureka \ Lab Test \ Other \ BM TOUCH PREP IMPRINT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007170');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007180\','BM BIOPSY EXAM','N','LAE',null,'LAB:8007180','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007180\',' \ Eureka \ Lab Test \ Other \ BM BIOPSY EXAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007180');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007185\','BM MICROSCOPIC DESCRIPTION','N','LAE',null,'LAB:8007185','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007185\',' \ Eureka \ Lab Test \ Other \ BM MICROSCOPIC DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007185');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007190\','BM ADDITIONAL STUDIES','N','LAE',null,'LAB:8007190','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007190\',' \ Eureka \ Lab Test \ Other \ BM ADDITIONAL STUDIES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007190');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007373\','IF PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007373','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007373\',' \ Eureka \ Lab Test \ Other \ IF PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007373');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007375\','IF TISSUE COMMITTE CODE','N','LAE',null,'LAB:8007375','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007375\',' \ Eureka \ Lab Test \ Other \ IF TISSUE COMMITTE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007375');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007379\','IF ICD 9 CODES','N','LAE',null,'LAB:8007379','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007379\',' \ Eureka \ Lab Test \ Other \ IF ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007379');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007400\','AP 3RD SUPPLEMENTAL DISCUSSION','N','LAE',null,'LAB:8007400','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007400\',' \ Eureka \ Lab Test \ Other \ AP 3RD SUPPLEMENTAL DISCUSSION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007400');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007405\','AP 3RD SUPPLEMENTAL DIAGNOSIS','N','LAE',null,'LAB:8007405','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007405\',' \ Eureka \ Lab Test \ Other \ AP 3RD SUPPLEMENTAL DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007405');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007406\','AP 3RD AMENDED DIAGNOSIS','N','LAE',null,'LAB:8007406','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007406\',' \ Eureka \ Lab Test \ Other \ AP 3RD AMENDED DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007406');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004035\','IP ENDOTHELIAL','N','LAE',null,'LAB:8004035','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004035\',' \ Eureka \ Lab Test \ Other \ IP ENDOTHELIAL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004035');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004037\','IP ENDOTHELIAL, DENDRITIC CELL','N','LAE',null,'LAB:8004037','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004037\',' \ Eureka \ Lab Test \ Other \ IP ENDOTHELIAL, DENDRITIC CELL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004037');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004039\','IP T CELL (LEU22)','N','LAE',null,'LAB:8004039','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004039\',' \ Eureka \ Lab Test \ Other \ IP T CELL (LEU22)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004039');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004041\','IP HCAM','N','LAE',null,'LAB:8004041','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004041\',' \ Eureka \ Lab Test \ Other \ IP HCAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004041');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004043\','IP LEU-7L','N','LAE',null,'LAB:8004043','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004043\',' \ Eureka \ Lab Test \ Other \ IP LEU-7L','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004043');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8004045\','IP KP-1','N','LAE',null,'LAB:8004045','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8004045\',' \ Eureka \ Lab Test \ Other \ IP KP-1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8004045');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005157\','AP TOLUIDINE BLUE','N','LAE',null,'LAB:8005157','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005157\',' \ Eureka \ Lab Test \ Other \ AP TOLUIDINE BLUE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005157');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005159\','AP PAS FUNGUS','N','LAE',null,'LAB:8005159','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005159\',' \ Eureka \ Lab Test \ Other \ AP PAS FUNGUS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005159');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005161\','AP BILE (LUNA)','N','LAE',null,'LAB:8005161','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005161\',' \ Eureka \ Lab Test \ Other \ AP BILE (LUNA)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005161');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005165\','AP COPPERAST BACILLI','N','LAE',null,'LAB:8005165','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005165\',' \ Eureka \ Lab Test \ Other \ AP COPPERAST BACILLI','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005165');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005167\','AP MELANIN BLEACH','N','LAE',null,'LAB:8005167','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005167\',' \ Eureka \ Lab Test \ Other \ AP MELANIN BLEACH','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005167');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005169\','AP MELANIN (FONTANA MASSON)','N','LAE',null,'LAB:8005169','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005169\',' \ Eureka \ Lab Test \ Other \ AP MELANIN (FONTANA MASSON)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005169');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007195\','BM CONSULT','N','LAE',null,'LAB:8007195','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007195\',' \ Eureka \ Lab Test \ Other \ BM CONSULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007195');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007196\','BM TISSUE COMMITTE CODE','N','LAE',null,'LAB:8007196','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007196\',' \ Eureka \ Lab Test \ Other \ BM TISSUE COMMITTE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007196');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007197\','BM RESIDENT/FELLOW ID','N','LAE',null,'LAB:8007197','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007197\',' \ Eureka \ Lab Test \ Other \ BM RESIDENT/FELLOW ID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007197');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007198\','BM ICD 9 CODES','N','LAE',null,'LAB:8007198','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007198\',' \ Eureka \ Lab Test \ Other \ BM ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007198');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007199\','BM QM CODES AND STAINS','N','LAE',null,'LAB:8007199','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007199\',' \ Eureka \ Lab Test \ Other \ BM QM CODES AND STAINS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007199');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007201\','BM ASPIRATE CLOT EXAM','N','LAE',null,'LAB:8007201','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007201\',' \ Eureka \ Lab Test \ Other \ BM ASPIRATE CLOT EXAM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007201');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007415\','AP 4TH SUPPLEMENTAL DISCUSSION','N','LAE',null,'LAB:8007415','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007415\',' \ Eureka \ Lab Test \ Other \ AP 4TH SUPPLEMENTAL DISCUSSION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007415');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007420\','AP 4TH SUPPLEMENTAL DIAGNOSIS','N','LAE',null,'LAB:8007420','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007420\',' \ Eureka \ Lab Test \ Other \ AP 4TH SUPPLEMENTAL DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007420');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007430\','DP TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007430','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007430\',' \ Eureka \ Lab Test \ Other \ DP TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007430');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007435\','DP CLINICAL INFORMATION','N','LAE',null,'LAB:8007435','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007435\',' \ Eureka \ Lab Test \ Other \ DP CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007435');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007440\','DP TISSUE COMMITTE INFORMATION','N','LAE',null,'LAB:8007440','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007440\',' \ Eureka \ Lab Test \ Other \ DP TISSUE COMMITTE INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007440');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007445\','DP RESIDENT/FELLOW INFORMATION','N','LAE',null,'LAB:8007445','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007445\',' \ Eureka \ Lab Test \ Other \ DP RESIDENT/FELLOW INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007445');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005010\','IP CYTOKERATIN CAM 5.2','N','LAE',null,'LAB:8005010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005010\',' \ Eureka \ Lab Test \ Other \ IP CYTOKERATIN CAM 5.2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005022\','IP CYTOKERTIN 903','N','LAE',null,'LAB:8005022','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005022\',' \ Eureka \ Lab Test \ Other \ IP CYTOKERTIN 903','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005022');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005025\','IP CYTOMEGALOVIRUS','N','LAE',null,'LAB:8005025','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005025\',' \ Eureka \ Lab Test \ Other \ IP CYTOMEGALOVIRUS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005025');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005027\','IP CYTOKERATIN MAK-6','N','LAE',null,'LAB:8005027','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005027\',' \ Eureka \ Lab Test \ Other \ IP CYTOKERATIN MAK-6','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005027');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005030\','IP FACTOR VIII','N','LAE',null,'LAB:8005030','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005030\',' \ Eureka \ Lab Test \ Other \ IP FACTOR VIII','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005030');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005032\','IP FACTOR XIIIA','N','LAE',null,'LAB:8005032','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005032\',' \ Eureka \ Lab Test \ Other \ IP FACTOR XIIIA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005032');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005173\','AP BODIAN','N','LAE',null,'LAB:8005173','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005173\',' \ Eureka \ Lab Test \ Other \ AP BODIAN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005173');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005181\','AP BIELSCHOWSKY','N','LAE',null,'LAB:8005181','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005181\',' \ Eureka \ Lab Test \ Other \ AP BIELSCHOWSKY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005181');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8005185\','AP GOMORI''S TRICHROME','N','LAE',null,'LAB:8005185','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8005185\',' \ Eureka \ Lab Test \ Other \ AP GOMORI''S TRICHROME','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8005185');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007010\','SP TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007010\',' \ Eureka \ Lab Test \ Other \ SP TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007020\','SP CLINICAL INFORMATION','N','LAE',null,'LAB:8007020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007020\',' \ Eureka \ Lab Test \ Other \ SP CLINICAL INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007030\','SP INTRAOPERATIVE CONSULTATION','N','LAE',null,'LAB:8007030','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007030\',' \ Eureka \ Lab Test \ Other \ SP INTRAOPERATIVE CONSULTATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007030');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007205\','DF TISSUE/SOURCE DESCRIPTION','N','LAE',null,'LAB:8007205','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007205\',' \ Eureka \ Lab Test \ Other \ DF TISSUE/SOURCE DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007205');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007206\','DF TEST DESCRIPTION','N','LAE',null,'LAB:8007206','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007206\',' \ Eureka \ Lab Test \ Other \ DF TEST DESCRIPTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007206');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007207\','DF DIAGNOSIS','N','LAE',null,'LAB:8007207','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007207\',' \ Eureka \ Lab Test \ Other \ DF DIAGNOSIS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007207');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007208\','DF PATHOLOGIST COMMENT','N','LAE',null,'LAB:8007208','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007208\',' \ Eureka \ Lab Test \ Other \ DF PATHOLOGIST COMMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007208');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007209\','DF TISSUE COMMITTE CODE','N','LAE',null,'LAB:8007209','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007209\',' \ Eureka \ Lab Test \ Other \ DF TISSUE COMMITTE CODE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007209');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:8007210\','DF ICD 9 CODES','N','LAE',null,'LAB:8007210','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:8007210\',' \ Eureka \ Lab Test \ Other \ DF ICD 9 CODES','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:8007210');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5010145\','ASPERGILLUS SPECIES AB','N','LAE',null,'LAB:5010145','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5010145\',' \ Eureka \ Lab Test \ Other \ ASPERGILLUS SPECIES AB','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5010145');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5010150\','FUNGAL AB INTERP','N','LAE',null,'LAB:5010150','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5010150\',' \ Eureka \ Lab Test \ Other \ FUNGAL AB INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5010150');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5010155\','RUBELLA ANTIBODY','N','LAE',null,'LAB:5010155','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5010155\',' \ Eureka \ Lab Test \ Other \ RUBELLA ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5010155');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5010160\','SYPHILIS CONFIRMATORY TEST','N','LAE',null,'LAB:5010160','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5010160\',' \ Eureka \ Lab Test \ Other \ SYPHILIS CONFIRMATORY TEST','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5010160');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5020040\','ANTI-DNA ANTIBODY LEVEL','N','LAE',null,'LAB:5020040','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5020040\',' \ Eureka \ Lab Test \ Other \ ANTI-DNA ANTIBODY LEVEL','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5020040');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5020041\','DNA INTERP','N','LAE',null,'LAB:5020041','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5020041\',' \ Eureka \ Lab Test \ Other \ DNA INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5020041');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5020171\','TOTAL COMPLEMENT BODY FLUID','N','LAE',null,'LAB:5020171','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5020171\',' \ Eureka \ Lab Test \ Other \ TOTAL COMPLEMENT BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5020171');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5020740\','RHEUMATOID FACTOR RESULT','N','LAE',null,'LAB:5020740','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5020740\',' \ Eureka \ Lab Test \ Other \ RHEUMATOID FACTOR RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5020740');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5020745\','RHEUMATOID FACTOR TITER','N','LAE',null,'LAB:5020745','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5020745\',' \ Eureka \ Lab Test \ Other \ RHEUMATOID FACTOR TITER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5020745');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5020821\','ANTI SMOOTH MUSCLE AB RESULT','N','LAE',null,'LAB:5020821','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5020821\',' \ Eureka \ Lab Test \ Other \ ANTI SMOOTH MUSCLE AB RESULT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5020821');
commit;
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5020826\','ANTI SMOOTH MUSCLE AB TITER','N','LAE',null,'LAB:5020826','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5020826\',' \ Eureka \ Lab Test \ Other \ ANTI SMOOTH MUSCLE AB TITER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5020826');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5020850\','ANTI MICROSOMAL AB TITER','N','LAE',null,'LAB:5020850','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5020850\',' \ Eureka \ Lab Test \ Other \ ANTI MICROSOMAL AB TITER','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5020850');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5031510\','CD16+56-','N','LAE',null,'LAB:5031510','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5031510\',' \ Eureka \ Lab Test \ Other \ CD16+56-','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5031510');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5031511\','CD3-CD8(lo)','N','LAE',null,'LAB:5031511','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5031511\',' \ Eureka \ Lab Test \ Other \ CD3-CD8(lo)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5031511');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5031512\','SAMPLE TYPE','N','LAE',null,'LAB:5031512','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5031512\',' \ Eureka \ Lab Test \ Other \ SAMPLE TYPE','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5031512');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5031514\','TOTAL CELLS','N','LAE',null,'LAB:5031514','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5031514\',' \ Eureka \ Lab Test \ Other \ TOTAL CELLS','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5031514');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5031515\','VIABILITY','N','LAE',null,'LAB:5031515','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5031515\',' \ Eureka \ Lab Test \ Other \ VIABILITY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5031515');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5031516\','LIN-123+11C-DR+','N','LAE',null,'LAB:5031516','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5031516\',' \ Eureka \ Lab Test \ Other \ LIN-123+11C-DR+','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5031516');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040070\','IgG CEREBROSPINAL FLUID','N','LAE',null,'LAB:5040070','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040070\',' \ Eureka \ Lab Test \ Other \ IgG CEREBROSPINAL FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040070');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040071\','ALBUMIN CEREBROSPINAL FLUID','N','LAE',null,'LAB:5040071','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040071\',' \ Eureka \ Lab Test \ Other \ ALBUMIN CEREBROSPINAL FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040071');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040072\','SERUM ALBUMIN(NEPHELOMETRY)','N','LAE',null,'LAB:5040072','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040072\',' \ Eureka \ Lab Test \ Other \ SERUM ALBUMIN(NEPHELOMETRY)','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040072');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040073\','CSF IGG/CSF ALB','N','LAE',null,'LAB:5040073','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040073\',' \ Eureka \ Lab Test \ Other \ CSF IGG/CSF ALB','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040073');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040074\','CSF ALB/SER ALB','N','LAE',null,'LAB:5040074','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040074\',' \ Eureka \ Lab Test \ Other \ CSF ALB/SER ALB','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040074');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040075\','IGG INDEX','N','LAE',null,'LAB:5040075','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040075\',' \ Eureka \ Lab Test \ Other \ IGG INDEX','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040075');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040078\','CSFINTERPRETATION','N','LAE',null,'LAB:5040078','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040078\',' \ Eureka \ Lab Test \ Other \ CSFINTERPRETATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040078');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040160\','C3 COMPLEMENT','N','LAE',null,'LAB:5040160','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040160\',' \ Eureka \ Lab Test \ Other \ C3 COMPLEMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040160');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040180\','C4 COMPLEMENT','N','LAE',null,'LAB:5040180','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040180\',' \ Eureka \ Lab Test \ Other \ C4 COMPLEMENT','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040180');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040215\','C3 COMPLEMENT BODY FLUID','N','LAE',null,'LAB:5040215','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040215\',' \ Eureka \ Lab Test \ Other \ C3 COMPLEMENT BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040215');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040220\','C4 COMPLEMENT BODY FLUID','N','LAE',null,'LAB:5040220','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040220\',' \ Eureka \ Lab Test \ Other \ C4 COMPLEMENT BODY FLUID','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040220');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040551\','FREE IMMUNOGLOBULIN KAPPA','N','LAE',null,'LAB:5040551','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040551\',' \ Eureka \ Lab Test \ Other \ FREE IMMUNOGLOBULIN KAPPA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040551');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040552\','FREE IMMUNOGLOBULIN LAMBDA','N','LAE',null,'LAB:5040552','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040552\',' \ Eureka \ Lab Test \ Other \ FREE IMMUNOGLOBULIN LAMBDA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040552');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040555\','FREE KAPPA/LAMBDA RATIO','N','LAE',null,'LAB:5040555','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040555\',' \ Eureka \ Lab Test \ Other \ FREE KAPPA/LAMBDA RATIO','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040555');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040570\','IMMUNOGLOBULIN A','N','LAE',null,'LAB:5040570','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040570\',' \ Eureka \ Lab Test \ Other \ IMMUNOGLOBULIN A','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040570');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040600\','IMMUNOGLOBULIN E','N','LAE',null,'LAB:5040600','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040600\',' \ Eureka \ Lab Test \ Other \ IMMUNOGLOBULIN E','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040600');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040620\','IMMUNOGLOBULIN G','N','LAE',null,'LAB:5040620','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040620\',' \ Eureka \ Lab Test \ Other \ IMMUNOGLOBULIN G','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040620');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040621\','IMMUNOGLOBULIN G','N','LAE',null,'LAB:5040621','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040621\',' \ Eureka \ Lab Test \ Other \ IMMUNOGLOBULIN G','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040621');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040640\','IMMUNOGLOBULIN M','N','LAE',null,'LAB:5040640','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040640\',' \ Eureka \ Lab Test \ Other \ IMMUNOGLOBULIN M','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040640');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5040650\','TRANSFERRIN','N','LAE',null,'LAB:5040650','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5040650\',' \ Eureka \ Lab Test \ Other \ TRANSFERRIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5040650');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050010\','GAMMA','N','LAE',null,'LAB:5050010','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050010\',' \ Eureka \ Lab Test \ Other \ GAMMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050010');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050011\','GAMMA','N','LAE',null,'LAB:5050011','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050011\',' \ Eureka \ Lab Test \ Other \ GAMMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050011');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050020\','ALPHA','N','LAE',null,'LAB:5050020','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050020\',' \ Eureka \ Lab Test \ Other \ ALPHA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050020');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050021\','ALPHA','N','LAE',null,'LAB:5050021','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050021\',' \ Eureka \ Lab Test \ Other \ ALPHA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050021');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050030\','MU','N','LAE',null,'LAB:5050030','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050030\',' \ Eureka \ Lab Test \ Other \ MU','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050030');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050031\','URINE MU','N','LAE',null,'LAB:5050031','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050031\',' \ Eureka \ Lab Test \ Other \ URINE MU','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050031');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050040\','KAPPA','N','LAE',null,'LAB:5050040','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050040\',' \ Eureka \ Lab Test \ Other \ KAPPA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050040');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050041\','URINE KAPPA','N','LAE',null,'LAB:5050041','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050041\',' \ Eureka \ Lab Test \ Other \ URINE KAPPA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050041');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050050\','LAMBDA','N','LAE',null,'LAB:5050050','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050050\',' \ Eureka \ Lab Test \ Other \ LAMBDA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050050');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050051\','URINE LAMBDA','N','LAE',null,'LAB:5050051','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050051\',' \ Eureka \ Lab Test \ Other \ URINE LAMBDA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050051');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050060\','IMMUNFIXATION INTERPRETATION','N','LAE',null,'LAB:5050060','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050060\',' \ Eureka \ Lab Test \ Other \ IMMUNFIXATION INTERPRETATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050060');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050065\','BETA-2 TRANSFERRIN','N','LAE',null,'LAB:5050065','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050065\',' \ Eureka \ Lab Test \ Other \ BETA-2 TRANSFERRIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050065');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050110\','URINE IMMUNO INTERPRETATION','N','LAE',null,'LAB:5050110','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050110\',' \ Eureka \ Lab Test \ Other \ URINE IMMUNO INTERPRETATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:01','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050110');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050501\','TOTAL PROTEIN SERUM','N','LAE',null,'LAB:5050501','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050501\',' \ Eureka \ Lab Test \ Other \ TOTAL PROTEIN SERUM','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050501');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050502\','ALBUMIN','N','LAE',null,'LAB:5050502','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050502\',' \ Eureka \ Lab Test \ Other \ ALBUMIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050502');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050575\','ALBUMIN FRACTION','N','LAE',null,'LAB:5050575','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050575\',' \ Eureka \ Lab Test \ Other \ ALBUMIN FRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050575');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050580\','% ALBUMIN','N','LAE',null,'LAB:5050580','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050580\',' \ Eureka \ Lab Test \ Other \ % ALBUMIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050580');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050585\','% ALPHA-1','N','LAE',null,'LAB:5050585','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050585\',' \ Eureka \ Lab Test \ Other \ % ALPHA-1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050585');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050590\','% ALPHA-2','N','LAE',null,'LAB:5050590','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050590\',' \ Eureka \ Lab Test \ Other \ % ALPHA-2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050590');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050595\','% BETA-1','N','LAE',null,'LAB:5050595','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050595\',' \ Eureka \ Lab Test \ Other \ % BETA-1','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050595');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050600\','% BETA-2','N','LAE',null,'LAB:5050600','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050600\',' \ Eureka \ Lab Test \ Other \ % BETA-2','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050600');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050610\','% GAMMA','N','LAE',null,'LAB:5050610','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050610\',' \ Eureka \ Lab Test \ Other \ % GAMMA','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050610');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050615\','% PARAPROTEIN','N','LAE',null,'LAB:5050615','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050615\',' \ Eureka \ Lab Test \ Other \ % PARAPROTEIN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050615');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050625\','ALPHA-1 FRACTION','N','LAE',null,'LAB:5050625','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050625\',' \ Eureka \ Lab Test \ Other \ ALPHA-1 FRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050625');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050630\','ALPHA-2 FRACTION','N','LAE',null,'LAB:5050630','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050630\',' \ Eureka \ Lab Test \ Other \ ALPHA-2 FRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050630');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050635\','BETA-1  FRACTION','N','LAE',null,'LAB:5050635','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050635\',' \ Eureka \ Lab Test \ Other \ BETA-1  FRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050635');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050640\','BETA-2  FRACTION','N','LAE',null,'LAB:5050640','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050640\',' \ Eureka \ Lab Test \ Other \ BETA-2  FRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050640');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050645\','GAMMA GLOBULIN FRACTION','N','LAE',null,'LAB:5050645','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050645\',' \ Eureka \ Lab Test \ Other \ GAMMA GLOBULIN FRACTION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050645');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050650\','PARAPROTEIN CONCENTRATION','N','LAE',null,'LAB:5050650','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050650\',' \ Eureka \ Lab Test \ Other \ PARAPROTEIN CONCENTRATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050650');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050655\','SERUM ELECTROPHORESIS INTERP','N','LAE',null,'LAB:5050655','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050655\',' \ Eureka \ Lab Test \ Other \ SERUM ELECTROPHORESIS INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050655');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5050710\','URINE ELECTROPHORESIS INTERP','N','LAE',null,'LAB:5050710','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5050710\',' \ Eureka \ Lab Test \ Other \ URINE ELECTROPHORESIS INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5050710');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5051005\','FLUID ELECTROPHORESIS INTERP','N','LAE',null,'LAB:5051005','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5051005\',' \ Eureka \ Lab Test \ Other \ FLUID ELECTROPHORESIS INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5051005');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5080021\','VOLUME FROZEN','N','LAE',null,'LAB:5080021','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5080021\',' \ Eureka \ Lab Test \ Other \ VOLUME FROZEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5080021');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5080022\','SAMPLE INFORMATION','N','LAE',null,'LAB:5080022','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5080022\',' \ Eureka \ Lab Test \ Other \ SAMPLE INFORMATION','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:02','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5080022');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5080080\','DELTA HEPATITIS ANTIBODY','N','LAE',null,'LAB:5080080','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5080080\',' \ Eureka \ Lab Test \ Other \ DELTA HEPATITIS ANTIBODY','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5080080');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5080085\','HIV ANTIGEN','N','LAE',null,'LAB:5080085','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5080085\',' \ Eureka \ Lab Test \ Other \ HIV ANTIGEN','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5080085');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5080105\','HEPATITIS A INTERP','N','LAE',null,'LAB:5080105','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5080105\',' \ Eureka \ Lab Test \ Other \ HEPATITIS A INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5080105');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5080125\','HEP B IMMUNE STATUS INTERP','N','LAE',null,'LAB:5080125','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5080125\',' \ Eureka \ Lab Test \ Other \ HEP B IMMUNE STATUS INTERP','@',to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:22:03','DD-MON-RR HH24:MI:SS'),to_date('04-FEB-15 13:26:50','DD-MON-RR HH24:MI:SS'),'org.protempa.backend.ksb.protege.LocalKnowledgeSou','LAB',null,'\EK\LAB:LabTest\LAB:Other\','LAB:5080125');
Insert into EK_LABS (C_HLEVEL,C_FULLNAME,C_NAME,C_SYNONYM_CD,C_VISUALATTRIBUTES,C_TOTALNUM,C_BASECODE,C_FACTTABLECOLUMN,C_TABLENAME,C_COLUMNNAME,C_COLUMNDATATYPE,C_OPERATOR,C_DIMCODE,C_TOOLTIP,M_APPLIED_PATH,UPDATE_DATE,DOWNLOAD_DATE,IMPORT_DATE,SOURCESYSTEM_CD,VALUETYPE_CD,M_EXCLUSION_CD,C_PATH,C_SYMBOL) values (3,'\EK\LAB:LabTest\LAB:Other\LAB:5080135\','HEPATITIS B INTERP','N','LAE',null,'LAB:5080135','concept_cd','concept_dimension','concept_path','T','LIKE','\EK\LAB:LabTest\LAB:Other\LAB:5080135\',' \ Eureka \ Lab Test \ Other \ HEPATITIS B INTERP','@',to_da