/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb.oracle;

import org.protempa.backend.dsb.relationaldb.AbstractInClause;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.SqlGeneratorUtil;
import org.protempa.backend.dsb.relationaldb.TableAliaser;

final class Ojdbc6OracleInClause
extends AbstractInClause {
    private final ColumnSpec columnSpec;
    private final Object[] elements;
    private final boolean not;
    private final TableAliaser referenceIndices;

    Ojdbc6OracleInClause(ColumnSpec columnSpec, Object[] elements, boolean not, TableAliaser referenceIndices) {
        super(columnSpec, elements, not, referenceIndices);
        this.columnSpec = columnSpec;
        this.elements = elements;
        this.not = not;
        this.referenceIndices = referenceIndices;
    }

    @Override
    public String generateClause() {
        StringBuilder wherePart = new StringBuilder();
        wherePart.append(this.referenceIndices.generateColumnReference(this.columnSpec));
        if (this.not) {
            wherePart.append(" NOT");
        }
        wherePart.append(" IN (");
        for (int k = 0; k < this.elements.length; ++k) {
            Object val = this.elements[k];
            wherePart.append(SqlGeneratorUtil.prepareValue(val));
            if (k + 1 >= this.elements.length) continue;
            if ((k + 1) % 1000 == 0) {
                wherePart.append(") OR ");
                wherePart.append(this.referenceIndices.generateColumnReference(this.columnSpec));
                wherePart.append(" IN (");
                continue;
            }
            wherePart.append(',');
        }
        wherePart.append(')');
        return wherePart.toString();
    }
}

