/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import java.util.HashMap;
import java.util.Map;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.BackendPropertySpec;
import org.protempa.backend.InvalidPropertyValueException;

public enum BackendPropertyType {
    STRING((Class)String.class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof String;
        }

        @Override
        public Object parse(String propertyName, String value) {
            return value;
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Boolean;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Boolean.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Integer;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Long;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Float;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Double;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    CHARACTER((Class)Character.class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Character;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            if (value.length() > 1) {
                throw new InvalidPropertyValueException(propertyName, value, null);
            }
            return Character.valueOf(value.charAt(0));
        }
    }
    ,
    STRING_ARRAY((Class)String[].class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof String;
        }

        @Override
        public Object parse(String propertyName, String value) {
            return value;
        }
    }
    ,
    DOUBLE_ARRAY((Class)Double[].class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Double;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    FLOAT_ARRAY((Class)Float[].class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Float;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    INTEGER_ARRAY((Class)Integer[].class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Integer;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    LONG_ARRAY((Class)Long[].class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Long;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    BOOLEAN_ARRAY((Class)Boolean[].class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Boolean;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            try {
                return Boolean.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPropertyValueException(propertyName, value, ex);
            }
        }
    }
    ,
    CHARACTER_ARRAY((Class)Character[].class){

        @Override
        public boolean isInstance(Object val) {
            return val instanceof Character;
        }

        @Override
        public Object parse(String propertyName, String value) throws InvalidPropertyValueException {
            if (value.length() > 1) {
                throw new InvalidPropertyValueException(propertyName, value, null);
            }
            return Character.valueOf(value.charAt(0));
        }
    };

    private static final Map<Class<?>, BackendPropertyType> clsToEnum;
    private Class<?> cls;

    public static BackendPropertyType fromCls(Class<?> cls) {
        return clsToEnum.get(cls);
    }

    public static boolean isAllowed(Class<?> cls) {
        return clsToEnum.containsKey(cls);
    }

    private BackendPropertyType(Class<?> cls) {
        this.cls = cls;
    }

    public abstract boolean isInstance(Object var1);

    public Class<?> getCls() {
        return this.cls;
    }

    public abstract Object parse(String var1, String var2) throws InvalidPropertyValueException;

    public void setProperty(BackendInstanceSpec instanceSpec, BackendPropertySpec propertySpec, Object value) throws InvalidPropertyValueException {
        instanceSpec.setProperty(propertySpec, value);
    }

    public void parseProperty(BackendInstanceSpec instanceSpec, BackendPropertySpec propertySpec, String value) throws InvalidPropertyValueException {
        this.setProperty(instanceSpec, propertySpec, this.parse(propertySpec.getName(), value));
    }

    static {
        clsToEnum = new HashMap();
        for (BackendPropertyType elt : BackendPropertyType.values()) {
            clsToEnum.put(elt.getCls(), elt);
        }
    }
}

