/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.base.SalienceInteger;
import org.drools.common.BaseNode;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.ReteooRuleBuilder;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Rule;
import org.drools.spi.Salience;

public class ReteooBuilder
implements Serializable {
    private static final long serialVersionUID = 400L;
    private transient InternalRuleBase ruleBase;
    private transient InternalWorkingMemory[] workingMemories;
    private Map rules;
    private transient ReteooRuleBuilder ruleBuilder;
    private IdGenerator idGenerator;
    private boolean ordered;

    ReteooBuilder(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.rules = new HashMap();
        this.idGenerator = new IdGenerator(1);
        this.ruleBuilder = new ReteooRuleBuilder();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.ruleBase = ((DroolsObjectInputStream)stream).getRuleBase();
        this.ruleBuilder = new ReteooRuleBuilder();
    }

    void addRule(Rule rule) throws InvalidPatternException {
        List terminals = this.ruleBuilder.addRule(rule, this.ruleBase, this.idGenerator);
        this.rules.put(rule, terminals.toArray(new BaseNode[terminals.size()]));
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void order() {
        if (this.ordered) {
            return;
        }
        HashMap<String, ArrayList<RuleTerminalNode>> map = new HashMap<String, ArrayList<RuleTerminalNode>>();
        Iterator<Object> it = this.rules.values().iterator();
        while (it.hasNext()) {
            BaseNode[] nodes = (BaseNode[])it.next();
            for (int i = 0; i < nodes.length; ++i) {
                ArrayList<RuleTerminalNode> rules;
                if (!(nodes[i] instanceof RuleTerminalNode)) continue;
                RuleTerminalNode node = (RuleTerminalNode)nodes[i];
                String agendaGroup = node.getRule().getAgendaGroup();
                if (agendaGroup == null || agendaGroup.equals("")) {
                    agendaGroup = "MAIN";
                }
                if ((rules = (ArrayList<RuleTerminalNode>)map.get(agendaGroup)) == null) {
                    rules = new ArrayList<RuleTerminalNode>();
                    map.put(agendaGroup, rules);
                }
                rules.add(node);
            }
        }
        it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String agendaGroup = (String)entry.getKey();
            List rules = (List)entry.getValue();
            Collections.sort(rules, RuleSequenceComparator.INSTANCE);
            int i = 0;
            Iterator listIter = rules.iterator();
            while (listIter.hasNext()) {
                RuleTerminalNode node = (RuleTerminalNode)listIter.next();
                node.setSequence(i++);
            }
            this.ruleBase.getAgendaGroupRuleTotals().put(agendaGroup, new Integer(i));
        }
        this.ordered = true;
    }

    public BaseNode[] getTerminalNodes(Rule rule) {
        return (BaseNode[])this.rules.get(rule);
    }

    public void removeRule(Rule rule) {
        this.workingMemories = this.ruleBase.getWorkingMemories();
        Object object = this.rules.remove(rule);
        BaseNode[] nodes = (BaseNode[])object;
        RuleRemovalContext context = new RuleRemovalContext();
        int length = nodes.length;
        for (int i = 0; i < length; ++i) {
            BaseNode node = nodes[i];
            node.remove(context, null, this.workingMemories);
            context.clear();
        }
    }

    public static class IdGenerator
    implements Serializable {
        private static final long serialVersionUID = 400L;
        private int nextId;

        public IdGenerator(int firstId) {
            this.nextId = firstId;
        }

        public int getNextId() {
            return this.nextId++;
        }

        public void releaseLastId() {
            --this.nextId;
        }
    }

    public static class RuleSequenceComparator
    implements Comparator {
        public static final RuleSequenceComparator INSTANCE = new RuleSequenceComparator();

        public int compare(Object o1, Object o2) {
            int id2;
            int s2;
            RuleTerminalNode r1 = (RuleTerminalNode)o1;
            RuleTerminalNode r2 = (RuleTerminalNode)o2;
            Salience so1 = r1.getRule().getSalience();
            if (so1 != null && !(so1 instanceof SalienceInteger)) {
                throw new RuntimeException(r1.getRule().getName() + "must not have a dynamic salience");
            }
            Salience so2 = r2.getRule().getSalience();
            if (so2 != null && !(so2 instanceof SalienceInteger)) {
                throw new RuntimeException(r2.getRule().getName() + "must not have a dynamic salience");
            }
            int s1 = so1.getValue(null, null);
            if (s1 > (s2 = so2.getValue(null, null))) {
                return -1;
            }
            if (s1 < s2) {
                return 1;
            }
            int id1 = r1.getId();
            if (id1 < (id2 = r2.getId())) {
                return -1;
            }
            if (id1 > id2) {
                return 1;
            }
            return 0;
        }
    }
}

