/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import org.protempa.backend.dsb.relationaldb.CaseClause;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.SqlGeneratorUtil;
import org.protempa.backend.dsb.relationaldb.TableAliaser;
import org.protempa.backend.dsb.relationaldb.mappings.Mappings;

abstract class AbstractCaseClause
implements CaseClause {
    private final Object[] sqlCodes;
    private final TableAliaser referenceIndices;
    private final ColumnSpec columnSpec;
    private final Mappings mappings;

    AbstractCaseClause(Object[] sqlCodes, TableAliaser referenceIndices, ColumnSpec columnSpec, Mappings mappings) {
        this.sqlCodes = sqlCodes;
        this.referenceIndices = referenceIndices;
        this.columnSpec = columnSpec;
        this.mappings = mappings;
    }

    @Override
    public String generateClause() {
        StringBuilder selectPart = new StringBuilder();
        selectPart.append(", case ");
        for (int k = 0; k < this.sqlCodes.length; ++k) {
            selectPart.append("when ");
            selectPart.append(this.referenceIndices.generateColumnReferenceWithOp(this.columnSpec));
            selectPart.append(" like ");
            selectPart.append(SqlGeneratorUtil.prepareValue(this.sqlCodes[k]));
            selectPart.append(" then ");
            selectPart.append(SqlGeneratorUtil.prepareValue(this.mappings.getTarget(this.sqlCodes[k])));
            if (k >= this.sqlCodes.length - 1) continue;
            selectPart.append(" ");
        }
        selectPart.append(" end ");
        return selectPart.toString();
    }
}

