/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.backend.dsb.relationaldb.NoCompatibleSQLGeneratorException;
import org.protempa.backend.dsb.relationaldb.RelationalDatabaseSpec;
import org.protempa.backend.dsb.relationaldb.RelationalDbDataSourceBackend;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.SQLGenerator;
import org.protempa.backend.dsb.relationaldb.SQLGeneratorLoadException;

public final class SQLGeneratorFactory {
    private final ConnectionSpec connectionSpec;
    private final RelationalDbDataSourceBackend backend;
    private final RelationalDatabaseSpec relationalDatabaseSpec;

    public SQLGeneratorFactory(ConnectionSpec connectionSpec, RelationalDatabaseSpec relationalDatabaseSpec, RelationalDbDataSourceBackend backend) {
        assert (connectionSpec != null) : "connectionSpec cannot be null!";
        assert (backend != null) : "backend cannot be null!";
        assert (relationalDatabaseSpec != null) : "relationalDatabaseSpec cannot be null";
        this.connectionSpec = connectionSpec;
        this.backend = backend;
        this.relationalDatabaseSpec = relationalDatabaseSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLGenerator newInstance() throws SQLException, NoCompatibleSQLGeneratorException, SQLGeneratorLoadException {
        Logger logger = SQLGenUtil.logger();
        logger.fine("Loading a compatible SQL generator");
        ServiceLoader<SQLGenerator> candidates = ServiceLoader.load(SQLGenerator.class);
        try {
            for (SQLGenerator candidateInstance : candidates) {
                candidateInstance.loadDriverIfNeeded();
            }
            Iterator<SQLGenerator> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                SQLGenerator candidateInstance;
                candidateInstance = iterator.next();
                logger.log(Level.FINER, "Checking compatibility of SQL generator {0}", candidateInstance.getClass().getName());
                String forcedSQLGenerator = System.getProperty("protempa.dsb.relationaldatabase.sqlgenerator");
                if (forcedSQLGenerator != null) {
                    if (!forcedSQLGenerator.equals(candidateInstance.getClass().getName())) continue;
                    logger.log(Level.INFO, "Forcing use of SQL generator {0}", candidateInstance.getClass().getName());
                    candidateInstance.initialize(this.backend.isDryRun() ? null : this.connectionSpec, this.relationalDatabaseSpec, this.backend);
                    logger.log(Level.FINE, "SQL generator {0} is loaded", candidateInstance.getClass().getName());
                    return candidateInstance;
                }
                Connection con = this.connectionSpec.getOrCreate();
                try {
                    if (candidateInstance.checkCompatibility(con)) {
                        DatabaseMetaData metaData = con.getMetaData();
                        SQLGeneratorFactory.logCompatibility(logger, candidateInstance, metaData);
                        candidateInstance.initialize(this.backend.isDryRun() ? null : this.connectionSpec, this.relationalDatabaseSpec, this.backend);
                        logger.log(Level.FINE, "SQL generator {0} is loaded", candidateInstance.getClass().getName());
                        SQLGenerator sQLGenerator = candidateInstance;
                        return sQLGenerator;
                    }
                    con.close();
                    con = null;
                }
                finally {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                logger.log(Level.FINER, "SQL generator {0} is not compatible", candidateInstance.getClass().getName());
            }
            throw new NoCompatibleSQLGeneratorException("Could not find a SQL generator that is compatible with your database and available JDBC drivers");
        }
        catch (ServiceConfigurationError sce) {
            throw new SQLGeneratorLoadException("Could not load SQL generators", sce);
        }
    }

    private static void logCompatibility(Logger logger, SQLGenerator candidateInstance, DatabaseMetaData metaData) throws SQLException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "{0} is compatible with database {1} ({2})", new Object[]{candidateInstance.getClass().getName(), metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion()});
            logger.log(Level.FINER, "{0} is compatible with driver {1} ({2})", new Object[]{candidateInstance.getClass().getName(), metaData.getDriverName(), metaData.getDriverVersion()});
        }
    }
}

