/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.arrays.Arrays;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.filter.PositionFilter;
import org.protempa.backend.dsb.filter.PropertyValueFilter;
import org.protempa.backend.dsb.relationaldb.AbstractSQLGenerator;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.ColumnSpecInfo;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.IntColumnSpecWrapper;
import org.protempa.backend.dsb.relationaldb.Operator;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.proposition.interval.Interval;

public final class ColumnSpecInfoFactory {
    public ColumnSpecInfo newInstance(Set<String> propIds, EntitySpec entitySpec, Collection<EntitySpec> entitySpecs, Map<String, ReferenceSpec> inboundRefSpecs, Collection<Filter> filters, ReferenceSpec referenceSpec, boolean streamingMode) {
        ColumnSpecInfo columnSpecInfo = new ColumnSpecInfo();
        if (referenceSpec == null || streamingMode) {
            columnSpecInfo.setUsingKeyIdIndex(true);
        }
        EntitySpec refEntitySpec = null;
        if (referenceSpec != null) {
            refEntitySpec = ColumnSpecInfoFactory.findRefEntitySpec(entitySpecs, referenceSpec);
            columnSpecInfo.setUnique(refEntitySpec.isUnique() && entitySpec.isUnique() && ColumnSpecInfoFactory.hasNoXToManyReferences(entitySpecs, entitySpec));
        } else {
            columnSpecInfo.setUnique(entitySpec.isUnique());
        }
        ArrayList<IntColumnSpecWrapper> columnSpecs = new ArrayList<IntColumnSpecWrapper>();
        int i = 0;
        i = ColumnSpecInfoFactory.processBaseSpec(entitySpec, columnSpecs, i);
        i = ColumnSpecInfoFactory.processUniqueIds(entitySpec, columnSpecs, i, columnSpecInfo, referenceSpec);
        i = ColumnSpecInfoFactory.processStartTimeOrTimestamp(entitySpec, columnSpecs, i, columnSpecInfo, referenceSpec);
        i = ColumnSpecInfoFactory.processFinishTimeSpec(entitySpec, columnSpecs, i, columnSpecInfo, referenceSpec);
        if (referenceSpec == null) {
            i = ColumnSpecInfoFactory.processPropertyAndValueSpecs(entitySpec, columnSpecs, i, columnSpecInfo);
        }
        i = ColumnSpecInfoFactory.processCodeSpec(propIds, entitySpec, columnSpecs, i, columnSpecInfo, referenceSpec);
        i = ColumnSpecInfoFactory.processConstraintSpecs(entitySpec, entitySpecs, columnSpecs, i);
        i = ColumnSpecInfoFactory.processFilters(entitySpec, entitySpecs, filters, columnSpecs, i);
        i = ColumnSpecInfoFactory.processCreateDate(entitySpec, columnSpecs, i, columnSpecInfo, referenceSpec);
        i = ColumnSpecInfoFactory.processUpdateDate(entitySpec, columnSpecs, i, columnSpecInfo, referenceSpec);
        i = ColumnSpecInfoFactory.processDeleteDate(entitySpec, columnSpecs, i, columnSpecInfo, referenceSpec);
        int refNum = 0;
        block0: for (EntitySpec entitySpec2 : entitySpecs) {
            for (Map.Entry<String, ReferenceSpec> inboundRef : inboundRefSpecs.entrySet()) {
                if (!inboundRef.getKey().equals(entitySpec2.getName())) continue;
                if (entitySpec2 == entitySpec || referenceSpec != null || !entitySpec2.hasReferenceTo(entitySpec)) continue block0;
                i = ColumnSpecInfoFactory.processReferenceSpecs(entitySpec2, entitySpec, columnSpecs, refNum, i, columnSpecInfo);
                ++refNum;
                continue block0;
            }
        }
        columnSpecInfo.setColumnSpecs(columnSpecs);
        return columnSpecInfo;
    }

    private static boolean hasNoXToManyReferences(Collection<EntitySpec> entitySpecs, EntitySpec entitySpec) {
        for (EntitySpec es : entitySpecs) {
            if (!es.hasReferenceTo(entitySpec)) continue;
            for (ReferenceSpec refSpec : entitySpec.referencesTo(es)) {
                if (refSpec.getType() != ReferenceSpec.Type.MANY) continue;
                return false;
            }
        }
        return true;
    }

    private static EntitySpec findRefEntitySpec(Collection<EntitySpec> entitySpecs, ReferenceSpec referenceSpec) {
        String referenceSpecEntityName = referenceSpec.getEntityName();
        for (EntitySpec es : entitySpecs) {
            if (!es.getName().equals(referenceSpecEntityName)) continue;
            return es;
        }
        throw new AssertionError((Object)("invalid entity spec name in reference spec " + referenceSpec));
    }

    private static int processUniqueIds(EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i, ColumnSpecInfo columnSpecInfo, ReferenceSpec referenceSpec) {
        ColumnSpec[] codeSpecs = entitySpec.getUniqueIdSpecs();
        ColumnSpec[] refSpecs = null;
        if (referenceSpec != null) {
            refSpecs = referenceSpec.getUniqueIdSpecs();
        }
        int numUniqueIndices = codeSpecs.length;
        if (refSpecs != null) {
            numUniqueIndices += refSpecs.length;
        }
        int[] uniqueIndices = new int[numUniqueIndices];
        int j = 0;
        if (codeSpecs != null && uniqueIndices != null) {
            for (ColumnSpec uniqueIdSpec : codeSpecs) {
                uniqueIndices[j++] = (i += ColumnSpecInfoFactory.wrapColumnSpec(uniqueIdSpec, columnSpecs)) - 1;
            }
        }
        if (refSpecs != null && uniqueIndices != null) {
            for (ColumnSpec uniqueIdSpec : refSpecs) {
                uniqueIndices[j++] = (i += ColumnSpecInfoFactory.wrapColumnSpec(uniqueIdSpec, columnSpecs)) - 1;
            }
        }
        if (uniqueIndices != null) {
            columnSpecInfo.setUniqueIdIndices(uniqueIndices);
        }
        return i;
    }

    private static int processCodeSpec(Set<String> propIds, EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i, ColumnSpecInfo columnSpecInfo, ReferenceSpec referenceSpec) {
        ColumnSpec codeSpec = entitySpec.getCodeSpec();
        if (codeSpec != null) {
            List<ColumnSpec> specAsList = codeSpec.asList();
            int specAsListSize = specAsList.size();
            ColumnSpec lastColumnSpec = specAsList.get(specAsListSize - 1);
            if (referenceSpec == null || lastColumnSpec.getConstraint() != Operator.EQUAL_TO || !lastColumnSpec.isPropositionIdsComplete() || AbstractSQLGenerator.needsPropIdInClause(propIds, entitySpec.getPropositionIds())) {
                i += ColumnSpecInfoFactory.wrapColumnSpec(codeSpec, columnSpecs);
            } else {
                codeSpec = null;
            }
        }
        if (codeSpec != null && referenceSpec == null) {
            columnSpecInfo.setCodeIndex(i - 1);
        }
        return i;
    }

    private static int processConstraintSpecs(EntitySpec entitySpec, Collection<EntitySpec> entitySpecs, List<IntColumnSpecWrapper> columnSpecs, int i) {
        LinkedList<EntitySpec> l = new LinkedList<EntitySpec>();
        l.add(entitySpec);
        for (EntitySpec es : entitySpecs) {
            if (!es.hasReferenceTo((EntitySpec)l.get(0))) continue;
            l.add(0, es);
        }
        for (EntitySpec es : l) {
            ColumnSpec[] constraintSpecs;
            for (ColumnSpec spec : constraintSpecs = es.getConstraintSpecs()) {
                i += ColumnSpecInfoFactory.wrapColumnSpec(spec, columnSpecs);
            }
        }
        return i;
    }

    private static int processFilters(EntitySpec entitySpec, Collection<EntitySpec> entitySpecs, Collection<Filter> filters, List<IntColumnSpecWrapper> columnSpecs, int i) {
        assert (!columnSpecs.isEmpty()) : "columnSpecs should be populated by now";
        LinkedList<EntitySpec> l = new LinkedList<EntitySpec>();
        l.add(entitySpec);
        for (EntitySpec es : entitySpecs) {
            if (!es.hasReferenceTo((EntitySpec)l.get(0))) continue;
            l.add(0, es);
        }
        for (Filter filter : filters) {
            for (EntitySpec mes : l) {
                if (!org.arp.javautil.collections.Collections.containsAny((Set)Arrays.asSet((Object[])mes.getPropositionIds()), (Object[])filter.getPropositionIds())) continue;
                if (filter instanceof PositionFilter) {
                    ColumnSpec finishTimeSpec;
                    PositionFilter pf = (PositionFilter)filter;
                    ColumnSpec startTimeSpec = mes.getStartTimeSpec();
                    if (startTimeSpec != null && (pf.getStartSide() == Interval.Side.START && pf.getStart() != null || pf.getFinish() != null && (pf.getFinishSide() == Interval.Side.START || mes.getFinishTimeSpec() == null && pf.getFinishSide() == Interval.Side.FINISH))) {
                        i += ColumnSpecInfoFactory.wrapColumnSpec(startTimeSpec, columnSpecs);
                    }
                    if ((finishTimeSpec = mes.getFinishTimeSpec()) == null || (pf.getStartSide() != Interval.Side.FINISH || pf.getStart() == null) && (pf.getFinishSide() != Interval.Side.FINISH || pf.getFinish() == null)) continue;
                    i += ColumnSpecInfoFactory.wrapColumnSpec(finishTimeSpec, columnSpecs);
                    continue;
                }
                if (!(filter instanceof PropertyValueFilter)) continue;
                PropertyValueFilter pvf = (PropertyValueFilter)filter;
                for (PropertySpec propertySpec : mes.getPropertySpecs()) {
                    if (!propertySpec.getName().equals(pvf.getProperty())) continue;
                    i += ColumnSpecInfoFactory.wrapColumnSpec(propertySpec.getCodeSpec(), columnSpecs);
                }
            }
        }
        return i;
    }

    private static int processPropertyAndValueSpecs(EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i, ColumnSpecInfo columnSpecInfo) {
        ColumnSpec valueSpec;
        PropertySpec[] propertySpecs = entitySpec.getPropertySpecs();
        HashMap<String, Integer> propertyIndices = new HashMap<String, Integer>();
        for (PropertySpec propertySpec : propertySpecs) {
            ColumnSpec codeSpec = propertySpec.getCodeSpec();
            propertyIndices.put(propertySpec.getName(), (i += ColumnSpecInfoFactory.wrapColumnSpec(codeSpec, columnSpecs)) - 1);
            i += ColumnSpecInfoFactory.wrapPropertySpecConstraintSpec(propertySpec, columnSpecs);
        }
        if (propertySpecs.length > 0) {
            columnSpecInfo.setPropertyIndices(propertyIndices);
        }
        if ((valueSpec = entitySpec.getValueSpec()) != null) {
            columnSpecInfo.setValueIndex((i += ColumnSpecInfoFactory.wrapColumnSpec(valueSpec, columnSpecs)) - 1);
        }
        return i;
    }

    private static int processReferenceSpecs(EntitySpec lhsEntitySpec, EntitySpec rhsEntitySpec, List<IntColumnSpecWrapper> columnSpecs, int refNum, int i, ColumnSpecInfo columnSpecInfo) {
        if (lhsEntitySpec.hasReferenceTo(rhsEntitySpec)) {
            for (ColumnSpec referringUniqueIdSpec : lhsEntitySpec.getUniqueIdSpecs()) {
                i += ColumnSpecInfoFactory.wrapColumnSpec(referringUniqueIdSpec, columnSpecs);
            }
            if (columnSpecInfo.getReferenceIndices() == null) {
                columnSpecInfo.setReferenceIndices(new HashMap<String, Integer>());
            }
            columnSpecInfo.getReferenceIndices().put("ref" + refNum, i - 1);
        }
        return i;
    }

    private static int processFinishTimeSpec(EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i, ColumnSpecInfo columnSpecInfo, ReferenceSpec referenceSpec) {
        ColumnSpec spec = entitySpec.getFinishTimeSpec();
        if (spec != null) {
            i += ColumnSpecInfoFactory.wrapColumnSpec(spec, columnSpecs);
            if (referenceSpec == null) {
                columnSpecInfo.setFinishTimeIndex(i - 1);
            }
        }
        return i;
    }

    private static int processStartTimeOrTimestamp(EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i, ColumnSpecInfo columnSpecInfo, ReferenceSpec referenceSpec) {
        ColumnSpec spec = entitySpec.getStartTimeSpec();
        if (spec != null) {
            i += ColumnSpecInfoFactory.wrapColumnSpec(spec, columnSpecs);
            if (referenceSpec == null) {
                columnSpecInfo.setStartTimeIndex(i - 1);
            }
        }
        return i;
    }

    private static int processCreateDate(EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i, ColumnSpecInfo columnSpecInfo, ReferenceSpec referenceSpec) {
        ColumnSpec spec = entitySpec.getCreateDateSpec();
        if (spec != null) {
            i += ColumnSpecInfoFactory.wrapColumnSpec(spec, columnSpecs);
            if (referenceSpec == null) {
                columnSpecInfo.setCreateDateIndex(i - 1);
            }
        }
        return i;
    }

    private static int processUpdateDate(EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i, ColumnSpecInfo columnSpecInfo, ReferenceSpec referenceSpec) {
        ColumnSpec spec = entitySpec.getUpdateDateSpec();
        if (spec != null) {
            i += ColumnSpecInfoFactory.wrapColumnSpec(spec, columnSpecs);
            if (referenceSpec == null) {
                columnSpecInfo.setUpdateDateIndex(i - 1);
            }
        }
        return i;
    }

    private static int processDeleteDate(EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i, ColumnSpecInfo columnSpecInfo, ReferenceSpec referenceSpec) {
        ColumnSpec spec = entitySpec.getDeleteDateSpec();
        if (spec != null) {
            i += ColumnSpecInfoFactory.wrapColumnSpec(spec, columnSpecs);
            if (referenceSpec == null) {
                columnSpecInfo.setDeleteDateIndex(i - 1);
            }
        }
        return i;
    }

    private static int wrapPropertySpecConstraintSpec(PropertySpec propertySpec, List<IntColumnSpecWrapper> columnSpecs) {
        ColumnSpec lastSpec = propertySpec.getCodeSpec().getLastSpec();
        return ColumnSpecInfoFactory.wrapColumnSpecsHelper(propertySpec.getConstraintSpec(), lastSpec, columnSpecs);
    }

    private static int wrapColumnSpec(ColumnSpec spec, List<IntColumnSpecWrapper> columnSpecs) {
        return ColumnSpecInfoFactory.wrapColumnSpecsHelper(spec, null, columnSpecs);
    }

    private static int wrapColumnSpecsHelper(ColumnSpec spec, ColumnSpec lastSpec, List<IntColumnSpecWrapper> columnSpecs) {
        boolean first = true;
        List<Object> asList = spec != null ? spec.asList() : Collections.emptyList();
        for (ColumnSpec columnSpec : asList) {
            IntColumnSpecWrapper w = new IntColumnSpecWrapper(columnSpec);
            if (first) {
                w.setIsSameAs(lastSpec);
                first = false;
            }
            columnSpecs.add(w);
        }
        return asList.size();
    }

    private static int processBaseSpec(EntitySpec entitySpec, List<IntColumnSpecWrapper> columnSpecs, int i) {
        ColumnSpec spec = entitySpec.getBaseSpec();
        List<ColumnSpec> specAsList = spec.asList();
        for (ColumnSpec cs : specAsList) {
            IntColumnSpecWrapper w = new IntColumnSpecWrapper(cs);
            columnSpecs.add(w);
        }
        return i += specAsList.size();
    }
}

