/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.protempa.backend.dsb.relationaldb.JDBCPositionFormat;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;

public class JDBCDecimalDayParser
implements JDBCPositionFormat {
    private static final Calendar calendar = Calendar.getInstance();
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long toPosition(ResultSet resultSet, int columnIndex, int colType) throws SQLException {
        int date = resultSet.getInt(columnIndex);
        if (date < 10000000) {
            return null;
        }
        int year = date / 10000;
        int monthDay = date - year * 10000;
        int month = monthDay / 100;
        int day = monthDay - month * 100;
        Calendar calendar = JDBCDecimalDayParser.calendar;
        synchronized (calendar) {
            JDBCDecimalDayParser.calendar.clear();
            JDBCDecimalDayParser.calendar.set(year, month - 1, day);
            return AbsoluteTimeGranularityUtil.asPosition((Date)JDBCDecimalDayParser.calendar.getTime());
        }
    }

    @Override
    public String format(Long position) {
        Date date = AbsoluteTimeGranularityUtil.asDate((Long)position);
        return DATE_FORMAT.get().format(date);
    }
}

