/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.DataSourceReadException;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.StreamingResultProcessor;

public class StreamingSQLExecutor {
    private final Connection connection;
    private final String backendNameForMessages;

    StreamingSQLExecutor(Connection connection, String backendNameForMessages, Integer timeout) {
        this.connection = connection;
        this.backendNameForMessages = backendNameForMessages;
    }

    Connection getConnection() {
        return this.connection;
    }

    void executeSelect(String entitySpecName, String query, StreamingResultProcessor<?> resultProcessor) throws DataSourceReadException {
        Logger logger = SQLGenUtil.logger();
        if (this.connection == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Data source backend {0} is skipping query for {1}", new Object[]{this.backendNameForMessages, entitySpecName});
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Data source backend {0} is executing query for {1}", new Object[]{this.backendNameForMessages, entitySpecName});
            }
            try {
                Statement stmt = this.connection.createStatement();
                stmt.setFetchSize(10000);
                ResultSet resultSet = stmt.executeQuery(query);
                resultProcessor.setStatement(stmt);
                resultProcessor.process(resultSet);
            }
            catch (SQLException ex) {
                throw new DataSourceReadException("Error retrieving " + entitySpecName + " from data source backend " + this.backendNameForMessages, (Throwable)ex);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Query for {0} in data source backend {1} is complete", new Object[]{entitySpecName, this.backendNameForMessages});
            }
        }
    }
}

