/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.collections.Iterators;
import org.arp.javautil.log.Logging;
import org.protempa.AbstractionFinder;
import org.protempa.CloseException;
import org.protempa.CreateRuleBaseException;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEvent;
import org.protempa.DataStreamingEventIterator;
import org.protempa.DerivationsBuilder;
import org.protempa.ExecutionStrategy;
import org.protempa.ExecutorStrategy;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceImplWrapper;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaAlreadyClosedException;
import org.protempa.ProtempaUtil;
import org.protempa.QueryException;
import org.protempa.QuerySession;
import org.protempa.QueueObject;
import org.protempa.StatefulExecutionStrategy;
import org.protempa.StatelessExecutionStrategy;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.dest.Destination;
import org.protempa.dest.GetSupportedPropositionIdsException;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerCloseException;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.dest.QueryResultsHandlerValidationFailedException;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.query.And;
import org.protempa.query.Query;

final class Executor
implements AutoCloseable {
    private static final Logger LOGGER = ProtempaUtil.logger();
    private final Set<String> keyIds;
    private final Set<String> propIds;
    private Set<String> propIdsToRetain;
    private final Set<And<String>> termIds;
    private final Filter filters;
    private final PropositionDefinition[] propDefs;
    private final KnowledgeSource ks;
    private final Query query;
    private final QuerySession qs;
    private DerivationsBuilder derivationsBuilder;
    private final ExecutorStrategy strategy;
    private Collection<PropositionDefinition> allNarrowerDescendants;
    private final AbstractionFinder abstractionFinder;
    private ExecutionStrategy executionStrategy = null;
    private final ExecutorCounter counter = new ExecutorCounter();
    private final List<QueryException> exceptions;
    private final Destination destination;
    private QueryResultsHandler resultsHandler;
    private boolean failed;
    private final MessageFormat logMessageFormat;
    private Thread handleQueryResultThread;
    private boolean canceled;

    Executor(Query query, Destination resultsHandlerFactory, QuerySession querySession, AbstractionFinder abstractionFinder) throws QueryException {
        this(query, resultsHandlerFactory, querySession, null, abstractionFinder);
    }

    Executor(Query query, Destination resultsHandlerFactory, QuerySession querySession, ExecutorStrategy strategy, AbstractionFinder abstractionFinder) throws QueryException {
        this.abstractionFinder = abstractionFinder;
        assert (query != null) : "query cannot be null";
        assert (resultsHandlerFactory != null) : "resultsHandlerFactory cannot be null";
        assert (abstractionFinder != null) : "abstractionFinder cannot be null";
        if (abstractionFinder.isClosed()) {
            throw new QueryException(query.getName(), new ProtempaAlreadyClosedException());
        }
        this.keyIds = Arrays.asSet((Object[])query.getKeyIds());
        this.propIds = Arrays.asSet((Object[])query.getPropositionIds());
        this.termIds = Arrays.asSet((Object[])query.getTermIds());
        this.filters = query.getFilters();
        this.propDefs = query.getPropositionDefinitions();
        this.ks = this.propDefs != null && this.propDefs.length > 0 ? new KnowledgeSourceImplWrapper(abstractionFinder.getKnowledgeSource(), this.propDefs) : abstractionFinder.getKnowledgeSource();
        this.query = query;
        this.qs = querySession;
        this.derivationsBuilder = new DerivationsBuilder();
        this.strategy = strategy;
        this.destination = resultsHandlerFactory;
        this.exceptions = Collections.synchronizedList(new ArrayList());
        this.logMessageFormat = new MessageFormat("Query " + this.query.getName() + ": {0}");
    }

    void init() throws QueryException {
        this.log(Level.FINE, "Initializing query results handler...");
        try {
            this.resultsHandler = this.destination.getQueryResultsHandler(this.getQuery(), this.abstractionFinder.getDataSource(), this.getKnowledgeSource());
            this.log(Level.FINE, "Got query results handler {0}", this.resultsHandler.getId());
            this.log(Level.FINE, "Validating query results handler");
            this.resultsHandler.validate();
            this.log(Level.FINE, "Query results handler validated successfully");
            String[] supportedPropositionIds = this.destination.getSupportedPropositionIds(this.abstractionFinder.getDataSource(), this.abstractionFinder.getKnowledgeSource());
            this.setPropIdsToRetain(supportedPropositionIds);
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "Propositions to be queried are {0}", StringUtils.join(this.propIds, (String)", "));
            }
            this.retain(this.ks.collectPropDefDescendantsUsingAllNarrower(false, this.propIds.toArray(new String[this.propIds.size()])));
            if (this.isLoggable(Level.FINE)) {
                HashSet<String> allNarrowerDescendantsPropIds = new HashSet<String>();
                for (PropositionDefinition pd : this.allNarrowerDescendants) {
                    allNarrowerDescendantsPropIds.add(pd.getId());
                }
                this.log(Level.FINE, "Proposition details: {0}", StringUtils.join(allNarrowerDescendantsPropIds, (String)", "));
            }
            if (this.strategy != null) {
                this.log(Level.FINE, "Setting execution strategy...");
                switch (this.strategy) {
                    case STATELESS: {
                        this.executionStrategy = this.newStatelessStrategy();
                        break;
                    }
                    case STATEFUL: {
                        this.executionStrategy = this.newStatefulStrategy();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Invalid execution strategy: " + (Object)((Object)this.strategy)));
                    }
                }
                this.log(Level.FINE, "Execution strategy is set to {0}", (Object)this.strategy);
            }
            this.log(Level.FINE, "Calling query results handler start...");
            this.resultsHandler.start(this.getAllNarrowerDescendants());
            this.log(Level.FINE, "Query results handler started");
            this.log(Level.FINE, "Query results handler waiting for results...");
        }
        catch (Error | RuntimeException | KnowledgeSourceReadException | GetSupportedPropositionIdsException | QueryResultsHandlerInitException | QueryResultsHandlerProcessingException | QueryResultsHandlerValidationFailedException ex) {
            this.failed = true;
            throw new QueryException(this.query.getName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Executor executor = this;
        synchronized (executor) {
            if (this.handleQueryResultThread != null) {
                this.handleQueryResultThread.interrupt();
            }
            this.canceled = true;
        }
        this.log(Level.INFO, "Canceled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() throws QueryException {
        try {
            DoProcessThread doProcessThread;
            RetrieveDataThread retrieveDataThread;
            Executor executor = this;
            synchronized (executor) {
                if (this.canceled) {
                    return;
                }
                this.log(Level.INFO, "Processing data");
                DataStreamingEvent doProcessPoisonPill = new DataStreamingEvent("poison", Collections.emptyList());
                QueueObject hqrPoisonPill = new QueueObject();
                ArrayBlockingQueue<DataStreamingEvent> doProcessQueue = new ArrayBlockingQueue<DataStreamingEvent>(1000);
                ArrayBlockingQueue<QueueObject> hqrQueue = new ArrayBlockingQueue<QueueObject>(1000);
                retrieveDataThread = new RetrieveDataThread(doProcessQueue, doProcessPoisonPill);
                doProcessThread = new DoProcessThread(doProcessQueue, hqrQueue, doProcessPoisonPill, hqrPoisonPill, retrieveDataThread);
                this.handleQueryResultThread = new HandleQueryResultThread(hqrQueue, hqrPoisonPill, doProcessThread);
                retrieveDataThread.start();
                doProcessThread.start();
                this.handleQueryResultThread.start();
            }
            try {
                retrieveDataThread.join();
                this.log(Level.INFO, "Done retrieving data");
            }
            catch (InterruptedException ex) {
                this.log(Level.FINER, "Protempa producer thread join interrupted", ex);
            }
            try {
                doProcessThread.join();
                this.log(Level.INFO, "Done processing data");
            }
            catch (InterruptedException ex) {
                this.log(Level.FINER, "Protempa consumer thread join interrupted", ex);
            }
            try {
                this.handleQueryResultThread.join();
                this.log(Level.INFO, "Done outputting results");
            }
            catch (InterruptedException ex) {
                this.log(Level.FINER, "Protempa consumer thread join interrupted", ex);
            }
            if (!this.exceptions.isEmpty()) {
                throw this.exceptions.get(0);
            }
        }
        catch (QueryException ex) {
            this.failed = true;
            throw ex;
        }
    }

    @Override
    public void close() throws CloseException {
        if (this.executionStrategy != null) {
            this.executionStrategy.cleanup();
        }
        try {
            if (this.resultsHandler != null) {
                if (!this.failed) {
                    this.resultsHandler.finish();
                }
                this.resultsHandler.close();
                this.resultsHandler = null;
            }
        }
        catch (QueryResultsHandlerCloseException | QueryResultsHandlerProcessingException ex) {
            throw new CloseException(ex);
        }
        finally {
            if (this.resultsHandler != null) {
                try {
                    this.resultsHandler.close();
                }
                catch (QueryResultsHandlerCloseException queryResultsHandlerCloseException) {}
            }
        }
    }

    ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    int getCount() {
        return this.counter.getCount();
    }

    Query getQuery() {
        return this.query;
    }

    Set<String> getPropIds() {
        return this.propIds;
    }

    Collection<PropositionDefinition> getAllNarrowerDescendants() {
        return this.allNarrowerDescendants;
    }

    Filter getFilters() {
        return this.filters;
    }

    Set<String> getKeyIds() {
        return this.keyIds;
    }

    void setPropIdsToRetain(String[] propIds) {
        this.propIdsToRetain = propIds == null || propIds.length == 0 ? null : Arrays.asSet((Object[])propIds);
        this.allNarrowerDescendants = null;
    }

    DerivationsBuilder getDerivationsBuilder() {
        return this.derivationsBuilder;
    }

    KnowledgeSource getKnowledgeSource() {
        return this.ks;
    }

    QuerySession getQuerySession() {
        return this.qs;
    }

    boolean isLoggable(Level level) {
        return LOGGER.isLoggable(level);
    }

    void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LOGGER.log(level, this.logMessageFormat.format(new Object[]{msg}), params);
        }
    }

    void log(Level level, String msg, Object param) {
        if (this.isLoggable(level)) {
            LOGGER.log(level, this.logMessageFormat.format(new Object[]{msg}), param);
        }
    }

    void log(Level level, String msg, Throwable throwable) {
        if (this.isLoggable(level)) {
            LOGGER.log(level, this.logMessageFormat.format(new Object[]{msg}), throwable);
        }
    }

    void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            LOGGER.log(level, this.logMessageFormat.format(new Object[]{msg}));
        }
    }

    void logCount(Level level, int count, String singularMsg, String pluralMsg, Object[] singularParams, Object[] pluralParams) {
        if (this.isLoggable(level)) {
            Logging.logCount((Logger)LOGGER, (Level)level, (int)count, (String)this.logMessageFormat.format(new Object[]{singularMsg}), (String)this.logMessageFormat.format(new Object[]{pluralMsg}), (Object[])singularParams, (Object[])pluralParams);
        }
    }

    private DataStreamingEventIterator<Proposition> newDataIterator() throws QueryException {
        DataStreamingEventIterator<Proposition> itr;
        this.log(Level.INFO, "Retrieving data");
        HashSet<String> inDataSourcePropIds = new HashSet<String>();
        for (PropositionDefinition pd : this.allNarrowerDescendants) {
            if (!pd.getInDataSource()) continue;
            inDataSourcePropIds.add(pd.getId());
        }
        if (this.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "Asking data source for {0}", StringUtils.join(inDataSourcePropIds, (String)", "));
        }
        try {
            itr = this.abstractionFinder.getDataSource().readPropositions(this.keyIds, inDataSourcePropIds, this.filters, this.getQuerySession(), this.resultsHandler);
        }
        catch (DataSourceReadException ex) {
            throw new QueryException(this.query.getName(), ex);
        }
        return itr;
    }

    private void retain(Set<PropositionDefinition> propDefs) {
        if (this.propIdsToRetain != null) {
            String pid;
            HashMap<String, PropositionDefinition> propDefMap = new HashMap<String, PropositionDefinition>();
            for (PropositionDefinition and : propDefs) {
                propDefMap.put(and.getId(), and);
            }
            LinkedList<String> propIdsQueue = new LinkedList<String>(this.propIds);
            HashSet<PropositionDefinition> propDefsToKeep = new HashSet<PropositionDefinition>();
            while ((pid = (String)propIdsQueue.poll()) != null) {
                if (this.propIdsToRetain.contains(pid)) {
                    String pid2;
                    LinkedList<String> propIdsToKeep = new LinkedList<String>();
                    propIdsToKeep.add(pid);
                    while ((pid2 = (String)propIdsToKeep.poll()) != null) {
                        PropositionDefinition get = (PropositionDefinition)propDefMap.get(pid2);
                        propDefsToKeep.add(get);
                        Arrays.addAll(propIdsToKeep, (Object[][])new String[][]{get.getChildren()});
                    }
                    continue;
                }
                PropositionDefinition get = (PropositionDefinition)propDefMap.get(pid);
                Arrays.addAll(propIdsQueue, (Object[][])new String[][]{get.getChildren()});
            }
            this.allNarrowerDescendants = propDefsToKeep;
        } else {
            this.allNarrowerDescendants = propDefs;
        }
    }

    private StatelessExecutionStrategy newStatelessStrategy() throws QueryException {
        StatelessExecutionStrategy result = new StatelessExecutionStrategy(this.abstractionFinder, this.abstractionFinder.getAlgorithmSource());
        try {
            this.createRuleBase(result);
        }
        catch (CreateRuleBaseException ex) {
            throw new QueryException(this.query.getName(), ex);
        }
        result.initialize();
        return result;
    }

    private StatefulExecutionStrategy newStatefulStrategy() throws QueryException {
        StatefulExecutionStrategy result = new StatefulExecutionStrategy(this.abstractionFinder.getAlgorithmSource());
        try {
            this.createRuleBase(result);
        }
        catch (CreateRuleBaseException ex) {
            throw new QueryException(this.query.getName(), ex);
        }
        result.initialize();
        return result;
    }

    private void createRuleBase(ExecutionStrategy result) throws CreateRuleBaseException {
        this.log(Level.FINEST, "Initializing rule base");
        result.createRuleBase(this.allNarrowerDescendants, this.derivationsBuilder, this.qs);
        this.abstractionFinder.clear();
        this.log(Level.FINEST, "Rule base initialized");
    }

    private class HandleQueryResultThread
    extends Thread {
        private final BlockingQueue<QueueObject> queue;
        private final Thread producerThread;
        private final QueueObject poisonPill;

        HandleQueryResultThread(BlockingQueue<QueueObject> queue, QueueObject poisonPill, Thread producerThread) {
            super("protempa.executor.HandleQueryResultThread");
            this.queue = queue;
            this.producerThread = producerThread;
            this.poisonPill = poisonPill;
        }

        @Override
        public void run() {
            Executor.this.log(Level.FINER, "Start handle query results thread");
            try {
                QueueObject qo;
                while ((qo = this.queue.take()) != this.poisonPill) {
                    Executor.this.log(Level.FINER, "Handling some results");
                    try {
                        Executor.this.resultsHandler.handleQueryResult(qo.keyId, qo.propositions, qo.forwardDerivations, qo.backwardDerivations, qo.refs);
                    }
                    catch (QueryResultsHandlerProcessingException ex) {
                        Executor.this.log(Level.FINER, "Handle query results threw QueryResultsHandlerProcessingException", ex);
                        Executor.this.exceptions.add(new QueryException(Executor.this.query.getName(), ex));
                        this.producerThread.interrupt();
                        break;
                    }
                    catch (Error | RuntimeException t) {
                        Executor.this.log(Level.FINER, "Handle query results threw exception", t);
                        Executor.this.exceptions.add(new QueryException(Executor.this.query.getName(), new QueryResultsHandlerProcessingException(t)));
                        this.producerThread.interrupt();
                        break;
                    }
                    Executor.this.log(Level.FINER, "Results passed to query result handler");
                }
            }
            catch (InterruptedException ex) {
                Executor.this.log(Level.FINER, "Handle query results thread interrupted", ex);
                this.producerThread.interrupt();
            }
            Executor.this.log(Level.FINER, "End handle query results thread");
        }
    }

    private class DoProcessThread
    extends Thread {
        private final BlockingQueue<DataStreamingEvent> doProcessQueue;
        private final BlockingQueue<QueueObject> hqrQueue;
        private final QueueObject hqrPoisonPill;
        private final DataStreamingEvent doProcessPoisonPill;
        private final Thread producer;

        DoProcessThread(BlockingQueue<DataStreamingEvent> doProcessQueue, BlockingQueue<QueueObject> hqrQueue, DataStreamingEvent doProcessPoisonPill, QueueObject hqrPoisonPill, Thread producer) {
            super("protempa.executor.DoProcessThread");
            this.doProcessQueue = doProcessQueue;
            this.hqrQueue = hqrQueue;
            this.doProcessPoisonPill = doProcessPoisonPill;
            this.producer = producer;
            this.hqrPoisonPill = hqrPoisonPill;
        }

        @Override
        public void run() {
            Executor.this.log(Level.FINER, "Start do process thread");
            try {
                DataStreamingEvent dse;
                while (!this.isInterrupted() && (dse = this.doProcessQueue.take()) != this.doProcessPoisonPill) {
                    String keyId = dse.getKeyId();
                    ExecutionStrategy strategy = Executor.this.getExecutionStrategy();
                    Iterator<Object> resultsItr = strategy != null ? strategy.execute(keyId, Executor.this.propIds, dse.getData(), null) : dse.getData().iterator();
                    Map<Proposition, List<Proposition>> forwardDerivations = Executor.this.derivationsBuilder.toForwardDerivations();
                    Map<Proposition, List<Proposition>> backwardDerivations = Executor.this.derivationsBuilder.toBackwardDerivations();
                    QuerySession qs = Executor.this.getQuerySession();
                    if (qs.isCachingEnabled()) {
                        List props = Iterators.asList(resultsItr);
                        this.addToCache(qs, Collections.unmodifiableList(props), Collections.unmodifiableMap(forwardDerivations), Collections.unmodifiableMap(backwardDerivations));
                        resultsItr = props.iterator();
                    }
                    HashMap<UniqueId, Proposition> refs = new HashMap<UniqueId, Proposition>();
                    List<Proposition> filteredPropositions = this.extractRequestedPropositions(resultsItr, refs);
                    if (Executor.this.isLoggable(Level.FINEST)) {
                        Executor.this.log(Level.FINEST, "Proposition ids: {0}", Executor.this.propIds);
                        Executor.this.log(Level.FINEST, "Filtered propositions: {0}", filteredPropositions);
                        Executor.this.log(Level.FINEST, "Forward derivations: {0}", forwardDerivations);
                        Executor.this.log(Level.FINEST, "Backward derivations: {0}", backwardDerivations);
                        Executor.this.log(Level.FINEST, "References: {0}", refs);
                    }
                    this.hqrQueue.put(new QueueObject(keyId, filteredPropositions, forwardDerivations, backwardDerivations, refs));
                    Executor.this.log(Level.FINER, "Results put on query result handler queue");
                    Executor.this.counter.incr();
                    Executor.this.derivationsBuilder.reset();
                }
                this.hqrQueue.put(this.hqrPoisonPill);
            }
            catch (QueryException ex) {
                Executor.this.log(Level.FINER, "Do process thread threw ExecutorExecuteException", ex);
                Executor.this.exceptions.add(ex);
                this.producer.interrupt();
                try {
                    this.hqrQueue.put(this.hqrPoisonPill);
                }
                catch (InterruptedException ignore) {
                    Executor.this.log(Level.SEVERE, "Failed to stop the query results handler queue; the query may be hung", ignore);
                }
            }
            catch (InterruptedException ex) {
                Executor.this.log(Level.FINER, "Do process thread interrupted", ex);
                this.producer.interrupt();
            }
            catch (Error | RuntimeException t) {
                Executor.this.log(Level.SEVERE, "Do process thread threw exception; the query may be hung", t);
                throw t;
            }
            Executor.this.log(Level.FINER, "End do process thread");
        }

        private List<Proposition> extractRequestedPropositions(Iterator<Proposition> propositions, Map<UniqueId, Proposition> refs) {
            ArrayList<Proposition> result = new ArrayList<Proposition>();
            while (!this.isInterrupted() && propositions.hasNext()) {
                Proposition prop = propositions.next();
                refs.put(prop.getUniqueId(), prop);
                if (!Executor.this.propIds.contains(prop.getId())) continue;
                result.add(prop);
            }
            return result;
        }

        private void addToCache(QuerySession qs, List<Proposition> propositions, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations) {
            qs.addPropositionsToCache(propositions);
            for (Map.Entry<Proposition, List<Proposition>> me : forwardDerivations.entrySet()) {
                qs.addDerivationsToCache(me.getKey(), me.getValue());
            }
            for (Map.Entry<Proposition, List<Proposition>> me : backwardDerivations.entrySet()) {
                qs.addDerivationsToCache(me.getKey(), me.getValue());
            }
        }
    }

    private class RetrieveDataThread
    extends Thread {
        private final BlockingQueue<DataStreamingEvent> queue;
        private final DataStreamingEvent poisonPill;
        private final DataStreamingEventIterator<Proposition> itr;

        RetrieveDataThread(BlockingQueue<DataStreamingEvent> queue, DataStreamingEvent poisonPill) throws QueryException {
            super("protempa.executor.RetrieveDataThread");
            this.queue = queue;
            this.poisonPill = poisonPill;
            this.itr = Executor.this.newDataIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Executor.this.log(Level.FINER, "Start retrieve data thread");
            boolean itrClosed = false;
            try {
                while (!this.isInterrupted() && this.itr.hasNext()) {
                    this.queue.put(this.itr.next());
                }
                this.itr.close();
                this.queue.put(this.poisonPill);
                itrClosed = true;
            }
            catch (DataSourceReadException ex) {
                Executor.this.exceptions.add(new QueryException(Executor.this.query.getName(), ex));
                try {
                    this.queue.put(this.poisonPill);
                }
                catch (InterruptedException ignore) {
                    Executor.this.log(Level.SEVERE, "Failed to send stop message to the do process thread; the query may be hung", ignore);
                }
            }
            catch (Error | RuntimeException ex) {
                Executor.this.exceptions.add(new QueryException(Executor.this.query.getName(), ex));
                try {
                    this.queue.put(this.poisonPill);
                }
                catch (InterruptedException ignore) {
                    Executor.this.log(Level.SEVERE, "Failed to send stop message to the do process thread; the query may be hung", ignore);
                }
            }
            catch (InterruptedException ex) {
                Executor.this.log(Level.FINER, "Retrieve data thread interrupted", ex);
            }
            finally {
                if (!itrClosed) {
                    try {
                        this.itr.close();
                    }
                    catch (DataSourceReadException ex) {}
                }
            }
            Executor.this.log(Level.FINER, "End retrieve data thread");
        }
    }

    private class ExecutorCounter {
        private int count;

        ExecutorCounter() {
        }

        void incr() throws QueryException {
            if (++this.count % 1000 == 0) {
                this.logNumProcessed(this.count);
            }
        }

        int getCount() {
            return this.count;
        }

        private void logNumProcessed(int numProcessed) throws QueryException {
            if (Executor.this.isLoggable(Level.FINE)) {
                try {
                    String keyTypeSingDisplayName = Executor.this.abstractionFinder.getDataSource().getKeyTypeDisplayName();
                    String keyTypePluralDisplayName = Executor.this.abstractionFinder.getDataSource().getKeyTypePluralDisplayName();
                    Executor.this.logCount(Level.FINE, numProcessed, "Processed {0} {1}", "Processed {0} {1}", new Object[]{keyTypeSingDisplayName}, new Object[]{keyTypePluralDisplayName});
                }
                catch (DataSourceReadException ex) {
                    throw new QueryException(Executor.this.query.getName(), ex);
                }
            }
        }
    }
}

