/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.arp.javautil.graph.Weight;
import org.arp.javautil.graph.WeightFactory;
import org.protempa.proposition.interval.IntervalUtil;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Unit;

public abstract class Interval
implements Comparable<Interval> {
    private static final WeightFactory weightFactory = new WeightFactory();
    private Long minStart;
    private Long maxStart;
    private Granularity startGranularity;
    private Long minFinish;
    private Long maxFinish;
    private Granularity finishGranularity;
    private Long minLength;
    private Long maxLength;
    private Unit lengthUnit;
    private Start start;
    private Finish finish;
    protected Long[] v;
    private Weight[] vw;
    private volatile int hashCode;
    private boolean minLengthComputed;
    private boolean maxLengthComputed;

    Interval() {
        this(null, null, null, null, null, null);
    }

    Interval(Long start, Granularity startGranularity, Long finish, Granularity finishGranularity, Long length, Unit lengthUnit) {
        this(start, start, startGranularity, finish, finish, finishGranularity, length, length, lengthUnit);
    }

    Interval(Long minStart, Long maxStart, Granularity startGranularity, Long minFinish, Long maxFinish, Granularity finishGranularity, Long minLength, Long maxLength, Unit lengthUnit) {
        this.init(minStart, maxStart, startGranularity, minFinish, maxFinish, finishGranularity, minLength, maxLength, lengthUnit);
    }

    protected void init(Long start, Granularity startGranularity, Long finish, Granularity finishGranularity, Long length, Unit lengthUnit) {
        this.init(start, start, startGranularity, finish, finish, finishGranularity, length, length, lengthUnit);
    }

    protected void init(Long minStart, Long maxStart, Granularity startGranularity, Long minFinish, Long maxFinish, Granularity finishGranularity, Long minLength, Long maxLength, Unit lengthUnit) {
        if (minStart != null && maxFinish != null && minStart > maxFinish) {
            throw new IllegalArgumentException("maxFinish cannot be before minStart; maxFinish=" + maxFinish + "; minStart=" + minStart);
        }
        if (minLength != null && minLength < 0L) {
            throw new IllegalArgumentException("minLength must be positive or 0 but was " + minLength);
        }
        if (maxLength != null && maxLength < 0L) {
            throw new IllegalArgumentException("maxLength must be positive or 0 but was " + maxLength);
        }
        this.minStart = minStart;
        this.maxStart = maxStart;
        this.startGranularity = startGranularity;
        this.minFinish = minFinish;
        this.maxFinish = maxFinish;
        this.finishGranularity = finishGranularity;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.lengthUnit = lengthUnit;
        this.initComputed();
    }

    protected void initComputed() throws IllegalArgumentException {
        this.start = new Start(this);
        this.finish = new Finish(this);
        Long w0 = null;
        Long w1 = null;
        Long w2 = null;
        Long w3 = null;
        Long w4 = 0L;
        Long w5 = null;
        if (this.startGranularity != null) {
            if (this.minStart != null) {
                w0 = this.minStart;
            }
            if (this.maxStart != null) {
                w1 = this.startGranularity.latest(this.maxStart);
            }
        } else {
            if (this.minStart != null) {
                w0 = this.minStart;
            }
            if (this.maxStart != null) {
                w1 = this.maxStart;
            }
        }
        if (this.finishGranularity != null) {
            if (this.minFinish != null) {
                w2 = this.minFinish;
            }
            if (this.maxFinish != null) {
                w3 = this.finishGranularity.latest(this.maxFinish);
            }
        } else {
            if (this.minFinish != null) {
                w2 = this.minFinish;
            }
            if (this.maxFinish != null) {
                w3 = this.maxFinish;
            }
        }
        Granularity g1 = null;
        g1 = this.startGranularity != null && this.finishGranularity != null ? (this.startGranularity.compareTo(this.finishGranularity) < 0 ? this.startGranularity : this.finishGranularity) : (this.startGranularity != null ? this.startGranularity : this.finishGranularity);
        if (this.minLength != null) {
            if (g1 != null) {
                w4 = g1.minimumDistance(this.maxStart, this.minLength, this.lengthUnit);
            } else if (this.minFinish != null && this.maxStart != null) {
                w4 = (long)this.minLength;
            }
            this.minLengthComputed = true;
        }
        if (this.maxLength != null) {
            if (g1 != null) {
                w5 = g1.maximumDistance(this.minStart, this.maxLength, this.lengthUnit);
            } else if (this.maxFinish != null && this.minStart != null) {
                w5 = (long)this.minLength;
            }
            this.maxLengthComputed = true;
        }
        this.v = new Long[]{w0, w1, w2, w3, w4, w5};
        if (this.v[0] != null && this.v[1] != null && this.v[0].compareTo(this.v[1]) > 0 || this.v[2] != null && this.v[3] != null && this.v[2].compareTo(this.v[3]) > 0 || this.v[4] != null && this.v[5] != null && this.v[4].compareTo(this.v[5]) > 0) {
            throw new IllegalArgumentException("Illegal values for interval");
        }
    }

    protected void computeLength() {
        if (!this.minLengthComputed || !this.maxLengthComputed) {
            Long w4 = 0L;
            Long w5 = null;
            Granularity g1 = null;
            Granularity g2 = null;
            if (this.startGranularity != null && this.finishGranularity != null) {
                if (this.startGranularity.compareTo(this.finishGranularity) < 0) {
                    g1 = this.startGranularity;
                    g2 = this.finishGranularity;
                } else {
                    g1 = this.finishGranularity;
                    g2 = this.startGranularity;
                }
            } else {
                g1 = this.startGranularity != null ? this.startGranularity : this.finishGranularity;
            }
            if (!this.minLengthComputed) {
                if (this.minLength == null) {
                    if (g1 != null) {
                        this.lengthUnit = g1.getCorrespondingUnit();
                        if (this.maxStart != null && this.minFinish != null) {
                            this.minLength = g1.distance(this.maxStart, this.minFinish, g2, this.lengthUnit);
                        }
                    } else if (this.minFinish != null && this.maxStart != null) {
                        this.minLength = this.minFinish - this.maxStart;
                    }
                }
                if (g1 != null) {
                    if (this.maxStart != null && this.minLength != null) {
                        w4 = g1.minimumDistance(this.maxStart, this.minLength, this.lengthUnit);
                    }
                } else if (this.minFinish != null && this.maxStart != null) {
                    w4 = (long)this.minLength;
                }
                this.minLengthComputed = true;
            }
            if (!this.maxLengthComputed) {
                if (this.maxLength == null) {
                    if (g1 != null) {
                        this.lengthUnit = g1.getCorrespondingUnit();
                        if (this.minStart != null && this.maxFinish != null) {
                            this.maxLength = g1.distance(this.minStart, this.maxFinish, g2, this.lengthUnit);
                        }
                    } else if (this.maxFinish != null && this.minStart != null) {
                        this.maxLength = this.maxFinish - this.minStart;
                    }
                }
                if (g1 != null) {
                    if (this.minStart != null && this.maxLength != null) {
                        w5 = g1.maximumDistance(this.minStart, this.maxLength, this.lengthUnit);
                    }
                } else if (this.maxFinish != null && this.minStart != null) {
                    w5 = (long)this.minLength;
                }
                this.maxLengthComputed = true;
            }
            this.v[4] = w4;
            this.v[5] = w5;
        }
    }

    public Long getMinimumStart() {
        return this.v[0];
    }

    public Long getMaximumStart() {
        return this.v[1];
    }

    public Long getMinimumFinish() {
        return this.v[2];
    }

    public Long getMaximumFinish() {
        return this.v[3];
    }

    public Long getMinimumLength() {
        this.computeLength();
        return this.v[4];
    }

    public Long getMaximumLength() {
        this.computeLength();
        return this.v[5];
    }

    private void initVw() {
        this.vw = new Weight[]{this.v[0] != null ? weightFactory.getInstance((Number)this.v[0]) : WeightFactory.NEG_INFINITY, this.v[1] != null ? weightFactory.getInstance((Number)this.v[1]) : WeightFactory.POS_INFINITY, this.v[2] != null ? weightFactory.getInstance((Number)this.v[2]) : WeightFactory.NEG_INFINITY, this.v[3] != null ? weightFactory.getInstance((Number)this.v[3]) : WeightFactory.POS_INFINITY, this.v[4] != null ? weightFactory.getInstance((Number)this.v[4]) : WeightFactory.ZERO, this.v[5] != null ? weightFactory.getInstance((Number)this.v[5]) : WeightFactory.POS_INFINITY};
    }

    Weight getSpecifiedMinimumStart() {
        if (this.vw == null) {
            this.initVw();
        }
        return this.vw[0];
    }

    Weight getSpecifiedMaximumStart() {
        if (this.vw == null) {
            this.initVw();
        }
        return this.vw[1];
    }

    Weight getSpecifiedMinimumFinish() {
        if (this.vw == null) {
            this.initVw();
        }
        return this.vw[2];
    }

    Weight getSpecifiedMaximumFinish() {
        if (this.vw == null) {
            this.initVw();
        }
        return this.vw[3];
    }

    Weight getSpecifiedMinimumLength() {
        if (this.vw == null) {
            this.initVw();
        }
        return this.vw[4];
    }

    Weight getSpecifiedMaximumLength() {
        if (this.vw == null) {
            this.initVw();
        }
        return this.vw[5];
    }

    Start getStart() {
        return this.start;
    }

    Finish getFinish() {
        return this.finish;
    }

    public boolean isLengthGreaterThan(int duration, Unit durationUnits) {
        Long minS = this.getMinimumStart();
        Long minF = this.getMinimumFinish();
        if (durationUnits == null || minS == null || minF == null) {
            if (minF == null) {
                return false;
            }
            if (minS == null) {
                return true;
            }
            return minS + (long)duration < minF;
        }
        return !Relation.isGreaterThanOrEqualToDuration(durationUnits, minS, minF, duration);
    }

    public boolean isLengthLessThan(int duration, Unit durationUnits) {
        Long maxS = this.getMaximumStart();
        Long maxF = this.getMaximumFinish();
        if (durationUnits == null || maxS == null || maxF == null) {
            if (maxF == null) {
                return false;
            }
            if (maxS == null) {
                return true;
            }
            return maxS + (long)duration > maxF;
        }
        return !Relation.isLessThanOrEqualToDuration(durationUnits, maxS, maxF, duration);
    }

    public String toString() {
        return Arrays.asList(this.v).toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Interval)) {
            return false;
        }
        Interval otherIval = (Interval)other;
        return Arrays.equals((Object[])this.v, (Object[])otherIval.v);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            this.hashCode = result = 37 * result + Arrays.hashCode((Object[])this.v);
        }
        return this.hashCode;
    }

    @Override
    public final int compareTo(Interval o) {
        if (this == o) {
            return 0;
        }
        Long start1 = this.getMinimumStart();
        Long finish1 = this.getMaximumFinish();
        Long start2 = o.getMinimumStart();
        Long finish2 = o.getMaximumFinish();
        int result = start1 == null && start2 != null ? -1 : (start1 != null && start2 == null ? 1 : (start1 == null && start2 == null ? 0 : start1.compareTo(start2)));
        if (result != 0) {
            return result;
        }
        if (finish1 == null && finish2 != null) {
            return 1;
        }
        if (finish1 != null && finish2 == null) {
            return -1;
        }
        if (finish1 == null && finish2 == null) {
            return 0;
        }
        return finish1.compareTo(finish2);
    }

    public Long getMinStart() {
        return this.minStart;
    }

    public Long getMaxStart() {
        return this.maxStart;
    }

    public Granularity getStartGranularity() {
        return this.startGranularity;
    }

    public Long getMinFinish() {
        return this.minFinish;
    }

    public Long getMaxFinish() {
        return this.maxFinish;
    }

    public Granularity getFinishGranularity() {
        return this.finishGranularity;
    }

    public Long getMinLength() {
        this.computeLength();
        return this.minLength;
    }

    public Long minLengthIn(Unit unit) {
        if (unit != null) {
            Long maxStart = this.getMaxStart();
            Long minFinish = this.getMinFinish();
            if (maxStart == null || minFinish == null) {
                return null;
            }
            Granularity startGran = this.getStartGranularity();
            if (startGran != null) {
                return startGran.distance(maxStart, minFinish, this.getFinishGranularity(), unit);
            }
            Granularity finishGran = this.getFinishGranularity();
            if (finishGran != null) {
                return finishGran.distance(maxStart, minFinish, null, unit);
            }
            return minFinish - maxStart;
        }
        return this.getMinLength();
    }

    public Long maxLengthIn(Unit unit) {
        if (unit != null) {
            Long minStart = this.getMinStart();
            Long maxFinish = this.getMaxFinish();
            if (minStart == null || maxFinish == null) {
                return null;
            }
            Granularity startGran = this.getStartGranularity();
            if (startGran != null) {
                return startGran.distance(minStart, maxFinish, this.getFinishGranularity(), unit);
            }
            Granularity finishGran = this.getFinishGranularity();
            if (finishGran != null) {
                return finishGran.distance(minStart, maxFinish, null, unit);
            }
            return maxFinish - minStart;
        }
        return this.getMaxLength();
    }

    public Long getMaxLength() {
        this.computeLength();
        return this.maxLength;
    }

    public Unit getLengthUnit() {
        this.computeLength();
        return this.lengthUnit;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.minStart != null && this.maxFinish != null && this.minStart > this.maxFinish) {
            throw new InvalidObjectException("maxFinish cannot be before minStart; maxFinish=" + this.maxFinish + "; minStart=" + this.minStart);
        }
        if (this.minLength != null && this.minLength < 0L) {
            throw new InvalidObjectException("minLength must be positive or 0 but was " + this.minLength);
        }
        if (this.maxLength != null && this.maxLength < 0L) {
            throw new InvalidObjectException("maxLength must be positive or 0 but was " + this.maxLength);
        }
        try {
            this.initComputed();
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidObjectException(iae.getMessage());
        }
    }

    static final class Finish {
        private final Interval interval;
        private volatile int hashCode;

        Finish(Interval interval) {
            this.interval = interval;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.interval.hashCode();
                this.hashCode = result = 37 * result;
            }
            return this.hashCode;
        }

        public String toString() {
            return "" + this.interval + " finish";
        }
    }

    static final class Start {
        private final Interval interval;
        private volatile int hashCode;

        Start(Interval interval) {
            this.interval = interval;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                this.hashCode = result = 37 * result + this.interval.hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            return "" + this.interval + " start";
        }
    }

    public static enum Side {
        START(IntervalUtil.resourceBundle().getString("intervalSide.startDisplayName")),
        FINISH(IntervalUtil.resourceBundle().getString("intervalSide.finishDisplayName"));

        private transient String displayName;

        private Side(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

