/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.arp.javautil.io.Retryable;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.SQLExecutor;

public class RetryableSQLExecutor
implements Retryable<SQLException> {
    private static final long THREE_SECONDS = 3000L;
    private final ConnectionSpec connectionSpec;
    private final String query;
    private final SQLExecutor.ResultProcessor resultProcessor;
    private final Integer queryTimeout;

    public RetryableSQLExecutor(ConnectionSpec connectionSpec, String query, SQLExecutor.ResultProcessor resultProcessor, Integer queryTimeout) {
        assert (connectionSpec != null) : "connectionSpec cannot be null";
        this.connectionSpec = connectionSpec;
        assert (query != null) : "query cannot be null";
        this.query = query;
        this.resultProcessor = resultProcessor;
        assert (queryTimeout == null || queryTimeout >= 0) : "queryTimeout cannot be negative";
        this.queryTimeout = queryTimeout;
    }

    public RetryableSQLExecutor(ConnectionSpec connectionSpec, String query, SQLExecutor.ResultProcessor resultProcessor) {
        this(connectionSpec, query, resultProcessor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLException attempt() {
        try {
            Connection con = this.connectionSpec.getOrCreate();
            con.setReadOnly(true);
            try {
                Statement stmt = con.createStatement(1003, 1007);
                stmt.setFetchSize(10000);
                if (this.queryTimeout != null) {
                    stmt.setQueryTimeout(this.queryTimeout);
                }
                try {
                    SQLExecutor.executeSQL((Connection)con, (Statement)stmt, (String)this.query, (SQLExecutor.ResultProcessor)this.resultProcessor);
                    stmt.close();
                    stmt = null;
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                con.close();
                con = null;
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return null;
        }
        catch (SQLException ex) {
            return ex;
        }
    }

    public void recover() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

