/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.log;

import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Logging {
    private static final ThreadLocal<NumberFormat> numberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NumberFormat.getIntegerInstance();
        }
    };

    public static void logCount(Logger logger, Level level, int count, String singularMessage, String pluralMessage) {
        Logging.logCount(logger, level, count, singularMessage, pluralMessage, null, null);
    }

    public static void logCount(Logger logger, Level level, int count, String singularMessage, String pluralMessage, Object[] singularParams, Object[] pluralParams) {
        String countStr = numberFormat.get().format(count);
        if (count > 1 || count == 0) {
            logger.log(level, pluralMessage, Logging.processLogCountParams(countStr, pluralParams));
        } else {
            logger.log(level, singularMessage, Logging.processLogCountParams(countStr, singularParams));
        }
    }

    private static Object[] processLogCountParams(String countStr, Object[] params) {
        Object[] sp;
        if (params != null && params.length > 0) {
            sp = new Object[1 + params.length];
            sp[0] = countStr;
            System.arraycopy(params, 0, sp, 1, params.length);
        } else {
            sp = new Object[]{countStr};
        }
        return sp;
    }
}

