/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.BooleanValueBuilder;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueBuilder;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;
import org.protempa.proposition.value.ValueType;
import org.protempa.proposition.value.ValueVisitor;

public final class BooleanValue
implements Value,
Serializable {
    private static final long serialVersionUID = 3913347786451127004L;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    private boolean val;
    private volatile transient int hashCode;

    public static BooleanValue parse(String str) {
        return (BooleanValue)ValueType.BOOLEANVALUE.parse(str);
    }

    public BooleanValue(boolean val) {
        this.val = val;
    }

    public BooleanValue(Boolean val) {
        this.val = val != null ? val : false;
    }

    @Override
    public BooleanValue replace() {
        return this;
    }

    public Boolean getBoolean() {
        return this.val;
    }

    public boolean booleanValue() {
        return this.val;
    }

    @Override
    public String getFormatted() {
        return Boolean.toString(this.val);
    }

    @Override
    public ValueType getType() {
        return ValueType.BOOLEANVALUE;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanValue other = (BooleanValue)obj;
        return this.val == other.val;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 3;
            this.hashCode = hash = 17 * hash + (this.val ? 1 : 0);
        }
        return this.hashCode;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        if (valueVisitor == null) {
            throw new IllegalArgumentException("valueVisitor cannot be null");
        }
        valueVisitor.visit(this);
    }

    @Override
    public ValueComparator compare(Value val) {
        if (val == null) {
            return ValueComparator.NOT_EQUAL_TO;
        }
        switch (val.getType()) {
            case BOOLEANVALUE: {
                if (this.val == ((BooleanValue)val).val) {
                    return ValueComparator.EQUAL_TO;
                }
                return ValueComparator.NOT_EQUAL_TO;
            }
            case VALUELIST: {
                ValueList vl = (ValueList)val;
                return vl.contains(this) ? ValueComparator.IN : ValueComparator.NOT_IN;
            }
        }
        return ValueComparator.NOT_EQUAL_TO;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeBoolean(this.val);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.val = s.readBoolean();
    }

    @Override
    public ValueBuilder asBuilder() {
        return new BooleanValueBuilder(this);
    }
}

