/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ParameterWrapper;
import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockParameterMap;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.regexp.PatternMatcher;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultSetHandler {
    private ResultSetFactory resultSetFactory = ResultSetFactory.Default.INSTANCE;
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;
    private PatternMatcher.Factory patternMatcherFactory = PatternMatcher.Factories.from((boolean)this.caseSensitive, (boolean)this.exactMatch, (boolean)this.useRegularExpressions);
    private boolean continueProcessingOnBatchFailure = false;
    private MockResultSet[] globalResultSets;
    private Integer[] globalUpdateCounts;
    private final Map<String, Boolean> returnsResultSetMap = new TreeMap<String, Boolean>();
    private final Map<PatternMatcher, Boolean> returnsResultSetMapCompiled = new HashMap<PatternMatcher, Boolean>();
    private MockResultSet globalGeneratedKeys;
    private final List<String> executedStatements = new ArrayList<String>();
    private final List<MockResultSet[]> returnedResultSets = new ArrayList<MockResultSet[]>();
    private final Map<String, List<ParameterWrapper<MockResultSet[]>>> resultSetsForStatement = new TreeMap<String, List<ParameterWrapper<MockResultSet[]>>>();
    private final Map<PatternMatcher, List<ParameterWrapper<MockResultSet[]>>> resultSetsForStatementCompiled = new HashMap<PatternMatcher, List<ParameterWrapper<MockResultSet[]>>>();
    private final Map<String, List<ParameterWrapper<Integer[]>>> updateCountForStatement = new TreeMap<String, List<ParameterWrapper<Integer[]>>>();
    private final Map<PatternMatcher, List<ParameterWrapper<Integer[]>>> updateCountForStatementCompiled = new HashMap<PatternMatcher, List<ParameterWrapper<Integer[]>>>();
    private final Map<String, List<ParameterWrapper<SQLException>>> throwsSQLException = new TreeMap<String, List<ParameterWrapper<SQLException>>>();
    private final Map<PatternMatcher, List<ParameterWrapper<SQLException>>> throwsSQLExceptionCompiled = new HashMap<PatternMatcher, List<ParameterWrapper<SQLException>>>();
    private final Map<String, List<ParameterWrapper<MockResultSet>>> generatedKeysForStatement = new TreeMap<String, List<ParameterWrapper<MockResultSet>>>();
    private final Map<PatternMatcher, List<ParameterWrapper<MockResultSet>>> generatedKeysForStatementCompiled = new HashMap<PatternMatcher, List<ParameterWrapper<MockResultSet>>>();

    public MockResultSet createResultSet() {
        return this.resultSetFactory.create(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String id) {
        return this.resultSetFactory.create(id);
    }

    public MockResultSet createResultSet(ResultSetFactory factory) {
        return factory.create(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String id, ResultSetFactory factory) {
        return factory.create(id);
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.resetPatternMatcherFactory();
    }

    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
        this.resetPatternMatcherFactory();
    }

    public void setUseRegularExpressions(boolean useRegularExpressions) {
        this.useRegularExpressions = useRegularExpressions;
        this.resetPatternMatcherFactory();
    }

    public void setPatternMatcherFactory(PatternMatcher.Factory factory) {
        this.patternMatcherFactory = factory;
        this.onPatternMatcherFactoryChanged();
    }

    public PatternMatcher.Factory getPatternMatcherFactory() {
        return this.patternMatcherFactory;
    }

    protected void resetPatternMatcherFactory() {
        this.patternMatcherFactory = PatternMatcher.Factories.from((boolean)this.caseSensitive, (boolean)this.exactMatch, (boolean)this.useRegularExpressions);
        this.onPatternMatcherFactoryChanged();
    }

    protected void onPatternMatcherFactoryChanged() {
        this.recompile(this.returnsResultSetMap, this.returnsResultSetMapCompiled);
        this.recompile(this.resultSetsForStatement, this.resultSetsForStatementCompiled);
        this.recompile(this.updateCountForStatement, this.updateCountForStatementCompiled);
        this.recompile(this.throwsSQLException, this.throwsSQLExceptionCompiled);
        this.recompile(this.generatedKeysForStatement, this.generatedKeysForStatementCompiled);
    }

    public void setContinueProcessingOnBatchFailure(boolean continueProcessingOnBatchFailure) {
        this.continueProcessingOnBatchFailure = continueProcessingOnBatchFailure;
    }

    public void addExecutedStatement(String sql) {
        this.executedStatements.add(sql);
    }

    public void addReturnedResultSet(MockResultSet resultSet) {
        if (null == resultSet) {
            return;
        }
        this.returnedResultSets.add(new MockResultSet[]{resultSet});
    }

    public void addReturnedResultSets(MockResultSet[] resultSets) {
        if (null == resultSets) {
            return;
        }
        this.returnedResultSets.add(resultSets);
    }

    public List<String> getExecutedStatements() {
        return Collections.unmodifiableList(this.executedStatements);
    }

    public List<MockResultSet[]> getReturnedResultSets() {
        return Collections.unmodifiableList(this.returnedResultSets);
    }

    public void clearResultSets() {
        this.resultSetsForStatement.clear();
        this.resultSetsForStatementCompiled.clear();
    }

    public void clearUpdateCounts() {
        this.updateCountForStatement.clear();
        this.updateCountForStatementCompiled.clear();
    }

    public void clearReturnsResultSet() {
        this.returnsResultSetMap.clear();
        this.returnsResultSetMapCompiled.clear();
    }

    public void clearThrowsSQLException() {
        this.throwsSQLException.clear();
        this.throwsSQLExceptionCompiled.clear();
    }

    public void clearGeneratedKeys() {
        this.generatedKeysForStatement.clear();
        this.generatedKeysForStatementCompiled.clear();
    }

    public void clearGlobalResultSet() {
        this.globalResultSets = null;
    }

    public void clearGlobalGeneratedKeys() {
        this.globalGeneratedKeys = null;
    }

    public void clearGlobalUpdateCount() {
        this.globalUpdateCounts = null;
    }

    public MockResultSet getResultSet(String sql) {
        return this.getResultSet(sql, new MockParameterMap(), true);
    }

    protected MockResultSet getResultSet(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        MockResultSet[] resultSets = this.getResultSets(sql, parameters, exactMatchParameter);
        if (null != resultSets && resultSets.length > 0) {
            return resultSets[0];
        }
        return null;
    }

    public MockResultSet[] getResultSets(String sql) {
        return this.getResultSets(sql, new MockParameterMap(), true);
    }

    protected MockResultSet[] getResultSets(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.resultSetsForStatementCompiled, exactMatchParameter);
        if (null == wrapper) {
            return null;
        }
        MockResultSet[] resultSets = (MockResultSet[])wrapper.getWrappedObject();
        if (resultSets == null) {
            return null;
        }
        MockResultSet[] evaluated = new MockResultSet[resultSets.length];
        for (int i = 0; i < resultSets.length; ++i) {
            evaluated[i] = resultSets[i].evaluate(sql, parameters);
        }
        return evaluated;
    }

    public boolean hasMultipleResultSets(String sql) {
        return this.hasMultipleResultSets(sql, new MockParameterMap(), true);
    }

    protected boolean hasMultipleResultSets(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.resultSetsForStatementCompiled, exactMatchParameter);
        return null != wrapper && ((MockResultSet[])wrapper.getWrappedObject()).length > 1;
    }

    public MockResultSet getGlobalResultSet() {
        if (null == this.globalResultSets) {
            return null;
        }
        MockResultSet[] resultSets = this.getGlobalResultSets();
        if (null != resultSets && resultSets.length > 0) {
            return resultSets[0];
        }
        return null;
    }

    public MockResultSet[] getGlobalResultSets() {
        if (null == this.globalResultSets) {
            return null;
        }
        return this.globalResultSets;
    }

    public boolean hasMultipleGlobalResultSets() {
        return this.globalResultSets != null && this.globalResultSets.length > 1;
    }

    public Integer getUpdateCount(String sql) {
        return this.getUpdateCount(sql, new MockParameterMap(), true);
    }

    protected Integer getUpdateCount(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        Integer[] updateCounts = this.getUpdateCounts(sql, parameters, exactMatchParameter);
        if (null != updateCounts && updateCounts.length > 0) {
            return updateCounts[0];
        }
        return null;
    }

    public Integer[] getUpdateCounts(String sql) {
        return this.getUpdateCounts(sql, new MockParameterMap(), true);
    }

    public boolean hasMultipleUpdateCounts(String sql) {
        return this.hasMultipleUpdateCounts(sql, new MockParameterMap(), true);
    }

    protected boolean hasMultipleUpdateCounts(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.updateCountForStatementCompiled, exactMatchParameter);
        return wrapper != null && ((Integer[])wrapper.getWrappedObject()).length > 1;
    }

    public Integer[] getUpdateCounts(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.updateCountForStatementCompiled, exactMatchParameter);
        if (null != wrapper) {
            return (Integer[])wrapper.getWrappedObject();
        }
        return null;
    }

    public int getGlobalUpdateCount() {
        if (null != this.globalUpdateCounts && this.globalUpdateCounts.length > 0) {
            return this.globalUpdateCounts[0];
        }
        return 0;
    }

    public Integer[] getGlobalUpdateCounts() {
        if (null == this.globalUpdateCounts) {
            return null;
        }
        return this.globalUpdateCounts;
    }

    public boolean hasMultipleGlobalUpdateCounts() {
        return null != this.globalUpdateCounts && this.globalUpdateCounts.length > 1;
    }

    public MockResultSet getGeneratedKeys(String sql) {
        return this.getGeneratedKeys(sql, new MockParameterMap(), true);
    }

    protected MockResultSet getGeneratedKeys(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.generatedKeysForStatementCompiled, exactMatchParameter);
        if (null == wrapper) {
            return null;
        }
        return ((MockResultSet)wrapper.getWrappedObject()).evaluate(sql, parameters);
    }

    public MockResultSet getGlobalGeneratedKeys() {
        return this.globalGeneratedKeys;
    }

    public Boolean getReturnsResultSet(String sql) {
        List<Boolean> list = this.getMatchingObjects(this.returnsResultSetMapCompiled, sql);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public boolean getThrowsSQLException(String sql) {
        return this.getSQLException(sql) != null;
    }

    public SQLException getSQLException(String sql) {
        return this.getSQLException(sql, new MockParameterMap(), true);
    }

    protected SQLException getSQLException(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.throwsSQLExceptionCompiled, exactMatchParameter);
        if (null != wrapper) {
            return (SQLException)wrapper.getWrappedObject();
        }
        return null;
    }

    public void prepareResultSet(String sql, MockResultSet resultSet) {
        this.prepareResultSet(sql, resultSet, new MockParameterMap());
    }

    protected void prepareResultSet(String sql, MockResultSet resultSet, MockParameterMap parameters) {
        List<ParameterWrapper<MockResultSet[]>> list = this.getListFromMapForSQLStatement(sql, this.resultSetsForStatement);
        list.add(new ParameterWrapper<MockResultSet[]>(new MockResultSet[]{resultSet}, new MockParameterMap(parameters)));
        this.resultSetsForStatementCompiled.put(this.patternMatcherFactory.create(sql), list);
    }

    public void prepareResultSets(String sql, MockResultSet[] resultSets) {
        this.prepareResultSets(sql, resultSets, new MockParameterMap());
    }

    protected void prepareResultSets(String sql, MockResultSet[] resultSets, MockParameterMap parameters) {
        List<ParameterWrapper<MockResultSet[]>> list = this.getListFromMapForSQLStatement(sql, this.resultSetsForStatement);
        list.add(new ParameterWrapper<Object>(resultSets.clone(), new MockParameterMap(parameters)));
        this.resultSetsForStatementCompiled.put(this.patternMatcherFactory.create(sql), list);
    }

    public void prepareGlobalResultSet(MockResultSet resultSet) {
        this.globalResultSets = new MockResultSet[]{resultSet};
    }

    public void prepareGlobalResultSets(MockResultSet[] resultSets) {
        this.globalResultSets = (MockResultSet[])resultSets.clone();
    }

    public void prepareUpdateCount(String sql, int updateCount) {
        this.prepareUpdateCount(sql, updateCount, new MockParameterMap());
    }

    protected void prepareUpdateCount(String sql, int updateCount, MockParameterMap parameters) {
        List<ParameterWrapper<Integer[]>> list = this.getListFromMapForSQLStatement(sql, this.updateCountForStatement);
        list.add(new ParameterWrapper<Integer[]>(new Integer[]{updateCount}, new MockParameterMap(parameters)));
        this.updateCountForStatementCompiled.put(this.patternMatcherFactory.create(sql), list);
    }

    public void prepareUpdateCounts(String sql, Integer[] updateCounts) {
        this.prepareUpdateCounts(sql, updateCounts, new MockParameterMap());
    }

    public void prepareUpdateCounts(String sql, Integer[] updateCounts, MockParameterMap parameters) {
        List<ParameterWrapper<Integer[]>> list = this.getListFromMapForSQLStatement(sql, this.updateCountForStatement);
        list.add(new ParameterWrapper<Object>(updateCounts.clone(), new MockParameterMap(parameters)));
        this.updateCountForStatementCompiled.put(this.patternMatcherFactory.create(sql), list);
    }

    public void prepareGlobalUpdateCount(int updateCount) {
        this.globalUpdateCounts = new Integer[]{updateCount};
    }

    public void prepareGlobalUpdateCounts(Integer[] updateCounts) {
        this.globalUpdateCounts = (Integer[])updateCounts.clone();
    }

    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult) {
        this.prepareGeneratedKeys(sql, generatedKeysResult, new MockParameterMap());
    }

    protected void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult, MockParameterMap parameters) {
        List<ParameterWrapper<MockResultSet>> list = this.getListFromMapForSQLStatement(sql, this.generatedKeysForStatement);
        list.add(new ParameterWrapper<MockResultSet>(generatedKeysResult, new MockParameterMap(parameters)));
        this.generatedKeysForStatementCompiled.put(this.patternMatcherFactory.create(sql), list);
    }

    public void prepareGlobalGeneratedKeys(MockResultSet generatedKeysResult) {
        this.globalGeneratedKeys = generatedKeysResult;
    }

    public void prepareReturnsResultSet(String sql, boolean returnsResultSet) {
        this.returnsResultSetMap.put(sql, returnsResultSet);
        this.returnsResultSetMapCompiled.put(this.patternMatcherFactory.create(sql), returnsResultSet);
    }

    public void prepareThrowsSQLException(String sql) {
        this.prepareThrowsSQLException(sql, new MockParameterMap());
    }

    protected void prepareThrowsSQLException(String sql, MockParameterMap parameters) {
        SQLException exc = new SQLException("Statement " + sql + " was specified to throw an exception");
        this.prepareThrowsSQLException(sql, exc, parameters);
    }

    public void prepareThrowsSQLException(String sql, SQLException exc) {
        this.prepareThrowsSQLException(sql, exc, new MockParameterMap());
    }

    protected void prepareThrowsSQLException(String sql, SQLException exc, MockParameterMap parameters) {
        List<ParameterWrapper<SQLException>> list = this.getListFromMapForSQLStatement(sql, this.throwsSQLException);
        list.add(new ParameterWrapper<SQLException>(exc, new MockParameterMap(parameters)));
        this.throwsSQLExceptionCompiled.put(this.patternMatcherFactory.create(sql), list);
    }

    protected boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    protected boolean getExactMatch() {
        return this.exactMatch;
    }

    protected boolean getUseRegularExpressions() {
        return this.useRegularExpressions;
    }

    public boolean getContinueProcessingOnBatchFailure() {
        return this.continueProcessingOnBatchFailure;
    }

    public void removeAllResultSet(String sql) {
        this.resultSetsForStatement.remove(sql);
        this.resultSetsForStatementCompiled.remove(this.patternMatcherFactory.create(sql));
    }

    public void removeAllThrowsSqlException(String sql) {
        this.throwsSQLException.remove(sql);
        this.throwsSQLExceptionCompiled.remove(this.patternMatcherFactory.create(sql));
    }

    public void removeAllUpdateCount(String sql) {
        this.updateCountForStatement.remove(sql);
        this.updateCountForStatementCompiled.remove(this.patternMatcherFactory.create(sql));
    }

    public void removeAllGeneratedKeys(String sql) {
        this.generatedKeysForStatement.remove(sql);
        this.generatedKeysForStatementCompiled.remove(this.patternMatcherFactory.create(sql));
    }

    public void removeResultSet(String sql) {
        this.removeResultSet(sql, new MockParameterMap(), false);
    }

    protected void removeResultSet(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        this.removeMatchingParameterWrapper(sql, parameters, this.resultSetsForStatement, exactMatchParameter);
        this.removeMatchingParameterWrapper(this.patternMatcherFactory.create(sql), parameters, this.resultSetsForStatementCompiled, exactMatchParameter);
    }

    public void removeThrowsSqlException(String sql) {
        this.removeThrowsSqlException(sql, new MockParameterMap(), false);
    }

    protected void removeThrowsSqlException(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        this.removeMatchingParameterWrapper(sql, parameters, this.throwsSQLException, exactMatchParameter);
    }

    public void removeUpdateCount(String sql) {
        this.removeUpdateCount(sql, new MockParameterMap(), false);
    }

    protected void removeUpdateCount(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        this.removeMatchingParameterWrapper(sql, parameters, this.updateCountForStatement, exactMatchParameter);
    }

    public void removeGeneratedKeys(String sql) {
        this.removeGeneratedKeys(sql, new MockParameterMap(), false);
    }

    protected void removeGeneratedKeys(String sql, MockParameterMap parameters, boolean exactMatchParameter) {
        this.removeMatchingParameterWrapper(sql, parameters, this.generatedKeysForStatement, exactMatchParameter);
    }

    protected <T> List<T> getMatchingObjects(Map<PatternMatcher, ? extends T> dataMap, String query) {
        if (null == query) {
            query = "";
        }
        ArrayList<T> resultList = new ArrayList<T>();
        for (Map.Entry<PatternMatcher, T> entry : dataMap.entrySet()) {
            PatternMatcher matcher = entry.getKey();
            if (!matcher.matches(query)) continue;
            T matchingObject = entry.getValue();
            resultList.add(matchingObject);
        }
        return resultList;
    }

    protected <T> ParameterWrapper<T> getMatchingParameterWrapper(String sql, MockParameterMap parameters, Map<PatternMatcher, List<ParameterWrapper<T>>> statementMap, boolean exactMatchParameter) {
        List<List<ParameterWrapper<T>>> list = this.getMatchingObjects(statementMap, sql);
        for (List<ParameterWrapper<T>> wrapperList : list) {
            for (ParameterWrapper<T> wrapper : wrapperList) {
                if (!wrapper.getParameters().doParameterMatch(parameters, exactMatchParameter)) continue;
                return wrapper;
            }
        }
        return null;
    }

    protected <S, T> ParameterWrapper<T> removeMatchingParameterWrapper(S sql, MockParameterMap parameters, Map<S, List<ParameterWrapper<T>>> map, boolean exactMatchParameter) {
        List<ParameterWrapper<T>> list = map.get(sql);
        for (ParameterWrapper<T> wrapper : list) {
            if (!wrapper.getParameters().doParameterMatch(parameters, exactMatchParameter)) continue;
            list.remove(wrapper);
            return wrapper;
        }
        return null;
    }

    protected <S, T> List<T> getListFromMapForSQLStatement(S sql, Map<S, List<T>> map) {
        List<T> list = map.get(sql);
        if (null == list) {
            list = new ArrayList<T>();
            map.put(sql, list);
        }
        return list;
    }

    protected <T> void recompile(Map<String, T> source, Map<PatternMatcher, T> compiled) {
        compiled.clear();
        for (Map.Entry<String, T> entry : source.entrySet()) {
            PatternMatcher patternMatcher = this.getPatternMatcherFactory().create(entry.getKey());
            compiled.put(patternMatcher, entry.getValue());
        }
    }
}

