/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.ArrayList;
import org.drools.RuleBaseConfiguration;
import org.drools.base.evaluators.Operator;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.FactHandleMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.util.AbstractHashTable;
import org.drools.util.FactHandleIndexHashTable;
import org.drools.util.FactHashTable;
import org.drools.util.FactList;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;
import org.drools.util.TupleHashTable;
import org.drools.util.TupleIndexHashTable;

public class QuadroupleBetaConstraints
implements Serializable,
BetaConstraints {
    private static final long serialVersionUID = 400L;
    private final BetaNodeFieldConstraint constraint0;
    private final BetaNodeFieldConstraint constraint1;
    private final BetaNodeFieldConstraint constraint2;
    private final BetaNodeFieldConstraint constraint3;
    private boolean indexed0;
    private boolean indexed1;
    private boolean indexed2;
    private boolean indexed3;

    public QuadroupleBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf) {
        this(constraints, conf, false);
    }

    public QuadroupleBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        if (disableIndexing || !conf.isIndexLeftBetaMemory() && !conf.isIndexRightBetaMemory()) {
            this.indexed0 = false;
            this.indexed1 = false;
            this.indexed2 = false;
            this.indexed3 = false;
        } else {
            int depth = conf.getCompositeKeyDepth();
            boolean i0 = this.isIndexable(constraints[0]);
            boolean i1 = this.isIndexable(constraints[1]);
            boolean i2 = this.isIndexable(constraints[2]);
            boolean i3 = this.isIndexable(constraints[3]);
            if (depth >= 1 && i0) {
                this.indexed0 = true;
            }
            if (i1) {
                if (depth >= 1 && !this.indexed0) {
                    this.indexed0 = true;
                    this.swap(constraints, 1, 0);
                } else if (depth >= 2) {
                    this.indexed1 = true;
                }
            }
            if (i2) {
                if (depth >= 1 && !this.indexed0) {
                    this.indexed0 = true;
                    this.swap(constraints, 2, 0);
                } else if (depth >= 2 && this.indexed0 && !this.indexed1) {
                    this.indexed1 = true;
                    this.swap(constraints, 2, 1);
                } else if (depth >= 3) {
                    this.indexed2 = true;
                }
            }
            if (i3) {
                if (depth >= 1 && !this.indexed0) {
                    this.indexed0 = true;
                    this.swap(constraints, 3, 0);
                } else if (depth >= 2 && this.indexed0 && !this.indexed1) {
                    this.indexed1 = true;
                    this.swap(constraints, 3, 1);
                } else if (depth >= 3 && this.indexed0 && this.indexed1 && !this.indexed2) {
                    this.indexed2 = true;
                    this.swap(constraints, 3, 2);
                } else if (depth >= 4) {
                    this.indexed3 = true;
                }
            }
        }
        this.constraint0 = constraints[0];
        this.constraint1 = constraints[1];
        this.constraint2 = constraints[2];
        this.constraint3 = constraints[3];
    }

    private void swap(BetaNodeFieldConstraint[] constraints, int p1, int p2) {
        BetaNodeFieldConstraint temp = constraints[p2];
        constraints[p2] = constraints[p1];
        constraints[p1] = temp;
    }

    private boolean isIndexable(BetaNodeFieldConstraint constraint) {
        if (constraint instanceof VariableConstraint) {
            VariableConstraint variableConstraint = (VariableConstraint)constraint;
            return variableConstraint.getEvaluator().getOperator() == Operator.EQUAL;
        }
        return false;
    }

    public void updateFromTuple(ContextEntry[] context, InternalWorkingMemory workingMemory, ReteTuple tuple) {
        context[0].updateFromTuple(workingMemory, tuple);
        context[1].updateFromTuple(workingMemory, tuple);
        context[2].updateFromTuple(workingMemory, tuple);
        context[3].updateFromTuple(workingMemory, tuple);
    }

    public void updateFromFactHandle(ContextEntry[] context, InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        context[0].updateFromFactHandle(workingMemory, handle);
        context[1].updateFromFactHandle(workingMemory, handle);
        context[2].updateFromFactHandle(workingMemory, handle);
        context[3].updateFromFactHandle(workingMemory, handle);
    }

    public void resetTuple(ContextEntry[] context) {
        context[0].resetTuple();
        context[1].resetTuple();
        context[2].resetTuple();
        context[3].resetTuple();
    }

    public void resetFactHandle(ContextEntry[] context) {
        context[0].resetFactHandle();
        context[1].resetFactHandle();
        context[2].resetFactHandle();
        context[3].resetFactHandle();
    }

    public boolean isAllowedCachedLeft(ContextEntry[] context, Object object) {
        return !(!this.indexed0 && !this.constraint0.isAllowedCachedLeft(context[0], object) || !this.indexed1 && !this.constraint1.isAllowedCachedLeft(context[1], object) || !this.indexed2 && !this.constraint2.isAllowedCachedLeft(context[2], object) || !this.indexed3 && !this.constraint3.isAllowedCachedLeft(context[3], object));
    }

    public boolean isAllowedCachedRight(ContextEntry[] context, ReteTuple tuple) {
        return this.constraint0.isAllowedCachedRight(tuple, context[0]) && this.constraint1.isAllowedCachedRight(tuple, context[1]) && this.constraint2.isAllowedCachedRight(tuple, context[2]) && (this.indexed3 || this.constraint3.isAllowedCachedRight(tuple, context[3]));
    }

    public boolean isIndexed() {
        return this.indexed0;
    }

    public int getIndexCount() {
        int count = 0;
        if (this.indexed0) {
            ++count;
        }
        if (this.indexed1) {
            ++count;
        }
        if (this.indexed2) {
            ++count;
        }
        if (this.indexed3) {
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return false;
    }

    public BetaMemory createBetaMemory(RuleBaseConfiguration conf) {
        BetaMemory memory;
        AbstractHashTable.FieldIndex index;
        VariableConstraint variableConstraint;
        ArrayList<AbstractHashTable.FieldIndex> list = new ArrayList<AbstractHashTable.FieldIndex>(2);
        if (this.indexed0) {
            variableConstraint = (VariableConstraint)this.constraint0;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed1) {
            variableConstraint = (VariableConstraint)this.constraint1;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed2) {
            variableConstraint = (VariableConstraint)this.constraint2;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed3) {
            variableConstraint = (VariableConstraint)this.constraint3;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (!list.isEmpty()) {
            AbstractHashTable.FieldIndex[] indexes = list.toArray(new AbstractHashTable.FieldIndex[list.size()]);
            AbstractHashTable tupleMemory = conf.isIndexLeftBetaMemory() ? new TupleIndexHashTable(indexes) : new TupleHashTable();
            FactHandleMemory factHandleMemory = conf.isIndexRightBetaMemory() ? new FactHandleIndexHashTable(indexes) : (conf.isSequential() ? new FactList() : new FactHashTable());
            memory = new BetaMemory((TupleMemory)((Object)(conf.isSequential() ? null : tupleMemory)), factHandleMemory, this.createContext());
        } else {
            memory = new BetaMemory(conf.isSequential() ? null : new TupleHashTable(), conf.isSequential() ? new FactList() : new FactHashTable(), this.createContext());
        }
        return memory;
    }

    public int hashCode() {
        return this.constraint0.hashCode() ^ this.constraint1.hashCode() ^ this.constraint2.hashCode() ^ this.constraint3.hashCode();
    }

    public LinkedList getConstraints() {
        LinkedList list = new LinkedList();
        list.add(new LinkedListEntry(this.constraint0));
        list.add(new LinkedListEntry(this.constraint1));
        list.add(new LinkedListEntry(this.constraint2));
        list.add(new LinkedListEntry(this.constraint3));
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof QuadroupleBetaConstraints)) {
            return false;
        }
        QuadroupleBetaConstraints other = (QuadroupleBetaConstraints)object;
        if (this.constraint0 != other.constraint0 && !this.constraint0.equals(other.constraint0)) {
            return false;
        }
        if (this.constraint1 != other.constraint1 && !this.constraint1.equals(other.constraint1)) {
            return false;
        }
        if (this.constraint2 != other.constraint2 && !this.constraint2.equals(other.constraint2)) {
            return false;
        }
        return this.constraint3 == other.constraint3 || this.constraint3.equals(other.constraint3);
    }

    public ContextEntry[] createContext() {
        return new ContextEntry[]{this.constraint0.createContextEntry(), this.constraint1.createContextEntry(), this.constraint2.createContextEntry(), this.constraint3.createContextEntry()};
    }
}

