/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.protempa.backend.dsb.relationaldb.AbstractFromClause;
import org.protempa.backend.dsb.relationaldb.AbstractJoinClause;
import org.protempa.backend.dsb.relationaldb.AbstractOnClause;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.DefaultJoinClause;
import org.protempa.backend.dsb.relationaldb.DefaultOnClause;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.JoinSpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.backend.dsb.relationaldb.TableAliaser;

class Ojdbc6OracleFromClause
extends AbstractFromClause {
    private final StagingSpec[] stagedTables;
    private final Map<String, ReferenceSpec> inboundReferenceSpecs;

    Ojdbc6OracleFromClause(EntitySpec currentSpec, Map<String, ReferenceSpec> inboundReferenceSpecs, List<ColumnSpec> columnSpecs, TableAliaser referenceIndices, StagingSpec[] stagedTables) {
        super(currentSpec, columnSpecs, referenceIndices);
        this.stagedTables = stagedTables;
        this.inboundReferenceSpecs = inboundReferenceSpecs;
    }

    protected StagingSpec[] getStagedTables() {
        return this.stagedTables;
    }

    private static List<String> toEntitySpecNames(EntitySpec[] entitySpecs) {
        ArrayList<String> result = new ArrayList<String>(entitySpecs.length);
        for (EntitySpec entitySpec : entitySpecs) {
            result.add(entitySpec.getName());
        }
        return result;
    }

    @Override
    protected String generateFromTable(ColumnSpec columnSpec) {
        StringBuilder fromPart = new StringBuilder();
        boolean foundStagedTable = false;
        String schemaToAppend = null;
        String tableToAppend = "";
        if (this.stagedTables != null) {
            ArrayList<String> entitySpecNames = new ArrayList<String>(this.inboundReferenceSpecs.keySet());
            entitySpecNames.add(this.getCurrentSpec().getName());
            for (StagingSpec sspec : this.stagedTables) {
                if (foundStagedTable || Collections.disjoint(Ojdbc6OracleFromClause.toEntitySpecNames(sspec.getEntitySpecs()), entitySpecNames) || !columnSpec.isSameSchemaAndTable(sspec.getReplacedTable())) continue;
                foundStagedTable = true;
                if (sspec.getStagingArea().getSchema() != null) {
                    schemaToAppend = sspec.getStagingArea().getSchema();
                }
                tableToAppend = sspec.getStagingArea().getTable();
            }
        }
        if (!foundStagedTable) {
            if (columnSpec.getSchema() != null) {
                schemaToAppend = columnSpec.getSchema();
            }
            tableToAppend = columnSpec.getTable();
        }
        if (schemaToAppend != null) {
            fromPart.append(schemaToAppend);
            fromPart.append('.');
        }
        fromPart.append(tableToAppend);
        fromPart.append(" ");
        fromPart.append(this.getReferenceIndices().generateTableReference(columnSpec));
        return fromPart.toString();
    }

    @Override
    protected AbstractJoinClause getJoinClause(JoinSpec.JoinType joinType) {
        return new DefaultJoinClause(joinType);
    }

    @Override
    protected AbstractOnClause getOnClause(JoinSpec joinSpec, TableAliaser referenceIndices) {
        return new DefaultOnClause(joinSpec, referenceIndices);
    }
}

