/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest;

import edu.emory.cci.aiw.i2b2etl.dest.I2B2QueryResultsHandlerSourceId;
import edu.emory.cci.aiw.i2b2etl.dest.I2b2ETLUtil;
import edu.emory.cci.aiw.i2b2etl.dest.RemoveMethod;
import edu.emory.cci.aiw.i2b2etl.dest.config.Concepts;
import edu.emory.cci.aiw.i2b2etl.dest.config.Configuration;
import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.DataSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.Database;
import edu.emory.cci.aiw.i2b2etl.dest.config.DatabaseSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptDimensionLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.FactHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.InvalidFactException;
import edu.emory.cci.aiw.i2b2etl.dest.table.InvalidPatientRecordException;
import edu.emory.cci.aiw.i2b2etl.dest.table.MetaTableConceptHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.MetaTableConceptLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.ModifierDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.ModifierDimensionLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimensionFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.PropositionFactHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimensionFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.RejectedFactHandlerFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.VisitDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.VisitDimensionFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.DataSource;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceCacheFactory;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.dest.AbstractQueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerCloseException;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.Reference;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

public final class I2b2QueryResultsHandler
extends AbstractQueryResultsHandler {
    private static final String[] OBX_FACT_IDXS = new String[]{"FACT_NOLOB", "FACT_PATCON_DATE_PRVD_IDX", "FACT_CNPT_PAT_ENCT_IDX"};
    private static final int UPLOAD_ID = 0;
    private final Query query;
    private final KnowledgeSource knowledgeSource;
    private final Settings settings;
    private final Data data;
    private final Database database;
    private final ConnectionSpec dataConnectionSpec;
    private final Concepts conceptsSection;
    private List<FactHandler> factHandlers;
    private ConceptDimensionHandler conceptDimensionHandler;
    private ModifierDimensionHandler modifierDimensionHandler;
    private Metadata ontologyModel;
    private final DataSpec providerFullNameSpec;
    private final DataSpec providerFirstNameSpec;
    private final DataSpec providerMiddleNameSpec;
    private final DataSpec providerLastNameSpec;
    private final ConnectionSpec metadataConnectionSpec;
    private final String visitPropId;
    private Connection dataSchemaConnection;
    private final Set<String> dataSourceBackendIds;
    private final RemoveMethod dataRemoveMethod;
    private RemoveMethod metaRemoveMethod;
    private final Set<String> knowledgeSourceBackendIds;
    private final String qrhId;
    private ProviderDimensionFactory providerDimensionFactory;
    private PatientDimensionFactory patientDimensionFactory;
    private VisitDimensionFactory visitDimensionFactory;
    private final Configuration configuration;
    private KnowledgeSourceCache cache;

    I2b2QueryResultsHandler(Query query, DataSource dataSource, KnowledgeSource knowledgeSource, Configuration configuration) throws QueryResultsHandlerInitException {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource cannot be null");
        }
        if (knowledgeSource == null) {
            throw new IllegalArgumentException("knowledgeSource cannot be null");
        }
        Logger logger = I2b2ETLUtil.logger();
        this.query = query;
        this.knowledgeSource = knowledgeSource;
        this.configuration = configuration;
        logger.log(Level.FINE, String.format("Using configuration: %s", this.configuration.getName()));
        logger.log(Level.FINER, "STEP: read conf.xml");
        this.settings = this.configuration.getSettings();
        this.data = this.configuration.getData();
        this.conceptsSection = this.configuration.getConcepts();
        this.database = this.configuration.getDatabase();
        DatabaseSpec dataSchemaSpec = this.database.getDataSpec();
        this.dataConnectionSpec = dataSchemaSpec != null ? dataSchemaSpec.toConnectionSpec() : null;
        DatabaseSpec metadataSchemaSpec = this.database.getMetadataSpec();
        this.metadataConnectionSpec = metadataSchemaSpec != null ? metadataSchemaSpec.toConnectionSpec() : null;
        this.providerFullNameSpec = this.data.get(this.settings.getProviderFullName());
        this.providerFirstNameSpec = this.data.get(this.settings.getProviderFirstName());
        this.providerMiddleNameSpec = this.data.get(this.settings.getProviderMiddleName());
        this.providerLastNameSpec = this.data.get(this.settings.getProviderLastName());
        this.visitPropId = this.settings.getVisitDimension();
        RemoveMethod removeMethod = this.settings.getDataRemoveMethod();
        this.dataRemoveMethod = removeMethod != null ? removeMethod : RemoveMethod.TRUNCATE;
        RemoveMethod metaRemoveMethod2 = this.settings.getMetaRemoveMethod();
        this.metaRemoveMethod = metaRemoveMethod2 != null ? metaRemoveMethod2 : RemoveMethod.TRUNCATE;
        DataSourceBackend[] dsBackends = (DataSourceBackend[])dataSource.getBackends();
        this.dataSourceBackendIds = new HashSet<String>();
        for (int i = 0; i < dsBackends.length; ++i) {
            String id = dsBackends[i].getId();
            if (id == null) continue;
            this.dataSourceBackendIds.add(id);
        }
        String sourceSystemCd = this.settings.getSourceSystemCode();
        this.qrhId = sourceSystemCd != null ? sourceSystemCd : I2B2QueryResultsHandlerSourceId.getInstance().getStringRepresentation();
        this.dataSourceBackendIds.add(this.qrhId);
        KnowledgeSourceBackend[] ksBackends = (KnowledgeSourceBackend[])knowledgeSource.getBackends();
        this.knowledgeSourceBackendIds = new HashSet<String>();
        for (int i = 0; i < ksBackends.length; ++i) {
            String id = ksBackends[i].getId();
            if (id == null) continue;
            this.knowledgeSourceBackendIds.add(id);
        }
        this.knowledgeSourceBackendIds.add(this.qrhId);
    }

    public String getId() {
        return this.qrhId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(Collection<PropositionDefinition> propDefs) throws QueryResultsHandlerProcessingException {
        Logger logger = I2b2ETLUtil.logger();
        try {
            this.conceptDimensionHandler = new ConceptDimensionHandler(this.dataConnectionSpec);
            this.modifierDimensionHandler = new ModifierDimensionHandler(this.dataConnectionSpec);
            this.cache = new KnowledgeSourceCacheFactory().getInstance(this.knowledgeSource, propDefs, true);
            this.ontologyModel = new Metadata(this.qrhId, this.cache, this.knowledgeSource, this.collectUserPropositionDefinitions(), this.conceptsSection.getFolderSpecs(), this.settings, this.data, this.metadataConnectionSpec);
            this.providerDimensionFactory = new ProviderDimensionFactory(this.ontologyModel, this.settings, this.dataConnectionSpec);
            this.patientDimensionFactory = new PatientDimensionFactory(this.ontologyModel, this.settings, this.data, this.dataConnectionSpec);
            this.visitDimensionFactory = new VisitDimensionFactory(this.ontologyModel, this.settings, this.data, this.dataConnectionSpec);
            if (this.query.getQueryMode() == QueryMode.REPLACE) {
                DataRemoverFactory f = new DataRemoverFactory();
                f.getInstance(this.dataRemoveMethod).doRemoveData();
                f.getInstance(this.metaRemoveMethod).doRemoveMetadata();
            }
            this.factHandlers = new ArrayList<FactHandler>();
            this.addPropositionFactHandlers();
            this.disableObservationFactIndexes();
            this.truncateTempTables();
            this.dataSchemaConnection = this.openDataDatabaseConnection();
            if (this.settings.getManageCTotalNum()) {
                try (Connection conn = this.openMetadataDatabaseConnection();
                     Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT DISTINCT C_TABLE_NAME FROM TABLE_ACCESS");){
                    while (rs.next()) {
                        CallableStatement mappingCall;
                        block50: {
                            String tableName = rs.getString(1);
                            mappingCall = conn.prepareCall("{ call EUREKA.EK_CLEAR_C_TOTALNUM(?) }");
                            Throwable throwable = null;
                            try {
                                logger.log(Level.INFO, "Clearing C_TOTALNUM for query {0}", this.query.getName());
                                mappingCall.setString(1, tableName);
                                mappingCall.execute();
                                if (mappingCall == null) continue;
                                if (throwable == null) break block50;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (mappingCall == null) throw throwable3;
                                    if (throwable == null) {
                                        mappingCall.close();
                                        throw throwable3;
                                    }
                                    try {
                                        mappingCall.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                mappingCall.close();
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                continue;
                            }
                        }
                        mappingCall.close();
                    }
                }
            }
            logger.log(Level.INFO, "Populating observation facts table for query {0}", this.query.getName());
            return;
        }
        catch (OntologyBuildException | SQLException | KnowledgeSourceReadException ex) {
            throw new QueryResultsHandlerProcessingException("Error during i2b2 load", ex);
        }
    }

    private String rejectedObservationFactTable() {
        return "EK_REJECTED_OBSERVATION_FACT";
    }

    private String tempPatientTableName() {
        return "ek_temp_patient";
    }

    private String tempPatientMappingTableName() {
        return "ek_temp_patient_mapping";
    }

    private String tempVisitTableName() {
        return "ek_temp_visit";
    }

    private String tempEncounterMappingTableName() {
        return "ek_temp_encounter_mapping";
    }

    private String tempProviderTableName() {
        return "ek_temp_provider";
    }

    private String tempConceptTableName() {
        return "ek_temp_concept";
    }

    private String tempObservationFactTableName() {
        return "ek_temp_observation";
    }

    private String tempObservationFactCompleteTableName() {
        return "ek_temp_observation_complete";
    }

    private String tempModifierTableName() {
        return "ek_temp_modifier";
    }

    private void truncateTempTables() throws SQLException {
        Logger logger = I2b2ETLUtil.logger();
        logger.log(Level.INFO, "Truncating temp data tables for query {0}", this.query.getName());
        try (Connection conn = this.openDataDatabaseConnection();){
            String[] dataschemaTables;
            conn.setAutoCommit(true);
            for (String tableName : dataschemaTables = new String[]{this.tempPatientTableName(), this.tempPatientMappingTableName(), this.tempVisitTableName(), this.tempEncounterMappingTableName(), this.tempProviderTableName(), this.tempConceptTableName(), this.tempModifierTableName(), this.tempObservationFactTableName(), this.tempObservationFactCompleteTableName()}) {
                this.truncateTable(conn, tableName);
            }
            logger.log(Level.INFO, "Done truncating temp data tables for query {0}", this.query.getName());
        }
    }

    public void handleQueryResult(String keyId, List<Proposition> propositions, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references) throws QueryResultsHandlerProcessingException {
        Logger logger = I2b2ETLUtil.logger();
        logger.log(Level.FINER, "Loading patient into i2b2");
        try {
            HashSet<Proposition> derivedPropositions = new HashSet<Proposition>();
            PatientDimension pd = null;
            for (Proposition prop : propositions) {
                if (!prop.getId().equals(this.visitPropId)) continue;
                pd = this.handlePatient(pd, keyId, prop, references, forwardDerivations, backwardDerivations, derivedPropositions);
            }
        }
        catch (InvalidConceptCodeException | InvalidFactException | InvalidPatientRecordException | SQLException ex) {
            throw new QueryResultsHandlerProcessingException("Load into i2b2 failed for query " + this.query.getName(), (Throwable)ex);
        }
        logger.log(Level.FINER, "Done loading patient into i2b2");
    }

    private PatientDimension handlePatient(PatientDimension pd, String keyId, Proposition prop, Map<UniqueId, Proposition> references, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Set<Proposition> derivedPropositions) throws SQLException, InvalidConceptCodeException, InvalidFactException, InvalidPatientRecordException {
        if (pd == null) {
            pd = this.patientDimensionFactory.getInstance(keyId, prop, references);
        }
        ProviderDimension providerDimension = this.providerDimensionFactory.getInstance(prop, this.providerFullNameSpec != null ? this.providerFullNameSpec.getReferenceName() : null, this.providerFullNameSpec != null ? this.providerFullNameSpec.getPropertyName() : null, this.providerFirstNameSpec != null ? this.providerFirstNameSpec.getReferenceName() : null, this.providerFirstNameSpec != null ? this.providerFirstNameSpec.getPropertyName() : null, this.providerMiddleNameSpec != null ? this.providerMiddleNameSpec.getReferenceName() : null, this.providerMiddleNameSpec != null ? this.providerMiddleNameSpec.getPropertyName() : null, this.providerLastNameSpec != null ? this.providerLastNameSpec.getReferenceName() : null, this.providerLastNameSpec != null ? this.providerLastNameSpec.getPropertyName() : null, references);
        VisitDimension vd = this.visitDimensionFactory.getInstance(pd.getEncryptedPatientId(), pd.getEncryptedPatientIdSource(), (TemporalProposition)prop, references);
        for (FactHandler factHandler : this.factHandlers) {
            factHandler.handleRecord(pd, vd, providerDimension, prop, forwardDerivations, backwardDerivations, references, derivedPropositions);
        }
        return pd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish() throws QueryResultsHandlerProcessingException {
        Throwable throwable;
        Connection conn;
        SQLException exception;
        String queryId;
        Logger logger;
        block326: {
            Object call2;
            Object factHandler;
            block323: {
                block321: {
                    block319: {
                        CallableStatement mappingCall2;
                        block315: {
                            block313: {
                                block312: {
                                    logger = I2b2ETLUtil.logger();
                                    logger.log(Level.FINE, "Beginning finish for query {0}", this.query.getName());
                                    queryId = this.query.getName();
                                    exception = null;
                                    try {
                                        if (this.factHandlers != null) {
                                            Iterator<FactHandler> itr = this.factHandlers.iterator();
                                            while (itr.hasNext()) {
                                                factHandler = itr.next();
                                                ((FactHandler)factHandler).close();
                                                itr.remove();
                                            }
                                        }
                                    }
                                    catch (SQLException ex) {
                                        exception = ex;
                                    }
                                    if (this.dataSchemaConnection != null) {
                                        try {
                                            this.dataSchemaConnection.close();
                                            this.dataSchemaConnection = null;
                                        }
                                        catch (SQLException ex) {
                                            if (exception != null) break block312;
                                            exception = ex;
                                        }
                                    }
                                }
                                if (this.patientDimensionFactory != null) {
                                    try {
                                        this.patientDimensionFactory.close();
                                        this.patientDimensionFactory = null;
                                    }
                                    catch (SQLException ex) {
                                        if (exception != null) break block313;
                                        exception = ex;
                                    }
                                }
                            }
                            logger.log(Level.INFO, "Populating dimensions for query {0}", queryId);
                            if (exception == null) {
                                try {
                                    conn = this.openDataDatabaseConnection();
                                    factHandler = null;
                                    try {
                                        mappingCall2 = conn.prepareCall("{ call EUREKA.EK_INSERT_PID_MAP_FROMTEMP(?, ?) }");
                                        throwable = null;
                                        try {
                                            conn.setAutoCommit(true);
                                            logger.log(Level.INFO, "Populating patient dimension for query {0}", queryId);
                                            mappingCall2.setString(1, this.tempPatientMappingTableName());
                                            mappingCall2.setInt(2, 0);
                                            mappingCall2.execute();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        finally {
                                            if (mappingCall2 != null) {
                                                if (throwable != null) {
                                                    try {
                                                        mappingCall2.close();
                                                    }
                                                    catch (Throwable throwable3) {
                                                        throwable.addSuppressed(throwable3);
                                                    }
                                                } else {
                                                    mappingCall2.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (Throwable mappingCall2) {
                                        factHandler = mappingCall2;
                                        throw mappingCall2;
                                    }
                                    finally {
                                        if (conn != null) {
                                            if (factHandler != null) {
                                                try {
                                                    conn.close();
                                                }
                                                catch (Throwable mappingCall2) {
                                                    ((Throwable)factHandler).addSuppressed(mappingCall2);
                                                }
                                            } else {
                                                conn.close();
                                            }
                                        }
                                    }
                                }
                                catch (SQLException ex) {
                                    exception = ex;
                                }
                            }
                            if (this.visitDimensionFactory != null) {
                                try {
                                    this.visitDimensionFactory.close();
                                    this.visitDimensionFactory = null;
                                }
                                catch (SQLException ex) {
                                    if (exception != null) break block315;
                                    exception = ex;
                                }
                            }
                        }
                        if (exception == null) {
                            try {
                                conn = this.openDataDatabaseConnection();
                                factHandler = null;
                                try {
                                    mappingCall2 = conn.prepareCall("{ call EUREKA.EK_INSERT_EID_MAP_FROMTEMP(?, ?) }");
                                    throwable = null;
                                    try {
                                        conn.setAutoCommit(true);
                                        mappingCall2.setString(1, this.tempEncounterMappingTableName());
                                        mappingCall2.setInt(2, 0);
                                        mappingCall2.execute();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (mappingCall2 != null) {
                                            if (throwable != null) {
                                                try {
                                                    mappingCall2.close();
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable.addSuppressed(throwable5);
                                                }
                                            } else {
                                                mappingCall2.close();
                                            }
                                        }
                                    }
                                }
                                catch (Throwable mappingCall3) {
                                    factHandler = mappingCall3;
                                    throw mappingCall3;
                                }
                                finally {
                                    if (conn != null) {
                                        if (factHandler != null) {
                                            try {
                                                conn.close();
                                            }
                                            catch (Throwable mappingCall3) {
                                                ((Throwable)factHandler).addSuppressed(mappingCall3);
                                            }
                                        } else {
                                            conn.close();
                                        }
                                    }
                                }
                            }
                            catch (SQLException ex) {
                                exception = ex;
                            }
                        }
                        if (exception == null) {
                            try {
                                conn = this.openDataDatabaseConnection();
                                factHandler = null;
                                try {
                                    call2 = conn.prepareCall("{ call EUREKA.EK_INS_PATIENT_FROMTEMP(?, ?) }");
                                    throwable = null;
                                    try {
                                        conn.setAutoCommit(true);
                                        call2.setString(1, this.tempPatientTableName());
                                        call2.setInt(2, 0);
                                        call2.execute();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable = throwable6;
                                        throw throwable6;
                                    }
                                    finally {
                                        if (call2 != null) {
                                            if (throwable != null) {
                                                try {
                                                    call2.close();
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable.addSuppressed(throwable7);
                                                }
                                            } else {
                                                call2.close();
                                            }
                                        }
                                    }
                                }
                                catch (Throwable call2) {
                                    factHandler = call2;
                                    throw call2;
                                }
                                finally {
                                    if (conn != null) {
                                        if (factHandler != null) {
                                            try {
                                                conn.close();
                                            }
                                            catch (Throwable call2) {
                                                ((Throwable)factHandler).addSuppressed(call2);
                                            }
                                        } else {
                                            conn.close();
                                        }
                                    }
                                }
                            }
                            catch (SQLException ex) {
                                exception = ex;
                            }
                        }
                        if (exception == null) {
                            try {
                                conn = this.openDataDatabaseConnection();
                                factHandler = null;
                                try {
                                    call2 = conn.prepareCall("{ call EUREKA.EK_INS_ENC_VISIT_FROMTEMP(?, ?) }");
                                    throwable = null;
                                    try {
                                        conn.setAutoCommit(true);
                                        logger.log(Level.INFO, "Populating visit dimension for query {0}", queryId);
                                        call2.setString(1, this.tempVisitTableName());
                                        call2.setInt(2, 0);
                                        call2.execute();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable = throwable8;
                                        throw throwable8;
                                    }
                                    finally {
                                        if (call2 != null) {
                                            if (throwable != null) {
                                                try {
                                                    call2.close();
                                                }
                                                catch (Throwable throwable9) {
                                                    throwable.addSuppressed(throwable9);
                                                }
                                            } else {
                                                call2.close();
                                            }
                                        }
                                    }
                                }
                                catch (Throwable call3) {
                                    factHandler = call3;
                                    throw call3;
                                }
                                finally {
                                    if (conn != null) {
                                        if (factHandler != null) {
                                            try {
                                                conn.close();
                                            }
                                            catch (Throwable call3) {
                                                ((Throwable)factHandler).addSuppressed(call3);
                                            }
                                        } else {
                                            conn.close();
                                        }
                                    }
                                }
                            }
                            catch (SQLException ex) {
                                exception = ex;
                            }
                        }
                        if (this.providerDimensionFactory != null) {
                            try {
                                this.providerDimensionFactory.close();
                                this.providerDimensionFactory = null;
                            }
                            catch (SQLException ex) {
                                if (exception != null) break block319;
                                exception = ex;
                            }
                        }
                    }
                    if (exception == null) {
                        try {
                            logger.log(Level.INFO, "Populating provider dimension for query {0}", queryId);
                            conn = this.openDataDatabaseConnection();
                            factHandler = null;
                            try {
                                conn.setAutoCommit(true);
                                call2 = conn.prepareCall("{ call EUREKA.EK_INS_PROVIDER_FROMTEMP(?, ?) }");
                                throwable = null;
                                try {
                                    call2.setString(1, this.tempProviderTableName());
                                    call2.setInt(2, 0);
                                    call2.execute();
                                }
                                catch (Throwable throwable10) {
                                    throwable = throwable10;
                                    throw throwable10;
                                }
                                finally {
                                    if (call2 != null) {
                                        if (throwable != null) {
                                            try {
                                                call2.close();
                                            }
                                            catch (Throwable throwable11) {
                                                throwable.addSuppressed(throwable11);
                                            }
                                        } else {
                                            call2.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable call4) {
                                factHandler = call4;
                                throw call4;
                            }
                            finally {
                                if (conn != null) {
                                    if (factHandler != null) {
                                        try {
                                            conn.close();
                                        }
                                        catch (Throwable call4) {
                                            ((Throwable)factHandler).addSuppressed(call4);
                                        }
                                    } else {
                                        conn.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException ex) {
                            exception = ex;
                        }
                    }
                    if (exception == null) {
                        try {
                            logger.log(Level.INFO, "Populating concept dimension for query {0}", this.query.getName());
                            new ConceptDimensionLoader(this.conceptDimensionHandler).execute(this.ontologyModel.getAllRoots());
                        }
                        catch (SQLException ex) {
                            exception = ex;
                        }
                    }
                    if (this.conceptDimensionHandler != null) {
                        try {
                            this.conceptDimensionHandler.close();
                            this.conceptDimensionHandler = null;
                        }
                        catch (SQLException ex) {
                            if (exception != null) break block321;
                            exception = ex;
                        }
                    }
                }
                if (exception == null) {
                    try {
                        conn = this.openDataDatabaseConnection();
                        factHandler = null;
                        try {
                            conn.setAutoCommit(true);
                            call2 = conn.prepareCall("{ call EUREKA.EK_INS_CONCEPT_FROMTEMP(?, ?) }");
                            throwable = null;
                            try {
                                call2.setString(1, this.tempConceptTableName());
                                call2.setInt(2, 0);
                                call2.execute();
                            }
                            catch (Throwable throwable12) {
                                throwable = throwable12;
                                throw throwable12;
                            }
                            finally {
                                if (call2 != null) {
                                    if (throwable != null) {
                                        try {
                                            call2.close();
                                        }
                                        catch (Throwable throwable13) {
                                            throwable.addSuppressed(throwable13);
                                        }
                                    } else {
                                        call2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable call5) {
                            factHandler = call5;
                            throw call5;
                        }
                        finally {
                            if (conn != null) {
                                if (factHandler != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (Throwable call5) {
                                        ((Throwable)factHandler).addSuppressed(call5);
                                    }
                                } else {
                                    conn.close();
                                }
                            }
                        }
                    }
                    catch (SQLException ex) {
                        exception = ex;
                    }
                }
                if (exception == null) {
                    try {
                        logger.log(Level.INFO, "Populating modifier dimension for query {0}", this.query.getName());
                        new ModifierDimensionLoader(this.modifierDimensionHandler).execute(this.ontologyModel.getModifierRoots());
                    }
                    catch (SQLException ex) {
                        exception = ex;
                    }
                }
                if (this.modifierDimensionHandler != null) {
                    try {
                        this.modifierDimensionHandler.close();
                        this.modifierDimensionHandler = null;
                    }
                    catch (SQLException ex) {
                        if (exception != null) break block323;
                        exception = ex;
                    }
                }
            }
            if (exception == null) {
                try {
                    conn = this.openDataDatabaseConnection();
                    factHandler = null;
                    try {
                        conn.setAutoCommit(true);
                        call2 = conn.prepareCall("{ call EUREKA.EK_INS_MODIFIER_FROMTEMP(?, ?) }");
                        throwable = null;
                        try {
                            call2.setString(1, this.tempModifierTableName());
                            call2.setInt(2, 0);
                            call2.execute();
                        }
                        catch (Throwable throwable14) {
                            throwable = throwable14;
                            throw throwable14;
                        }
                        finally {
                            if (call2 != null) {
                                if (throwable != null) {
                                    try {
                                        call2.close();
                                    }
                                    catch (Throwable throwable15) {
                                        throwable.addSuppressed(throwable15);
                                    }
                                } else {
                                    call2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable call6) {
                        factHandler = call6;
                        throw call6;
                    }
                    finally {
                        if (conn != null) {
                            if (factHandler != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable call6) {
                                    ((Throwable)factHandler).addSuppressed(call6);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
            }
            if (exception == null) {
                try {
                    logger.log(Level.INFO, "Done populating dimensions for query {0}", queryId);
                    conn = this.openDataDatabaseConnection();
                    factHandler = null;
                    try {
                        conn.setAutoCommit(true);
                        logger.log(Level.INFO, "Populating observation_fact from temporary table");
                        call2 = conn.prepareCall("{ call EUREKA.EK_UPDATE_OBSERVATION_FACT(?, ?, ?, ?) }");
                        throwable = null;
                        try {
                            call2.setString(1, this.tempObservationFactTableName());
                            call2.setString(2, this.tempObservationFactCompleteTableName());
                            call2.setLong(3, 0L);
                            call2.setLong(4, this.query.getQueryMode() == QueryMode.UPDATE && this.settings.getMergeOnUpdate() ? 1L : 0L);
                            call2.execute();
                        }
                        catch (Throwable throwable16) {
                            throwable = throwable16;
                            throw throwable16;
                        }
                        finally {
                            if (call2 != null) {
                                if (throwable != null) {
                                    try {
                                        call2.close();
                                    }
                                    catch (Throwable throwable17) {
                                        throwable.addSuppressed(throwable17);
                                    }
                                } else {
                                    call2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable call7) {
                        factHandler = call7;
                        throw call7;
                    }
                    finally {
                        if (conn != null) {
                            if (factHandler != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable call7) {
                                    ((Throwable)factHandler).addSuppressed(call7);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
            }
            if (exception == null) {
                try {
                    this.enableObservationFactIndexes();
                }
                catch (SQLException ex) {
                    exception = ex;
                }
            }
            if (exception == null) {
                try {
                    logger.log(Level.INFO, "Done populating observation fact table for query {0}", queryId);
                    if (this.metadataConnectionSpec != null) {
                        logger.log(Level.INFO, "Populating metadata tables for query {0}", queryId);
                        String tableName = this.settings.getMetaTableName();
                        MetaTableConceptHandler metaTableHandler = new MetaTableConceptHandler(this.metadataConnectionSpec, tableName);
                        call2 = null;
                        try {
                            MetaTableConceptLoader metaTableConceptLoader = new MetaTableConceptLoader(metaTableHandler);
                            metaTableConceptLoader.execute(this.ontologyModel.getAllRoots());
                            logger.log(Level.INFO, "Done populating metadata tables for query {0}", queryId);
                            break block326;
                        }
                        catch (Throwable throwable18) {
                            call2 = throwable18;
                            throw throwable18;
                        }
                        finally {
                            if (metaTableHandler != null) {
                                if (call2 != null) {
                                    try {
                                        metaTableHandler.close();
                                    }
                                    catch (Throwable throwable19) {
                                        ((Throwable)call2).addSuppressed(throwable19);
                                    }
                                } else {
                                    metaTableHandler.close();
                                }
                            }
                        }
                    }
                    logger.log(Level.INFO, "Skipping metadata tables for query {0}", queryId);
                }
                catch (SQLException ex) {
                    exception = ex;
                }
            }
        }
        if (exception == null && this.settings.getManageCTotalNum()) {
            try {
                conn = this.openMetadataDatabaseConnection();
                Throwable throwable20 = null;
                try {
                    conn.setAutoCommit(true);
                    throwable = null;
                    try (Statement stmt = conn.createStatement();
                         ResultSet rs = stmt.executeQuery("SELECT DISTINCT C_TABLE_NAME FROM TABLE_ACCESS");){
                        while (rs.next()) {
                            CallableStatement mappingCall;
                            block327: {
                                String tableName = rs.getString(1);
                                mappingCall = conn.prepareCall("{ call EUREKA.EK_UPDATE_C_TOTALNUM(?) }");
                                Throwable throwable21 = null;
                                try {
                                    logger.log(Level.INFO, "Updating C_TOTALNUM for query {0}", this.query.getName());
                                    mappingCall.setString(1, tableName);
                                    mappingCall.execute();
                                    if (mappingCall == null) continue;
                                    if (throwable21 == null) break block327;
                                }
                                catch (Throwable throwable22) {
                                    try {
                                        throwable21 = throwable22;
                                        throw throwable22;
                                    }
                                    catch (Throwable throwable23) {
                                        if (mappingCall == null) throw throwable23;
                                        if (throwable21 == null) {
                                            mappingCall.close();
                                            throw throwable23;
                                        }
                                        try {
                                            mappingCall.close();
                                            throw throwable23;
                                        }
                                        catch (Throwable throwable24) {
                                            throwable21.addSuppressed(throwable24);
                                            throw throwable23;
                                        }
                                    }
                                }
                                try {
                                    mappingCall.close();
                                    continue;
                                }
                                catch (Throwable throwable25) {
                                    throwable21.addSuppressed(throwable25);
                                    continue;
                                }
                            }
                            mappingCall.close();
                        }
                    }
                    catch (Throwable throwable26) {
                        throwable = throwable26;
                        throw throwable26;
                    }
                }
                catch (Throwable throwable27) {
                    throwable20 = throwable27;
                    throw throwable27;
                }
                finally {
                    if (conn != null) {
                        if (throwable20 != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable28) {
                                throwable20.addSuppressed(throwable28);
                            }
                        } else {
                            conn.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                exception = ex;
            }
        }
        if (exception == null) return;
        logger.log(Level.SEVERE, "Load into i2b2 failed for query " + queryId, exception);
        throw new QueryResultsHandlerProcessingException("Load into i2b2 failed for query " + queryId, (Throwable)exception);
    }

    public void close() throws QueryResultsHandlerCloseException {
        if (this.factHandlers != null) {
            for (FactHandler factHandler : this.factHandlers) {
                try {
                    factHandler.close();
                }
                catch (SQLException sQLException) {}
            }
            this.factHandlers = null;
        }
        if (this.visitDimensionFactory != null) {
            try {
                this.visitDimensionFactory.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.patientDimensionFactory != null) {
            try {
                this.patientDimensionFactory.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.conceptDimensionHandler != null) {
            try {
                this.conceptDimensionHandler.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.modifierDimensionHandler != null) {
            try {
                this.modifierDimensionHandler.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.dataSchemaConnection != null) {
            try {
                this.dataSchemaConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private PropositionDefinition[] collectUserPropositionDefinitions() {
        PropositionDefinition[] allUserPropDefs = this.query.getPropositionDefinitions();
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        Set propIds = Arrays.asSet((Object[])this.query.getPropositionIds());
        for (PropositionDefinition propDef : allUserPropDefs) {
            if (!propIds.contains(propDef.getId())) continue;
            result.add(propDef);
        }
        return result.toArray(new PropositionDefinition[result.size()]);
    }

    private void addPropositionFactHandlers() throws KnowledgeSourceReadException, SQLException {
        String[] potentialDerivedPropIdsArr = this.ontologyModel.extractDerived();
        Set<String> dimDataTypes = this.settings.getDimensionDataTypes();
        RejectedFactHandlerFactory rejectedFactHandlerFactory = new RejectedFactHandlerFactory(this.dataConnectionSpec, this.rejectedObservationFactTable());
        for (DataSpec dataSpec : this.data.getAll()) {
            if (dimDataTypes.contains(dataSpec.getKey())) continue;
            Link[] links = dataSpec.getReferenceName() != null ? new Link[]{new Reference(dataSpec.getReferenceName())} : null;
            PropositionFactHandler propFactHandler = new PropositionFactHandler(this.dataConnectionSpec, links, dataSpec.getPropertyName(), dataSpec.getStart(), dataSpec.getFinish(), dataSpec.getUnits(), potentialDerivedPropIdsArr, this.ontologyModel, this.cache, rejectedFactHandlerFactory);
            this.factHandlers.add(propFactHandler);
        }
    }

    private void truncateTable(Connection conn, String tableName) throws SQLException {
        Logger logger = I2b2ETLUtil.logger();
        String queryId = this.query.getName();
        String sql = "TRUNCATE TABLE " + tableName;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Executing the following SQL for query {0}: {1}", new Object[]{queryId, sql});
        }
        try (Statement st = conn.createStatement();){
            st.execute(sql);
            logger.log(Level.FINE, "Done executing SQL for query {0}", queryId);
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, "An error occurred truncating the tables for query " + queryId, ex);
            throw ex;
        }
    }

    private void disableObservationFactIndexes() throws SQLException {
        Logger logger = I2b2ETLUtil.logger();
        logger.log(Level.INFO, "Disabling indices on observation_fact");
        try (Connection conn = this.openDataDatabaseConnection();
             CallableStatement stmt = conn.prepareCall("{call EUREKA.EK_DISABLE_INDEXES()}");){
            stmt.execute();
            logger.log(Level.INFO, "Disabled indices on observation_fact");
        }
    }

    private void enableObservationFactIndexes() throws SQLException {
        Logger logger = I2b2ETLUtil.logger();
        logger.log(Level.INFO, "Enabling indices on observation_fact");
        try (Connection conn = this.openDataDatabaseConnection();
             CallableStatement stmt = conn.prepareCall("{call EUREKA.EK_ENABLE_INDEXES()}");){
            stmt.execute();
            logger.log(Level.INFO, "Enabled indices on observation_fact");
        }
    }

    private Connection openDataDatabaseConnection() throws SQLException {
        return this.dataConnectionSpec.getOrCreate();
    }

    private Connection openMetadataDatabaseConnection() throws SQLException {
        return this.metadataConnectionSpec.getOrCreate();
    }

    private class TableDeleter
    extends DataRemover {
        private TableDeleter() {
        }

        @Override
        void doRemoveData() throws SQLException {
            String queryId = I2b2QueryResultsHandler.this.query.getName();
            Logger logger = I2b2ETLUtil.logger();
            logger.log(Level.INFO, "Deleting data tables for query {0}", queryId);
            String[] dataschemaTables = new String[]{"OBSERVATION_FACT", "CONCEPT_DIMENSION", "PATIENT_DIMENSION", "PATIENT_MAPPING", "PROVIDER_DIMENSION", "VISIT_DIMENSION", "ENCOUNTER_MAPPING", "MODIFIER_DIMENSION"};
            try (Connection conn = I2b2QueryResultsHandler.this.openDataDatabaseConnection();){
                conn.setAutoCommit(true);
                for (String tableName : dataschemaTables) {
                    this.deleteTable(conn, tableName, I2b2QueryResultsHandler.this.dataSourceBackendIds);
                }
                logger.log(Level.INFO, "Done deleting data for query {0}", queryId);
            }
        }

        @Override
        void doRemoveMetadata() throws SQLException {
            if (I2b2QueryResultsHandler.this.metadataConnectionSpec != null) {
                String queryId = I2b2QueryResultsHandler.this.query.getName();
                Logger logger = I2b2ETLUtil.logger();
                logger.log(Level.INFO, "Deleting metadata for query {0}", queryId);
                try (Connection conn = I2b2QueryResultsHandler.this.openMetadataDatabaseConnection();){
                    conn.setAutoCommit(true);
                    this.deleteTable(conn, I2b2QueryResultsHandler.this.settings.getMetaTableName(), I2b2QueryResultsHandler.this.knowledgeSourceBackendIds);
                    logger.log(Level.INFO, "Done deleting metadata for query {0}", queryId);
                }
            }
        }

        private void deleteTable(Connection conn, String tableName, Set<String> sourceSystemCodes) throws SQLException {
            Logger logger = I2b2ETLUtil.logger();
            String queryId = I2b2QueryResultsHandler.this.query.getName();
            String sql = "DELETE FROM " + tableName;
            if (sourceSystemCodes != null && !sourceSystemCodes.isEmpty()) {
                sql = sql + " WHERE SOURCESYSTEM_CD IN ('" + StringUtils.join(sourceSystemCodes, (String)"','") + "')";
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Executing the following SQL for query {0}: {1}", new Object[]{queryId, sql});
            }
            try (Statement st = conn.createStatement();){
                st.execute(sql);
                logger.log(Level.FINE, "Done executing SQL for query {0}", queryId);
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "An error occurred deleting for query " + queryId, ex);
                throw ex;
            }
        }
    }

    private class TableTruncater
    extends DataRemover {
        private TableTruncater() {
        }

        @Override
        void doRemoveData() throws SQLException {
            String queryId = I2b2QueryResultsHandler.this.query.getName();
            Logger logger = I2b2ETLUtil.logger();
            logger.log(Level.INFO, "Truncating data tables for query {0}", queryId);
            String[] dataschemaTables = new String[]{"OBSERVATION_FACT", "CONCEPT_DIMENSION", "PATIENT_DIMENSION", "PATIENT_MAPPING", "PROVIDER_DIMENSION", "VISIT_DIMENSION", "ENCOUNTER_MAPPING", "MODIFIER_DIMENSION"};
            try (Connection conn = I2b2QueryResultsHandler.this.openDataDatabaseConnection();){
                conn.setAutoCommit(true);
                for (String tableName : dataschemaTables) {
                    I2b2QueryResultsHandler.this.truncateTable(conn, tableName);
                }
                logger.log(Level.INFO, "Done truncating data tables for query {0}", queryId);
            }
        }

        @Override
        void doRemoveMetadata() throws SQLException {
            if (I2b2QueryResultsHandler.this.metadataConnectionSpec != null) {
                String queryId = I2b2QueryResultsHandler.this.query.getName();
                Logger logger = I2b2ETLUtil.logger();
                logger.log(Level.INFO, "Truncating metadata tables for query {0}", queryId);
                try (Connection conn = I2b2QueryResultsHandler.this.openMetadataDatabaseConnection();){
                    conn.setAutoCommit(true);
                    I2b2QueryResultsHandler.this.truncateTable(conn, I2b2QueryResultsHandler.this.settings.getMetaTableName());
                    logger.log(Level.INFO, "Done truncating metadata tables for query {0}", queryId);
                }
            }
        }
    }

    private class DataRemoverFactory {
        private DataRemoverFactory() {
        }

        DataRemover getInstance(RemoveMethod removeMethod) {
            switch (removeMethod) {
                case TRUNCATE: {
                    return new TableTruncater();
                }
                case DELETE: {
                    return new TableDeleter();
                }
            }
            throw new AssertionError((Object)("Unexpected remove method " + (Object)((Object)removeMethod)));
        }
    }

    private abstract class DataRemover {
        private DataRemover() {
        }

        abstract void doRemoveData() throws SQLException;

        abstract void doRemoveMetadata() throws SQLException;
    }
}

