/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;

public class JoinSpec
implements Serializable {
    private static final long serialVersionUID = 7297631285803290163L;
    private final String fromKey;
    private final String toKey;
    private final ColumnSpec nextColumnSpec;
    private final JoinType joinType;
    private final String onClause;
    private ColumnSpec prevColumnSpec;

    public JoinSpec(String onClause, ColumnSpec nextColumnSpec) {
        this(onClause, (JoinType)null, nextColumnSpec);
    }

    public JoinSpec(String onClause, JoinType joinType, ColumnSpec nextColumnSpec) {
        if (onClause == null) {
            throw new IllegalArgumentException("onClause cannot be null");
        }
        if (nextColumnSpec == null) {
            throw new IllegalArgumentException("nextColumnSpec cannot be null");
        }
        if (joinType == null) {
            joinType = JoinType.INNER;
        }
        this.onClause = onClause;
        this.joinType = joinType;
        this.nextColumnSpec = nextColumnSpec;
        this.fromKey = null;
        this.toKey = null;
    }

    public JoinSpec(String fromKey, String toKey, ColumnSpec nextColumnSpec) {
        this(fromKey, toKey, null, nextColumnSpec);
    }

    public JoinSpec(String fromKey, String toKey, JoinType joinType, ColumnSpec nextColumnSpec) {
        if (nextColumnSpec == null) {
            throw new IllegalArgumentException("nextColumnSpec cannot be null");
        }
        if (joinType == null) {
            joinType = JoinType.INNER;
        }
        if (fromKey == null) {
            throw new IllegalArgumentException("fromKey cannot be null");
        }
        if (toKey == null) {
            throw new IllegalArgumentException("toKey cannot be null");
        }
        this.joinType = joinType;
        this.nextColumnSpec = nextColumnSpec;
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.onClause = null;
    }

    public ColumnSpec getPrevColumnSpec() {
        return this.prevColumnSpec;
    }

    void setPrevColumnSpec(ColumnSpec prevColumnSpec) {
        this.prevColumnSpec = prevColumnSpec;
    }

    public String getFromKey() {
        return this.fromKey;
    }

    public String getToKey() {
        return this.toKey;
    }

    public ColumnSpec getNextColumnSpec() {
        return this.nextColumnSpec;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinSpec other = (JoinSpec)obj;
        if (this.fromKey == null ? other.fromKey != null : !this.fromKey.equals(other.fromKey)) {
            return false;
        }
        if (this.toKey == null ? other.toKey != null : !this.toKey.equals(other.toKey)) {
            return false;
        }
        if (!(this.nextColumnSpec == other.nextColumnSpec || this.nextColumnSpec != null && this.nextColumnSpec.equals(other.nextColumnSpec))) {
            return false;
        }
        if (!(this.prevColumnSpec == other.prevColumnSpec || this.prevColumnSpec != null && this.prevColumnSpec.equals(other.prevColumnSpec))) {
            return false;
        }
        return this.joinType == other.joinType;
    }

    public String getOnClause() {
        return this.onClause;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.fromKey != null ? this.fromKey.hashCode() : 0);
        hash = 59 * hash + (this.toKey != null ? this.toKey.hashCode() : 0);
        hash = 59 * hash + (this.nextColumnSpec != null ? this.nextColumnSpec.hashCode() : 0);
        hash = 59 * hash + (this.prevColumnSpec != null ? this.prevColumnSpec.hashCode() : 0);
        hash = 59 * hash + this.joinType.hashCode();
        return hash;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fromKey", (Object)this.fromKey).append("toKey", (Object)this.toKey).append("nextColumnSpec", (Object)this.nextColumnSpec).append("joinType", (Object)this.joinType).toString();
    }

    public static enum JoinType {
        INNER,
        LEFT_OUTER;

    }
}

