/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.Operator;
import org.protempa.backend.dsb.relationaldb.SqlGeneratorUtil;
import org.protempa.backend.dsb.relationaldb.TableAliaser;
import org.protempa.backend.dsb.relationaldb.WhereClause;
import org.protempa.backend.dsb.relationaldb.WhereConstraintProcessor;

final class LikeWhereConstraintProcessor
extends WhereConstraintProcessor {
    LikeWhereConstraintProcessor(ColumnSpec columnSpec, Operator constraint, WhereClause whereClause, Object[] sqlCodes, TableAliaser referenceIndices) {
        super(columnSpec, constraint, whereClause, sqlCodes, referenceIndices);
    }

    @Override
    protected String processConstraint() {
        StringBuilder result = new StringBuilder();
        if (this.getSqlCodes().length > 1) {
            result.append('(');
        }
        for (int i = 0; i < this.getSqlCodes().length; ++i) {
            result.append(this.getReferenceIndices().generateColumnReferenceWithOp(this.getColumnSpec()));
            result.append(" LIKE ");
            result.append(SqlGeneratorUtil.prepareValue(this.getSqlCodes()[i]));
            if (i + 1 >= this.getSqlCodes().length) continue;
            result.append(" OR ");
        }
        if (this.getSqlCodes().length > 1) {
            result.append(')');
        }
        return result.toString();
    }
}

