/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.ProtempaUtil;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;

public class ReferenceSpec
implements Serializable {
    private static final long serialVersionUID = -2223863541098753792L;
    private final String referenceName;
    private final String entityName;
    private EntitySpec referringEntitySpec;
    private final ColumnSpec[] uniqueIdSpecs;
    private final Type type;

    public ReferenceSpec(String referenceName, String entityName, ColumnSpec[] uniqueIdSpecs, Type type) {
        if (referenceName == null) {
            throw new IllegalArgumentException("referenceName cannot be null");
        }
        if (entityName == null) {
            throw new IllegalArgumentException("entityName cannot be null");
        }
        if (uniqueIdSpecs == null) {
            throw new IllegalArgumentException("uniqueIdSpecs cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.uniqueIdSpecs = (ColumnSpec[])uniqueIdSpecs.clone();
        ProtempaUtil.checkArray((Object[])this.uniqueIdSpecs, (String)"uniqueIdSpecs");
        this.referenceName = referenceName.intern();
        this.entityName = entityName;
        this.type = type;
    }

    EntitySpec getReferringEntitySpec() {
        return this.referringEntitySpec;
    }

    void setReferringEntitySpec(EntitySpec referringEntitySpec) {
        this.referringEntitySpec = referringEntitySpec;
    }

    public ColumnSpec[] getUniqueIdSpecs() {
        return (ColumnSpec[])this.uniqueIdSpecs.clone();
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("referenceName", (Object)this.referenceName).append("entityName", (Object)this.entityName).append("uniqueIdSpecs", (Object[])this.uniqueIdSpecs).append("type", (Object)this.type).toString();
    }

    public static enum Type {
        ONE,
        MANY;

    }
}

