/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.arp.javautil.sql.AbstractConnectionSpec;
import org.arp.javautil.sql.ConnectionSpecVisitor;

public class DriverManagerConnectionSpec
extends AbstractConnectionSpec {
    private final String url;
    private final String user;
    private final String password;

    public DriverManagerConnectionSpec(String url, String user, String password) {
        super(true);
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public DriverManagerConnectionSpec(String url, String user, String password, boolean autoCommitEnabled) {
        super(autoCommitEnabled);
        this.url = url;
        this.user = user;
        this.password = password;
    }

    @Override
    public Connection getOrCreate() throws SQLException {
        Connection con = DriverManager.getConnection(this.url, this.user, this.password);
        con.setAutoCommit(this.isAutoCommitEnabled());
        return con;
    }

    @Override
    public void accept(ConnectionSpecVisitor connectionSpecVisitor) {
        connectionSpecVisitor.visit(this);
    }
}

