/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.protempa.DataStreamingEventIterator;
import org.protempa.UniqueIdPair;
import org.protempa.backend.dsb.relationaldb.AbstractResultProcessor;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.JDBCValueFormat;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.StreamingResultProcessor;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueType;

abstract class StreamingMainResultProcessor<P extends Proposition>
extends AbstractResultProcessor
implements StreamingResultProcessor<P> {
    private ColumnSpec[] lastColumnSpecs;
    private PropertySpec[] propertySpecs = this.getEntitySpec().getPropertySpecs();
    private LinkedHashMap<String, ReferenceSpec> inboundRefSpecs;
    private Map<String, ReferenceSpec> bidirectionalRefSpecs;
    private Statement statement;

    protected StreamingMainResultProcessor(EntitySpec entitySpec, LinkedHashMap<String, ReferenceSpec> inboundRefSpecs, Map<String, ReferenceSpec> bidirectionalRefSpecs, String dataSourceBackendId) {
        super(entitySpec, dataSourceBackendId);
        this.inboundRefSpecs = inboundRefSpecs;
        this.bidirectionalRefSpecs = bidirectionalRefSpecs;
        this.lastColumnSpecs = new ColumnSpec[this.propertySpecs.length];
    }

    protected static String sqlCodeToPropositionId(ColumnSpec codeSpec, String code) throws SQLException {
        return codeSpec.getTarget(code);
    }

    protected int extractPropertyValues(ResultSet resultSet, int i, Value[] propertyValues, int[] colTypes) throws SQLException {
        for (int j = 0; j < this.propertySpecs.length; ++j) {
            Value value;
            PropertySpec propertySpec = this.propertySpecs[j];
            ValueType valueType = propertySpec.getValueType();
            JDBCValueFormat valueFormat = propertySpec.getJDBCValueFormat();
            if (valueFormat != null) {
                value = valueFormat.toValue(resultSet, i, colTypes[i - 1]);
            } else {
                String valAsString;
                String propId;
                ColumnSpec columnSpec = this.lastColumnSpecs[j];
                if (columnSpec == null) {
                    ColumnSpec cs = propertySpec.getCodeSpec();
                    List<ColumnSpec> codeSpecL = cs.asList();
                    this.lastColumnSpecs[j] = columnSpec = codeSpecL.get(codeSpecL.size() - 1);
                }
                if ((propId = columnSpec.getTarget(valAsString = resultSet.getString(i))) != null) {
                    valAsString = propId;
                }
                value = valueType.parse(valAsString);
            }
            ++i;
            propertyValues[j] = value;
        }
        return i;
    }

    protected int extractReferenceUniqueIdPairs(ResultSet resultSet, UniqueId referredToUniqueId, UniqueIdPair[] uniqueIdPairs, int i) throws SQLException {
        int j = 0;
        for (Map.Entry<String, ReferenceSpec> entry : this.inboundRefSpecs.entrySet()) {
            UniqueIdPair pair;
            String referringEntityName = entry.getKey();
            ReferenceSpec refSpec = entry.getValue();
            String[] referringUniqueIds = new String[refSpec.getReferringEntitySpec().getUniqueIdSpecs().length];
            i = StreamingMainResultProcessor.readUniqueIds(referringUniqueIds, resultSet, i);
            UniqueId referringUniqueId = this.generateUniqueId(referringEntityName, referringUniqueIds);
            uniqueIdPairs[j] = pair = new UniqueIdPair(refSpec.getReferenceName(), referringUniqueId, referredToUniqueId);
            for (Map.Entry<String, ReferenceSpec> bidirRefSpec : this.bidirectionalRefSpecs.entrySet()) {
                if (!bidirRefSpec.getKey().equals(referringEntityName)) continue;
                UniqueIdPair reversePair = new UniqueIdPair(bidirRefSpec.getValue().getReferenceName(), referredToUniqueId, referringUniqueId);
                uniqueIdPairs[++j] = reversePair;
            }
            ++j;
        }
        return i;
    }

    abstract DataStreamingEventIterator<P> getResults();

    abstract DataStreamingEventIterator<UniqueIdPair> getInboundReferenceResults();

    protected LinkedHashMap<String, ReferenceSpec> getInboundRefSpecs() {
        return this.inboundRefSpecs;
    }

    protected Map<String, ReferenceSpec> getBidirectionalRefSpecs() {
        return this.bidirectionalRefSpecs;
    }

    @Override
    public void setStatement(Statement stmt) {
        this.statement = stmt;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }
}

