/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.datastore;

import com.sleepycat.je.Environment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.arp.javautil.datastore.DataStoreUtil;
import org.arp.javautil.datastore.EnvironmentInfo;

public final class BdbStoreShutdownHook
extends Thread {
    private final List<EnvironmentInfo> envInfos = new ArrayList<EnvironmentInfo>();
    private final boolean deleteOnExit;

    BdbStoreShutdownHook(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    void addEnvironmentInfo(EnvironmentInfo environmentInfo) {
        this.envInfos.add(environmentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() throws IOException {
        BdbStoreShutdownHook bdbStoreShutdownHook = this;
        synchronized (bdbStoreShutdownHook) {
            for (EnvironmentInfo envInfo : this.envInfos) {
                envInfo.getClassCatalog().close();
                envInfo.closeAndRemoveAllDatabaseHandles();
                try (Environment env = envInfo.getEnvironment();){
                    if (!this.deleteOnExit) continue;
                    FileUtils.deleteDirectory((File)env.getHome());
                }
            }
            this.envInfos.clear();
        }
    }

    @Override
    public void run() {
        try {
            this.shutdown();
        }
        catch (IOException ex) {
            Logger logger = DataStoreUtil.logger();
            logger.log(Level.SEVERE, "Error during shutdown", ex);
        }
    }
}

