/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.log.Logging;
import org.protempa.DataSourceBackendSourceSystem;
import org.protempa.SourceSystem;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.JDBCPositionFormat;
import org.protempa.backend.dsb.relationaldb.MainResultProcessor;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.QueryResultsCacheException;
import org.protempa.backend.dsb.relationaldb.ResultCache;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.proposition.Event;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Value;

class EventResultProcessor
extends MainResultProcessor<Event> {
    private static final IntervalFactory intervalFactory = new IntervalFactory();
    private static final int FLUSH_SIZE = 1000000;

    EventResultProcessor(ResultCache<Event> results, EntitySpec entitySpec, String dataSourceBackendId) {
        super(results, entitySpec, dataSourceBackendId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ResultSet resultSet) throws SQLException {
        ResultCache<Event> results = this.getResults();
        EntitySpec entitySpec = this.getEntitySpec();
        String entitySpecName = entitySpec.getName();
        String[] propIds = entitySpec.getPropositionIds();
        ColumnSpec codeSpec = entitySpec.getCodeSpec();
        if (codeSpec != null) {
            List<ColumnSpec> codeSpecL = codeSpec.asList();
            codeSpec = codeSpecL.get(codeSpecL.size() - 1);
        }
        Logger logger = SQLGenUtil.logger();
        PropertySpec[] propertySpecs = entitySpec.getPropertySpecs();
        Value[] propertyValues = new Value[propertySpecs.length];
        int count = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int[] columnTypes = new int[resultSetMetaData.getColumnCount()];
        for (int i = 0; i < columnTypes.length; ++i) {
            columnTypes[i] = resultSetMetaData.getColumnType(i + 1);
        }
        Object[] uniqueIds = new String[entitySpec.getUniqueIdSpecs().length];
        DataSourceBackendSourceSystem dsType = DataSourceBackendSourceSystem.getInstance((String)this.getDataSourceBackendId());
        JDBCPositionFormat positionParser = entitySpec.getPositionParser();
        while (resultSet.next()) {
            String keyId;
            int i = 1;
            if ((keyId = resultSet.getString(i++)) == null) {
                logger.warning("A keyId is null. Skipping record.");
                continue;
            }
            i = EventResultProcessor.readUniqueIds((String[])uniqueIds, resultSet, i);
            if (Arrays.contains((Object[])uniqueIds, null) && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Unique ids contain null ({0}). Skipping record.", StringUtils.join((Object[])uniqueIds, (String)", "));
                continue;
            }
            UniqueId uniqueId = this.generateUniqueId(entitySpecName, (String[])uniqueIds);
            String propId = null;
            if (!this.isCasePresent()) {
                String code;
                if (codeSpec == null) {
                    assert (propIds.length == 1) : "Don't know which proposition id to assign to";
                    propId = propIds[0];
                } else if ((propId = EventResultProcessor.sqlCodeToPropositionId(codeSpec, code = resultSet.getString(i++))) == null) {
                    continue;
                }
            } else {
                ++i;
            }
            ColumnSpec finishTimeSpec = entitySpec.getFinishTimeSpec();
            Granularity gran = entitySpec.getGranularity();
            Interval interval = null;
            if (finishTimeSpec == null) {
                Long d = null;
                try {
                    d = positionParser.toPosition(resultSet, i, columnTypes[i - 1]);
                    ++i;
                }
                catch (SQLException e) {
                    logger.log(Level.WARNING, "Could not parse timestamp. Leaving the start time/timestamp unset.", e);
                }
                interval = intervalFactory.getInstance(d, gran);
            } else {
                Long start = null;
                try {
                    start = positionParser.toPosition(resultSet, i, columnTypes[i - 1]);
                }
                catch (SQLException e) {
                    logger.log(Level.WARNING, "Could not parse start time. Leaving the start time/timestamp unset.", e);
                }
                finally {
                    ++i;
                }
                Long finish = null;
                try {
                    finish = positionParser.toPosition(resultSet, i, columnTypes[i - 1]);
                }
                catch (SQLException e) {
                    logger.log(Level.WARNING, "Could not parse start time. Leaving the finish time unset.", e);
                }
                finally {
                    ++i;
                }
                if (finish != null && start != null && finish.compareTo(start) < 0) {
                    logger.log(Level.WARNING, "Finish {0} is before start {1}: Leaving time unset", new Object[]{finish, start});
                    interval = intervalFactory.getInstance(null, gran, null, gran);
                } else {
                    interval = intervalFactory.getInstance(start, gran, finish, gran);
                }
            }
            i = this.extractPropertyValues(resultSet, i, propertyValues, columnTypes);
            if (this.isCasePresent()) {
                propId = resultSet.getString(i++);
            }
            Event event = new Event(propId, uniqueId);
            event.setSourceSystem((SourceSystem)dsType);
            event.setInterval(interval);
            for (int j = 0; j < propertySpecs.length; ++j) {
                PropertySpec propertySpec = propertySpecs[j];
                event.setProperty(propertySpec.getName(), propertyValues[j]);
            }
            logger.log(Level.FINEST, "Created event {0}", event);
            results.add(keyId, event);
            if (++count % 1000000 != 0) continue;
            try {
                results.flush(this);
            }
            catch (IOException ex) {
                throw new QueryResultsCacheException("Flushing primitive parameters to cache failed", ex);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            Logging.logCount((Logger)logger, (Level)Level.FINE, (int)count, (String)"Retrieved {0} record", (String)"Retrieved {0} records");
        }
        try {
            results.flush(this);
        }
        catch (IOException ex) {
            throw new QueryResultsCacheException("Flushing primitive parameters to cache failed", ex);
        }
        if (logger.isLoggable(Level.FINE)) {
            Logging.logCount((Logger)logger, (Level)Level.FINE, (int)count, (String)"Retrieved {0} record total", (String)"Retrieved {0} records total");
        }
    }
}

