/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.Collections;
import java.util.List;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.FromClause;
import org.protempa.backend.dsb.relationaldb.JoinClause;
import org.protempa.backend.dsb.relationaldb.JoinSpec;
import org.protempa.backend.dsb.relationaldb.OnClause;
import org.protempa.backend.dsb.relationaldb.TableAliaser;

public abstract class AbstractFromClause
implements FromClause {
    private final EntitySpec currentSpec;
    private final List<ColumnSpec> columnSpecs;
    private final TableAliaser referenceIndices;

    protected AbstractFromClause(EntitySpec currentSpec, List<ColumnSpec> columnSpecs, TableAliaser referenceIndices) {
        this.columnSpecs = Collections.unmodifiableList(columnSpecs);
        this.referenceIndices = referenceIndices;
        this.currentSpec = currentSpec;
    }

    protected EntitySpec getCurrentSpec() {
        return this.currentSpec;
    }

    protected List<ColumnSpec> getColumnSpecs() {
        return this.columnSpecs;
    }

    protected TableAliaser getReferenceIndices() {
        return this.referenceIndices;
    }

    protected abstract JoinClause getJoinClause(JoinSpec.JoinType var1);

    protected abstract OnClause getOnClause(JoinSpec var1, TableAliaser var2);

    @Override
    public String generateClause() {
        StringBuilder fromPart = new StringBuilder("FROM ");
        boolean begin = true;
        JoinSpec currentJoin = null;
        for (ColumnSpec columnSpec : this.columnSpecs) {
            if (begin || currentJoin != null) {
                if (!begin) {
                    fromPart.append(this.getJoinClause(currentJoin.getJoinType()).generateClause());
                }
                fromPart.append(this.generateFromTable(columnSpec));
                fromPart.append(' ');
                if (!begin) {
                    fromPart.append(this.getOnClause(currentJoin, this.referenceIndices).generateClause());
                }
            }
            currentJoin = columnSpec.getJoin();
            begin = false;
        }
        return fromPart.toString();
    }

    protected abstract String generateFromTable(ColumnSpec var1);
}

