/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEvent;
import org.protempa.DataStreamingEventIterator;
import org.protempa.UniqueIdPair;
import org.protempa.proposition.UniqueId;

final class InboundReferenceResultSetIterator
implements DataStreamingEventIterator<UniqueIdPair> {
    private static final Logger LOGGER = Logger.getLogger(InboundReferenceResultSetIterator.class.getName());
    private Map<DestructuredUniqueIdPair, Set<UniqueId>> referenceUniqueIds;
    private Queue<DataStreamingEvent<UniqueIdPair>> dataStreamingEventQueue;
    private String keyId;
    private boolean end = false;
    private final String entityName;
    private String lastDelivered;
    private boolean nextInvoked = false;
    private boolean addUniqueIdsInvoked = false;

    InboundReferenceResultSetIterator(String entityName) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Creating reference iterator for {0}", new Object[]{entityName});
        }
        this.entityName = entityName;
        this.referenceUniqueIds = new HashMap<DestructuredUniqueIdPair, Set<UniqueId>>();
        this.dataStreamingEventQueue = new LinkedList<DataStreamingEvent<UniqueIdPair>>();
    }

    void resultSetComplete() {
        this.end = true;
        this.createDataStreamingEvent();
    }

    private boolean isDone() {
        return this.dataStreamingEventQueue.isEmpty() && this.end;
    }

    public boolean hasNext() throws DataSourceReadException {
        return !this.isDone();
    }

    public DataStreamingEvent<UniqueIdPair> next() throws DataSourceReadException {
        if (LOGGER.isLoggable(Level.FINEST) && !this.nextInvoked) {
            this.nextInvoked = true;
            LOGGER.log(Level.FINEST, "First invocation of next() for {0} reference iterator", this.entityName);
        }
        if (this.isDone()) {
            throw new NoSuchElementException("dataStreamingEventQueue is empty");
        }
        if (this.keyId == null) {
            LOGGER.log(Level.SEVERE, "Fatal error in reference iterator {0}: keyId is null", this.entityName);
            LOGGER.log(Level.SEVERE, "Queue has data: {0}", this.dataStreamingEventQueue.isEmpty() ? "no" : "yes");
            LOGGER.log(Level.SEVERE, "Unique ids waiting: {0}", this.referenceUniqueIds == null || this.referenceUniqueIds.isEmpty() ? "no" : "yes");
        }
        DataStreamingEvent result = this.dataStreamingEventQueue.isEmpty() ? new DataStreamingEvent(this.keyId, new ArrayList(0)) : this.dataStreamingEventQueue.remove();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Iterating over references for {0}: Current: {1}, Last Delivered: {2}", new Object[]{this.entityName, result.getKeyId(), this.lastDelivered});
        }
        this.lastDelivered = result.getKeyId();
        return result;
    }

    private void handleKeyId(String keyId) {
        if (this.keyId != null && !this.keyId.equals(keyId)) {
            this.createDataStreamingEvent();
        }
        this.keyId = keyId;
    }

    void addUniqueIds(String keyId, UniqueIdPair[] uniqueIds) {
        if (LOGGER.isLoggable(Level.FINEST) && !this.addUniqueIdsInvoked) {
            this.addUniqueIdsInvoked = true;
            LOGGER.log(Level.FINEST, "First invocation of addUniqueIds for {0}. keyId = {1}", new Object[]{this.entityName, keyId});
        }
        if (keyId == null) {
            LOGGER.log(Level.SEVERE, "Adding unique ids for {0} with null keyId", this.entityName);
        }
        this.handleKeyId(keyId);
        if (uniqueIds != null) {
            for (UniqueIdPair uniqueId : uniqueIds) {
                if (uniqueId == null) continue;
                DestructuredUniqueIdPair lhs = new DestructuredUniqueIdPair(uniqueId.getReferenceName(), uniqueId.getProposition());
                if (!this.referenceUniqueIds.containsKey(lhs)) {
                    this.referenceUniqueIds.put(lhs, new HashSet());
                }
                this.referenceUniqueIds.get(lhs).add(uniqueId.getReference());
            }
        }
    }

    private void createDataStreamingEvent() {
        if (this.keyId != null) {
            ArrayList<UniqueIdPair> uniqueIds = new ArrayList<UniqueIdPair>();
            for (Map.Entry<DestructuredUniqueIdPair, Set<UniqueId>> e : this.referenceUniqueIds.entrySet()) {
                for (UniqueId refId : e.getValue()) {
                    uniqueIds.add(new UniqueIdPair(e.getKey().referenceName, e.getKey().proposition, refId));
                }
            }
            this.dataStreamingEventQueue.offer((DataStreamingEvent<UniqueIdPair>)new DataStreamingEvent(this.keyId, uniqueIds));
        }
        this.referenceUniqueIds = new HashMap<DestructuredUniqueIdPair, Set<UniqueId>>();
    }

    public void close() throws DataSourceReadException {
        this.referenceUniqueIds.clear();
        this.referenceUniqueIds = null;
        if (!this.dataStreamingEventQueue.isEmpty()) {
            LOGGER.log(Level.WARNING, "Closing non-empty data streaming event queue for entity {0}. {1} elements remain.", new Object[]{this.entityName, this.dataStreamingEventQueue.size()});
        }
        this.dataStreamingEventQueue.clear();
        this.dataStreamingEventQueue = null;
    }

    private static final class DestructuredUniqueIdPair {
        private final String referenceName;
        private final UniqueId proposition;

        DestructuredUniqueIdPair(String referenceName, UniqueId proposition) {
            this.referenceName = referenceName;
            this.proposition = proposition;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof DestructuredUniqueIdPair) {
                DestructuredUniqueIdPair other = (DestructuredUniqueIdPair)o;
                return this.referenceName.equals(other.referenceName) && this.proposition.equals((Object)other.proposition);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            int c = this.referenceName.hashCode();
            result = 31 * result + c;
            c = this.proposition.hashCode();
            result = 31 * result + c;
            return result;
        }
    }
}

