/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import org.protempa.backend.dsb.relationaldb.JoinSpec;
import org.protempa.backend.dsb.relationaldb.OnClause;
import org.protempa.backend.dsb.relationaldb.TableAliaser;

public abstract class AbstractOnClause
implements OnClause {
    private final JoinSpec joinSpec;
    private final TableAliaser referenceIndices;

    protected AbstractOnClause(JoinSpec joinSpec, TableAliaser referenceIndices) {
        this.joinSpec = joinSpec;
        this.referenceIndices = referenceIndices;
    }

    @Override
    public String generateClause() {
        String onClause = this.joinSpec.getOnClause();
        if (onClause != null) {
            return "ON (" + onClause + ") ";
        }
        String fromRef = this.referenceIndices.generateTableReference(this.joinSpec.getPrevColumnSpec());
        String toRef = this.referenceIndices.generateTableReference(this.joinSpec.getNextColumnSpec());
        return "ON (" + fromRef + '.' + this.joinSpec.getFromKey() + " = " + toRef + '.' + this.joinSpec.getToKey() + ") ";
    }
}

