/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.SQLGenLocalUniqueId;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.proposition.DataSourceBackendId;
import org.protempa.proposition.LocalUniqueId;
import org.protempa.proposition.SourceId;
import org.protempa.proposition.UniqueId;

abstract class AbstractResultProcessor
implements SQLGenResultProcessor {
    private String dataSourceBackendId;
    private EntitySpec entitySpec;
    private boolean casePresent;

    protected AbstractResultProcessor(EntitySpec entitySpec, String dataSourceBackendId) {
        assert (entitySpec != null) : "entitySpec cannot be null";
        assert (dataSourceBackendId != null) : "dataSourceBackendId cannot be null";
        this.entitySpec = entitySpec;
        this.dataSourceBackendId = dataSourceBackendId;
    }

    final String getDataSourceBackendId() {
        return this.dataSourceBackendId;
    }

    @Override
    public final EntitySpec getEntitySpec() {
        return this.entitySpec;
    }

    @Override
    public final boolean isCasePresent() {
        return this.casePresent;
    }

    @Override
    public final void setCasePresent(boolean casePresent) {
        this.casePresent = casePresent;
    }

    protected static int readUniqueIds(String[] uniqueIds, ResultSet resultSet, int i) throws SQLException {
        for (int m = 0; m < uniqueIds.length; ++m) {
            uniqueIds[m] = resultSet.getString(i++);
        }
        return i;
    }

    protected final UniqueId generateUniqueId(String name, String[] uniqueIds) {
        return new UniqueId((SourceId)DataSourceBackendId.getInstance((String)this.dataSourceBackendId), (LocalUniqueId)new SQLGenLocalUniqueId(name, uniqueIds, this.entitySpec.getMaxWidths()));
    }
}

