/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.Set;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.collections.Collections;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.filter.PositionFilter;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.TableAliaser;

abstract class AbstractTimeSpecProcessor {
    private final EntitySpec entitySpec;
    private final Set<Filter> filters;
    private final boolean first;
    private final TableAliaser referenceIndices;

    protected AbstractTimeSpecProcessor(EntitySpec entitySpec, Set<Filter> filters, boolean first, TableAliaser referenceIndices) {
        this.entitySpec = entitySpec;
        this.filters = filters;
        this.first = first;
        this.referenceIndices = referenceIndices;
    }

    protected final EntitySpec getEntitySpec() {
        return this.entitySpec;
    }

    protected abstract ColumnSpec getTimeSpec();

    protected abstract boolean outputStart(PositionFilter var1);

    protected abstract boolean outputFinish(PositionFilter var1);

    String process() {
        ColumnSpec timeSpec;
        StringBuilder wherePart = new StringBuilder();
        ColumnSpec ts = this.getTimeSpec();
        if (ts != null && this.referenceIndices.getIndex(timeSpec = ts.getLastSpec()) > -1) {
            Set entitySpecPropIds = Arrays.asSet((Object[])this.entitySpec.getPropositionIds());
            for (Filter filter : this.filters) {
                if (!(filter instanceof PositionFilter) || !Collections.containsAny((Set)entitySpecPropIds, (Object[])filter.getPropositionIds())) continue;
                PositionFilter pdsc2 = (PositionFilter)filter;
                boolean outputStart = this.outputStart(pdsc2);
                boolean outputFinish = this.outputFinish(pdsc2);
                if (outputStart) {
                    if (!this.first) {
                        wherePart.append(" AND ");
                    }
                    wherePart.append(this.referenceIndices.generateColumnReferenceWithOp(timeSpec));
                    wherePart.append(" >= ");
                    wherePart.append(this.entitySpec.getPositionParser().format(pdsc2.getMinimumStart()));
                }
                if (!outputFinish) continue;
                if (!this.first || outputStart) {
                    wherePart.append(" AND ");
                }
                wherePart.append(this.referenceIndices.generateColumnReferenceWithOp(timeSpec));
                wherePart.append(" <= ");
                wherePart.append(this.entitySpec.getPositionParser().format(pdsc2.getMaximumFinish()));
            }
        }
        return wherePart.toString();
    }
}

