/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.JDBCValueFormat;
import org.protempa.proposition.value.ValueType;

public final class PropertySpec
implements Serializable {
    private static final long serialVersionUID = -1917547963157896382L;
    private final String name;
    private final Map<String, String> codeToPropIdMap;
    private final ColumnSpec codeSpec;
    private final ColumnSpec constraintSpec;
    private final ValueType valueType;
    private final JDBCValueFormat jdbcValueFormat;

    public PropertySpec(String name, Map<String, String> codeToPropIdMap, ColumnSpec codeSpec, ValueType valueType) {
        this(name, codeToPropIdMap, codeSpec, null, valueType, null);
    }

    public PropertySpec(String name, Map<String, String> codeToPropIdMap, ColumnSpec codeSpec, ColumnSpec constraintSpec, ValueType valueType) {
        this(name, codeToPropIdMap, codeSpec, constraintSpec, valueType, null);
    }

    public PropertySpec(String name, Map<String, String> codeToPropIdMap, ColumnSpec codeSpec, ValueType valueType, JDBCValueFormat jdbcValueFormat) {
        this(name, codeToPropIdMap, codeSpec, null, valueType, jdbcValueFormat);
    }

    public PropertySpec(String name, Map<String, String> codeToPropIdMap, ColumnSpec codeSpec, ColumnSpec constraintSpec, ValueType valueType, JDBCValueFormat jdbcValueFormat) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (codeSpec == null) {
            throw new IllegalArgumentException("codeSpec cannot be null");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType cannot be null");
        }
        this.name = name.intern();
        this.codeToPropIdMap = codeToPropIdMap != null ? new HashMap<String, String>(codeToPropIdMap) : Collections.emptyMap();
        this.codeSpec = codeSpec;
        this.valueType = valueType;
        this.constraintSpec = constraintSpec;
        this.jdbcValueFormat = jdbcValueFormat;
    }

    public String getName() {
        return this.name;
    }

    public boolean codeToPropIdMapContainsKey(String key) {
        return this.codeToPropIdMap.containsKey(key);
    }

    public String propositionIdFor(String key) {
        return this.codeToPropIdMap.get(key);
    }

    public ColumnSpec getCodeSpec() {
        return this.codeSpec;
    }

    public ColumnSpec getConstraintSpec() {
        return this.constraintSpec;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public JDBCValueFormat getJDBCValueFormat() {
        return this.jdbcValueFormat;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

