/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.log.Logging;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEvent;
import org.protempa.DataStreamingEventIterator;
import org.protempa.UniqueIdPair;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.StreamingRefResultProcessor;
import org.protempa.proposition.UniqueId;

public final class ReferenceResultSetIterator
implements DataStreamingEventIterator<UniqueIdPair> {
    private static final Logger LOGGER = Logger.getLogger(ReferenceResultSetIterator.class.getName());
    private ResultSet resultSet;
    private final Logger logger;
    private final String[] uniqueIds;
    private final String[] refUniqueIds;
    private final EntitySpec entitySpec;
    private int count;
    private List<UniqueIdPair> props;
    private DataStreamingEvent<UniqueIdPair> dataStreamingEvent;
    private ReferenceSpec referenceSpec;
    private UniqueId uniqueIdentifier;
    private String[] uniqueIdsCopy;
    private StreamingRefResultProcessor processor;
    private String keyId;
    private String lastDelivered;
    private Statement statement;
    private boolean end;

    ReferenceResultSetIterator(ResultSet resultSet, ReferenceSpec referenceSpec, EntitySpec entitySpec, String dataSourceBackendId, StreamingRefResultProcessor<?> processor) throws SQLException {
        assert (resultSet != null) : "resultSet cannot be null";
        assert (entitySpec != null) : "entitySpec cannot be null";
        assert (referenceSpec != null) : "referenceSpec cannot be null";
        assert (dataSourceBackendId != null) : "dataSourceBackendId cannot be null";
        this.resultSet = resultSet;
        this.logger = SQLGenUtil.logger();
        this.uniqueIds = new String[entitySpec.getUniqueIdSpecs().length];
        this.entitySpec = entitySpec;
        this.referenceSpec = referenceSpec;
        this.refUniqueIds = new String[referenceSpec.getUniqueIdSpecs().length];
        this.uniqueIdsCopy = new String[this.uniqueIds.length];
        this.processor = processor;
        this.props = new ArrayList<UniqueIdPair>();
        this.statement = processor.getStatement();
    }

    public boolean hasNext() throws DataSourceReadException {
        return this.dataStreamingEvent != null || this.advance() != null;
    }

    public DataStreamingEvent<UniqueIdPair> next() throws DataSourceReadException {
        DataStreamingEvent<UniqueIdPair> result = this.dataStreamingEvent != null ? this.dataStreamingEvent : this.advance();
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.dataStreamingEvent = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Iterating over references for {0}: Current: {1}, Last Delivered: {2}", new Object[]{this.entitySpec.getName(), result.getKeyId(), this.lastDelivered});
        }
        this.lastDelivered = result.getKeyId();
        return result;
    }

    public void close() throws DataSourceReadException {
        block13: {
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                    this.resultSet = null;
                    if (this.statement == null) break block13;
                    try {
                        this.statement.close();
                        this.statement = null;
                    }
                    catch (SQLException ex) {
                        throw new DataSourceReadException("Error closing statement", (Throwable)ex);
                    }
                }
                catch (SQLException ex) {
                    throw new DataSourceReadException("Error closing result set", (Throwable)ex);
                }
                finally {
                    if (this.statement != null) {
                        try {
                            this.statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private DataStreamingEvent<UniqueIdPair> advance() throws DataSourceReadException {
        block40: {
            if (this.end) {
                return null;
            }
            boolean normalExit = true;
            try {
                block38: {
                    DataStreamingEvent<UniqueIdPair> i222;
                    block39: {
                        while (this.dataStreamingEvent == null) {
                            String kId;
                            if (!this.resultSet.next()) {
                                this.end = true;
                                break;
                            }
                            int i222 = 1;
                            if ((kId = this.resultSet.getString(i222++)) == null) {
                                this.logger.warning("A keyId is null. Skipping record.");
                                continue;
                            }
                            if (this.keyId != null && !this.keyId.equals(kId)) {
                                this.createDataStreamingEvent(this.props);
                            }
                            this.keyId = kId;
                            i222 = StreamingRefResultProcessor.readUniqueIds(this.uniqueIds, this.resultSet, i222);
                            if (org.arp.javautil.arrays.Arrays.contains((Object[])this.uniqueIds, null)) continue;
                            if (this.uniqueIdentifier == null || !Arrays.equals(this.uniqueIds, this.uniqueIdsCopy)) {
                                this.uniqueIdentifier = this.processor.generateUniqueId(this.entitySpec.getName(), this.uniqueIds);
                                System.arraycopy(this.uniqueIds, 0, this.uniqueIdsCopy, 0, this.uniqueIds.length);
                            }
                            i222 = StreamingRefResultProcessor.readUniqueIds(this.refUniqueIds, this.resultSet, i222);
                            if (org.arp.javautil.arrays.Arrays.contains((Object[])this.refUniqueIds, null)) continue;
                            UniqueId refUniqueIdentifier = this.processor.generateUniqueId(this.referenceSpec.getEntityName(), this.refUniqueIds);
                            this.props.add(new UniqueIdPair(this.referenceSpec.getReferenceName(), this.uniqueIdentifier, refUniqueIdentifier));
                            ++this.count;
                        }
                        if (this.dataStreamingEvent == null) break block38;
                        i222 = this.dataStreamingEvent;
                        if (normalExit || this.resultSet == null) break block39;
                        try {
                            this.resultSet.close();
                            this.resultSet = null;
                        }
                        catch (SQLException sQLException) {
                            this.resultSet = null;
                        }
                        catch (Throwable throwable) {
                            this.resultSet = null;
                            throw throwable;
                        }
                    }
                    return i222;
                }
                if (this.end) {
                    this.resultSet.close();
                    this.resultSet = null;
                    this.statement.close();
                    this.statement = null;
                }
                if (normalExit || this.resultSet == null) break block40;
                try {
                    this.resultSet.close();
                    this.resultSet = null;
                    break block40;
                }
                catch (SQLException i222) {
                    this.resultSet = null;
                    break block40;
                }
                catch (Throwable throwable) {
                    this.resultSet = null;
                    throw throwable;
                }
                catch (SQLException ex) {
                    try {
                        normalExit = false;
                        throw new DataSourceReadException("Error during streaming", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        if (!normalExit && this.resultSet != null) {
                            try {
                                this.resultSet.close();
                            }
                            catch (SQLException sQLException) {
                            }
                            finally {
                                this.resultSet = null;
                            }
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                if (!normalExit && this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        if (this.dataStreamingEvent == null && this.logger.isLoggable(Level.FINE)) {
            Logging.logCount((Logger)this.logger, (Level)Level.FINE, (int)this.count, (String)"Retrieved {0} reference total", (String)"Retrieved {0} references total");
        }
        assert (this.dataStreamingEvent == null) : "dataStreamingEvent must be null";
        if (this.keyId != null) {
            this.createDataStreamingEvent(this.props);
        }
        return this.dataStreamingEvent;
    }

    private void createDataStreamingEvent(List<UniqueIdPair> uniqueIds) {
        this.dataStreamingEvent = new DataStreamingEvent(this.keyId, uniqueIds);
        this.props = new ArrayList<UniqueIdPair>();
    }
}

