/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.DataSourceBackendMultiplexingDataStreamingEventIterator;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEventIterator;
import org.protempa.UniqueIdPair;
import org.protempa.backend.dsb.relationaldb.DataStager;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.proposition.Proposition;

public class RelationalDbDataReadIterator
extends DataSourceBackendMultiplexingDataStreamingEventIterator {
    private final List<Connection> connections;
    private final DataStager stager;

    RelationalDbDataReadIterator(List<? extends DataStreamingEventIterator<UniqueIdPair>> refs, List<? extends DataStreamingEventIterator<Proposition>> itrs, List<Connection> connections, DataStager stager) {
        super(itrs, refs);
        this.connections = connections;
        this.stager = stager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws DataSourceReadException {
        try {
            super.close();
            return;
        }
        finally {
            Iterator<Connection> iterator = this.connections.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                }
                Connection connection = iterator.next();
                try {
                    if (this.stager != null) {
                        this.cleanupStagingArea(this.stager);
                    }
                    connection.close();
                    connection = null;
                    if (connection == null) continue;
                }
                catch (SQLException sqle) {
                    try {
                        throw new DataSourceReadException("Error retrieving data", (Throwable)sqle);
                    }
                    catch (Throwable throwable) {
                        if (connection == null) throw throwable;
                        try {
                            connection.close();
                            throw throwable;
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    private void cleanupStagingArea(DataStager stager) throws DataSourceReadException {
        Logger logger = SQLGenUtil.logger();
        logger.log(Level.INFO, "Cleaning up staged data");
        try {
            stager.cleanup();
        }
        catch (SQLException ex) {
            throw new DataSourceReadException("Failed to clean up the staging area", (Throwable)ex);
        }
    }
}

