/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.collections.Collections;
import org.eurekaclinical.datastore.DataStore;
import org.protempa.backend.dsb.relationaldb.BDBDataSourceResultMap;
import org.protempa.backend.dsb.relationaldb.RefResultProcessor;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.datastore.PropositionStoreCreator;
import org.protempa.datastore.UniqueIdUniqueIdStoreCreator;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;

public class ResultCache<P extends Proposition> {
    private Map<String, List<P>> inMemoryPatientCache = new HashMap<String, List<P>>();
    private final List<DataStore<String, List<P>>> patientCache = new ArrayList<DataStore<String, List<P>>>();
    private Map<UniqueId, List<UniqueId>> tmpInMemoryRefCache;
    private int patientCacheNumber;
    private DataStore<String, List<P>> currentPatientCache;
    private Map<String, String> propIdToEntitySpecNames;
    private int indexForAnyAdded;
    private Set<String> keyIds;
    private Map<String, List<DataStore<UniqueId, List<UniqueIdUniqueIdStoreCreator.Reference>>>> refCache;
    private final PropositionStoreCreator<P> propositionStoreCreator = new PropositionStoreCreator();
    private final UniqueIdUniqueIdStoreCreator uniqueIdCreator = new UniqueIdUniqueIdStoreCreator();

    ResultCache() throws IOException {
        this.currentPatientCache = this.propositionStoreCreator.newCacheStore();
        this.patientCache.add(this.currentPatientCache);
        this.refCache = new HashMap<String, List<DataStore<UniqueId, List<UniqueIdUniqueIdStoreCreator.Reference>>>>();
        this.tmpInMemoryRefCache = new HashMap<UniqueId, List<UniqueId>>();
        this.propIdToEntitySpecNames = new HashMap<String, String>();
        this.keyIds = new HashSet<String>();
    }

    public BDBDataSourceResultMap<P> getPatientCache() {
        this.inMemoryPatientCache = null;
        this.tmpInMemoryRefCache = null;
        return new BDBDataSourceResultMap<P>(this.patientCache, this.refCache, this.propIdToEntitySpecNames, this.keyIds);
    }

    boolean anyAdded() {
        return !this.patientCache.get(this.indexForAnyAdded).isEmpty();
    }

    void addReference(UniqueId uid, UniqueId refUid) {
        Collections.putList(this.tmpInMemoryRefCache, (Object)uid, (Object)refUid);
    }

    void flushReferences(RefResultProcessor<P> resultProcessor) throws IOException {
        DataStore databaseMap = this.uniqueIdCreator.newCacheStore();
        Collections.putList(this.refCache, (Object)resultProcessor.getEntitySpec().getName(), (Object)databaseMap);
        String refName = resultProcessor.getReferenceSpec().getReferenceName();
        for (Map.Entry<UniqueId, List<UniqueId>> me : this.tmpInMemoryRefCache.entrySet()) {
            UniqueId key = me.getKey();
            List<UniqueId> uids = me.getValue();
            ArrayList<UniqueIdUniqueIdStoreCreator.Reference> refs = new ArrayList<UniqueIdUniqueIdStoreCreator.Reference>(uids.size());
            for (UniqueId uid : uids) {
                refs.add(new UniqueIdUniqueIdStoreCreator.Reference(refName, uid));
            }
            databaseMap.put((Object)key, refs);
        }
        this.tmpInMemoryRefCache.clear();
    }

    void add(String keyId, P proposition) {
        assert (keyId != null) : "keyId cannot be null";
        Collections.putList(this.inMemoryPatientCache, (Object)keyId, proposition);
    }

    void flush(SQLGenResultProcessor resultProcessor) throws IOException {
        String entitySpecName = resultProcessor.getEntitySpec().getName();
        assert (entitySpecName != null) : "entitySpecName cannot be null";
        for (Map.Entry<String, List<P>> entry : this.inMemoryPatientCache.entrySet()) {
            List<P> propList = entry.getValue();
            for (Proposition prop : propList) {
                this.propIdToEntitySpecNames.put(prop.getId(), entitySpecName);
            }
            String keyId = entry.getKey();
            if (propList == null || propList.isEmpty()) continue;
            this.addAll(keyId, propList);
        }
        for (List list : this.inMemoryPatientCache.values()) {
            list.clear();
        }
        this.currentPatientCache = this.propositionStoreCreator.newCacheStore();
        this.patientCache.add(this.currentPatientCache);
        ++this.patientCacheNumber;
    }

    void clearTmp() {
        this.indexForAnyAdded = this.patientCacheNumber;
    }

    void shutdown() {
        for (DataStore<String, List<P>> dataStore : this.patientCache) {
            dataStore.shutdown();
        }
        for (List list : this.refCache.values()) {
            for (DataStore ds : list) {
                ds.shutdown();
            }
        }
    }

    private void put(String keyId, List<P> propList) {
        this.currentPatientCache.put((Object)keyId, propList);
        this.keyIds.add(keyId);
    }

    private void addAll(String keyId, List<P> propositions) {
        ArrayList<P> propList = (ArrayList<P>)this.currentPatientCache.remove((Object)keyId);
        if (propList == null) {
            propList = new ArrayList<P>();
        }
        propList.addAll(propositions);
        this.put(keyId, propList);
    }
}

